/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.load.Loader;
import au.org.ala.biocache.util.OptionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class Loader$
implements Tool {
    public static final Loader$ MODULE$;
    private final Logger logger;

    static {
        new Loader$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public String cmd() {
        return "load";
    }

    @Override
    public String desc() {
        return "Load a data resource";
    }

    @Override
    public void main(String[] args) {
        ObjectRef dataResourceUid = new ObjectRef((Object)"");
        BooleanRef forceLoad = new BooleanRef(false);
        BooleanRef testLoad = new BooleanRef(false);
        BooleanRef loadAll = new BooleanRef(false);
        OptionParser parser = new OptionParser(dataResourceUid, forceLoad, testLoad, loadAll){
            {
                this.arg("data-resource-uid", "The data resource to load. Specify 'all' to load all", (Function1<String, BoxedUnit>)new Serializable(this, dataResourceUid$1, loadAll$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dataResourceUid$1;
                    private final BooleanRef loadAll$1;

                    public final void apply(String v) {
                        String string = v;
                        String string2 = "all";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            this.loadAll$1.elem = true;
                        } else {
                            this.dataResourceUid$1.elem = v;
                        }
                    }
                    {
                        this.dataResourceUid$1 = dataResourceUid$1;
                        this.loadAll$1 = loadAll$1;
                    }
                });
                this.opt("fl", "force-load", "Force the (re)load of media", (Function0<BoxedUnit>)new Serializable(this, forceLoad$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef forceLoad$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.forceLoad$1.elem = true;
                    }
                    {
                        this.forceLoad$1 = forceLoad$1;
                    }
                });
                this.opt("t", "test-load", "Test the (re)load of media", (Function0<BoxedUnit>)new Serializable(this, testLoad$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef testLoad$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.testLoad$1.elem = true;
                    }
                    {
                        this.testLoad$1 = testLoad$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            if (loadAll.elem) {
                Loader l = new Loader();
                l.resourceList().foreach((Function1)new Serializable(forceLoad, testLoad, l){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef forceLoad$1;
                    private final BooleanRef testLoad$1;
                    private final Loader l$1;

                    public final void apply(Map<String, String> resource) {
                        String uid = (String)resource.getOrElse((Object)"uid", (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        });
                        String name = (String)resource.getOrElse((Object)"name", (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        });
                        Loader$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading resource ", ", uid: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, uid})));
                        String string = uid;
                        String string2 = "";
                        if (string == null ? string2 != null : !string.equals(string2)) {
                            try {
                                this.l$1.load(uid, this.testLoad$1.elem, this.forceLoad$1.elem);
                            }
                            catch (Exception exception) {
                                Loader$.MODULE$.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to load data resource with ", ". Exception message: ", ".getMessage"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uid, exception})), (Throwable)exception);
                            }
                        }
                    }
                    {
                        this.forceLoad$1 = forceLoad$1;
                        this.testLoad$1 = testLoad$1;
                        this.l$1 = l$1;
                    }
                });
            } else {
                this.logger().info(new StringBuilder().append((Object)"Starting to load resource: ").append((Object)((String)dataResourceUid.elem)).toString());
                Loader l = new Loader();
                l.load((String)dataResourceUid.elem, testLoad.elem, forceLoad.elem);
                this.logger().info(new StringBuilder().append((Object)"Completed loading resource: ").append((Object)((String)dataResourceUid.elem)).toString());
            }
            Config$.MODULE$.persistenceManager().shutdown();
        }
    }

    private Loader$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"Loader");
    }
}

