/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.load.DataLoader;
import au.org.ala.biocache.load.DownloadMedia$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Multimedia;
import au.org.ala.biocache.parser.DateParser$;
import au.org.ala.biocache.util.BiocacheConversions$;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.HttpUtil$;
import au.org.ala.biocache.util.SFTPTools$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.parsing.json.JSON$;

public abstract class DataLoader$class {
    public static boolean emptyTempFileStore(DataLoader $this, String resourceUid) {
        return FileUtils.deleteQuietly((File)new File(new StringBuilder().append((Object)$this.temporaryFileStore()).append((Object)File.separator).append((Object)resourceUid).toString()));
    }

    public static FileWriter getDeletedFileWriter(DataLoader $this, String resourceUid) {
        File file = new File(new StringBuilder().append((Object)Config$.MODULE$.deletedFileStore()).append((Object)File.separator).append((Object)resourceUid).append((Object)File.separator).append((Object)"deleted.txt").toString());
        FileUtils.forceMkdir((File)file.getParentFile());
        return new FileWriter(file);
    }

    public static void deleteOldRowKeys(DataLoader $this, String resourceUid) {
        FileUtils.deleteQuietly((File)new File(new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/row_key_").append((Object)resourceUid).append((Object)".csv").toString()));
    }

    public static Option getRowKeyWriter(DataLoader $this, String resourceUid, boolean writeRowKeys) {
        None$ none$;
        if (writeRowKeys) {
            FileUtils.forceMkdir((File)new File(Config$.MODULE$.tmpWorkDir()));
            none$ = new Some((Object)new FileWriter(new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/row_key_").append((Object)resourceUid).append((Object)".csv").toString(), true));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static void setNotLoadedForOtherPhases(DataLoader $this, String resourceUid) {
        if (DataLoader$class.writer$1($this, resourceUid).isDefined()) {
            ((Writer)DataLoader$class.writer$1($this, resourceUid).get()).flush();
            ((Writer)DataLoader$class.writer$1($this, resourceUid).get()).close();
        }
    }

    public static Map getDataResourceDetailsAsMap(DataLoader $this, String uid) {
        String json = Source$.MODULE$.fromURL(new StringBuilder().append((Object)Config$.MODULE$.registryUrl()).append((Object)"/dataResource/").append((Object)uid).toString(), "UTF-8").getLines().mkString();
        return (Map)JSON$.MODULE$.parseFull(json).get();
    }

    public static Map getDataProviderDetailsAsMap(DataLoader $this, String uid) {
        String json = Source$.MODULE$.fromURL(new StringBuilder().append((Object)Config$.MODULE$.registryUrl()).append((Object)"/dataProvider/").append((Object)uid).toString(), "UTF-8").getLines().mkString();
        return (Map)JSON$.MODULE$.parseFull(json).get();
    }

    public static Map getInstitutionDetailsAsMap(DataLoader $this, String uid) {
        String json = Source$.MODULE$.fromURL(new StringBuilder().append((Object)Config$.MODULE$.registryUrl()).append((Object)"/institution/").append((Object)uid).toString(), "UTF-8").getLines().mkString();
        return (Map)JSON$.MODULE$.parseFull(json).get();
    }

    public static Tuple6 retrieveConnectionParameters(DataLoader $this, String resourceUid) {
        Option option;
        block10: {
            Map map;
            String string;
            Nil$ nil$;
            Object urls;
            String protocol;
            Map connectionParameters;
            Map<String, String> map2;
            block8: {
                block9: {
                    Object singleValue;
                    Some some;
                    boolean bl;
                    block7: {
                        Object object;
                        map2 = $this.getDataResourceDetailsAsMap(resourceUid);
                        connectionParameters = (Map)map2.getOrElse((Object)"connectionParameters", (Function0)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final Map<String, Object> apply() {
                                return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
                            }
                        });
                        protocol = (String)connectionParameters.getOrElse((Object)"protocol", (Function0)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        });
                        Object urlsObject = connectionParameters.getOrElse((Object)"url", (Function0)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final List<String> apply() {
                                return Nil$.MODULE$;
                            }
                        });
                        if (urlsObject instanceof List) {
                            object = urlsObject;
                        } else {
                            String singleValue2 = (String)connectionParameters.apply((Object)"url");
                            object = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{singleValue2}));
                        }
                        urls = object;
                        bl = false;
                        some = null;
                        option = connectionParameters.get((Object)"termsForUniqueKey");
                        if (!(option instanceof Some)) break block7;
                        bl = true;
                        some = (Some)option;
                        Object list = some.x();
                        if (!(list instanceof List)) break block7;
                        List list2 = (List)list;
                        nil$ = list2;
                        break block8;
                    }
                    if (!bl || !((singleValue = some.x()) instanceof String)) break block9;
                    String string2 = (String)singleValue;
                    nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string2}));
                    break block8;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block10;
                nil$ = Nil$.MODULE$;
            }
            Nil$ uniqueTerms = nil$;
            String string3 = string = protocol.toLowerCase();
            if (!("customwebservice" != null ? !"customwebservice".equals(string3) : string3 != null)) {
                String params = (String)connectionParameters.getOrElse((Object)"params", (Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                map = (Map)JSON$.MODULE$.parseFull(params).getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, String> apply() {
                        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
                    }
                });
            } else {
                map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            }
            Map customParams = map;
            String lastChecked = (String)map2.apply((Object)"lastChecked");
            Option<Date> dateLastChecked = DateParser$.MODULE$.parseStringToDate(lastChecked);
            return new Tuple6((Object)protocol, (Object)((List)urls), (Object)uniqueTerms, (Object)connectionParameters, (Object)customParams, dateLastChecked);
        }
        throw new MatchError((Object)option);
    }

    public static List mapConceptTerms(DataLoader $this, List terms) {
        TermFactory termFactory = TermFactory.instance();
        return (List)terms.map((Function1)new Serializable($this, termFactory){
            public static final long serialVersionUID = 0L;
            private final TermFactory termFactory$1;

            public final Term apply(String term) {
                return this.termFactory$1.findTerm(term);
            }
            {
                this.termFactory$1 = termFactory$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public static boolean exists(DataLoader $this, String dataResourceUid, List identifyingTerms) {
        return !Config$.MODULE$.occurrenceDAO().getUUIDForUniqueID($this.createUniqueID(dataResourceUid, (List<String>)identifyingTerms, $this.createUniqueID$default$3())).isEmpty();
    }

    public static String createUniqueID(DataLoader $this, String dataResourceUid, List identifyingTerms, boolean stripSpaces) {
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{dataResourceUid}));
        String uniqueId = identifyingTerms.$colon$colon$colon(list).mkString("|").trim();
        return stripSpaces ? uniqueId.replaceAll("\\s", "") : uniqueId;
    }

    public static boolean createUniqueID$default$3(DataLoader $this) {
        return false;
    }

    public static boolean load(DataLoader $this, String dataResourceUid, FullRecord fr, List identifyingTerms) {
        return $this.load(dataResourceUid, fr, (List<String>)identifyingTerms, true, false, false, (Option<Writer>)None$.MODULE$);
    }

    public static boolean load(DataLoader $this, String dataResourceUid, FullRecord fr, List identifyingTerms, boolean updateLastModified) {
        return $this.load(dataResourceUid, fr, (List<String>)identifyingTerms, updateLastModified, false, false, (Option<Writer>)None$.MODULE$);
    }

    public static boolean load(DataLoader $this, String dataResourceUid, FullRecord fr, List identifyingTerms, boolean updateLastModified, boolean downloadMedia2) {
        return $this.load(dataResourceUid, fr, (List<String>)identifyingTerms, updateLastModified, downloadMedia2, false, (Option<Writer>)None$.MODULE$);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static boolean load(DataLoader $this, String dataResourceUid, FullRecord fr, List identifyingTerms, boolean updateLastModified, boolean downloadMedia, boolean stripSpaces, Option rowKeyWriter) {
        block7: {
            block6: {
                v0 /* !! */  = uniqueID = identifyingTerms.isEmpty() != false ? None$.MODULE$ : new Some((Object)$this.createUniqueID(dataResourceUid, (List<String>)identifyingTerms, stripSpaces));
                if (fr.uuid() == null) break block6;
                v1 = fr.uuid().trim();
                var11_9 = "";
                if (v1 != null ? v1.equals(var11_9) == false : var11_9 != null) ** GOTO lbl20
            }
            if (!((var12_10 = uniqueID) instanceof Some)) break block7;
            var13_11 = (Some)var12_10;
            value = (String)var13_11.x();
            var15_13 = Config$.MODULE$.occurrenceDAO().createOrRetrieveUuid(value);
            ** GOTO lbl17
        }
        v2 = None$.MODULE$;
        var16_14 = var12_10;
        if (!(v2 != null ? v2.equals(var16_14) == false : var16_14 != null)) {
            var15_13 = new Tuple2((Object)Config$.MODULE$.occurrenceDAO().createUuid(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
lbl17:
            // 2 sources

            v3 = var15_13;
        } else {
            throw new MatchError((Object)var12_10);
lbl20:
            // 1 sources

            v3 = var10_15 = new Tuple2((Object)fr.uuid(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (var10_15 != null) {
            recordUuid = (String)var10_15._1();
            isNew = var10_15._2$mcZ$sp();
            var9_19 = var19_18 = new Tuple2((Object)recordUuid, (Object)BoxesRunTime.boxToBoolean((boolean)isNew));
            recordUuid = (String)var9_19._1();
            isNew = var9_19._2$mcZ$sp();
            fr.uuid_$eq(recordUuid);
            fr.rowKey_$eq(uniqueID.isEmpty() != false ? new StringBuilder().append((Object)dataResourceUid).append((Object)"|").append((Object)recordUuid).toString() : (String)uniqueID.get());
            if (rowKeyWriter.isDefined()) {
                ((Writer)rowKeyWriter.get()).write(new StringBuilder().append((Object)fr.rowKey()).append((Object)"\n").toString());
            }
            if (updateLastModified) {
                fr.lastModifiedTime_$eq($this.loadTime());
            }
            if (isNew) {
                fr.firstLoaded_$eq($this.loadTime());
            }
            fr.attribution().dataResourceUid_$eq(dataResourceUid);
            $this.processMedia(dataResourceUid, fr, $this.processMedia$default$3());
            Config$.MODULE$.occurrenceDAO().addRawOccurrence(fr);
            return true;
        }
        throw new MatchError((Object)var10_15);
    }

    public static FullRecord processMedia(DataLoader $this, String dataResourceUid, FullRecord fr, Seq multimedia) {
        Seq suppliedMedia = (Seq)multimedia.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Multimedia media) {
                return media.location().toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq associatedMedia = (Seq)DownloadMedia$.MODULE$.unpackAssociatedMedia(fr.occurrence().associatedMedia()).filter((Function1)new Serializable($this, suppliedMedia){
            public static final long serialVersionUID = 0L;
            private final Seq suppliedMedia$1;

            public final boolean apply(String url) {
                return this.suppliedMedia$1.forall((Function1)new Serializable(this, url){
                    public static final long serialVersionUID = 0L;
                    private final String url$1;

                    public final boolean apply(String x$3) {
                        return !x$3.endsWith(this.url$1);
                    }
                    {
                        this.url$1 = url$1;
                    }
                });
            }
            {
                this.suppliedMedia$1 = suppliedMedia$1;
            }
        });
        Seq filesToImport = (Seq)((TraversableLike)associatedMedia.$plus$plus((GenTraversableOnce)suppliedMedia, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String url) {
                return Config$.MODULE$.blacklistedMediaUrls().forall((Function1)new Serializable(this, url){
                    public static final long serialVersionUID = 0L;
                    private final String url$2;

                    public final boolean apply(String x$4) {
                        return !this.url$2.startsWith(x$4);
                    }
                    {
                        this.url$2 = url$2;
                    }
                });
            }
        });
        if (!filesToImport.isEmpty()) {
            HashMap fileNameToID = new HashMap();
            filesToImport.foreach((Function1)new Serializable($this, fileNameToID, dataResourceUid, fr, multimedia){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DataLoader $outer;
                private final HashMap fileNameToID$1;
                private final String dataResourceUid$1;
                private final FullRecord fr$1;
                private final Seq multimedia$1;

                public final Object apply(String fileToStore) {
                    Tuple3<Object, String, String> tuple3;
                    block2: {
                        Option<Tuple2<String, String>> option;
                        block7: {
                            Option option2;
                            block4: {
                                BoxedUnit boxedUnit;
                                block6: {
                                    block5: {
                                        Some some;
                                        Tuple2 tuple2;
                                        Option media;
                                        block3: {
                                            Tuple3 tuple32;
                                            media = this.multimedia$1.find((Function1)new Serializable(this, fileToStore){
                                                public static final long serialVersionUID = 0L;
                                                private final String fileToStore$1;

                                                public final boolean apply(Multimedia media) {
                                                    String string = media.location().toString();
                                                    String string2 = this.fileToStore$1;
                                                    return !(string != null ? !string.equals(string2) : string2 != null);
                                                }
                                                {
                                                    this.fileToStore$1 = fileToStore$1;
                                                }
                                            });
                                            tuple3 = Config$.MODULE$.mediaStore().alreadyStored(this.fr$1.uuid(), this.dataResourceUid$1, fileToStore);
                                            if (tuple3 == null) break block2;
                                            boolean exists = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
                                            String filename = (String)tuple3._2();
                                            String filePathOrId = (String)tuple3._3();
                                            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)exists), (Object)filename, (Object)filePathOrId);
                                            boolean exists2 = BoxesRunTime.unboxToBoolean((Object)tuple33._1());
                                            String filename2 = (String)tuple33._2();
                                            String filePathOrId2 = (String)tuple33._3();
                                            if (!exists2) break block3;
                                            this.$outer.logger().info(new StringBuilder().append((Object)"Media file already stored: ").append((Object)filePathOrId2).toString());
                                            option2 = this.fileNameToID$1.put((Object)filename2, (Object)filePathOrId2);
                                            break block4;
                                        }
                                        Option<Tuple2<String, String>> savedTo = Config$.MODULE$.mediaStore().save(this.fr$1.uuid(), this.fr$1.attribution().dataResourceUid(), fileToStore, (Option<Multimedia>)media);
                                        this.$outer.logger().info(new StringBuilder().append((Object)"Media file stored to: ").append(savedTo.getOrElse((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply() {
                                                return "**** not available ****";
                                            }
                                        })).toString());
                                        option = savedTo;
                                        if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block5;
                                        String savedFilename = (String)tuple2._1();
                                        String savedFilePathOrId = (String)tuple2._2();
                                        boxedUnit = this.fileNameToID$1.put((Object)savedFilename, (Object)savedFilePathOrId);
                                        break block6;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option<Tuple2<String, String>> option3 = option;
                                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block7;
                                    this.$outer.logger().warn(new StringBuilder().append((Object)"Unable to save file: ").append((Object)fileToStore).toString());
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                option2 = boxedUnit;
                            }
                            return option2;
                        }
                        throw new MatchError(option);
                    }
                    throw new MatchError(tuple3);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.fileNameToID$1 = fileNameToID$1;
                    this.dataResourceUid$1 = dataResourceUid$1;
                    this.fr$1 = fr$1;
                    this.multimedia$1 = multimedia$1;
                }
            });
            ArrayBuffer associatedMediaBuffer = new ArrayBuffer();
            ArrayBuffer imagesBuffer = new ArrayBuffer();
            ArrayBuffer soundsBuffer = new ArrayBuffer();
            ArrayBuffer videosBuffer = new ArrayBuffer();
            fileNameToID.foreach((Function1)new Serializable($this, associatedMediaBuffer, imagesBuffer, soundsBuffer, videosBuffer){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer associatedMediaBuffer$1;
                private final ArrayBuffer imagesBuffer$1;
                private final ArrayBuffer soundsBuffer$1;
                private final ArrayBuffer videosBuffer$1;

                public final ArrayBuffer<String> apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String filename = (String)tuple2._1();
                        String filePathOrID = (String)tuple2._2();
                        Object object = Config$.MODULE$.mediaStore().isValidImage(filename) ? this.imagesBuffer$1.$plus$eq((Object)filePathOrID) : BoxedUnit.UNIT;
                        Object object2 = Config$.MODULE$.mediaStore().isValidSound(filename) ? this.soundsBuffer$1.$plus$eq((Object)filePathOrID) : BoxedUnit.UNIT;
                        Object object3 = Config$.MODULE$.mediaStore().isValidVideo(filename) ? this.videosBuffer$1.$plus$eq((Object)filePathOrID) : BoxedUnit.UNIT;
                        ArrayBuffer arrayBuffer = this.associatedMediaBuffer$1.$plus$eq((Object)filename);
                        return arrayBuffer;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.associatedMediaBuffer$1 = associatedMediaBuffer$1;
                    this.imagesBuffer$1 = imagesBuffer$1;
                    this.soundsBuffer$1 = soundsBuffer$1;
                    this.videosBuffer$1 = videosBuffer$1;
                }
            });
            fr.occurrence().associatedMedia_$eq(Predef$.MODULE$.refArrayOps((Object[])associatedMediaBuffer.toArray(ClassTag$.MODULE$.apply(String.class))).mkString(";"));
            fr.occurrence().images_$eq((String[])imagesBuffer.toArray(ClassTag$.MODULE$.apply(String.class)));
            fr.occurrence().sounds_$eq((String[])soundsBuffer.toArray(ClassTag$.MODULE$.apply(String.class)));
            fr.occurrence().videos_$eq((String[])videosBuffer.toArray(ClassTag$.MODULE$.apply(String.class)));
        }
        return fr;
    }

    public static Seq processMedia$default$3(DataLoader $this) {
        return List$.MODULE$.empty();
    }

    public static Tuple2 downloadArchive(DataLoader $this, String url, String resourceUid, Option lastChecked) {
        Tuple4<File, Date, Object, Object> tuple4;
        Tuple4<File, Date, Object, Object> tuple42 = tuple4 = url.startsWith("sftp://") ? $this.downloadSFTPArchive(url, resourceUid, (Option<Date>)lastChecked) : $this.downloadStandardArchive(url, resourceUid, (Option<Date>)lastChecked);
        if (tuple4 != null) {
            Tuple2 tuple2;
            Tuple4 tuple43;
            File file = (File)tuple4._1();
            Date date = (Date)tuple4._2();
            boolean isZipped = BoxesRunTime.unboxToBoolean((Object)tuple4._3());
            boolean isGzipped = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
            Tuple4 tuple44 = tuple43 = new Tuple4((Object)file, (Object)date, (Object)BoxesRunTime.boxToBoolean((boolean)isZipped), (Object)BoxesRunTime.boxToBoolean((boolean)isGzipped));
            File file2 = (File)tuple44._1();
            Date date2 = (Date)tuple44._2();
            boolean isZipped2 = BoxesRunTime.unboxToBoolean((Object)tuple44._3());
            boolean isGzipped2 = BoxesRunTime.unboxToBoolean((Object)tuple44._4());
            if (file2 == null) {
                $this.logger().info(new StringBuilder().append((Object)"Unable to extract a new file for ").append((Object)resourceUid).append((Object)" at ").append((Object)url).toString());
                tuple2 = new Tuple2(null, null);
            } else if (isZipped2) {
                $this.logger().info(new StringBuilder().append((Object)"Extracting ZIP ").append((Object)file2.getAbsolutePath()).toString());
                FileHelper$.MODULE$.file2helper(file2).extractZip();
                String fileName = FilenameUtils.removeExtension((String)file2.getAbsolutePath());
                $this.logger().info(new StringBuilder().append((Object)"Archive extracted to directory: ").append((Object)fileName).toString());
                tuple2 = new Tuple2((Object)fileName, (Object)date2);
            } else if (isGzipped2) {
                $this.logger().info(new StringBuilder().append((Object)"Extracting GZIP ").append((Object)file2.getAbsolutePath()).toString());
                FileHelper$.MODULE$.file2helper(file2).extractGzip();
                FileUtils.forceDelete((File)file2);
                String fileName = FilenameUtils.removeExtension((String)file2.getAbsolutePath());
                $this.logger().info(new StringBuilder().append((Object)"Archive extracted to directory: ").append((Object)fileName).toString());
                tuple2 = new Tuple2((Object)new File(fileName).getParentFile().getAbsolutePath(), (Object)date2);
            } else {
                tuple2 = new Tuple2((Object)file2.getParentFile().getAbsolutePath(), (Object)date2);
            }
            return tuple2;
        }
        throw new MatchError(tuple4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Tuple4 downloadSFTPArchive(DataLoader $this, String url, String resourceUid, Option lastChecked) {
        Tuple4 tuple4;
        Option<Tuple2<String, Date>> fileDetails;
        Tuple5 tuple5;
        Tuple5 tuple52;
        String string = url;
        Option option = $this.sftpPattern().unapplySeq((Object)string);
        if (option.isEmpty()) return new Tuple4(null, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        if (option.get() == null) return new Tuple4(null, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        if (((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) return new Tuple4(null, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String server = (String)((LinearSeqOptimized)option.get()).apply(0);
        String filename = (String)((LinearSeqOptimized)option.get()).apply(1);
        if (url.endsWith(".zip")) {
            File f = new File(new StringBuilder().append((Object)$this.temporaryFileStore()).append((Object)resourceUid).append((Object)".zip").toString());
            f.createNewFile();
            tuple52 = new Tuple5((Object)f, null, (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else if (url.endsWith(".gz")) {
            File f = new File(new StringBuilder().append((Object)$this.temporaryFileStore()).append((Object)resourceUid).append((Object)File.separator).append((Object)resourceUid).append((Object)".gz").toString());
            $this.logger().info(new StringBuilder().append((Object)"  creating file: ").append((Object)f.getAbsolutePath()).toString());
            FileUtils.forceMkdir((File)f.getParentFile());
            f.createNewFile();
            tuple52 = new Tuple5((Object)f, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else if (filename.contains(".")) {
            File f = new File(new StringBuilder().append((Object)$this.temporaryFileStore()).append((Object)resourceUid).append((Object)File.separator).append((Object)resourceUid).append((Object)".csv").toString());
            $this.logger().info(new StringBuilder().append((Object)"  creating file: ").append((Object)f.getAbsolutePath()).toString());
            FileUtils.forceMkdir((File)f.getParentFile());
            f.createNewFile();
            tuple52 = new Tuple5((Object)f, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            $this.logger().info(new StringBuilder().append((Object)"SFTP the most recent from ").append((Object)url).toString());
            if (DataLoader$class.fileDetails$1($this, url, resourceUid, lastChecked).isDefined()) {
                Tuple2 tuple2;
                Tuple2 tuple22 = (Tuple2)DataLoader$class.fileDetails$1($this, url, resourceUid, lastChecked).get();
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                String file = (String)tuple22._1();
                Date date = (Date)tuple22._2();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)file, (Object)date);
                String file2 = (String)tuple23._1();
                Date date2 = (Date)tuple23._2();
                $this.logger().info(new StringBuilder().append((Object)"The most recent file is ").append((Object)file2).append((Object)" with last modified date : ").append((Object)date2).toString());
                tuple52 = new Tuple5((Object)new File(file2), (Object)date2, (Object)BoxesRunTime.boxToBoolean((boolean)file2.endsWith("zip")), (Object)BoxesRunTime.boxToBoolean((boolean)file2.endsWith("gz")), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else {
                tuple52 = new Tuple5(null, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }
        Tuple5 tuple53 = tuple52;
        if (tuple53 == null) throw new MatchError((Object)tuple53);
        File targetfile = (File)tuple53._1();
        Date date = (Date)tuple53._2();
        boolean isZipped = BoxesRunTime.unboxToBoolean((Object)tuple53._3());
        boolean isGzipped = BoxesRunTime.unboxToBoolean((Object)tuple53._4());
        boolean downloaded = BoxesRunTime.unboxToBoolean((Object)tuple53._5());
        Tuple5 tuple54 = tuple5 = new Tuple5((Object)targetfile, (Object)date, (Object)BoxesRunTime.boxToBoolean((boolean)isZipped), (Object)BoxesRunTime.boxToBoolean((boolean)isGzipped), (Object)BoxesRunTime.boxToBoolean((boolean)downloaded));
        File targetfile2 = (File)tuple54._1();
        Date date3 = (Date)tuple54._2();
        boolean isZipped2 = BoxesRunTime.unboxToBoolean((Object)tuple54._3());
        boolean isGzipped2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
        boolean downloaded2 = BoxesRunTime.unboxToBoolean((Object)tuple54._5());
        Object object = targetfile2 == null ? None$.MODULE$ : (fileDetails = downloaded2 ? new Some((Object)new Tuple2((Object)targetfile2, (Object)date3)) : SFTPTools$.MODULE$.scpFile(server, Config$.MODULE$.getProperty("uploadUser"), Config$.MODULE$.getProperty("uploadPassword"), filename, targetfile2));
        if (fileDetails.isDefined()) {
            Tuple2 tuple2;
            Tuple2 tuple24 = (Tuple2)fileDetails.get();
            if (tuple24 == null) throw new MatchError((Object)tuple24);
            Object file = tuple24._1();
            Date date4 = (Date)tuple24._2();
            Tuple2 tuple25 = tuple2 = new Tuple2(file, (Object)date4);
            Object file3 = tuple25._1();
            Date date5 = (Date)tuple25._2();
            tuple4 = new Tuple4((Object)targetfile2, (Object)date5, (Object)BoxesRunTime.boxToBoolean((boolean)isZipped2), (Object)BoxesRunTime.boxToBoolean((boolean)isGzipped2));
            return tuple4;
        } else {
            tuple4 = new Tuple4(null, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple4;
    }

    public static Option sftpLatestArchive(DataLoader $this, String url, String resourceUid, Option afterDate) {
        return SFTPTools$.MODULE$.sftpLatestArchive(url, resourceUid, $this.temporaryFileStore(), (Option<Date>)afterDate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Tuple4 downloadStandardArchive(DataLoader $this, String url, String resourceUid, Option afterDate) {
        Tuple4 tuple4;
        Date date;
        File tmpStore = new File($this.temporaryFileStore());
        if (!tmpStore.exists()) {
            FileUtils.forceMkdir((File)tmpStore);
        }
        $this.logger().info(new StringBuilder().append((Object)"Downloading zip file from ").append((Object)url).toString());
        URLConnection urlConnection = new URL(url.replaceAll(" ", "%20")).openConnection();
        Date date2 = date = urlConnection.getLastModified() == 0L ? new Date() : new Date(urlConnection.getLastModified());
        if (afterDate.isEmpty() || urlConnection.getLastModified() == 0L || ((Date)afterDate.get()).getTime() < urlConnection.getLastModified()) {
            Tuple3 tuple3;
            Tuple3 tuple32;
            Tuple3 tuple33;
            String contentDisp = urlConnection.getHeaderField("Content-Disposition");
            if (contentDisp != null) {
                $this.logger().info(new StringBuilder().append((Object)" Content-Disposition: ").append((Object)contentDisp).toString());
            }
            InputStream in = urlConnection.getInputStream();
            if (url.endsWith(".zip") || contentDisp != null && contentDisp.endsWith(".zip\"")) {
                File f = new File(new StringBuilder().append((Object)$this.temporaryFileStore()).append((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)).append((Object)resourceUid).append((Object)".zip").toString());
                f.createNewFile();
                tuple33 = new Tuple3((Object)f, (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            } else if (url.endsWith(".gz") || contentDisp != null && contentDisp.endsWith(".gz\"")) {
                File f = new File(new StringBuilder().append((Object)$this.temporaryFileStore()).append((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)).append((Object)resourceUid).append((Object)File.separator).append((Object)resourceUid).append((Object)".gz").toString());
                $this.logger().info(new StringBuilder().append((Object)"Creating file: ").append((Object)f.getAbsolutePath()).toString());
                FileUtils.forceMkdir((File)f.getParentFile());
                f.createNewFile();
                tuple33 = new Tuple3((Object)f, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else {
                File f = new File(new StringBuilder().append((Object)$this.temporaryFileStore()).append((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)).append((Object)resourceUid).append((Object)File.separator).append((Object)resourceUid).append((Object)".csv").toString());
                $this.logger().info(new StringBuilder().append((Object)"Creating file: ").append((Object)f.getAbsolutePath()).toString());
                FileUtils.forceMkdir((File)f.getParentFile());
                f.createNewFile();
                tuple33 = tuple32 = new Tuple3((Object)f, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            if (tuple32 == null) throw new MatchError((Object)tuple32);
            File file = (File)tuple32._1();
            boolean isZipped = BoxesRunTime.unboxToBoolean((Object)tuple32._2());
            boolean isGzipped = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
            Tuple3 tuple34 = tuple3 = new Tuple3((Object)file, (Object)BoxesRunTime.boxToBoolean((boolean)isZipped), (Object)BoxesRunTime.boxToBoolean((boolean)isGzipped));
            File file2 = (File)tuple34._1();
            boolean isZipped2 = BoxesRunTime.unboxToBoolean((Object)tuple34._2());
            boolean isGzipped2 = BoxesRunTime.unboxToBoolean((Object)tuple34._3());
            FileOutputStream out = new FileOutputStream(file2);
            byte[] buffer = new byte[40960];
            int numRead = 0;
            int counter = 0;
            while ((numRead = in.read(buffer)) != -1) {
                counter += numRead;
                out.write(buffer, 0, numRead);
                out.flush();
            }
            out.flush();
            in.close();
            out.close();
            $this.logger().info("Downloaded. File size: ", new Object[]{new StringBuilder().append(counter / 1024).append((Object)"kB, ").append((Object)file2.getAbsolutePath()).append((Object)", is zipped: ").append((Object)BoxesRunTime.boxToBoolean((boolean)isZipped2)).append((Object)"\n").toString()});
            tuple4 = new Tuple4((Object)file2, (Object)date, (Object)BoxesRunTime.boxToBoolean((boolean)isZipped2), (Object)BoxesRunTime.boxToBoolean((boolean)isGzipped2));
            return tuple4;
        } else {
            $this.logger().info("The file has not changed since the last time it  was loaded. To load the data a force-load will need to be performed");
            tuple4 = new Tuple4(null, null, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple4;
    }

    public static boolean updateLastChecked(DataLoader $this, String resourceUid, Option dataCurrency) {
        boolean bl;
        try {
            String string = Config$.MODULE$.allowCollectoryUpdates();
            String string2 = "true";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                HashMap map = new HashMap();
                map.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"user"), (Object)$this.user()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"api_key"), (Object)Config$.MODULE$.collectoryApiKey()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lastChecked"), (Object)$this.loadTime())})));
                Object object = dataCurrency.isDefined() ? map.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"dataCurrency"), (Object)BiocacheConversions$.MODULE$.dateToString((Date)dataCurrency.get()))) : BoxedUnit.UNIT;
                String data = ((TraversableOnce)map.map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, String> pair) {
                        return new StringBuilder().append((Object)"\"").append(pair._1()).append((Object)"\":\"").append(pair._2()).append((Object)"\"").toString();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                Tuple2<Object, String> tuple2 = HttpUtil$.MODULE$.postBody(new StringBuilder().append((Object)Config$.MODULE$.registryUrl()).append((Object)"/dataResource/").append((Object)resourceUid).toString(), "application/json", data);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    int responseCode = tuple2._1$mcI$sp();
                    String responseBody = (String)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)responseCode), (Object)responseBody);
                    int responseCode2 = tuple23._1$mcI$sp();
                    String responseBody2 = (String)tuple23._2();
                    $this.logger().info(new StringBuilder().append((Object)"Registry response code: ").append((Object)BoxesRunTime.boxToInteger((int)responseCode2)).toString());
                } else {
                    throw new MatchError(tuple2);
                }
            }
            bl = true;
        }
        catch (Exception exception) {
            $this.logger().warn(new StringBuilder().append((Object)"Unable to update the lastChecked timestamp in the collectory.  This is most likely caused by a bad URL path for the collectory. Please check configuration. ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
            bl = false;
        }
        return bl;
    }

    public static Option updateLastChecked$default$2(DataLoader $this) {
        return None$.MODULE$;
    }

    private static final Option writer$1(DataLoader $this, String resourceUid$1) {
        return $this.getRowKeyWriter(resourceUid$1, true);
    }

    private static final Option fileDetails$1(DataLoader $this, String url$3, String resourceUid$2, Option lastChecked$1) {
        return SFTPTools$.MODULE$.sftpLatestArchive(url$3, resourceUid$2, $this.temporaryFileStore(), (Option<Date>)lastChecked$1);
    }

    public static void $init$(DataLoader $this) {
        $this.au$org$ala$biocache$load$DataLoader$_setter_$user_$eq("biocache");
        $this.au$org$ala$biocache$load$DataLoader$_setter_$logger_$eq(LoggerFactory.getLogger((String)"DataLoader"));
        $this.au$org$ala$biocache$load$DataLoader$_setter_$temporaryFileStore_$eq(Config$.MODULE$.loadFileStore());
        $this.au$org$ala$biocache$load$DataLoader$_setter_$pm_$eq(Config$.MODULE$.persistenceManager());
        $this.au$org$ala$biocache$load$DataLoader$_setter_$loadTime_$eq(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'"));
        $this.au$org$ala$biocache$load$DataLoader$_setter_$sftpPattern_$eq(new StringOps(Predef$.MODULE$.augmentString("sftp://([a-zA-z\\.]*):([0-9a-zA-Z_/\\.\\-]*)")).r());
    }
}

