/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.caches;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.caches.WebServiceLoader$;
import au.org.ala.biocache.util.StringHelper$;
import au.org.ala.sds.SensitiveDataService;
import au.org.ala.sds.SensitiveSpeciesFinder;
import au.org.ala.sds.util.GeoLocationHelper;
import java.io.File;
import org.ala.layers.intersect.SimpleShapeFile;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.parsing.json.JSON$;

public final class SensitiveAreaDAO$ {
    public static final SensitiveAreaDAO$ MODULE$;
    private final Logger logger;
    private final LRUMap lru;
    private final Object lock;
    private SensitiveSpeciesFinder sdsFinder;
    private final SensitiveDataService sds;
    private final HashMap<String, String> idNameLookup;
    private final HashMap<String, String> nameFieldLookup;
    private final HashMap<String, SimpleShapeFile> loadedShapeFiles;
    private volatile boolean bitmap$0;

    static {
        new SensitiveAreaDAO$();
    }

    private SensitiveSpeciesFinder sdsFinder$lzycompute() {
        SensitiveAreaDAO$ sensitiveAreaDAO$ = this;
        synchronized (sensitiveAreaDAO$) {
            if (!this.bitmap$0) {
                this.sdsFinder = Config$.MODULE$.sdsFinder();
                this.bitmap$0 = true;
            }
            return this.sdsFinder;
        }
    }

    public Logger logger() {
        return this.logger;
    }

    private LRUMap lru() {
        return this.lru;
    }

    private Object lock() {
        return this.lock;
    }

    public SensitiveSpeciesFinder sdsFinder() {
        return this.bitmap$0 ? this.sdsFinder : this.sdsFinder$lzycompute();
    }

    public SensitiveDataService sds() {
        return this.sds;
    }

    public HashMap<String, String> idNameLookup() {
        return this.idNameLookup;
    }

    public HashMap<String, String> nameFieldLookup() {
        return this.nameFieldLookup;
    }

    public HashMap<String, SimpleShapeFile> loadedShapeFiles() {
        return this.loadedShapeFiles;
    }

    private void init() {
        if (Config$.MODULE$.sdsEnabled()) {
            this.logger().info(new StringBuilder().append((Object)"Loading Layer information from .....").append((Object)Config$.MODULE$.layersServiceUrl()).toString());
            String layersJson = WebServiceLoader$.MODULE$.getWSStringContent(new StringBuilder().append((Object)Config$.MODULE$.layersServiceUrl()).append((Object)"/layers").toString());
            String fieldsJson = WebServiceLoader$.MODULE$.getWSStringContent(new StringBuilder().append((Object)Config$.MODULE$.layersServiceUrl()).append((Object)"/fields").toString());
            List layers = (List)JSON$.MODULE$.parseFull(layersJson).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final List<Map<String, String>> apply() {
                    return Nil$.MODULE$;
                }
            });
            this.logger().info(new StringBuilder().append((Object)"Number of layers loaded .....").append((Object)BoxesRunTime.boxToInteger((int)layers.size())).toString());
            layers.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply(Map<String, String> layer) {
                    return SensitiveAreaDAO$.MODULE$.idNameLookup().put((Object)((Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToDouble((Object)layer.getOrElse((Object)"id", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return -1;
                        }
                    }))))).toString(), layer.getOrElse((Object)"name", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }));
                }
            });
            List fields = (List)JSON$.MODULE$.parseFull(fieldsJson).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final List<Map<String, String>> apply() {
                    return Nil$.MODULE$;
                }
            });
            this.logger().info(new StringBuilder().append((Object)"Number of fields loaded .....").append((Object)BoxesRunTime.boxToInteger((int)fields.size())).toString());
            fields.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply(Map<String, String> field) {
                    return SensitiveAreaDAO$.MODULE$.nameFieldLookup().put(field.getOrElse((Object)"spid", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "-1";
                        }
                    }), field.getOrElse((Object)"sname", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }));
                }
            });
            this.logger().info("Loaded layers required by SDS.....");
            JavaConversions$.MODULE$.asScalaBuffer(GeoLocationHelper.getGeospatialLayers()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String layerID) {
                    SensitiveAreaDAO$.MODULE$.au$org$ala$biocache$caches$SensitiveAreaDAO$$loadLayer(layerID, true);
                }
            });
            if (StringUtils.isNotBlank((String)Config$.MODULE$.stateProvinceLayerID())) {
                this.au$org$ala$biocache$caches$SensitiveAreaDAO$$loadLayer(Config$.MODULE$.stateProvinceLayerID(), false);
            }
            if (StringUtils.isNotBlank((String)Config$.MODULE$.terrestrialLayerID())) {
                this.au$org$ala$biocache$caches$SensitiveAreaDAO$$loadLayer(Config$.MODULE$.terrestrialLayerID(), false);
            }
            if (StringUtils.isNotBlank((String)Config$.MODULE$.marineLayerID())) {
                this.au$org$ala$biocache$caches$SensitiveAreaDAO$$loadLayer(Config$.MODULE$.marineLayerID(), false);
            }
            if (StringUtils.isNotBlank((String)Config$.MODULE$.countriesLayerID())) {
                this.au$org$ala$biocache$caches$SensitiveAreaDAO$$loadLayer(Config$.MODULE$.countriesLayerID(), false);
            }
            if (StringUtils.isNotBlank((String)Config$.MODULE$.localGovLayerID())) {
                this.au$org$ala$biocache$caches$SensitiveAreaDAO$$loadLayer(Config$.MODULE$.localGovLayerID(), false);
            }
        } else {
            this.logger().info("SDS is currently disabled");
        }
    }

    public void au$org$ala$biocache$caches$SensitiveAreaDAO$$loadLayer(String layerID, boolean errorIfNotAvailable) {
        String id = layerID.replaceAll("cl", "");
        File f = new File(new StringBuilder().append((Object)Config$.MODULE$.layersDirectory()).append(this.idNameLookup().getOrElse((Object)id, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "xxxxx";
            }
        })).append((Object)".shp").toString());
        this.logger().info(new StringBuilder().append((Object)"Geospatial ID...").append((Object)layerID).append((Object)" - available: ").append((Object)BoxesRunTime.boxToBoolean((boolean)f.exists())).append((Object)" - ").append((Object)f.getAbsolutePath()).append((Object)", field name: ").append(this.nameFieldLookup().getOrElse((Object)id, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "xxxxx";
            }
        })).toString());
        if (f.exists()) {
            this.loadedShapeFiles().put((Object)layerID, (Object)new SimpleShapeFile(new StringBuilder().append((Object)Config$.MODULE$.layersDirectory()).append(this.idNameLookup().getOrElse((Object)id, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "xxxxx";
                }
            })).toString(), (String)this.nameFieldLookup().getOrElse((Object)id, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "xxxxx";
                }
            })));
        } else if (errorIfNotAvailable) {
            throw new RuntimeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Layer ", " unavailable on local filesystem. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{layerID}))).append((Object)"To disable SDS checking set sds.enabled=false in your external config file.").toString());
        }
    }

    private boolean loadLayer$default$2() {
        return false;
    }

    public Map<String, String> intersect(String decimalLongitude, String decimalLatitude) {
        Option<Object> optLong = StringHelper$.MODULE$.string2helper(decimalLongitude).toDoubleWithOption();
        Option<Object> optLat = StringHelper$.MODULE$.string2helper(decimalLatitude).toDoubleWithOption();
        return optLong.isEmpty() || optLong.isEmpty() ? (Map<String, String>)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$) : this.intersect(BoxesRunTime.unboxToDouble((Object)optLong.get()), BoxesRunTime.unboxToDouble((Object)optLat.get()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> intersect(double decimalLongitude, double decimalLatitude) {
        Map map;
        if (BoxesRunTime.boxToDouble((double)decimalLongitude) == null) return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        if (BoxesRunTime.boxToDouble((double)decimalLatitude) == null) {
            return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        String guid = this.getLatLongKey(decimalLongitude, decimalLatitude);
        Object lookup = this.lru().get((Object)guid);
        if (lookup != null) {
            map = (Map)lookup;
            return map;
        }
        HashMap intersects = new HashMap();
        this.loadedShapeFiles().foreach((Function1)new Serializable(decimalLongitude, decimalLatitude, intersects){
            public static final long serialVersionUID = 0L;
            private final double decimalLongitude$1;
            private final double decimalLatitude$1;
            private final HashMap intersects$1;

            public final Object apply(Tuple2<String, SimpleShapeFile> x0$1) {
                Tuple2<String, SimpleShapeFile> tuple2 = x0$1;
                if (tuple2 != null) {
                    String layerID = (String)tuple2._1();
                    SimpleShapeFile shp = (SimpleShapeFile)tuple2._2();
                    String intersectValue = shp.intersect(this.decimalLongitude$1, this.decimalLatitude$1);
                    BoxedUnit boxedUnit = intersectValue == null ? BoxedUnit.UNIT : this.intersects$1.put((Object)layerID, (Object)intersectValue);
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.decimalLongitude$1 = decimalLongitude$1;
                this.decimalLatitude$1 = decimalLatitude$1;
                this.intersects$1 = intersects$1;
            }
        });
        Map intersectMap = intersects.toMap(Predef$.MODULE$.conforms());
        Object object = this.lock();
        synchronized (object) {
            this.lru().put((Object)guid, (Object)intersectMap);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl17 : MonitorExitStatement: MONITOREXIT : object
            map = intersectMap;
            return map;
        }
    }

    public void add(double decimalLongitude, double decimalLatitude, Map<String, String> intersectValues) {
        Object object = this.lock();
        synchronized (object) {
            this.lru().put((Object)this.getLatLongKey(decimalLongitude, decimalLatitude), intersectValues);
            return;
        }
    }

    private String getLatLongKey(double longitude, double latitude) {
        return new StringBuilder().append((Object)((Object)BoxesRunTime.boxToDouble((double)longitude)).toString()).append((Object)"|").append((Object)((Object)BoxesRunTime.boxToDouble((double)latitude)).toString()).toString();
    }

    private SensitiveAreaDAO$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"SensitiveAreaDAO");
        this.lru = new LRUMap(10000);
        this.lock = new Object();
        this.sds = new SensitiveDataService();
        this.idNameLookup = new HashMap();
        this.nameFieldLookup = new HashMap();
        this.loadedShapeFiles = new HashMap();
        this.init();
    }
}

