/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.util;

import au.org.ala.sds.model.SDSSpeciesListDTO;
import au.org.ala.sds.model.SDSSpeciesListItemDTO;
import au.org.ala.sds.util.Configuration;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class SpeciesListUtil {
    static final Logger logger = Logger.getLogger(SpeciesListUtil.class);

    public static Map<String, SDSSpeciesListDTO> getSDSLists() {
        HashMap<String, SDSSpeciesListDTO> map = new HashMap<String, SDSSpeciesListDTO>();
        try {
            URL url = new URL(Configuration.getInstance().getListToolUrl() + "/ws/speciesList?isSDS=eq:true");
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            URLConnection connection = url.openConnection();
            logger.debug((Object)("Looking up location using " + url));
            InputStream inStream = connection.getInputStream();
            Map values = (Map)mapper.readValue(inStream, Map.class);
            if (values.containsKey("lists")) {
                List lists = (List)values.get("lists");
                for (Map lmap : lists) {
                    String dataResourceUid = (String)lmap.get("dataResourceUid");
                    SDSSpeciesListDTO item = new SDSSpeciesListDTO(dataResourceUid, (String)lmap.get("listName"), (String)lmap.get("region"), (String)lmap.get("authority"), (String)lmap.get("category"), (String)lmap.get("generalisation"), (String)lmap.get("sdsType"), (String)lmap.get("lastUpdated"));
                    logger.debug((Object)item);
                    map.put(dataResourceUid, item);
                }
                logger.debug((Object)(lists + " " + lists.getClass() + " " + ((Map)lists.get(0)).getClass()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to obtain the list details.", (Throwable)e);
        }
        return map;
    }

    public static List<SDSSpeciesListItemDTO> getSDSListItems(boolean hasMatch) {
        try {
            String suffix = hasMatch ? "&guid=isNotNull:guid&sort=guid" : "&guid=isNull:guid&sort=rawScientificName";
            URL url = new URL(Configuration.getInstance().getListToolUrl() + "/ws/speciesListItems?isSDS=eq:true" + suffix);
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            URLConnection connection = url.openConnection();
            logger.debug((Object)("Looking up location using " + url));
            InputStream inStream = connection.getInputStream();
            List values = (List)mapper.readValue(inStream, (TypeReference)new TypeReference<List<SDSSpeciesListItemDTO>>(){});
            logger.debug((Object)values);
            return values;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to get the list items. ", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        SpeciesListUtil.getSDSLists();
        SpeciesListUtil.getSDSListItems(true);
        SpeciesListUtil.getSDSListItems(false);
    }
}

