/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.EclipseJavaCompiler;
import org.drools.compiler.commons.jci.compilers.EclipseJavaCompilerSettings;
import org.drools.compiler.commons.jci.problems.CompilationProblem;
import org.drools.compiler.commons.jci.readers.DiskResourceReader;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.FormatConversionResult;
import org.drools.compiler.kie.builder.impl.FormatConverter;
import org.drools.compiler.kie.builder.impl.FormatsManager;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderSetImpl;
import org.drools.compiler.kie.builder.impl.KieFileSystemImpl;
import org.drools.compiler.kie.builder.impl.KieModuleCache;
import org.drools.compiler.kie.builder.impl.KieModuleCacheHelper;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.compiler.kproject.xml.PomModel;
import org.drools.core.builder.conf.impl.ResourceConfigurationImpl;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.KieModuleMetaInfo;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.TypeMetaInfo;
import org.drools.core.util.StringUtils;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.internal.builder.KieBuilderSet;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.io.ResourceTypeImpl;

public class KieBuilderImpl
implements InternalKieBuilder {
    static final String RESOURCES_ROOT = "src/main/resources/";
    static final String JAVA_ROOT = "src/main/java/";
    static final String JAVA_TEST_ROOT = "src/test/java/";
    private ResultsImpl results;
    private final ResourceReader srcMfs;
    private MemoryFileSystem trgMfs;
    private MemoryKieModule kModule;
    private PomModel pomModel;
    private byte[] pomXml;
    private ReleaseId releaseId;
    private byte[] kModuleModelXml;
    private KieModuleModel kModuleModel;
    private Collection<KieModule> kieDependencies;
    private Collection<ReleaseId> jarDependencies;
    private KieBuilderSetImpl kieBuilderSet;

    public KieBuilderImpl(File file) {
        this.srcMfs = new DiskResourceReader(file);
    }

    public KieBuilderImpl(KieFileSystem kieFileSystem) {
        this.srcMfs = ((KieFileSystemImpl)kieFileSystem).asMemoryFileSystem();
    }

    public KieBuilder setDependencies(KieModule ... dependencies) {
        this.kieDependencies = Arrays.asList(dependencies);
        return this;
    }

    public KieBuilder setDependencies(Resource ... resources) {
        KieRepositoryImpl kr = (KieRepositoryImpl)KieServices.Factory.get().getRepository();
        ArrayList<KieModule> list = new ArrayList<KieModule>();
        for (Resource res : resources) {
            InternalKieModule depKieMod = (InternalKieModule)kr.getKieModule(res);
            list.add(depKieMod);
        }
        this.kieDependencies = list;
        return this;
    }

    private void init() {
        KieServices ks = KieServices.Factory.get();
        this.results = new ResultsImpl();
        this.buildPomModel();
        this.buildKieModuleModel();
        if (this.pomModel != null) {
            this.releaseId = this.pomModel.getReleaseId();
            KieRepositoryImpl repository = (KieRepositoryImpl)ks.getRepository();
            for (ReleaseId dep : this.pomModel.getDependencies()) {
                KieModule depModule = repository.getKieModule(dep, this.pomXml);
                if (depModule != null) {
                    this.addKieDependency(depModule);
                    continue;
                }
                this.addJarDependency(dep);
            }
        } else {
            this.releaseId = KieServices.Factory.get().getRepository().getDefaultReleaseId();
        }
    }

    private void addKieDependency(KieModule depModule) {
        if (this.kieDependencies == null) {
            this.kieDependencies = new ArrayList<KieModule>();
        }
        this.kieDependencies.add(depModule);
    }

    private void addJarDependency(ReleaseId releaseId) {
        if (this.jarDependencies == null) {
            this.jarDependencies = new ArrayList<ReleaseId>();
        }
        this.jarDependencies.add(releaseId);
    }

    public KieBuilder buildAll() {
        this.init();
        if (!this.isBuilt() && this.kModuleModel != null) {
            this.trgMfs = new MemoryFileSystem();
            this.writePomAndKModule();
            this.addKBasesFilesToTrg();
            this.markSource();
            this.kModule = new MemoryKieModule(this.releaseId, this.kModuleModel, this.trgMfs);
            if (this.kieDependencies != null && !this.kieDependencies.isEmpty()) {
                for (KieModule kieModule : this.kieDependencies) {
                    this.kModule.addKieDependency((InternalKieModule)kieModule);
                }
            }
            if (this.pomModel != null) {
                this.kModule.setPomModel(this.pomModel);
            }
            KieModuleKieProject kProject = new KieModuleKieProject(this.kModule);
            this.compileJavaClasses(kProject.getClassLoader());
            if (KieBuilderImpl.buildKieProject(this.kModule, this.results, kProject)) {
                this.writeKieModuleMetaInfo(this.generateKieModuleMetaInfo());
            }
        }
        return this;
    }

    void markSource() {
        this.srcMfs.mark();
    }

    Collection<String> getModifiedResourcesSinceLastMark() {
        return this.srcMfs.getModifiedResourcesSinceLastMark();
    }

    void updateKieModuleMetaInfo() {
        this.writeKieModuleMetaInfo(this.generateKieModuleMetaInfo());
    }

    private KieModuleMetaInfo generateKieModuleMetaInfo() {
        HashMap<String, TypeMetaInfo> typeInfos = new HashMap<String, TypeMetaInfo>();
        HashMap rulesPerPackage = new HashMap();
        KieModuleModel kieModuleModel = this.kModule.getKieModuleModel();
        for (String kieBaseName : kieModuleModel.getKieBaseModels().keySet()) {
            KnowledgeBuilderImpl kBuilder = (KnowledgeBuilderImpl)this.kModule.getKnowledgeBuilderForKieBase(kieBaseName);
            Map<String, PackageRegistry> pkgRegistryMap = kBuilder.getPackageBuilder().getPackageRegistry();
            KieModuleCache.KModuleCache.Builder _kmoduleCacheBuilder = this.createCacheBuilder();
            KieModuleCache.CompilationData.Builder _compData = this.createCompilationData();
            for (KnowledgePackage kPkg : kBuilder.getKnowledgePackages()) {
                PackageRegistry pkgRegistry = pkgRegistryMap.get(kPkg.getName());
                JavaDialectRuntimeData runtimeData = (JavaDialectRuntimeData)pkgRegistry.getDialectRuntimeRegistry().getDialectData("java");
                ArrayList<String> types = new ArrayList<String>();
                for (FactType factType : kPkg.getFactTypes()) {
                    Class typeClass = ((ClassDefinition)factType).getDefinedClass();
                    TypeDeclaration typeDeclaration = pkgRegistry.getPackage().getTypeDeclaration(typeClass);
                    if (typeDeclaration != null) {
                        typeInfos.put(typeClass.getName(), new TypeMetaInfo(typeDeclaration));
                    }
                    String className = factType.getName();
                    String internalName = className.replace('.', '/') + ".class";
                    byte[] bytes = runtimeData.getBytecode(internalName);
                    this.trgMfs.write(internalName, bytes, true);
                    types.add(internalName);
                }
                HashSet<String> rules = (HashSet<String>)rulesPerPackage.get(kPkg.getName());
                if (rules == null) {
                    rules = new HashSet<String>();
                }
                for (Rule rule : kPkg.getRules()) {
                    if (rules.contains(rule.getName())) continue;
                    rules.add(rule.getName());
                }
                if (!rules.isEmpty()) {
                    rulesPerPackage.put(kPkg.getName(), rules);
                }
                this.addToCompilationData(_compData, runtimeData, types);
            }
            _kmoduleCacheBuilder.addCompilationData(_compData.build());
            this.writeCompilationDataToTrg(_kmoduleCacheBuilder.build(), kieBaseName);
        }
        return new KieModuleMetaInfo(typeInfos, rulesPerPackage);
    }

    private KieModuleCache.KModuleCache.Builder createCacheBuilder() {
        KieModuleCache.KModuleCache.Builder _kmoduleCacheBuilder = KieModuleCache.KModuleCache.newBuilder();
        return _kmoduleCacheBuilder;
    }

    private KieModuleCache.CompilationData.Builder createCompilationData() {
        KieModuleCache.CompilationData.Builder _cdata = KieModuleCache.CompilationData.newBuilder().setDialect("java");
        return _cdata;
    }

    private void addToCompilationData(KieModuleCache.CompilationData.Builder _cdata, JavaDialectRuntimeData runtimeData, List<String> types) {
        for (Map.Entry entry : runtimeData.getStore().entrySet()) {
            if (types.contains(entry.getKey())) continue;
            KieModuleCache.CompDataEntry _entry = KieModuleCache.CompDataEntry.newBuilder().setId((String)entry.getKey()).setData(ByteString.copyFrom((byte[])((byte[])entry.getValue()))).build();
            _cdata.addEntry(_entry);
        }
    }

    private void writeCompilationDataToTrg(KieModuleCache.KModuleCache _kmoduleCache, String kieBaseName) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            KieModuleCacheHelper.writeToStreamWithHeader(out, (Message)_kmoduleCache);
            this.trgMfs.write(KieBuilderImpl.getCompilationCachePath(this.releaseId, kieBaseName), out.toByteArray(), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getCompilationCachePath(ReleaseId releaseId, String kbaseName) {
        return ((ReleaseIdImpl)releaseId).getCompilationCachePathPrefix() + kbaseName.replace('.', '/') + "/kbase.cache";
    }

    private void writeKieModuleMetaInfo(KieModuleMetaInfo info) {
        this.trgMfs.write(KieModuleModelImpl.KMODULE_INFO_JAR_PATH, info.marshallMetaInfos().getBytes(), true);
    }

    public static boolean buildKieModule(InternalKieModule kModule, ResultsImpl messages) {
        return KieBuilderImpl.buildKieProject(kModule, messages, new KieModuleKieProject(kModule));
    }

    private static boolean buildKieProject(InternalKieModule kModule, ResultsImpl messages, KieModuleKieProject kProject) {
        kProject.init();
        kProject.verify(messages);
        if (messages.filterMessages(Message.Level.ERROR).isEmpty()) {
            KieServices.Factory.get().getRepository().addKieModule((KieModule)kModule);
            return true;
        }
        return false;
    }

    private void addKBasesFilesToTrg() {
        for (KieBaseModel kieBaseModel : this.kModuleModel.getKieBaseModels().values()) {
            this.addKBaseFilesToTrg(kieBaseModel);
        }
    }

    private KieBaseConfiguration getKnowledgeBaseConfiguration(KieBaseModel kieBase, Properties properties, ClassLoader ... classLoaders) {
        KieBaseConfiguration kbConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration((Properties)properties, (ClassLoader[])classLoaders);
        kbConf.setOption((KieBaseOption)kieBase.getEqualsBehavior());
        kbConf.setOption((KieBaseOption)kieBase.getEventProcessingMode());
        kbConf.setOption((KieBaseOption)kieBase.getDeclarativeAgenda());
        return kbConf;
    }

    private void addKBaseFilesToTrg(KieBaseModel kieBase) {
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!(fileName = fileName.replace(File.separatorChar, '/')).startsWith(RESOURCES_ROOT) || !KieBuilderImpl.isFileInKieBase(kieBase, fileName)) continue;
            this.copySourceToTarget(fileName);
        }
    }

    String copySourceToTarget(String fileName) {
        if (!fileName.startsWith(RESOURCES_ROOT)) {
            return null;
        }
        byte[] bytes = this.srcMfs.getBytes(fileName);
        String trgFileName = fileName.substring(RESOURCES_ROOT.length());
        if (bytes != null) {
            FormatConverter formatConverter = FormatsManager.get().getConverterFor(trgFileName);
            if (formatConverter != null) {
                FormatConversionResult result = formatConverter.convert(trgFileName, bytes);
                trgFileName = result.getConvertedName();
                this.trgMfs.write(trgFileName, result.getContent(), true);
            } else if (this.getResourceType(fileName) != null) {
                this.trgMfs.write(trgFileName, bytes, true);
            }
        } else {
            this.trgMfs.remove(trgFileName);
        }
        return trgFileName;
    }

    private ResourceType getResourceType(String fileName) {
        if (this.srcMfs.isAvailable(fileName + ".properties")) {
            Properties prop = new Properties();
            try {
                prop.load(new ByteArrayInputStream(this.srcMfs.getBytes(fileName + ".properties")));
                return KieBuilderImpl.getResourceType(ResourceTypeImpl.fromProperties((Properties)prop));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    void cloneKieModuleForIncrementalCompilation() {
        this.trgMfs = this.trgMfs.clone();
        this.init();
        this.kModule = this.kModule.cloneForIncrementalCompilation(this.releaseId, this.kModuleModel, this.trgMfs);
    }

    private void addMetaInfBuilder() {
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.startsWith(RESOURCES_ROOT) || FormatsManager.isKieExtension(fileName)) continue;
            byte[] bytes = this.srcMfs.getBytes(fileName);
            this.trgMfs.write(fileName.substring(RESOURCES_ROOT.length() - 1), bytes, true);
        }
    }

    private static ResourceType getResourceType(InternalKieModule kieModule, String fileName) {
        return KieBuilderImpl.getResourceType(kieModule.getResourceConfiguration(fileName));
    }

    private static ResourceType getResourceType(ResourceConfiguration conf) {
        return conf instanceof ResourceConfigurationImpl ? ((ResourceConfigurationImpl)conf).getResourceType() : null;
    }

    public static boolean filterFileInKBase(InternalKieModule kieModule, KieBaseModel kieBase, String fileName) {
        return KieBuilderImpl.isFileInKieBase(kieBase, fileName) && (FormatsManager.isKieExtension(fileName) || KieBuilderImpl.getResourceType(kieModule, fileName) != null);
    }

    private static boolean isFileInKieBase(KieBaseModel kieBase, String fileName) {
        if (kieBase.getPackages().isEmpty()) {
            return true;
        }
        int lastSep = fileName.lastIndexOf("/");
        String pkgNameForFile = lastSep > 0 ? fileName.substring(0, lastSep) : fileName;
        pkgNameForFile = pkgNameForFile.replace('/', '.');
        for (String pkgName : kieBase.getPackages()) {
            boolean isNegative = pkgName.startsWith("!");
            if (isNegative) {
                pkgName = pkgName.substring(1);
            }
            if (!pkgName.equals("*") && !pkgNameForFile.endsWith(pkgName) && (!pkgName.endsWith(".*") || !pkgNameForFile.contains(pkgName.substring(0, pkgName.length() - 2)))) continue;
            return !isNegative;
        }
        return false;
    }

    public Results getResults() {
        if (!this.isBuilt()) {
            this.buildAll();
        }
        return this.results;
    }

    public KieModule getKieModule() {
        return this.getKieModule(false);
    }

    public KieModule getKieModuleIgnoringErrors() {
        return this.getKieModule(true);
    }

    private KieModule getKieModule(boolean ignoreErrors) {
        if (!this.isBuilt()) {
            this.buildAll();
        }
        if (!ignoreErrors && (this.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}) || this.kModule == null)) {
            throw new RuntimeException("Unable to get KieModule, Errors Existed");
        }
        return this.kModule;
    }

    private boolean isBuilt() {
        return this.kModule != null;
    }

    private void buildKieModuleModel() {
        if (this.srcMfs.isAvailable(KieModuleModelImpl.KMODULE_SRC_PATH)) {
            this.kModuleModelXml = this.srcMfs.getBytes(KieModuleModelImpl.KMODULE_SRC_PATH);
            try {
                this.kModuleModel = KieModuleModelImpl.fromXML(new ByteArrayInputStream(this.kModuleModelXml));
            }
            catch (Exception e) {
                this.results.addMessage(Message.Level.ERROR, "kmodule.xml", "kmodule.xml found, but unable to read\n" + e.getMessage());
            }
        } else {
            this.kModuleModel = KieServices.Factory.get().newKieModuleModel();
        }
        if (KieBuilderImpl.setDefaultsforEmptyKieModule(this.kModuleModel)) {
            this.kModuleModelXml = this.kModuleModel.toXML().getBytes();
        }
    }

    public static boolean setDefaultsforEmptyKieModule(KieModuleModel kModuleModel) {
        if (kModuleModel != null && kModuleModel.getKieBaseModels().isEmpty()) {
            KieBaseModel kieBaseModel = kModuleModel.newKieBaseModel("defaultKieBase").addPackage("*").setDefault(true);
            kieBaseModel.newKieSessionModel("defaultKieSession").setDefault(true);
            kieBaseModel.newKieSessionModel("defaultStatelessKieSession").setType(KieSessionModel.KieSessionType.STATELESS).setDefault(true);
            return true;
        }
        return false;
    }

    private void buildPomModel() {
        this.pomXml = KieBuilderImpl.getOrGeneratePomXml(this.srcMfs);
        if (this.pomXml == null) {
            return;
        }
        try {
            PomModel tempPomModel = PomModel.Parser.parse("pom.xml", new ByteArrayInputStream(this.pomXml));
            KieBuilderImpl.validatePomModel(tempPomModel);
            this.pomModel = tempPomModel;
        }
        catch (Exception e) {
            this.results.addMessage(Message.Level.ERROR, "pom.xml", "maven pom.xml found, but unable to read\n" + e.getMessage());
        }
    }

    public static void validatePomModel(PomModel pomModel) {
        ReleaseId pomReleaseId = pomModel.getReleaseId();
        if (StringUtils.isEmpty((CharSequence)pomReleaseId.getGroupId()) || StringUtils.isEmpty((CharSequence)pomReleaseId.getArtifactId()) || StringUtils.isEmpty((CharSequence)pomReleaseId.getVersion())) {
            throw new RuntimeException("Maven pom.properties exists but ReleaseId content is malformed");
        }
    }

    public static byte[] getOrGeneratePomXml(ResourceReader mfs) {
        if (mfs.isAvailable("pom.xml")) {
            return mfs.getBytes("pom.xml");
        }
        return KieBuilderImpl.generatePomXml(KieServices.Factory.get().getRepository().getDefaultReleaseId()).getBytes();
    }

    public void writePomAndKModule() {
        this.addMetaInfBuilder();
        if (this.pomXml != null) {
            ReleaseIdImpl g = (ReleaseIdImpl)this.releaseId;
            this.trgMfs.write(g.getPomXmlPath(), this.pomXml, true);
            this.trgMfs.write(g.getPomPropertiesPath(), KieBuilderImpl.generatePomProperties(this.releaseId).getBytes(), true);
        }
        if (this.kModuleModelXml != null) {
            this.trgMfs.write(KieModuleModelImpl.KMODULE_JAR_PATH, this.kModuleModel.toXML().getBytes(), true);
        }
    }

    public static String generatePomXml(ReleaseId releaseId) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n");
        sBuilder.append("         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"> \n");
        sBuilder.append("    <modelVersion>4.0.0</modelVersion> \n");
        sBuilder.append("    <groupId>");
        sBuilder.append(releaseId.getGroupId());
        sBuilder.append("</groupId> \n");
        sBuilder.append("    <artifactId>");
        sBuilder.append(releaseId.getArtifactId());
        sBuilder.append("</artifactId> \n");
        sBuilder.append("    <version>");
        sBuilder.append(releaseId.getVersion());
        sBuilder.append("</version> \n");
        sBuilder.append("    <packaging>jar</packaging> \n");
        sBuilder.append("    <name>Default</name> \n");
        sBuilder.append("</project>  \n");
        return sBuilder.toString();
    }

    public static String generatePomProperties(ReleaseId releaseId) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("groupId=");
        sBuilder.append(releaseId.getGroupId());
        sBuilder.append("\n");
        sBuilder.append("artifactId=");
        sBuilder.append(releaseId.getArtifactId());
        sBuilder.append("\n");
        sBuilder.append("version=");
        sBuilder.append(releaseId.getVersion());
        sBuilder.append("\n");
        return sBuilder.toString();
    }

    private void compileJavaClasses(ClassLoader classLoader) {
        ArrayList<String> classFiles = new ArrayList<String>();
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.endsWith(".class")) continue;
            this.trgMfs.write(fileName, this.srcMfs.getBytes(fileName), true);
            classFiles.add(fileName.substring(0, fileName.length() - ".class".length()));
        }
        ArrayList<String> javaFiles = new ArrayList<String>();
        ArrayList<String> javaTestFiles = new ArrayList<String>();
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.endsWith(".java") || classFiles.contains(fileName.substring(0, fileName.length() - ".java".length()))) continue;
            if (!(fileName = fileName.replace(File.separatorChar, '/')).startsWith(JAVA_ROOT) && !fileName.startsWith(JAVA_TEST_ROOT)) {
                this.results.addMessage(Message.Level.WARNING, fileName, "Found Java file out of the Java source folder: \"" + fileName + "\"");
                continue;
            }
            if (fileName.substring(JAVA_ROOT.length()).indexOf(47) < 0) {
                this.results.addMessage(Message.Level.ERROR, fileName, "A Java class must have a package: " + fileName.substring(JAVA_ROOT.length()) + " is not allowed");
                continue;
            }
            if (fileName.startsWith(JAVA_ROOT)) {
                javaFiles.add(fileName);
                continue;
            }
            javaTestFiles.add(fileName);
        }
        this.compileJavaClasses(classLoader, javaFiles, JAVA_ROOT);
        this.compileJavaClasses(classLoader, javaTestFiles, JAVA_TEST_ROOT);
    }

    private void compileJavaClasses(ClassLoader classLoader, List<String> javaFiles, String rootFolder) {
        if (!javaFiles.isEmpty()) {
            String[] sourceFiles = javaFiles.toArray(new String[javaFiles.size()]);
            EclipseJavaCompiler compiler = this.createCompiler(rootFolder);
            CompilationResult res = compiler.compile(sourceFiles, this.srcMfs, this.trgMfs, classLoader);
            for (CompilationProblem problem : res.getErrors()) {
                this.results.addMessage(problem);
            }
            for (CompilationProblem problem : res.getWarnings()) {
                this.results.addMessage(problem);
            }
        }
    }

    public static String findPomProperties(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String fileName = zipEntry.getName();
            if (!fileName.endsWith("pom.properties") || !fileName.startsWith("META-INF/maven/")) continue;
            return fileName;
        }
        return null;
    }

    public static File findPomProperties(File root) {
        File mavenRoot = new File(root, "META-INF/maven");
        return KieBuilderImpl.recurseToPomProperties(mavenRoot);
    }

    public static File recurseToPomProperties(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                if (child.isDirectory()) {
                    File returnedFile = KieBuilderImpl.recurseToPomProperties(child);
                    if (returnedFile == null) continue;
                    return returnedFile;
                }
                if (!child.getName().endsWith("pom.properties")) continue;
                return child;
            }
        }
        return null;
    }

    private EclipseJavaCompiler createCompiler(String prefix) {
        EclipseJavaCompilerSettings settings = new EclipseJavaCompilerSettings();
        settings.setSourceVersion("1.5");
        settings.setTargetVersion("1.5");
        return new EclipseJavaCompiler(settings, prefix);
    }

    public KieBuilderSet createFileSet(String ... files) {
        if (this.kieBuilderSet == null) {
            this.kieBuilderSet = new KieBuilderSetImpl(this);
        }
        return this.kieBuilderSet.setFiles(files);
    }

    public IncrementalResults incrementalBuild() {
        return new KieBuilderSetImpl(this).build();
    }
}

