/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.jdbc.AbstractParameterResultSetHandler;
import com.mockrunner.jdbc.ParameterUtil;
import com.mockrunner.mock.jdbc.MockParameterMetaData;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.MockResultSetMetaData;
import com.mockrunner.mock.jdbc.MockStatement;
import com.mockrunner.util.common.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MockPreparedStatement
extends MockStatement
implements PreparedStatement {
    private AbstractParameterResultSetHandler resultSetHandler;
    private Map paramObjects = new HashMap();
    private List batchParameters = new ArrayList();
    private String sql;
    private MockParameterMetaData parameterMetaData;

    public MockPreparedStatement(Connection connection, String string) {
        super(connection);
        this.sql = string;
        this.prepareParameterMetaData();
    }

    public MockPreparedStatement(Connection connection, String string, int n, int n2) {
        super(connection, n, n2);
        this.sql = string;
        this.prepareParameterMetaData();
    }

    public MockPreparedStatement(Connection connection, String string, int n, int n2, int n3) {
        super(connection, n, n2, n3);
        this.sql = string;
        this.prepareParameterMetaData();
    }

    public void setPreparedStatementResultSetHandler(AbstractParameterResultSetHandler abstractParameterResultSetHandler) {
        super.setResultSetHandler(abstractParameterResultSetHandler);
        this.resultSetHandler = abstractParameterResultSetHandler;
    }

    private void prepareParameterMetaData() {
        int n = StringUtil.countMatches(this.sql, "?");
        this.parameterMetaData = new MockParameterMetaData();
        this.parameterMetaData.setParameterCount(n);
    }

    public String getSQL() {
        return this.sql;
    }

    public Map getIndexedParameterMap() {
        return Collections.unmodifiableMap(this.paramObjects);
    }

    public Map getParameterMap() {
        return this.getIndexedParameterMap();
    }

    public Object getParameter(int n) {
        return this.paramObjects.get(new Integer(n));
    }

    public void setObject(int n, Object object) throws SQLException {
        this.paramObjects.put(new Integer(n), object);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object);
    }

    public void addBatch() throws SQLException {
        this.batchParameters.add(new HashMap(this.paramObjects));
    }

    public void clearParameters() throws SQLException {
        this.paramObjects.clear();
    }

    public boolean execute() throws SQLException {
        boolean bl = this.isQuery(this.getSQL());
        if (bl) {
            this.executeQuery();
        } else {
            this.executeUpdate();
        }
        return bl;
    }

    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.paramObjects);
    }

    protected ResultSet executeQuery(Map map) throws SQLException {
        SQLException sQLException = this.resultSetHandler.getSQLException(this.sql, map);
        if (null != sQLException) {
            throw sQLException;
        }
        sQLException = this.resultSetHandler.getSQLException(this.sql);
        if (null != sQLException) {
            throw sQLException;
        }
        MockResultSet mockResultSet = this.resultSetHandler.getResultSet(this.getSQL(), map);
        this.resultSetHandler.addParameterMapForExecutedStatement(this.getSQL(), this.getParameterMapCopy(map));
        if (null != mockResultSet) {
            this.resultSetHandler.addExecutedStatement(this.getSQL());
            mockResultSet = this.cloneResultSet(mockResultSet);
            this.resultSetHandler.addReturnedResultSet(mockResultSet);
            this.setResultSet(mockResultSet);
            return mockResultSet;
        }
        return super.executeQuery(this.getSQL());
    }

    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.paramObjects);
    }

    protected int executeUpdate(Map map) throws SQLException {
        SQLException sQLException = this.resultSetHandler.getSQLException(this.sql, map);
        if (null != sQLException) {
            throw sQLException;
        }
        sQLException = this.resultSetHandler.getSQLException(this.sql);
        if (null != sQLException) {
            throw sQLException;
        }
        Integer n = this.resultSetHandler.getUpdateCount(this.getSQL(), map);
        this.resultSetHandler.addParameterMapForExecutedStatement(this.getSQL(), this.getParameterMapCopy(map));
        if (null != n) {
            this.resultSetHandler.addExecutedStatement(this.getSQL());
            int n2 = n;
            this.setUpdateCount(n2);
            return n2;
        }
        return super.executeUpdate(this.getSQL());
    }

    public int[] executeBatch() throws SQLException {
        return this.executeBatch(this.batchParameters);
    }

    protected int[] executeBatch(List list) throws SQLException {
        int[] nArray = new int[list.size()];
        if (this.isQuery(this.getSQL())) {
            throw new BatchUpdateException("SQL " + this.getSQL() + " returned a ResultSet.", null);
        }
        for (int i = 0; i < nArray.length; ++i) {
            Map map = (Map)list.get(i);
            nArray[i] = this.executeUpdate(map);
        }
        return nArray;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new MockResultSetMetaData();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.parameterMetaData;
    }

    public void setArray(int n, Array array) throws SQLException {
        this.setObject(n, array);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setObject(n, inputStream);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setObject(n, bigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setObject(n, inputStream);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.setObject(n, blob);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.setObject(n, new Boolean(bl));
    }

    public void setByte(int n, byte by) throws SQLException {
        this.setObject(n, new Byte(by));
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.setObject(n, byArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setObject(n, reader);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.setObject(n, clob);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setObject(n, date);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setObject(n, date);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.setObject(n, new Double(d));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setObject(n, new Float(f));
    }

    public void setInt(int n, int n2) throws SQLException {
        this.setObject(n, new Integer(n2));
    }

    public void setLong(int n, long l) throws SQLException {
        this.setObject(n, new Long(l));
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setObject(n, null);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.setObject(n, null);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.setObject(n, ref);
    }

    public void setShort(int n, short s) throws SQLException {
        this.setObject(n, new Short(s));
    }

    public void setString(int n, String string) throws SQLException {
        this.setObject(n, string);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setObject(n, time);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setObject(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setObject(n, timestamp);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setObject(n, timestamp);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setObject(n, inputStream);
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.setObject(n, uRL);
    }

    private Map getParameterMapCopy(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            Object object = ParameterUtil.copyParameter(v);
            hashMap.put(k, object);
        }
        return hashMap;
    }
}

