/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class EmailUtils {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("(?:(.+)(?: +| *<))?([^@ ]+(?:@| at )[^@ ]+\\.[a-zA-Z0-9_-]{2,4})(?: *>)?");

    public static EmailWithName parseEmail(String x) {
        if (StringUtils.isBlank(x)) {
            return null;
        }
        EmailWithName n = new EmailWithName();
        Matcher m = EMAIL_PATTERN.matcher(x);
        if (m.find()) {
            n.name = StringUtils.trimToNull(m.group(1));
            n.email = StringUtils.trimToNull(m.group(2));
        } else {
            n.name = StringUtils.trimToNull(x);
        }
        return n;
    }

    private EmailUtils() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    public static class EmailWithName {
        public String email;
        public String name;
    }
}

