/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.file.properties;

import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Properties;

public class PropertiesUtil {
    public static final String UTF8_ENCODING = "UTF-8";

    private PropertiesUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String propertiesFile) throws IOException, IllegalArgumentException {
        Properties tempProperties;
        InputStream inputStream = null;
        try {
            URL configFileURL = Resources.getResource(propertiesFile);
            inputStream = Resources.newInputStreamSupplier(configFileURL).getInput();
            tempProperties = new Properties();
            tempProperties.load(inputStream);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(inputStream);
            throw throwable;
        }
        Closeables.closeQuietly(inputStream);
        return tempProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readFromFile(String filepath) throws IOException, IllegalArgumentException {
        if (Strings.isNullOrEmpty(filepath)) {
            throw new IllegalArgumentException("No properties file given");
        }
        File pf = new File(filepath);
        if (!pf.exists()) {
            throw new IllegalArgumentException("Cannot find properties file " + filepath);
        }
        Properties properties = new Properties();
        FileReader reader = new FileReader(pf);
        try {
            properties.load(reader);
        }
        finally {
            Closeables.closeQuietly(reader);
        }
        return properties;
    }

    public static Double propertyAsDouble(Properties p, String key, boolean exceptionForNull, Double defaultValue) throws IllegalArgumentException {
        String v = p.getProperty(key);
        if (v != null) {
            try {
                return Double.parseDouble(v);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid value[" + v + "] supplied for " + key);
            }
        }
        if (exceptionForNull) {
            throw new IllegalArgumentException("Missing property for " + key);
        }
        return defaultValue;
    }

    public static Float propertyAsFloat(Properties p, String key, boolean exceptionForNull, Float defaultValue) throws IllegalArgumentException {
        String v = p.getProperty(key);
        if (v != null) {
            try {
                return Float.valueOf(Float.parseFloat(v));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid value[" + v + "] supplied for " + key);
            }
        }
        if (exceptionForNull) {
            throw new IllegalArgumentException("Missing property for " + key);
        }
        return defaultValue;
    }

    public static Integer propertyAsInt(Properties p, String key, boolean exceptionForNull, Integer defaultValue) throws IllegalArgumentException {
        String v = p.getProperty(key);
        if (v != null) {
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid value[" + v + "] supplied for " + key);
            }
        }
        if (exceptionForNull) {
            throw new IllegalArgumentException("Missing property for " + key);
        }
        return defaultValue;
    }

    public static byte[] propertyAsUTF8Bytes(Properties p, String key, boolean exceptionForNull, byte[] defaultValue) throws IllegalArgumentException {
        String v = p.getProperty(key);
        if (v != null) {
            try {
                return v.getBytes(UTF8_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("System does not support UTF-8 encoding");
            }
        }
        if (exceptionForNull) {
            throw new IllegalArgumentException("Missing property for " + key);
        }
        return defaultValue;
    }
}

