/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.extractors;

import java.lang.reflect.Method;
import org.drools.core.RuntimeDroolsException;
import org.drools.core.base.BaseClassFieldWriter;
import org.drools.core.base.ValueType;

public abstract class BaseBooleanClassFieldWriter
extends BaseClassFieldWriter {
    private static final long serialVersionUID = 510L;

    public BaseBooleanClassFieldWriter(Class<?> clazz, String fieldName) {
        super(clazz, fieldName);
    }

    protected BaseBooleanClassFieldWriter(int index, Class<?> fieldType, ValueType valueType) {
        super(index, fieldType, valueType);
    }

    @Override
    public void setValue(Object bean, Object value) {
        this.setBooleanValue(bean, value == null ? false : (Boolean)value);
    }

    @Override
    public abstract void setBooleanValue(Object var1, boolean var2);

    @Override
    public void setByteValue(Object bean, byte value) {
        throw new RuntimeDroolsException("Conversion to boolean not supported from byte");
    }

    @Override
    public void setCharValue(Object bean, char value) {
        throw new RuntimeDroolsException("Conversion to boolean not supported from char");
    }

    @Override
    public void setDoubleValue(Object bean, double value) {
        throw new RuntimeDroolsException("Conversion to boolean not supported from double");
    }

    @Override
    public void setFloatValue(Object bean, float value) {
        throw new RuntimeDroolsException("Conversion to boolean not supported from float");
    }

    @Override
    public void setIntValue(Object bean, int value) {
        throw new RuntimeDroolsException("Conversion to boolean not supported from int");
    }

    @Override
    public void setLongValue(Object bean, long value) {
        throw new RuntimeDroolsException("Conversion to boolean not supported from long");
    }

    @Override
    public void setShortValue(Object bean, short value) {
        throw new RuntimeDroolsException("Conversion to boolean not supported from short");
    }

    @Override
    public Method getNativeWriteMethod() {
        try {
            return this.getClass().getDeclaredMethod("setBooleanValue", Object.class, Boolean.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }
}

