/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.gbif.dwc.record.Record;
import org.gbif.dwc.terms.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarRecord
implements Iterable<Record> {
    private Record core;
    private final SortedMap<String, List<Record>> extensions = new TreeMap<String, List<Record>>();

    public StarRecord(Collection<String> extensions) {
        for (String rowType : extensions) {
            this.extensions.put(rowType, new ArrayList());
        }
    }

    public void addRecord(String rowType, Record record) {
        if (!this.extensions.containsKey(rowType)) {
            throw new IllegalArgumentException("RowType not supported");
        }
        ((List)this.extensions.get(rowType)).add(record);
    }

    public Record core() {
        return this.core;
    }

    public List<Record> extension(Term rowType) {
        return this.extension(rowType.qualifiedName());
    }

    public List<Record> extension(String rowType) {
        return (List)this.extensions.get(rowType);
    }

    public Map<String, List<Record>> extensions() {
        return this.extensions;
    }

    @Override
    public Iterator<Record> iterator() {
        ArrayList<Record> records = new ArrayList<Record>();
        for (List<Record> recs : this.extensions.values()) {
            records.addAll(recs);
        }
        return records.iterator();
    }

    public void newCoreRecord(Record core) {
        this.core = core;
        for (List<Record> lists : this.extensions.values()) {
            lists.clear();
        }
    }

    public Set<String> rowTypes() {
        return this.extensions.keySet();
    }

    public int size() {
        int x = 0;
        for (List<Record> recs : this.extensions.values()) {
            x += recs.size();
        }
        return x;
    }
}

