/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.text;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.gbif.dwc.record.Record;
import org.gbif.dwc.record.RecordIterator;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.gbif.dwc.text.Archive;
import org.gbif.dwc.text.ArchiveField;
import org.gbif.file.CSVReader;
import org.gbif.file.CSVReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveFile
implements Iterable<Record> {
    private static final TermFactory TERM_FACTORY = TermFactory.instance();
    private ArchiveField id;
    private Archive archive;
    private final LinkedList<String> locations = new LinkedList();
    private String title;
    private String fieldsTerminatedBy;
    private Character fieldsEnclosedBy;
    private String linesTerminatedBy = "\n";
    private String encoding = "utf8";
    private String rowType = "http://rs.tdwg.org/dwc/xsd/simpledarwincore/SimpleDarwinRecord";
    private Integer ignoreHeaderLines = 0;
    private String dateFormat = "YYYY-MM-DD";
    private Map<Term, ArchiveField> fields = new HashMap<Term, ArchiveField>();

    public static ArchiveFile buildCsvFile() {
        ArchiveFile af = new ArchiveFile();
        af.setFieldsEnclosedBy(Character.valueOf('\"'));
        af.setFieldsTerminatedBy(",");
        return af;
    }

    public static ArchiveFile buildTabFile() {
        ArchiveFile af = new ArchiveFile();
        af.setFieldsEnclosedBy(null);
        af.setFieldsTerminatedBy("\t");
        return af;
    }

    public static File getLocationFileSorted(File location) {
        return new File(location.getParentFile(), location.getName() + "-sorted");
    }

    public static String getLocationSorted(String location) {
        return location + "-sorted";
    }

    public void addField(ArchiveField field) {
        this.fields.put(field.getTerm(), field);
    }

    public void addLocation(String location) {
        if (this.title == null) {
            this.title = location != null && location.lastIndexOf(47) > 1 ? location.substring(location.lastIndexOf(47) + 1, location.length()) : location;
        }
        this.locations.add(location);
    }

    public Archive getArchive() {
        return this.archive;
    }

    public CSVReader getCSVReader() throws IOException {
        return CSVReaderFactory.build(this);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public ArchiveField getField(Term term) {
        if (term == null) {
            return null;
        }
        return this.fields.get(term);
    }

    public ArchiveField getField(String term) {
        return this.getField(TERM_FACTORY.findTerm(term));
    }

    public Map<Term, ArchiveField> getFields() {
        return this.fields;
    }

    public Character getFieldsEnclosedBy() {
        return this.fieldsEnclosedBy;
    }

    public List<ArchiveField> getFieldsSorted() {
        ArrayList<ArchiveField> list = new ArrayList<ArchiveField>(this.fields.values());
        Collections.sort(list, new ArchiveFieldIndexComparator());
        return list;
    }

    public String getFieldsTerminatedBy() {
        return this.fieldsTerminatedBy;
    }

    public ArchiveField getId() {
        return this.id;
    }

    public Integer getIgnoreHeaderLines() {
        return this.ignoreHeaderLines;
    }

    public String getLinesTerminatedBy() {
        return this.linesTerminatedBy;
    }

    public String getLocation() {
        return this.locations.getFirst();
    }

    public File getLocationFile() {
        File dataFile = this.archive != null ? (this.getLocation() == null ? this.archive.getLocation() : (this.getLocation().startsWith("/") ? new File(this.getLocation()) : new File(this.archive.getLocation(), this.getLocation()))) : new File(this.getLocation());
        return dataFile;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public String getRowType() {
        return this.rowType;
    }

    public Set<Term> getTerms() {
        return this.fields.keySet();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasTerm(Term term) {
        return this.getField(term) != null;
    }

    public boolean hasTerm(String term) {
        return this.getField(term) != null;
    }

    @Override
    public Iterator<Record> iterator() {
        return RecordIterator.build(this, true);
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setEncoding(String encoding) {
        this.encoding = StringUtils.trimToNull((String)encoding);
    }

    public void setFieldsEnclosedBy(Character fieldsEnclosedBy) {
        this.fieldsEnclosedBy = fieldsEnclosedBy;
    }

    public void setFieldsTerminatedBy(String fieldsTerminatedBy) {
        this.fieldsTerminatedBy = (String)StringUtils.defaultIfEmpty((CharSequence)fieldsTerminatedBy, null);
    }

    public void setId(ArchiveField id) {
        this.id = id;
    }

    public void setIgnoreHeaderLines(Integer ignoreHeaderLines) {
        if (ignoreHeaderLines == null || ignoreHeaderLines < 0) {
            ignoreHeaderLines = 0;
        }
        this.ignoreHeaderLines = ignoreHeaderLines;
    }

    public void setLinesTerminatedBy(String linesTerminatedBy) {
        this.linesTerminatedBy = (String)StringUtils.defaultIfEmpty((CharSequence)linesTerminatedBy, null);
    }

    public void setRowType(String rowType) {
        this.rowType = rowType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ArchiveFieldIndexComparator
    implements Comparator<ArchiveField> {
        @Override
        public int compare(ArchiveField o1, ArchiveField o2) {
            if (o1.getIndex() == null && o2.getIndex() == null) {
                return 0;
            }
            if (o1.getIndex() == null) {
                return -1;
            }
            if (o2.getIndex() == null) {
                return 1;
            }
            if (o1.getIndex().equals(o2.getIndex())) {
                return o1.getTerm().qualifiedName().compareToIgnoreCase(o2.getTerm().qualifiedName());
            }
            return o1.getIndex().compareTo(o2.getIndex());
        }
    }
}

