/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.text;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.gbif.dwc.text.Archive;
import org.gbif.dwc.text.ArchiveField;
import org.gbif.dwc.text.ArchiveFile;
import org.gbif.dwc.text.UnsupportedArchiveException;
import org.gbif.file.CSVReader;
import org.gbif.file.CSVReaderFactory;
import org.gbif.file.DownloadUtil;
import org.gbif.metadata.handler.BasicMetadataSaxHandler;
import org.gbif.utils.file.BomSafeInputStreamWrapper;
import org.gbif.utils.file.CompressionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ArchiveFactory {
    private static final TermFactory TERM_FACTORY = TermFactory.instance();
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveFactory.class);
    private static final SAXParserFactory SAX_FACTORY = SAXParserFactory.newInstance();

    public static Archive openArchive(URL archiveUrl, File workingDir) throws IOException, UnsupportedArchiveException {
        File downloadTo = new File(workingDir, "dwca-download");
        File dwca = new File(workingDir, "dwca");
        DownloadUtil.download(archiveUrl, downloadTo);
        return ArchiveFactory.openArchive(downloadTo, dwca);
    }

    public static Archive openArchive(File archiveFile, File archiveDir) throws IOException, UnsupportedArchiveException {
        try {
            List files = CompressionUtil.decompressFile((File)archiveDir, (File)archiveFile);
            return ArchiveFactory.openArchive(archiveDir);
        }
        catch (CompressionUtil.UnsupportedCompressionType e) {
            return ArchiveFactory.openArchive(archiveFile);
        }
    }

    public static Archive openArchive(File unzippedFolderLocation) throws IOException, UnsupportedArchiveException {
        Archive archive = new Archive();
        archive.setLocation(unzippedFolderLocation);
        File mf = null;
        if (unzippedFolderLocation.isFile()) {
            String suffix = unzippedFolderLocation.getName().substring(unzippedFolderLocation.getName().lastIndexOf("."));
            if (suffix.equalsIgnoreCase(".xml")) {
                mf = unzippedFolderLocation;
            }
        } else {
            mf = new File(unzippedFolderLocation, "meta.xml");
        }
        if (mf != null && mf.exists()) {
            File emlFile;
            ArchiveFactory.readMetaDescriptor(archive, new FileInputStream(mf), true);
            if (archive.getMetadataLocation() == null && (emlFile = new File(mf.getParentFile(), "eml.xml")).exists()) {
                archive.setMetadataLocation("eml.xml");
            }
        } else if (unzippedFolderLocation.isFile()) {
            ArchiveFile coreFile = ArchiveFactory.readFileHeaders(unzippedFolderLocation);
            archive.setCore(coreFile);
        } else {
            ArrayList<File> dataFiles = new ArrayList<File>();
            SuffixFileFilter ff = new SuffixFileFilter(".csv", IOCase.INSENSITIVE);
            dataFiles.addAll(Arrays.asList(unzippedFolderLocation.listFiles((FilenameFilter)ff)));
            ff = new SuffixFileFilter(".txt", IOCase.INSENSITIVE);
            dataFiles.addAll(Arrays.asList(unzippedFolderLocation.listFiles((FilenameFilter)ff)));
            if (dataFiles.size() == 1) {
                File emlFile;
                File dataFile = new File(unzippedFolderLocation, ((File)dataFiles.get(0)).getName());
                archive.setLocation(unzippedFolderLocation);
                if (archive.getMetadataLocation() == null && unzippedFolderLocation.isDirectory() && (emlFile = new File(unzippedFolderLocation, "eml.xml")).exists()) {
                    archive.setMetadataLocation("eml.xml");
                }
                ArchiveFile coreFile = ArchiveFactory.readFileHeaders(dataFile);
                coreFile.getLocations().clear();
                coreFile.addLocation(dataFile.getName());
                archive.setCore(coreFile);
            } else {
                throw new UnsupportedArchiveException("The archive given is a folder with more or less than 1 data files having a txt or csv suffix");
            }
        }
        ArchiveFactory.validateArchive(archive);
        LOG.debug("Archive contains " + archive.getExtensions().size() + " described extension files");
        LOG.debug("Archive contains " + archive.getCore().getFields().size() + " core properties");
        return archive;
    }

    public static Term findTerm(String termName) {
        return TERM_FACTORY.findTerm(termName);
    }

    private static ArchiveFile readFileHeaders(File dataFile) throws UnsupportedArchiveException, IOException {
        ArchiveFile dwcFile = new ArchiveFile();
        dwcFile.addLocation(null);
        dwcFile.setIgnoreHeaderLines(1);
        CSVReader reader = CSVReaderFactory.build(dataFile);
        dwcFile.setEncoding(reader.encoding);
        dwcFile.setFieldsTerminatedBy(reader.delimiter);
        dwcFile.setFieldsEnclosedBy(reader.quoteChar);
        String[] headers = reader.header;
        int index = 0;
        for (String head : headers) {
            if (head != null && head.length() > 1) {
                try {
                    Term dt = TERM_FACTORY.findTerm(head);
                    ArchiveField field = new ArchiveField(index, dt, null, ArchiveField.DataType.string);
                    if (dwcFile.getId() == null && (dt.equals(DwcTerm.occurrenceID) || dt.equals(DwcTerm.taxonID) || dt.equals(DcTerm.identifier))) {
                        dwcFile.setId(field);
                    } else {
                        dwcFile.addField(field);
                    }
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Illegal term name >>{}<< found in header, ignore column {}", (Object)head, (Object)index);
                }
            }
            ++index;
        }
        return dwcFile;
    }

    private static void readMetaDescriptor(Archive archive, InputStream metaDescriptor, boolean normaliseTerms) throws UnsupportedArchiveException {
        try {
            SAXParser p = SAX_FACTORY.newSAXParser();
            MetaHandler mh = new MetaHandler(archive);
            LOG.debug("Reading archive metadata file");
            p.parse((InputStream)new BomSafeInputStreamWrapper(metaDescriptor), (DefaultHandler)((Object)mh));
        }
        catch (Exception e1) {
            LOG.warn("Exception caught", (Throwable)e1);
            throw new UnsupportedArchiveException(e1);
        }
    }

    private static void validateArchive(Archive archive) throws UnsupportedArchiveException {
        ArchiveFactory.validateCoreFile(archive.getCore(), !archive.getExtensions().isEmpty());
        for (ArchiveFile af : archive.getExtensions()) {
            ArchiveFactory.validateExtensionFile(af);
        }
    }

    private static void validateCoreFile(ArchiveFile f, boolean hasExtensions) throws UnsupportedArchiveException {
        if (hasExtensions && f.getId() == null) {
            LOG.warn("DwC-A core data file " + f.getTitle() + " is lacking an id column. No extensions allowed in this case");
        }
        ArchiveFactory.validateFile(f);
    }

    private static void validateExtensionFile(ArchiveFile f) throws UnsupportedArchiveException {
        if (f.getId() == null) {
            throw new UnsupportedArchiveException("DwC-A data file " + f.getTitle() + " requires an id or foreign key to the core id");
        }
        ArchiveFactory.validateFile(f);
    }

    private static void validateFile(ArchiveFile f) throws UnsupportedArchiveException {
        if (f == null) {
            throw new UnsupportedArchiveException("DwC-A data file is NULL");
        }
        if (f.getLocationFile() == null) {
            throw new UnsupportedArchiveException("DwC-A data file " + f.getTitle() + " requires a location");
        }
        if (f.getEncoding() == null) {
            throw new UnsupportedArchiveException("DwC-A data file " + f.getTitle() + " requires a character encoding");
        }
    }

    static {
        SAX_FACTORY.setNamespaceAware(true);
        SAX_FACTORY.setValidating(false);
    }

    static class MetaHandler
    extends BasicMetadataSaxHandler {
        private static final String NS_DWCA = "http://rs.tdwg.org/dwc/text/";
        private Archive archive;
        private ArchiveFile af;

        protected MetaHandler(Archive archive) {
            this.archive = archive;
        }

        private static Character getFirstChar(String x) throws UnsupportedArchiveException {
            if (x == null || x.length() == 0) {
                return null;
            }
            if (x.length() == 1) {
                return Character.valueOf(x.charAt(0));
            }
            if (x.equalsIgnoreCase("\\t")) {
                return Character.valueOf('\t');
            }
            if (x.equalsIgnoreCase("\\n")) {
                return Character.valueOf('\n');
            }
            if (x.equalsIgnoreCase("\\r")) {
                return Character.valueOf('\r');
            }
            if (x.length() > 1) {
                throw new UnsupportedArchiveException("Only darwin core archives with a single quotation character are supported, but found >>>" + x + "<<<");
            }
            return Character.valueOf(' ');
        }

        private static void makeLocationPathsAbsolute(ArchiveFile af, File root) {
            ArrayList<String> newLocs = new ArrayList<String>();
            for (String loc : af.getLocations()) {
                newLocs.add(new File(root, af.getLocation()).getAbsolutePath());
            }
            af.getLocations().clear();
            for (String loc : newLocs) {
                af.getLocations().add(loc);
            }
        }

        private static String unescapeBackslash(String x) {
            if (x == null || x.length() == 0) {
                return null;
            }
            return x.replaceAll("\\\\t", String.valueOf('\t')).replaceAll("\\\\n", String.valueOf('\n')).replaceAll("\\\\r", String.valueOf('\r')).replaceAll("\\\\f", String.valueOf('\f'));
        }

        private ArchiveFile buildArchiveFile(Attributes attr) throws UnsupportedArchiveException {
            ArchiveFile dwcFile = new ArchiveFile();
            if (this.getAttr(attr, "encoding") != null) {
                dwcFile.setEncoding(this.getAttr(attr, "encoding"));
            }
            if (this.getAttr(attr, "fieldsTerminatedBy") != null) {
                dwcFile.setFieldsTerminatedBy(MetaHandler.unescapeBackslash(this.getAttr(attr, "fieldsTerminatedBy")));
            }
            if (this.getAttr(attr, "fieldsEnclosedBy") != null) {
                dwcFile.setFieldsEnclosedBy(MetaHandler.getFirstChar(this.getAttr(attr, "fieldsEnclosedBy")));
            }
            if (this.getAttr(attr, "linesTerminatedBy") != null) {
                dwcFile.setLinesTerminatedBy(MetaHandler.unescapeBackslash(this.getAttr(attr, "linesTerminatedBy")));
            }
            if (this.getAttr(attr, "rowType") != null) {
                dwcFile.setRowType(this.getAttr(attr, "rowType"));
            }
            String ignoreHeaderLines = this.getAttr(attr, "ignoreHeaderLines");
            try {
                dwcFile.setIgnoreHeaderLines(Integer.parseInt(ignoreHeaderLines));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            return dwcFile;
        }

        private ArchiveField buildField(Attributes attributes) {
            Term term = TERM_FACTORY.findTerm(this.getAttr(attributes, "term"));
            String defaultValue = this.getAttr(attributes, "default");
            ArchiveField.DataType type = ArchiveField.DataType.findByXmlSchemaType(this.getAttr(attributes, "type"));
            if (type == null) {
                type = ArchiveField.DataType.string;
            }
            String indexAsString = this.getAttr(attributes, "index");
            Integer index = null;
            if (indexAsString != null) {
                try {
                    index = Integer.parseInt(indexAsString);
                }
                catch (NumberFormatException e) {
                    throw new UnsupportedArchiveException(e);
                }
            }
            return new ArchiveField(index, term, defaultValue, type);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (!localName.equalsIgnoreCase("archive")) {
                if (localName.equalsIgnoreCase("core")) {
                    this.archive.setCore(this.af);
                } else if (localName.equalsIgnoreCase("extension")) {
                    if (this.af.getId() != null && this.af.getId().getIndex() != null) {
                        this.archive.addExtension(this.af);
                    } else {
                        this.log.warn("Skipping extension [" + this.af.getRowType() + "] with no index attribute");
                    }
                } else if (localName.equalsIgnoreCase("location")) {
                    this.af.addLocation(this.content);
                }
            }
        }

        private String getAttr(Attributes attributes, String key) {
            String val = null;
            if (attributes != null && (val = attributes.getValue("", key)) == null) {
                val = attributes.getValue(NS_DWCA, key);
            }
            return val;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (localName.equalsIgnoreCase("archive") || localName.equalsIgnoreCase("stararchive")) {
                this.archive.setMetadataLocation(this.getAttr(attributes, "metadata"));
            } else if (localName.equalsIgnoreCase("core") || localName.equalsIgnoreCase("extension")) {
                this.af = new ArchiveFile();
                if (localName.equalsIgnoreCase("core") || localName.equalsIgnoreCase("extension")) {
                    this.af = this.buildArchiveFile(attributes);
                }
            } else if (localName.equalsIgnoreCase("coreid") || localName.equalsIgnoreCase("id")) {
                ArchiveField field = this.buildField(attributes);
                if (this.af != null) {
                    this.af.setId(field);
                } else {
                    this.log.warn(localName + " field found outside of an archive file");
                }
            } else if (localName.equalsIgnoreCase("field")) {
                ArchiveField field = this.buildField(attributes);
                if (this.af != null) {
                    this.af.addField(field);
                } else {
                    this.log.warn("field found outside of an archive file");
                }
            }
        }
    }
}

