/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.record;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.gbif.dwc.record.Record;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.gbif.dwc.text.ArchiveField;
import org.gbif.dwc.text.ArchiveFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordImpl
implements Record {
    private static final Pattern NULL_REPL = Pattern.compile("^\\s*(null|\\\\N)?\\s*$", 2);
    private static final TermFactory TERM_FACTORY = TermFactory.instance();
    private final ArchiveField id;
    private final Map<Term, ArchiveField> fields;
    protected String[] row;
    private final String rowType;
    private final boolean replaceNulls;

    public RecordImpl(ArchiveField id, Collection<ArchiveField> fields, String rowType, boolean replaceNulls) {
        this.id = id;
        this.fields = new HashMap<Term, ArchiveField>();
        for (ArchiveField f : fields) {
            this.fields.put(f.getTerm(), f);
        }
        this.rowType = rowType;
        this.replaceNulls = replaceNulls;
    }

    public RecordImpl(ArchiveField id, Map<Term, ArchiveField> fields, String rowType, boolean replaceNulls) {
        this.id = id;
        this.fields = fields;
        this.rowType = rowType;
        this.replaceNulls = replaceNulls;
    }

    public RecordImpl(ArchiveFile af, boolean replaceNulls) {
        this.id = af.getId();
        this.fields = af.getFields();
        this.rowType = af.getRowType();
        this.replaceNulls = replaceNulls;
    }

    protected String replaceNull(String val) {
        if (val == null || NULL_REPL.matcher(val).find()) {
            return null;
        }
        return val;
    }

    @Override
    public String column(int index) {
        if (this.row.length > index) {
            return this.row[index];
        }
        return null;
    }

    public boolean hasRow() {
        return this.row != null;
    }

    @Override
    public String id() {
        if (this.id != null) {
            return this.column(this.id.getIndex());
        }
        return null;
    }

    @Override
    public String rowType() {
        return this.rowType;
    }

    public void setRow(String[] row) {
        this.row = row;
    }

    public String toString() {
        return "Record{" + this.id() + "}[" + StringUtils.join((Object[])this.row, (String)"|") + "]";
    }

    private String value(ArchiveField f) {
        if (f != null) {
            if (f.getIndex() == null) {
                return f.getDefaultValue();
            }
            String val = this.column(f.getIndex());
            if (StringUtils.trimToNull((String)val) == null) {
                return f.getDefaultValue();
            }
            return val;
        }
        return null;
    }

    @Override
    public String value(Term term) {
        if (term == null) {
            return null;
        }
        return this.value(this.fields.get(term));
    }

    @Override
    public String value(String qterm) {
        return this.value(TERM_FACTORY.findTerm(qterm));
    }

    @Override
    public Collection<Term> terms() {
        return this.fields.keySet();
    }
}

