/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.handler;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gbif.metadata.DateUtils;
import org.gbif.metadata.handler.BasicMetadataSaxHandler;
import org.xml.sax.SAXException;

public class EmlHandler
extends BasicMetadataSaxHandler {
    private List<String> keywords;
    private List<String> description;

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.bm.setSubject(Strings.emptyToNull((String)Joiner.on((String)"; ").useForNull("").join(this.keywords).trim()));
        this.bm.setDescription(Strings.emptyToNull((String)Joiner.on((String)" \n").useForNull("").join(this.description).trim()));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (this.content != null) {
            if (this.parents.startsWith("/eml/additionalmetadata/metadata")) {
                this.bm.addAdditionalMetadata(localName, this.content);
            } else if (this.parents.startsWith("/eml/dataset/keywordset")) {
                if (localName.equalsIgnoreCase("keyword")) {
                    this.keywords.add(this.content);
                }
            } else if (this.parents.startsWith("/eml/dataset/abstract")) {
                if (localName.equalsIgnoreCase("para")) {
                    this.description.add(this.content);
                }
            } else if (this.parents.startsWith("/eml/dataset/creator")) {
                if (localName.equalsIgnoreCase("onlineUrl") && this.bm.getHomepageUrl() == null) {
                    this.bm.setHomepageUrl(this.content);
                }
            } else if (this.parents.startsWith("/eml/dataset/distribution/online")) {
                if (localName.equalsIgnoreCase("url")) {
                    this.bm.setHomepageUrl(this.content);
                }
            } else if (this.parents.startsWith("/eml/dataset")) {
                if (localName.equalsIgnoreCase("title")) {
                    this.bm.setTitle(this.content);
                } else if (localName.equalsIgnoreCase("alternateIdentifier")) {
                    this.bm.setSourceId(this.content);
                } else if (localName.equalsIgnoreCase("pubDate")) {
                    Date published = DateUtils.parse(this.content, DateUtils.ISO_DATE_FORMAT);
                    this.bm.setPublished(published);
                }
            }
        }
    }

    @Override
    public void startDocument() {
        super.startDocument();
        this.keywords = new ArrayList<String>();
        this.description = new ArrayList<String>();
    }
}

