/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.handler;

import com.google.common.base.Strings;
import java.util.Date;
import org.gbif.metadata.DateUtils;
import org.gbif.metadata.handler.BasicMetadataSaxHandler;
import org.gbif.utils.text.EmailUtils;
import org.xml.sax.SAXException;

public class DcHandler
extends BasicMetadataSaxHandler {
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (uri != null && (uri.equalsIgnoreCase("http://purl.org/dc/terms/") || uri.equalsIgnoreCase("http://purl.org/dc/elements/1.1/"))) {
            if (localName.equalsIgnoreCase("title")) {
                this.bm.setTitle(this.content);
            } else if (localName.equalsIgnoreCase("description") || localName.equalsIgnoreCase("abstract") && this.bm.getDescription() == null) {
                this.bm.setDescription(this.content);
            } else if (localName.equalsIgnoreCase("subject") || localName.equalsIgnoreCase("coverage") || localName.equalsIgnoreCase("spatial") || localName.equalsIgnoreCase("temporal")) {
                this.bm.addSubject(this.content);
            } else if (localName.equalsIgnoreCase("created")) {
                Date published = DateUtils.parse(this.content, DateUtils.ISO_DATE_FORMAT);
                this.bm.setPublished(published);
            } else if (localName.equalsIgnoreCase("relation")) {
                if (this.bm.getHomepageUrl() == null) {
                    this.bm.setHomepageUrl(this.content);
                }
            } else if (localName.equalsIgnoreCase("identifier")) {
                this.bm.setSourceId(this.content);
            } else if (localName.equalsIgnoreCase("rights")) {
                this.bm.setRights(this.content);
            } else if (localName.equalsIgnoreCase("bibliographicCitation")) {
                this.bm.setCitationString(this.content);
            } else if (localName.equalsIgnoreCase("creator") || localName.equalsIgnoreCase("publisher")) {
                String creator = Strings.emptyToNull((String)this.content.trim());
                if (creator != null) {
                    EmailUtils.EmailWithName n = EmailUtils.parseEmail((String)creator);
                    this.bm.setCreatorEmail(n.email);
                    this.bm.setCreatorName(n.name);
                }
            } else if (localName.equalsIgnoreCase("source")) {
                this.bm.setHomepageUrl(this.content);
            }
        } else if (uri == null && localName.equalsIgnoreCase("onlineurl") || uri == null && localName.equalsIgnoreCase("homepage")) {
            this.bm.setHomepageUrl(this.content);
        }
    }
}

