/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.eml;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum TemporalCoverageType implements Serializable
{
    SINGLE_DATE("singleDateTime"),
    DATE_RANGE("dateRange"),
    FORMATION_PERIOD("formationPeriod"),
    LIVING_TIME_PERIOD("livingTimePeriod");

    public static final Map<String, String> HTML_SELECT_MAP;
    private final String name;

    private TemporalCoverageType(String name) {
        this.name = name;
    }

    public static TemporalCoverageType fromString(String type) {
        if (type == null) {
            return null;
        }
        type = type.trim();
        for (TemporalCoverageType r : TemporalCoverageType.values()) {
            if (!r.name.equalsIgnoreCase(type)) continue;
            return r;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    static {
        HashMap map = Maps.newHashMap();
        for (TemporalCoverageType rt : TemporalCoverageType.values()) {
            map.put(rt.name(), "temporalCoverageType." + rt.name());
        }
        HTML_SELECT_MAP = Collections.unmodifiableMap(map);
    }
}

