/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.eml;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import org.gbif.metadata.DateUtils;
import org.gbif.metadata.eml.TemporalCoverageType;

public class TemporalCoverage
implements Serializable {
    private static final long serialVersionUID = 898101764914677290L;
    private Date startDate;
    private Date endDate;
    private String formationPeriod;
    private String livingTimePeriod;

    public String getFormationPeriod() {
        if (this.formationPeriod == null || this.formationPeriod.length() == 0) {
            return null;
        }
        return this.formationPeriod;
    }

    public void setFormationPeriod(String formationPeriod) {
        this.formationPeriod = formationPeriod != null && formationPeriod.isEmpty() ? null : formationPeriod;
    }

    public String getLivingTimePeriod() {
        if (this.livingTimePeriod == null || this.livingTimePeriod.length() == 0) {
            return null;
        }
        return this.livingTimePeriod;
    }

    public void setLivingTimePeriod(String livingTimePeriod) {
        this.livingTimePeriod = livingTimePeriod != null && livingTimePeriod.isEmpty() ? null : livingTimePeriod;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void correctDateOrder() {
        if (this.startDate == null && this.endDate != null) {
            this.startDate = this.endDate;
            this.endDate = null;
        }
        if (this.startDate != null && this.endDate != null && this.startDate.compareTo(this.endDate) > 0) {
            Date d = this.startDate;
            this.startDate = this.endDate;
            this.endDate = d;
        }
    }

    public Date getEndDate() {
        if (this.endDate == null) {
            return this.endDate;
        }
        return new Date(this.endDate.getTime());
    }

    public Date getStartDate() {
        if (this.startDate == null) {
            return this.startDate;
        }
        return new Date(this.startDate.getTime());
    }

    public TemporalCoverageType getType() {
        if (this.formationPeriod != null && !this.formationPeriod.isEmpty()) {
            return TemporalCoverageType.FORMATION_PERIOD;
        }
        if (this.livingTimePeriod != null && !this.livingTimePeriod.isEmpty()) {
            return TemporalCoverageType.LIVING_TIME_PERIOD;
        }
        if (this.startDate != null && this.endDate != null && this.startDate.compareTo(this.endDate) != 0) {
            return TemporalCoverageType.DATE_RANGE;
        }
        return TemporalCoverageType.SINGLE_DATE;
    }

    public void setEnd(String start) throws ParseException {
        this.endDate = DateUtils.calendarDate(start);
    }

    public void setStart(String start) throws ParseException {
        this.startDate = DateUtils.calendarDate(start);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemporalCoverage other = (TemporalCoverage)obj;
        return Objects.equal((Object)this.startDate, (Object)other.startDate) && Objects.equal((Object)this.endDate, (Object)other.endDate) && Objects.equal((Object)this.formationPeriod, (Object)other.formationPeriod) && Objects.equal((Object)this.livingTimePeriod, (Object)other.livingTimePeriod);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.startDate, this.endDate, this.formationPeriod, this.livingTimePeriod});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("startDate", (Object)this.startDate).add("endDate", (Object)this.endDate).add("formationPeriod", (Object)this.formationPeriod).add("livingTimePeriod", (Object)this.livingTimePeriod).toString();
    }
}

