/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.eml;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gbif.metadata.eml.TaxonKeyword;

public class TaxonomicCoverage
implements Serializable {
    private static final long serialVersionUID = -1550877218411220807L;
    private String description;
    private List<TaxonKeyword> taxonKeywords = new ArrayList<TaxonKeyword>();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<TaxonKeyword> getTaxonKeywords() {
        return this.taxonKeywords;
    }

    public void setTaxonKeywords(List<TaxonKeyword> keywords) {
        this.taxonKeywords = keywords;
    }

    public void addTaxonKeyword(TaxonKeyword keyword) {
        this.taxonKeywords.add(keyword);
    }

    public int addTaxonKeywords(String scientificNames) {
        String delimiter = ";";
        if (scientificNames.contains("\n")) {
            delimiter = "\n";
        } else if (scientificNames.contains("|")) {
            delimiter = "|";
        }
        int count = 0;
        for (String sciname : Splitter.on((String)delimiter).split((CharSequence)scientificNames)) {
            if ((sciname = Strings.emptyToNull((String)sciname.trim())) == null) continue;
            this.taxonKeywords.add(new TaxonKeyword(sciname, null, null));
            ++count;
        }
        return count;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaxonomicCoverage other = (TaxonomicCoverage)obj;
        return Objects.equal((Object)this.description, (Object)other.description) && Objects.equal(this.taxonKeywords, other.taxonKeywords);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.description, this.taxonKeywords});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("description", (Object)this.description).add("taxonKeywords", this.taxonKeywords).toString();
    }
}

