/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.eml;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.io.Serializable;
import org.gbif.metadata.eml.Address;

public class Agent
implements Serializable {
    private static final long serialVersionUID = 7028536657833651816L;
    private String firstName;
    private String lastName;
    private String organisation;
    private String position;
    private Address address = new Address();
    private String phone;
    private String email;
    private String role;
    private String homepage;

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public String getEmail() {
        if (this.email == null || this.email.isEmpty()) {
            return null;
        }
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        if (this.firstName == null || this.firstName.isEmpty()) {
            return null;
        }
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getHomepage() {
        if (this.homepage == null || this.homepage.isEmpty()) {
            return null;
        }
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public String getLastName() {
        if (this.lastName == null || this.lastName.isEmpty()) {
            return null;
        }
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getOrganisation() {
        if (this.organisation == null || this.organisation.isEmpty()) {
            return null;
        }
        return this.organisation;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public String getPhone() {
        if (this.phone == null || this.phone.isEmpty()) {
            return null;
        }
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPosition() {
        if (this.position == null || this.position.isEmpty()) {
            return null;
        }
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getFullName() {
        String name = "";
        if (this.firstName != null && !this.firstName.isEmpty()) {
            name = name + this.firstName;
        }
        if (this.lastName != null && !this.lastName.isEmpty()) {
            name = name + " " + this.lastName;
        }
        return Strings.emptyToNull((String)name.trim());
    }

    public boolean isEmpty() {
        return Strings.nullToEmpty((String)this.firstName).trim().isEmpty() && Strings.nullToEmpty((String)this.lastName).trim().isEmpty() && Strings.nullToEmpty((String)this.organisation).trim().isEmpty() && Strings.nullToEmpty((String)this.position).trim().isEmpty() && this.address.isEmpty() && Strings.nullToEmpty((String)this.phone).trim().isEmpty() && Strings.nullToEmpty((String)this.email).trim().isEmpty() && Strings.nullToEmpty((String)this.role).trim().isEmpty() && Strings.nullToEmpty((String)this.homepage).trim().isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Agent other = (Agent)obj;
        return Objects.equal((Object)this.firstName, (Object)other.firstName) && Objects.equal((Object)this.lastName, (Object)other.lastName) && Objects.equal((Object)this.organisation, (Object)other.organisation) && Objects.equal((Object)this.position, (Object)other.position) && Objects.equal((Object)this.address, (Object)other.address) && Objects.equal((Object)this.phone, (Object)other.phone) && Objects.equal((Object)this.email, (Object)other.email) && Objects.equal((Object)this.role, (Object)other.role) && Objects.equal((Object)this.homepage, (Object)other.homepage);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.firstName, this.lastName, this.organisation, this.position, this.address, this.phone, this.email, this.role, this.homepage});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("firstName", (Object)this.firstName).add("lastName", (Object)this.lastName).add("organisation", (Object)this.organisation).add("position", (Object)this.position).add("address", (Object)this.address).add("phone", (Object)this.phone).add("email", (Object)this.email).add("role", (Object)this.role).add("homepage", (Object)this.homepage).toString();
    }
}

