/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.eml;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.io.Serializable;

public class Address
implements Serializable {
    private static final long serialVersionUID = 3617859655330969141L;
    private String address;
    private String city;
    private String province;
    private String country;
    private String postalCode;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        if (this.city == null || this.city.isEmpty()) {
            return null;
        }
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        if (this.country == null || this.country.isEmpty()) {
            return null;
        }
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getPostalCode() {
        if (this.postalCode == null || this.postalCode.isEmpty()) {
            return null;
        }
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getProvince() {
        if (this.province == null || this.province.isEmpty()) {
            return null;
        }
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public boolean isEmpty() {
        return Strings.nullToEmpty((String)this.address).trim().isEmpty() && Strings.nullToEmpty((String)this.city).trim().isEmpty() && Strings.nullToEmpty((String)this.province).trim().isEmpty() && Strings.nullToEmpty((String)this.postalCode).trim().isEmpty() && Strings.nullToEmpty((String)this.country).trim().isEmpty();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Address)) {
            return false;
        }
        Address o = (Address)other;
        return Objects.equal((Object)this.address, (Object)o.address) && Objects.equal((Object)this.city, (Object)o.city) && Objects.equal((Object)this.province, (Object)o.province) && Objects.equal((Object)this.country, (Object)o.country) && Objects.equal((Object)this.postalCode, (Object)o.postalCode);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.address, this.city, this.province, this.country, this.postalCode});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("country", (Object)this.country).add("address", (Object)this.address).add("province", (Object)this.province).add("postalCode", (Object)this.postalCode).add("city", (Object)this.city).toString();
    }

    public String toFormattedString() {
        String formattedAddress = null;
        if (!Strings.isNullOrEmpty((String)this.address)) {
            formattedAddress = this.address;
        }
        if (!Strings.isNullOrEmpty((String)this.city)) {
            formattedAddress = !Strings.isNullOrEmpty((String)formattedAddress) ? formattedAddress + ", " + this.city : this.city;
        }
        if (!Strings.isNullOrEmpty((String)this.province)) {
            formattedAddress = !Strings.isNullOrEmpty((String)formattedAddress) ? formattedAddress + ", " + this.province : this.province;
        }
        if (!Strings.isNullOrEmpty((String)this.country)) {
            formattedAddress = !Strings.isNullOrEmpty((String)formattedAddress) ? formattedAddress + " " + this.country : this.country;
        }
        if (!Strings.isNullOrEmpty((String)this.postalCode)) {
            formattedAddress = !Strings.isNullOrEmpty((String)formattedAddress) ? formattedAddress + ", " + this.postalCode : this.postalCode;
        }
        return formattedAddress;
    }
}

