/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.gbif.metadata.BasicMetadataImpl;
import org.gbif.metadata.MetadataException;
import org.gbif.metadata.handler.BasicMetadataSaxHandler;
import org.gbif.metadata.handler.DcHandler;
import org.gbif.metadata.handler.EmlHandler;
import org.gbif.utils.file.BomSafeInputStreamWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataFactory {
    private final Logger log = LoggerFactory.getLogger(MetadataFactory.class);
    private final SAXParserFactory saxFactory;
    private final List<BasicMetadataSaxHandler> handler = new ArrayList<BasicMetadataSaxHandler>();

    public MetadataFactory() {
        this.handler.add(new EmlHandler());
        this.handler.add(new DcHandler());
        this.saxFactory = SAXParserFactory.newInstance();
        this.saxFactory.setNamespaceAware(true);
        this.saxFactory.setValidating(false);
    }

    private boolean hasContent(BasicMetadataImpl bm) {
        return bm != null && (bm.getTitle() != null || bm.getDescription() != null || bm.getSubject() != null || bm.getSourceId() != null || bm.getHomepageUrl() != null || bm.getPublished() != null);
    }

    public BasicMetadataImpl read(File metadataFile) throws MetadataException {
        try {
            return this.read(new FileInputStream(metadataFile));
        }
        catch (FileNotFoundException e) {
            throw new MetadataException("FileNotFound", e);
        }
    }

    public BasicMetadataImpl read(InputStream stream) throws MetadataException {
        try {
            byte[] data = IOUtils.toByteArray((InputStream)stream);
            for (BasicMetadataSaxHandler h : this.handler) {
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(data);
                    BasicMetadataImpl bm = this.read(in, h);
                    if (bm == null || !this.hasContent(bm)) continue;
                    this.log.debug("Using " + h.toString() + " for parsing metadata");
                    return bm;
                }
                catch (MetadataException ignored) {
                }
            }
        }
        catch (IOException e1) {
            throw new MetadataException("Can't read input stream", e1);
        }
        throw new MetadataException("Can't find suitable metadata parser");
    }

    public BasicMetadataImpl read(InputStream stream, BasicMetadataSaxHandler handler) throws MetadataException {
        try {
            SAXParser p = this.saxFactory.newSAXParser();
            p.parse((InputStream)new BomSafeInputStreamWrapper(stream), (DefaultHandler)handler);
            BasicMetadataImpl bm = handler.yield();
            if (this.hasContent(bm)) {
                return bm;
            }
        }
        catch (Exception e) {
            this.log.error("Error parsing metadata document: " + e.getMessage());
        }
        return null;
    }
}

