/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.legend;

import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import org.ala.layers.intersect.Grid;
import org.ala.layers.legend.Legend;
import org.ala.layers.legend.LegendEqualArea;
import org.ala.layers.legend.LegendEqualSize;
import org.ala.layers.legend.LegendEvenInterval;
import org.ala.layers.legend.LegendEvenIntervalLog;
import org.ala.layers.legend.LegendEvenIntervalLog10;

public class GridFileLegends {
    public GridFileLegends(String filename, String output_name, boolean useAreaEvaluation, String[] legendNames, FileWriter cutpointFile) {
        Grid g = Grid.getGrid(filename);
        float[] d = g.getGrid();
        if (legendNames != null) {
            Arrays.sort(legendNames);
        }
        float[] dsorted = (float[])d.clone();
        Arrays.sort(dsorted);
        Legend[] legends = new Legend[5];
        legends[4] = new LegendEqualArea();
        legends[3] = new LegendEqualSize();
        legends[1] = new LegendEvenInterval();
        legends[2] = new LegendEvenIntervalLog();
        legends[0] = new LegendEvenIntervalLog10();
        int minI = 0;
        double minE = 0.0;
        boolean firstTime = true;
        for (int i = 0; i < legends.length; ++i) {
            if (legendNames == null || Arrays.binarySearch(legendNames, legends[i].getTypeName()) < 0) continue;
            legends[i].generate(dsorted);
            legends[i].determineGroupSizes(dsorted);
            double e2 = 0.0;
            e2 = useAreaEvaluation ? legends[i].evaluateStdDevArea(dsorted) : legends[i].evaluateStdDev(dsorted);
            try {
                new File(output_name + "_" + legends[i].getTypeName() + ".jpg").delete();
            }
            catch (Exception e) {
                // empty catch block
            }
            legends[i].exportImage(d, g.ncols, output_name + "_" + legends[i].getTypeName() + ".jpg", 8, false);
            legends[i].exportLegend(output_name + "_" + legends[i].getTypeName() + "_legend.txt");
            System.out.println(output_name + "," + legends[i].getTypeName() + ": " + String.valueOf(e2));
            if (!firstTime && !(e2 <= minE)) continue;
            minE = e2;
            minI = i;
            firstTime = false;
        }
        try {
            if (cutpointFile != null) {
                cutpointFile.append(filename).append(",").append(legends[minI].getTypeName());
                float[] minmax = legends[minI].getMinMax();
                float[] f = legends[minI].getCutoffFloats();
                cutpointFile.append(",min,").append(String.valueOf(minmax[0]));
                cutpointFile.append(",#cutpoints,").append(String.valueOf(f.length));
                cutpointFile.append(",cutpoints");
                for (int i = 0; i < f.length; ++i) {
                    cutpointFile.append(",").append(String.valueOf(f[i]));
                }
                cutpointFile.append(",distribution");
                int[] a = useAreaEvaluation ? legends[minI].groupSizesArea : legends[minI].groupSizes;
                for (int i = 0; i < a.length; ++i) {
                    cutpointFile.append(",").append(String.valueOf(a[i]));
                }
                cutpointFile.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(output_name + ",best=" + legends[minI].getTypeName());
    }
}

