/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.vocab;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.util.Stemmer$;
import au.org.ala.biocache.vocab.DwC$;
import au.org.ala.biocache.vocab.Term;
import au.org.ala.biocache.vocab.Vocab;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Source;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.NonLocalReturnControl;

public abstract class Vocab$class {
    public static List getStringList(Vocab $this) {
        return JavaConversions$.MODULE$.seqAsJavaList((Seq)((TraversableOnce)$this.all().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Term t) {
                return t.canonical();
            }
        }, Set$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public static Option matchTerm(Vocab $this, String string2Match) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            None$ none$;
            Object object = new Object();
            try {
                if (string2Match != null) {
                    String stringToUse = string2Match.replaceAll($this.regexNorm(), "").toLowerCase();
                    String stemmed = Stemmer$.MODULE$.stem(stringToUse);
                    $this.all().foreach((Function1)new Serializable($this, stringToUse, stemmed, object){
                        public static final long serialVersionUID = 0L;
                        private final String stringToUse$1;
                        private final String stemmed$1;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(Term term) {
                            if (term.canonical().equalsIgnoreCase(this.stringToUse$1)) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)term));
                            }
                            if (Predef$.MODULE$.refArrayOps((Object[])term.variants()).contains((Object)this.stringToUse$1) || Predef$.MODULE$.refArrayOps((Object[])term.variants()).contains((Object)this.stemmed$1)) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)term));
                            }
                        }
                        {
                            this.stringToUse$1 = stringToUse$1;
                            this.stemmed$1 = stemmed$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                }
                none$ = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                none$ = (Option)nonLocalReturnControl2.value();
            }
            return none$;
        }
        throw nonLocalReturnControl2;
    }

    public static Seq retrieveCanonicals(Vocab $this, Seq terms) {
        return (Seq)terms.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String ch) {
                Option<Term> option;
                block4: {
                    String string;
                    block3: {
                        block2: {
                            option = DwC$.MODULE$.matchTerm(ch);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Term term = (Term)some.x();
                            string = term.canonical();
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Term> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        string = ch;
                    }
                    return string;
                }
                throw new MatchError(option);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Seq retrieveCanonicalsOrNothing(Vocab $this, Seq terms) {
        return (Seq)terms.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String ch) {
                Option<Term> option;
                block4: {
                    String string;
                    block3: {
                        block2: {
                            option = DwC$.MODULE$.matchTerm(ch);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Term term = (Term)some.x();
                            string = term.canonical();
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Term> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        string = "";
                    }
                    return string;
                }
                throw new MatchError(option);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Set loadVocabFromVerticalFile(Vocab $this, String filePath) {
        Map map = ((TraversableOnce)Vocab$class.getSource($this, filePath).getLines().toList().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Vocab $outer;

            public final Tuple2<String, String> apply(String row) {
                String[] values = row.split("\t");
                String variant = ((String)Predef$.MODULE$.refArrayOps((Object[])values).head()).replaceAll(this.$outer.regexNorm(), "").toLowerCase();
                String canonical = (String)Predef$.MODULE$.refArrayOps((Object[])values).last();
                return new Tuple2((Object)variant, (Object)canonical);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        Map grouped = map.groupBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String v;
                    String string = v = (String)tuple2._2();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        });
        return ((TraversableOnce)grouped.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Term apply(Tuple2<String, Map<String, String>> x0$2) {
                Tuple2<String, Map<String, String>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String canonical = (String)tuple2._1();
                    Map valueMap = (Map)tuple2._2();
                    Iterable variants = valueMap.keys();
                    Term term = new Term(canonical, (String[])variants.toArray(ClassTag$.MODULE$.apply(String.class)));
                    return term;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    public static Set loadVocabFromFile(Vocab $this, String filePath) {
        return ((TraversableOnce)Vocab$class.getSource($this, filePath).getLines().toList().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Term apply(String row) {
                String[] values = row.split("\t");
                String[] variants = (String[])Predef$.MODULE$.refArrayOps((Object[])values).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x) {
                        return x.replaceAll("[ \\\\\"\\\\'\\\\.\\\\,\\\\-\\\\?]*", "").toLowerCase();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                return new Term((String)Predef$.MODULE$.refArrayOps((Object[])values).head(), variants);
            }
        }, List$.MODULE$.canBuildFrom())).toSet();
    }

    private static Source getSource(Vocab $this, String filePath) {
        BufferedSource bufferedSource;
        File overrideFile = new File(new StringBuilder().append((Object)Config$.MODULE$.vocabDirectory()).append((Object)filePath).toString());
        if (overrideFile.exists()) {
            $this.logger().info(new StringBuilder().append((Object)"Reading vocab file: ").append((Object)overrideFile.getAbsolutePath()).toString());
            bufferedSource = Source$.MODULE$.fromFile(overrideFile, "utf-8");
        } else {
            $this.logger().info(new StringBuilder().append((Object)"Reading internal vocab file: ").append((Object)filePath).toString());
            bufferedSource = Source$.MODULE$.fromURL($this.getClass().getResource(filePath), "utf-8");
        }
        return bufferedSource;
    }

    public static Set retrieveAll(Vocab $this) {
        Method[] methods = $this.getClass().getMethods();
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])methods).withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Method method) {
                String string = method.getReturnType().getName();
                String string2 = "au.org.ala.biocache.vocab.Term";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Vocab $outer;

            public final Term apply(Method method) {
                return (Term)method.invoke((Object)this.$outer, new Object[0]);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Term.class)))).toSet();
    }

    public static void $init$(Vocab $this) {
        $this.au$org$ala$biocache$vocab$Vocab$_setter_$logger_$eq(LoggerFactory.getLogger((String)"Vocab"));
        $this.au$org$ala$biocache$vocab$Vocab$_setter_$regexNorm_$eq("[ \\\\\"\\\\'\\\\.\\\\,\\\\-\\\\?]*");
    }
}

