/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.IncrementalTool;
import au.org.ala.biocache.cmd.IncrementalTool$class;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.parser.DateParser$;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.tool.ResourceCleanupTask$;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.OptionParser;
import java.io.File;
import java.util.Date;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class ResourceCleanupTask$
implements Tool,
IncrementalTool {
    public static final ResourceCleanupTask$ MODULE$;
    private final Logger logger;

    static {
        new ResourceCleanupTask$();
    }

    @Override
    public Option<String> getDeleteRowFile(String resourceUid) {
        return IncrementalTool$class.getDeleteRowFile(this, resourceUid);
    }

    @Override
    public Tuple2<Object, Option<String>> hasRowKey(String resourceUid) {
        return IncrementalTool$class.hasRowKey(this, resourceUid);
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public String cmd() {
        return "resource-cleanup";
    }

    @Override
    public String desc() {
        return "Resource cleanup tool for removing record or columns which have not been updated since a supplied date.";
    }

    @Override
    public void main(String[] args) {
        BooleanRef checkRowKeyFile;
        ObjectRef filename;
        BooleanRef isInclusiveList;
        ObjectRef columns;
        ObjectRef end;
        ObjectRef start;
        BooleanRef test;
        BooleanRef removeDeleted;
        BooleanRef removeColumns;
        BooleanRef removeRows;
        ObjectRef dataResourceUid = new ObjectRef((Object)"");
        ObjectRef lastLoadDate = new ObjectRef((Object)new StringBuilder().append((Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd")).append((Object)"T00:00:00Z").toString());
        OptionParser parser = new OptionParser(dataResourceUid, lastLoadDate, removeRows = new BooleanRef(false), removeColumns = new BooleanRef(false), removeDeleted = new BooleanRef(false), test = new BooleanRef(false), start = new ObjectRef((Object)None$.MODULE$), end = new ObjectRef((Object)None$.MODULE$), columns = new ObjectRef((Object)((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))), isInclusiveList = new BooleanRef(true), filename = new ObjectRef((Object)None$.MODULE$), checkRowKeyFile = new BooleanRef(false)){
            {
                this.arg("data-resource-uid", "The data resource on which to perform the clean up.", (Function1<String, BoxedUnit>)new Serializable(this, dataResourceUid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dataResourceUid$1;

                    public final void apply(String v) {
                        this.dataResourceUid$1.elem = v;
                    }
                    {
                        this.dataResourceUid$1 = dataResourceUid$1;
                    }
                });
                this.arg("type", "The type of cleanup to perform.Either all, columns, rows, delete. \n\t\tcolumns - removes the columns that were not modified since the last date \n\t\trows - marks records as deleted when they have not been reloaded since the supplied date \n\t\tdelete - removes the deleted record from occ and places them into the dellog ", (Function1<String, BoxedUnit>)new Serializable(this, removeRows$1, removeColumns$1, removeDeleted$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef removeRows$1;
                    private final BooleanRef removeColumns$1;
                    private final BooleanRef removeDeleted$1;

                    public final void apply(String v) {
                        String string;
                        String string2 = string = v;
                        if (!("all" != null ? !"all".equals(string2) : string2 != null)) {
                            this.removeRows$1.elem = true;
                            this.removeColumns$1.elem = true;
                            this.removeDeleted$1.elem = true;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string3 = string;
                            if (!("columns" != null ? !"columns".equals(string3) : string3 != null)) {
                                this.removeColumns$1.elem = true;
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                String string4 = string;
                                if (!("rows" != null ? !"rows".equals(string4) : string4 != null)) {
                                    this.removeRows$1.elem = true;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    String string5 = string;
                                    if (!("delete" != null ? !"delete".equals(string5) : string5 != null)) {
                                        this.removeDeleted$1.elem = true;
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }
                                }
                            }
                        }
                    }
                    {
                        this.removeRows$1 = removeRows$1;
                        this.removeColumns$1 = removeColumns$1;
                        this.removeDeleted$1 = removeDeleted$1;
                    }
                });
                this.opt("f", "file", "<absolute path to file>", "The name of the file to incrementally remove obsolete columns from", (Function1<String, BoxedUnit>)new Serializable(this, filename$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef filename$1;

                    public final void apply(String value) {
                        this.filename$1.elem = new Some((Object)value);
                    }
                    {
                        this.filename$1 = filename$1;
                    }
                });
                this.opt("d", "date", "<date last loaded yyyy-MM-dd format>", "The date of the last load.  Any records that have not been updated since this date will be marked as deleted.", (Function1<String, BoxedUnit>)new Serializable(this, lastLoadDate$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef lastLoadDate$1;

                    public final void apply(String value) {
                        this.lastLoadDate$1.elem = new StringBuilder().append((Object)value).append((Object)"T00:00:00Z").toString();
                    }
                    {
                        this.lastLoadDate$1 = lastLoadDate$1;
                    }
                });
                this.opt("s", "start", "<starting rowkey>", "The row key to start looking for deleted records", (Function1<String, BoxedUnit>)new Serializable(this, start$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef start$1;

                    public final void apply(String value) {
                        this.start$1.elem = new Some((Object)value);
                    }
                    {
                        this.start$1 = start$1;
                    }
                });
                this.opt("e", "end", "<ending rowkey>", "The row key to stop looking for deleted records", (Function1<String, BoxedUnit>)new Serializable(this, end$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef end$1;

                    public final void apply(String value) {
                        this.end$1.elem = new Some((Object)value);
                    }
                    {
                        this.end$1 = end$1;
                    }
                });
                this.opt("test", "Simulates the cleanup without removing anything.  Useful to run to determine whether or not you are happy with the load.", (Function0<BoxedUnit>)new Serializable(this, test$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef test$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.test$1.elem = true;
                    }
                    {
                        this.test$1 = test$1;
                    }
                });
                this.opt("delcols", "Delete the columns in the supplied list", (Function0<BoxedUnit>)new Serializable(this, isInclusiveList$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef isInclusiveList$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.isInclusiveList$1.elem = false;
                    }
                    {
                        this.isInclusiveList$1 = isInclusiveList$1;
                    }
                });
                this.opt("c", "cols", "<list of columns>", "Comma separated list of columns to perform the operation on", (Function1<String, BoxedUnit>)new Serializable(this, columns$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef columns$1;

                    public final void apply(String value) {
                        this.columns$1.elem = value.split(",");
                    }
                    {
                        this.columns$1 = columns$1;
                    }
                });
                this.opt("crk", "check for row key file", (Function0<BoxedUnit>)new Serializable(this, checkRowKeyFile$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef checkRowKeyFile$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.checkRowKeyFile$1.elem = true;
                    }
                    {
                        this.checkRowKeyFile$1 = checkRowKeyFile$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            if (checkRowKeyFile.elem) {
                String string = (String)dataResourceUid.elem;
                String string2 = "";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    Tuple2<Object, Option<String>> tuple2 = this.hasRowKey((String)dataResourceUid.elem);
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        boolean hasRowKeyFile = tuple2._1$mcZ$sp();
                        Option filePath = (Option)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)hasRowKeyFile), (Object)filePath);
                        boolean hasRowKeyFile2 = tuple23._1$mcZ$sp();
                        Option filePath2 = (Option)tuple23._2();
                        filename.elem = filePath2;
                    } else {
                        throw new MatchError(tuple2);
                    }
                }
            }
            Option<Date> checkDate = DateParser$.MODULE$.parseStringToDate((String)lastLoadDate.elem);
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to cleanup ", " based on a last load date of ", " rows: ", "  columns: ", ", start:  ", ",end:  ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)dataResourceUid.elem, checkDate, BoxesRunTime.boxToBoolean((boolean)removeRows.elem), BoxesRunTime.boxToBoolean((boolean)removeColumns.elem), (Option)start.elem, (Option)end.elem})));
            if (checkDate.isDefined() && ((String[])columns.elem).length == 0) {
                if (removeRows.elem) {
                    this.modifyRecord((String)dataResourceUid.elem, (Date)checkDate.get(), (Option<String>)((Option)start.elem), (Option<String>)((Option)end.elem), test.elem);
                }
                if (removeColumns.elem) {
                    if (((Option)filename.elem).isDefined()) {
                        this.removeObsoleteColumnsIncremental(new File((String)((Option)filename.elem).get()), ((Date)checkDate.get()).getTime(), test.elem);
                    } else {
                        this.removeObsoleteColumns((String)dataResourceUid.elem, ((Date)checkDate.get()).getTime(), (Option<String>)((Option)start.elem), (Option<String>)((Option)end.elem), test.elem);
                    }
                }
                if (removeDeleted.elem && !test.elem) {
                    this.removeDeletedRecords((String)dataResourceUid.elem, (Option<String>)((Option)start.elem), (Option<String>)((Option)end.elem));
                }
            } else if (((String[])columns.elem).length > 0) {
                if (isInclusiveList.elem) {
                    this.removeRawRecordColumnsNotInList((String)dataResourceUid.elem, (String[])columns.elem, (Option<String>)((Option)start.elem), (Option<String>)((Option)end.elem), test.elem);
                } else {
                    this.removeSpecifiedColumns((String)dataResourceUid.elem, (String[])columns.elem, (Option<String>)((Option)start.elem), (Option<String>)((Option)end.elem));
                }
            }
        }
    }

    public void removeRawRecordColumnsNotInList(String dr, String[] colsToKeep, Option<String> start, Option<String> end, boolean test) {
        this.logger().info(new StringBuilder().append((Object)"Starting to remove raw record columns not in ").append((Object)Predef$.MODULE$.refArrayOps((Object[])colsToKeep).toList()).toString());
        String startUuid = (String)start.getOrElse((Function0)new Serializable(dr){
            public static final long serialVersionUID = 0L;
            private final String dr$4;

            public final String apply() {
                return new StringBuilder().append((Object)this.dr$4).append((Object)"|").toString();
            }
            {
                this.dr$4 = dr$4;
            }
        });
        String endUuid = (String)end.getOrElse((Function0)new Serializable(startUuid){
            public static final long serialVersionUID = 0L;
            private final String startUuid$1;

            public final String apply() {
                return new StringBuilder().append((Object)this.startUuid$1).append((Object)"~").toString();
            }
            {
                this.startUuid$1 = startUuid$1;
            }
        });
        PersistenceManager pm = Config$.MODULE$.persistenceManager();
        HashSet valueSet = new HashSet();
        IntRef totalRecords = new IntRef(0);
        IntRef totalRecordModified = new IntRef(0);
        IntRef totalColumnsRemoved = new IntRef(0);
        FullRecord fullRecord = new FullRecord();
        String[] valuesToIgnore = (String[])((Object[])new String[]{"uuid", "originalSensitiveValues", "rowKey"});
        pm.pageOverAll("occ", (Function2<String, Map<String, String>, Object>)new Serializable(colsToKeep, test, valueSet, totalRecords, totalRecordModified, totalColumnsRemoved, fullRecord, valuesToIgnore){
            public static final long serialVersionUID = 0L;
            public final String[] colsToKeep$1;
            private final boolean test$5;
            public final HashSet valueSet$1;
            private final IntRef totalRecords$1;
            private final IntRef totalRecordModified$1;
            public final IntRef totalColumnsRemoved$1;
            public final FullRecord fullRecord$1;
            public final String[] valuesToIgnore$1;

            public final boolean apply(String guid, Map<String, String> map) {
                ++this.totalRecords$1.elem;
                ArrayBuffer colToDelete = new ArrayBuffer();
                map.keySet().foreach((Function1)new Serializable(this, colToDelete){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.removeRawRecordColumnsNotInList.1 $outer;
                    private final ArrayBuffer colToDelete$1;

                    public final void apply(String fieldName) {
                        String string = fieldName;
                        if (this.$outer.fullRecord$1.hasNestedProperty(fieldName)) {
                            BoxedUnit boxedUnit;
                            if (Predef$.MODULE$.refArrayOps((Object[])this.$outer.colsToKeep$1).contains((Object)fieldName) || Predef$.MODULE$.refArrayOps((Object[])this.$outer.valuesToIgnore$1).contains((Object)fieldName)) {
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.colToDelete$1.$plus$eq((Object)fieldName);
                                this.$outer.valueSet$1.$plus$eq((Object)fieldName);
                                ++this.$outer.totalColumnsRemoved$1.elem;
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                        } else {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.colToDelete$1 = colToDelete$1;
                    }
                });
                if (colToDelete.size() > 0) {
                    ++this.totalRecordModified$1.elem;
                    if (!this.test$5) {
                        Config$.MODULE$.persistenceManager().deleteColumns(guid, "occ", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colToDelete.toArray(ClassTag$.MODULE$.apply(String.class))));
                    }
                }
                return true;
            }
            {
                this.colsToKeep$1 = colsToKeep$1;
                this.test$5 = test$5;
                this.valueSet$1 = valueSet$1;
                this.totalRecords$1 = totalRecords$1;
                this.totalRecordModified$1 = totalRecordModified$1;
                this.totalColumnsRemoved$1 = totalColumnsRemoved$1;
                this.fullRecord$1 = fullRecord$1;
                this.valuesToIgnore$1 = valuesToIgnore$1;
            }
        }, startUuid, endUuid, 1000);
        this.logger().info("Finished cleanup for columns");
        this.logger().info("List of columns that have been removed from one or more records:");
        this.logger().info(valueSet.toList().toString());
        this.logger().info(new StringBuilder().append((Object)"total records changed: ").append((Object)BoxesRunTime.boxToInteger((int)totalRecordModified.elem)).append((Object)" out of ").append((Object)BoxesRunTime.boxToInteger((int)totalRecords.elem)).append((Object)". ").append((Object)BoxesRunTime.boxToInteger((int)totalColumnsRemoved.elem)).append((Object)" columns were removed from cassandra").toString());
    }

    public boolean removeRawRecordColumnsNotInList$default$5() {
        return false;
    }

    public void removeSpecifiedColumns(String dr, String[] colsToDelete, Option<String> start, Option<String> end) {
        this.logger().info(new StringBuilder().append((Object)"Starting to remove all columns in ").append((Object)Predef$.MODULE$.refArrayOps((Object[])colsToDelete).toList()).toString());
        String startUuid = (String)start.getOrElse((Function0)new Serializable(dr){
            public static final long serialVersionUID = 0L;
            private final String dr$5;

            public final String apply() {
                return new StringBuilder().append((Object)this.dr$5).append((Object)"|").toString();
            }
            {
                this.dr$5 = dr$5;
            }
        });
        String endUuid = (String)end.getOrElse((Function0)new Serializable(startUuid){
            public static final long serialVersionUID = 0L;
            private final String startUuid$2;

            public final String apply() {
                return new StringBuilder().append((Object)this.startUuid$2).append((Object)"~").toString();
            }
            {
                this.startUuid$2 = startUuid$2;
            }
        });
        PersistenceManager pm = Config$.MODULE$.persistenceManager();
        IntRef count = new IntRef(0);
        pm.pageOverSelect("occ", (Function2<String, Map<String, String>, Object>)new Serializable(colsToDelete, pm, count){
            public static final long serialVersionUID = 0L;
            private final String[] colsToDelete$1;
            private final PersistenceManager pm$1;
            private final IntRef count$1;

            public final boolean apply(String guid, Map<String, String> map) {
                this.pm$1.deleteColumns(guid, "occ", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.colsToDelete$1));
                ++this.count$1.elem;
                return true;
            }
            {
                this.colsToDelete$1 = colsToDelete$1;
                this.pm$1 = pm$1;
                this.count$1 = count$1;
            }
        }, startUuid, endUuid, 1000, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowKey", "uuid"}));
        this.logger().info(new StringBuilder().append((Object)"Finished removing columns on list for ").append((Object)BoxesRunTime.boxToInteger((int)count.elem)).append((Object)" records").toString());
    }

    public void removeObsoleteColumnsIncremental(File file, long editTime, boolean test) {
        this.logger().info(new StringBuilder().append((Object)"Starting to remove the obsolete columns from an incremental file ").append((Object)file.getAbsolutePath()).toString());
        IntRef totalRecords = new IntRef(0);
        IntRef totalRecordModified = new IntRef(0);
        IntRef totalColumnsRemoved = new IntRef(0);
        HashSet valueSet = new HashSet();
        FullRecord fullRecord = new FullRecord();
        FileHelper$.MODULE$.file2helper(file).foreachLine((Function1<String, BoxedUnit>)new Serializable(editTime, test, totalRecords, totalRecordModified, totalColumnsRemoved, valueSet, fullRecord){
            public static final long serialVersionUID = 0L;
            private final long editTime$1;
            private final boolean test$3;
            private final IntRef totalRecords$2;
            private final IntRef totalRecordModified$2;
            private final IntRef totalColumnsRemoved$2;
            private final HashSet valueSet$2;
            private final FullRecord fullRecord$2;

            public final void apply(String line) {
                Tuple2<Object, Object> tuple2 = ResourceCleanupTask$.MODULE$.removeRecordColumnsBasedOnTime(line, this.editTime$1, (HashSet<String>)this.valueSet$2, this.fullRecord$2, this.test$3);
                if (tuple2 != null) {
                    Tuple2.mcII.sp sp2;
                    int mod = tuple2._1$mcI$sp();
                    int rem = tuple2._2$mcI$sp();
                    Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(mod, rem);
                    int mod2 = sp3._1$mcI$sp();
                    int rem2 = sp3._2$mcI$sp();
                    this.totalColumnsRemoved$2.elem += rem2;
                    this.totalRecordModified$2.elem += mod2;
                    ++this.totalRecords$2.elem;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.editTime$1 = editTime$1;
                this.test$3 = test$3;
                this.totalRecords$2 = totalRecords$2;
                this.totalRecordModified$2 = totalRecordModified$2;
                this.totalColumnsRemoved$2 = totalColumnsRemoved$2;
                this.valueSet$2 = valueSet$2;
                this.fullRecord$2 = fullRecord$2;
            }
        });
        this.logger().info("Finished cleanup for columns");
        this.logger().info("List of columns that have been removed from one or more records:");
        this.logger().info(valueSet.toList().toString());
        this.logger().info(new StringBuilder().append((Object)"total records changed: ").append((Object)BoxesRunTime.boxToInteger((int)totalRecordModified.elem)).append((Object)" out of ").append((Object)BoxesRunTime.boxToInteger((int)totalRecords.elem)).append((Object)". ").append((Object)BoxesRunTime.boxToInteger((int)totalColumnsRemoved.elem)).append((Object)" columns were removed from cassandra").toString());
    }

    public Tuple2<Object, Object> removeRecordColumnsBasedOnTime(String rowKey, long editTime, HashSet<String> valueSet, FullRecord fullRecord, boolean test) {
        Option<Map<String, Object>> timemap = Config$.MODULE$.persistenceManager().getColumnsWithTimestamps(rowKey, "occ");
        ArrayBuffer colToDelete = new ArrayBuffer();
        IntRef totalColumnsRemoved = new IntRef(0);
        int totalRecordModified = 0;
        Set columnsToAlwaysKeep = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuid", "originalSensitiveValues", "rowKey"}));
        if (timemap.isDefined()) {
            ((scala.collection.immutable.MapLike)timemap.get()).keySet().foreach((Function1)new Serializable(editTime, valueSet, fullRecord, timemap, colToDelete, totalColumnsRemoved, columnsToAlwaysKeep){
                public static final long serialVersionUID = 0L;
                private final long editTime$3;
                private final HashSet valueSet$3;
                private final FullRecord fullRecord$3;
                private final Option timemap$1;
                private final ArrayBuffer colToDelete$2;
                private final IntRef totalColumnsRemoved$3;
                private final Set columnsToAlwaysKeep$1;

                public final Object apply(String fieldName) {
                    BoxedUnit boxedUnit;
                    String string = fieldName;
                    if (this.fullRecord$3.hasNestedProperty(string) && !this.columnsToAlwaysKeep$1.contains((Object)string)) {
                        BoxedUnit boxedUnit2;
                        if (BoxesRunTime.unboxToLong((Object)((MapLike)this.timemap$1.get()).get((Object)fieldName).get()) < this.editTime$3) {
                            ++this.totalColumnsRemoved$3.elem;
                            this.colToDelete$2.$plus$eq((Object)fieldName);
                            boxedUnit2 = this.valueSet$3.$plus$eq((Object)fieldName);
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit2;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                {
                    this.editTime$3 = editTime$3;
                    this.valueSet$3 = valueSet$3;
                    this.fullRecord$3 = fullRecord$3;
                    this.timemap$1 = timemap$1;
                    this.colToDelete$2 = colToDelete$2;
                    this.totalColumnsRemoved$3 = totalColumnsRemoved$3;
                    this.columnsToAlwaysKeep$1 = columnsToAlwaysKeep$1;
                }
            });
        }
        if (colToDelete.size() > 0) {
            totalRecordModified = 1;
            if (!test) {
                Config$.MODULE$.persistenceManager().deleteColumns(rowKey, "occ", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colToDelete.toArray(ClassTag$.MODULE$.apply(String.class))));
            }
        }
        return new Tuple2.mcII.sp(totalRecordModified, totalColumnsRemoved.elem);
    }

    public void removeObsoleteColumns(String dr, long editTime, Option<String> start, Option<String> end, boolean test) {
        this.logger().info("Starting to remove obsolete columns based on timestamps.");
        String startUuid = (String)start.getOrElse((Function0)new Serializable(dr){
            public static final long serialVersionUID = 0L;
            private final String dr$2;

            public final String apply() {
                return new StringBuilder().append((Object)this.dr$2).append((Object)"|").toString();
            }
            {
                this.dr$2 = dr$2;
            }
        });
        String endUuid = (String)end.getOrElse((Function0)new Serializable(startUuid){
            public static final long serialVersionUID = 0L;
            private final String startUuid$3;

            public final String apply() {
                return new StringBuilder().append((Object)this.startUuid$3).append((Object)"~").toString();
            }
            {
                this.startUuid$3 = startUuid$3;
            }
        });
        FullRecord fullRecord = new FullRecord();
        HashSet valueSet = new HashSet();
        IntRef totalRecords = new IntRef(0);
        IntRef totalRecordModified = new IntRef(0);
        IntRef totalColumnsRemoved = new IntRef(0);
        String[] valuesToIgnore = (String[])((Object[])new String[]{"uuid", "originalSensitiveValues", "rowKey"});
        Config$.MODULE$.persistenceManager().pageOverSelect("occ", (Function2<String, Map<String, String>, Object>)new Serializable(editTime, test, fullRecord, valueSet, totalRecords, totalRecordModified, totalColumnsRemoved, valuesToIgnore){
            public static final long serialVersionUID = 0L;
            public final long editTime$2;
            private final boolean test$4;
            public final FullRecord fullRecord$4;
            public final HashSet valueSet$4;
            private final IntRef totalRecords$3;
            private final IntRef totalRecordModified$3;
            public final IntRef totalColumnsRemoved$4;
            public final String[] valuesToIgnore$2;

            public final boolean apply(String guid, Map<String, String> map) {
                ++this.totalRecords$3.elem;
                if (!map.contains((Object)"dateDeleted")) {
                    Option<Map<String, Object>> timemap = Config$.MODULE$.persistenceManager().getColumnsWithTimestamps(guid, "occ");
                    ArrayBuffer colToDelete = new ArrayBuffer();
                    if (timemap.isDefined()) {
                        ((scala.collection.immutable.MapLike)timemap.get()).keySet().foreach((Function1)new Serializable(this, timemap, colToDelete){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.removeObsoleteColumns.1 $outer;
                            private final Option timemap$2;
                            private final ArrayBuffer colToDelete$3;

                            public final Object apply(String fieldName) {
                                BoxedUnit boxedUnit;
                                String string = fieldName;
                                if (this.$outer.fullRecord$4.hasNestedProperty(fieldName) && !Predef$.MODULE$.refArrayOps((Object[])this.$outer.valuesToIgnore$2).contains((Object)string)) {
                                    BoxedUnit boxedUnit2;
                                    if (BoxesRunTime.unboxToLong((Object)((MapLike)this.timemap$2.get()).get((Object)fieldName).get()) < this.$outer.editTime$2) {
                                        ++this.$outer.totalColumnsRemoved$4.elem;
                                        this.colToDelete$3.$plus$eq((Object)fieldName);
                                        boxedUnit2 = this.$outer.valueSet$4.$plus$eq((Object)fieldName);
                                    } else {
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    }
                                    boxedUnit = boxedUnit2;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                return boxedUnit;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.timemap$2 = timemap$2;
                                this.colToDelete$3 = colToDelete$3;
                            }
                        });
                    }
                    if (colToDelete.size() > 0) {
                        ++this.totalRecordModified$3.elem;
                        if (!this.test$4) {
                            Config$.MODULE$.persistenceManager().deleteColumns(guid, "occ", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colToDelete.toArray(ClassTag$.MODULE$.apply(String.class))));
                        }
                    }
                }
                return true;
            }
            {
                this.editTime$2 = editTime$2;
                this.test$4 = test$4;
                this.fullRecord$4 = fullRecord$4;
                this.valueSet$4 = valueSet$4;
                this.totalRecords$3 = totalRecords$3;
                this.totalRecordModified$3 = totalRecordModified$3;
                this.totalColumnsRemoved$4 = totalColumnsRemoved$4;
                this.valuesToIgnore$2 = valuesToIgnore$2;
            }
        }, startUuid, endUuid, 1000, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowKey", "dateDeleted"}));
        this.logger().info("Finished cleanup for columns");
        this.logger().info("List of columns that have been removed from one or more records:");
        this.logger().info(valueSet.toList().toString());
        this.logger().info(new StringBuilder().append((Object)"total records changed: ").append((Object)BoxesRunTime.boxToInteger((int)totalRecordModified.elem)).append((Object)" out of ").append((Object)BoxesRunTime.boxToInteger((int)totalRecords.elem)).append((Object)". ").append((Object)BoxesRunTime.boxToInteger((int)totalColumnsRemoved.elem)).append((Object)" columns were removed from cassandra").toString());
    }

    public boolean removeObsoleteColumns$default$5() {
        return false;
    }

    public void modifyRecord(String dr, Date lastDate, Option<String> start, Option<String> end, boolean test) {
        String startUuid = (String)start.getOrElse((Function0)new Serializable(dr){
            public static final long serialVersionUID = 0L;
            private final String dr$1;

            public final String apply() {
                return new StringBuilder().append((Object)this.dr$1).append((Object)"|").toString();
            }
            {
                this.dr$1 = dr$1;
            }
        });
        String endUuid = (String)end.getOrElse((Function0)new Serializable(dr){
            public static final long serialVersionUID = 0L;
            private final String dr$1;

            public final String apply() {
                return new StringBuilder().append((Object)this.dr$1).append((Object)"|~").toString();
            }
            {
                this.dr$1 = dr$1;
            }
        });
        String deleteTime = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
        IntRef totalRecords = new IntRef(0);
        IntRef deleted = new IntRef(0);
        IntRef reinstate = new IntRef(0);
        Config$.MODULE$.persistenceManager().pageOverSelect("occ", (Function2<String, Map<String, String>, Object>)new Serializable(lastDate, test, deleteTime, totalRecords, deleted, reinstate){
            public static final long serialVersionUID = 0L;
            private final Date lastDate$1;
            private final boolean test$2;
            private final String deleteTime$1;
            private final IntRef totalRecords$4;
            private final IntRef deleted$1;
            private final IntRef reinstate$1;

            public final boolean apply(String guid, Map<String, String> map) {
                ++this.totalRecords$4.elem;
                Option<Date> lastModified = DateParser$.MODULE$.parseStringToDate((String)map.getOrElse((Object)"lastModifiedTime", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
                Option<Date> dateDeleted = DateParser$.MODULE$.parseStringToDate((String)map.getOrElse((Object)"dateDeleted", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
                if (lastModified.isDefined()) {
                    if (((Date)lastModified.get()).before(this.lastDate$1)) {
                        if (dateDeleted.isEmpty()) {
                            ++this.deleted$1.elem;
                            if (!this.test$2) {
                                Config$.MODULE$.occurrenceDAO().setDeleted(guid, true, (Option<String>)new Some((Object)this.deleteTime$1));
                            }
                        }
                    } else if (dateDeleted.isDefined()) {
                        ++this.reinstate$1.elem;
                        if (!this.test$2) {
                            Config$.MODULE$.occurrenceDAO().setDeleted(guid, false, Config$.MODULE$.occurrenceDAO().setDeleted$default$3());
                        }
                    }
                } else {
                    ++this.deleted$1.elem;
                    if (!this.test$2) {
                        Config$.MODULE$.occurrenceDAO().setDeleted(guid, true, (Option<String>)new Some((Object)this.deleteTime$1));
                    }
                }
                return true;
            }
            {
                this.lastDate$1 = lastDate$1;
                this.test$2 = test$2;
                this.deleteTime$1 = deleteTime$1;
                this.totalRecords$4 = totalRecords$4;
                this.deleted$1 = deleted$1;
                this.reinstate$1 = reinstate$1;
            }
        }, startUuid, endUuid, 1000, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowKey", "uuid", "lastModifiedTime", "dateDeleted"}));
        Predef$.MODULE$.println((Object)"Finished cleanup for rows");
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Records checked: ").append((Object)BoxesRunTime.boxToInteger((int)totalRecords.elem)).append((Object)" Records deleted: ").append((Object)BoxesRunTime.boxToInteger((int)deleted.elem)).append((Object)" Records reinstated: ").append((Object)BoxesRunTime.boxToInteger((int)reinstate.elem)).toString());
    }

    public boolean modifyRecord$default$5() {
        return false;
    }

    public void removeDeletedRecords(String dr, Option<String> start, Option<String> end) {
        OccurrenceDAO occDao = Config$.MODULE$.occurrenceDAO();
        IntRef count = new IntRef(0);
        IntRef totalRecords = new IntRef(0);
        String startUuid = (String)start.getOrElse((Function0)new Serializable(dr){
            public static final long serialVersionUID = 0L;
            private final String dr$3;

            public final String apply() {
                return new StringBuilder().append((Object)this.dr$3).append((Object)"|").toString();
            }
            {
                this.dr$3 = dr$3;
            }
        });
        String endUuid = (String)end.getOrElse((Function0)new Serializable(startUuid){
            public static final long serialVersionUID = 0L;
            private final String startUuid$4;

            public final String apply() {
                return new StringBuilder().append((Object)this.startUuid$4).append((Object)"~").toString();
            }
            {
                this.startUuid$4 = startUuid$4;
            }
        });
        Config$.MODULE$.persistenceManager().pageOverSelect("occ", (Function2<String, Map<String, String>, Object>)new Serializable(occDao, count, totalRecords){
            public static final long serialVersionUID = 0L;
            private final OccurrenceDAO occDao$1;
            private final IntRef count$2;
            private final IntRef totalRecords$5;

            public final boolean apply(String guid, Map<String, String> map) {
                ++this.totalRecords$5.elem;
                String delete = (String)map.getOrElse((Object)FullRecordMapper$.MODULE$.deletedColumn(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "false";
                    }
                });
                if ("true".equals(delete)) {
                    this.occDao$1.delete(guid, false, true);
                    ++this.count$2.elem;
                }
                if (this.totalRecords$5.elem % 1000 == 0) {
                    ResourceCleanupTask$.MODULE$.logger().info(new StringBuilder().append((Object)"Deleted ").append((Object)BoxesRunTime.boxToInteger((int)this.count$2.elem)).append((Object)" records out of ").append((Object)BoxesRunTime.boxToInteger((int)this.totalRecords$5.elem)).toString());
                    ResourceCleanupTask$.MODULE$.logger().info(new StringBuilder().append((Object)"Last key checked: ").append((Object)guid).toString());
                }
                return true;
            }
            {
                this.occDao$1 = occDao$1;
                this.count$2 = count$2;
                this.totalRecords$5 = totalRecords$5;
            }
        }, startUuid, endUuid, 1000, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowKey", "uuid", FullRecordMapper$.MODULE$.deletedColumn()}));
    }

    private ResourceCleanupTask$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        IncrementalTool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"ResourceCleanupTask");
    }
}

