/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.caches.LocationDAO$;
import au.org.ala.biocache.caches.TaxonProfileDAO$;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.Feet$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Location;
import au.org.ala.biocache.model.MeasurementUnit;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.model.TaxonProfile;
import au.org.ala.biocache.model.Versions$;
import au.org.ala.biocache.parser.DistanceRangeParser$;
import au.org.ala.biocache.parser.VerbatimLatLongParser$;
import au.org.ala.biocache.poso.POSO;
import au.org.ala.biocache.processor.LocationProcessor$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import au.org.ala.biocache.util.Json$;
import au.org.ala.biocache.util.StringHelper$;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.BBox;
import au.org.ala.biocache.vocab.Countries$;
import au.org.ala.biocache.vocab.CountryCentrePoints$;
import au.org.ala.biocache.vocab.HabitatMap$;
import au.org.ala.biocache.vocab.LatLng;
import au.org.ala.biocache.vocab.StateProvinceCentrePoints$;
import au.org.ala.biocache.vocab.StateProvinceToCountry$;
import au.org.ala.biocache.vocab.StateProvinces$;
import au.org.ala.biocache.vocab.Term;
import au.org.ala.sds.SensitiveDataService;
import au.org.ala.sds.SensitiveSpeciesFinder;
import au.org.ala.sds.model.Message;
import au.org.ala.sds.util.GeoLocationHelper;
import au.org.ala.sds.validation.ValidationOutcome;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.util.Precision;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.DefaultCoordinateOperationFactory;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.io.Source$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001B\u0001\u0003\u00015\u0011\u0011\u0003T8dCRLwN\u001c)s_\u000e,7o]8s\u0015\t\u0019A!A\u0005qe>\u001cWm]:pe*\u0011QAB\u0001\tE&|7-Y2iK*\u0011q\u0001C\u0001\u0004C2\f'BA\u0005\u000b\u0003\ry'o\u001a\u0006\u0002\u0017\u0005\u0011\u0011-^\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!!\u0003)s_\u000e,7o]8s\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u0016\u0001!9Q\u0004\u0001b\u0001\n\u0003q\u0012A\u00027pO\u001e,'/F\u0001 !\t\u0001C%D\u0001\"\u0015\t\u00113%A\u0003tY\u001a$$NC\u0001\n\u0013\t)\u0013E\u0001\u0004M_\u001e<WM\u001d\u0005\u0007O\u0001\u0001\u000b\u0011B\u0010\u0002\u000f1|wmZ3sA!A\u0011\u0006\u0001EC\u0002\u0013\u0005!&A\u0005tIN4\u0015N\u001c3feV\t1\u0006\u0005\u0002-_5\tQF\u0003\u0002/\r\u0005\u00191\u000fZ:\n\u0005Aj#AF*f]NLG/\u001b<f'B,7-[3t\r&tG-\u001a:\t\u0011I\u0002\u0001\u0012!Q!\n-\n!b\u001d3t\r&tG-\u001a:!\u0011\u001dq\u0003A1A\u0005\u0002Q*\u0012!\u000e\t\u0003YYJ!aN\u0017\u0003)M+gn]5uSZ,G)\u0019;b'\u0016\u0014h/[2f\u0011\u0019I\u0004\u0001)A\u0005k\u0005!1\u000fZ:!\u0011!Y\u0004\u0001#b\u0001\n\u0003a\u0014aD2sg\u0016\u00038oZ\"pI\u0016\u001cX*\u00199\u0016\u0003u\u0002BAP\"F\u000b6\tqH\u0003\u0002A\u0003\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u0005B\t!bY8mY\u0016\u001cG/[8o\u0013\t!uHA\u0002NCB\u0004\"AR%\u000f\u0005=9\u0015B\u0001%\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!\u0003\u0002\u0002C'\u0001\u0011\u0003\u0005\u000b\u0015B\u001f\u0002!\r\u00148/\u00129tO\u000e{G-Z:NCB\u0004\u0003\u0002C(\u0001\u0011\u000b\u0007I\u0011\u0001\u001f\u0002!i|g.Z#qg\u001e\u001cu\u000eZ3t\u001b\u0006\u0004\b\u0002C)\u0001\u0011\u0003\u0005\u000b\u0015B\u001f\u0002#i|g.Z#qg\u001e\u001cu\u000eZ3t\u001b\u0006\u0004\b\u0005C\u0004T\u0001\t\u0007I\u0011\u0001+\u0002\u001f];5\u000b\u000f\u001b`\u000bB\u001bviX\"pI\u0016,\u0012!\u0016\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000bA\u0001\\1oO*\t!,\u0001\u0003kCZ\f\u0017B\u0001&X\u0011\u0019i\u0006\u0001)A\u0005+\u0006\u0001rkR*9i}+\u0005kU$`\u0007>$W\r\t\u0005\u0006?\u0002!\t\u0001Y\u0001\baJ|7-Z:t)\u0015\t'\u000e\\9t!\ry!\rZ\u0005\u0003GB\u0011Q!\u0011:sCf\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a\u0003\u0002\u000b5|G-\u001a7\n\u0005%4'\u0001E)vC2LG/_!tg\u0016\u0014H/[8o\u0011\u0015Yg\f1\u0001F\u0003\u00119W/\u001b3\t\u000b5t\u0006\u0019\u00018\u0002\u0007I\fw\u000f\u0005\u0002f_&\u0011\u0001O\u001a\u0002\u000b\rVdGNU3d_J$\u0007\"\u0002:_\u0001\u0004q\u0017!\u00039s_\u000e,7o]3e\u0011\u001d!h\f%AA\u0002U\fQ\u0002\\1tiB\u0013xnY3tg\u0016$\u0007cA\bw]&\u0011q\u000f\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u000be\u0004A\u0011\u0001>\u0002!A\u0014xnY3tg2{7-\u0019;j_:\u001cH#B>\u007f\u007f\u0006\u0005\u0001CA\b}\u0013\ti\bC\u0001\u0003V]&$\b\"B7y\u0001\u0004q\u0007\"\u0002:y\u0001\u0004q\u0007bBA\u0002q\u0002\u0007\u0011QA\u0001\u000bCN\u001cXM\u001d;j_:\u001c\b#BA\u0004\u0003\u001b!WBAA\u0005\u0015\r\tY!Q\u0001\b[V$\u0018M\u00197f\u0013\u0011\ty!!\u0003\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\b\u0003'\u0001A\u0011AA\u000b\u0003]\u0001(o\\2fgN\fE\u000e^5uk\u0012,\u0017I\u001c3EKB$\b\u000eF\u0005|\u0003/\tI\"a\u0007\u0002\u001e!11.!\u0005A\u0002\u0015Ca!\\A\t\u0001\u0004q\u0007B\u0002:\u0002\u0012\u0001\u0007a\u000e\u0003\u0005\u0002\u0004\u0005E\u0001\u0019AA\u0003\u0011\u001d\t\t\u0003\u0001C\u0001\u0003G\tqc]3u!J|7-Z:tK\u0012\u001cun\u001c:eS:\fG/Z:\u0015\u000fm\f)#a\n\u0002*!1Q.a\bA\u00029DaA]A\u0010\u0001\u0004q\u0007\u0002CA\u0002\u0003?\u0001\r!!\u0002\t\u000f\u00055\u0002\u0001\"\u0001\u00020\u0005q\u0001O]8dKN\u001cH*\u0019;M_:<GCFA\u0019\u0003s\ti$!\u0011\u0002F\u0005%\u0013QJA)\u0003+\nI&!\u0018\u0011\t=1\u00181\u0007\t\u0007\u001f\u0005UR)R#\n\u0007\u0005]\u0002C\u0001\u0004UkBdWm\r\u0005\b\u0003w\tY\u00031\u0001F\u0003-\u0011\u0018m\u001e'bi&$X\u000fZ3\t\u000f\u0005}\u00121\u0006a\u0001\u000b\u0006a!/Y<M_:<\u0017\u000e^;eK\"9\u00111IA\u0016\u0001\u0004)\u0015\u0001\u0005:bo\u001e+w\u000eZ3uS\u000e$\u0015\r^;n\u0011\u001d\t9%a\u000bA\u0002\u0015\u000b\u0001C^3sE\u0006$\u0018.\u001c'bi&$X\u000fZ3\t\u000f\u0005-\u00131\u0006a\u0001\u000b\u0006\tb/\u001a:cCRLW\u000eT8oO&$X\u000fZ3\t\u000f\u0005=\u00131\u0006a\u0001\u000b\u0006Ya/\u001a:cCRLWn\u0015*T\u0011\u001d\t\u0019&a\u000bA\u0002\u0015\u000bq!Z1ti&tw\rC\u0004\u0002X\u0005-\u0002\u0019A#\u0002\u00119|'\u000f\u001e5j]\u001eDq!a\u0017\u0002,\u0001\u0007Q)\u0001\u0003{_:,\u0007\u0002CA\u0002\u0003W\u0001\r!!\u0002\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d\u0005Y\"/\u001a9s_*,7\r^\"p_J$\u0017N\\1uKN$vnV$TqQ\"\"\"!\u001a\u0002n\u0005]\u00141PA@!\u0011ya/a\u001a\u0011\u000b=\tI'R#\n\u0007\u0005-\u0004C\u0001\u0004UkBdWM\r\u0005\t\u0003_\ny\u00061\u0001\u0002r\u0005Y1m\\8sI&t\u0017\r^32!\ry\u00111O\u0005\u0004\u0003k\u0002\"A\u0002#pk\ndW\r\u0003\u0005\u0002z\u0005}\u0003\u0019AA9\u0003-\u0019wn\u001c:eS:\fG/\u001a\u001a\t\u000f\u0005u\u0014q\fa\u0001\u000b\u0006\t2o\\;sG\u0016\u001c%o]#qg\u001e\u001cu\u000eZ3\t\u0011\u0005\u0005\u0015q\fa\u0001\u0003\u0007\u000ba\u0003Z3dS6\fG\u000e\u00157bG\u0016\u001cHk\u001c*pk:$Gk\u001c\t\u0004\u001f\u0005\u0015\u0015bAAD!\t\u0019\u0011J\u001c;\t\u000f\u0005-\u0005\u0001\"\u0001\u0002\u000e\u0006\u0001s-\u001a;Ok6\u0014WM](g\t\u0016\u001c\u0017.\\1m!2\f7-Z:J]\u0012{WO\u00197f)\u0011\t\u0019)a$\t\u000f\u0005E\u0015\u0011\u0012a\u0001\u000b\u0006yA-Z2j[\u0006d\u0017i]*ue&tw\rC\u0004\u0002\u0016\u0002!\t!a&\u0002\u001d1|wn[;q\u000bB\u001cxmQ8eKR!\u0011\u0011TAN!\rya/\u0012\u0005\b\u0003;\u000b\u0019\n1\u0001F\u0003\r\u0019'o\u001d\u0005\b\u0003C\u0003A\u0011AAR\u0003i\u0019\u0007.Z2l\u0007>|'\u000fZ5oCR,WK\\2feR\f\u0017N\u001c;z)\u001dY\u0018QUAT\u0003SCa!\\AP\u0001\u0004q\u0007B\u0002:\u0002 \u0002\u0007a\u000e\u0003\u0005\u0002\u0004\u0005}\u0005\u0019AA\u0003\u0011\u001d\ti\u000b\u0001C\u0001\u0003_\u000bqc\u00195fG.4uN\u001d%bE&$\u0018\r^'jg6\fGo\u00195\u0015\u0013m\f\t,a-\u00026\u0006}\u0006BB7\u0002,\u0002\u0007a\u000e\u0003\u0004s\u0003W\u0003\rA\u001c\u0005\t\u0003o\u000bY\u000b1\u0001\u0002:\u0006aA/\u0019=p]B\u0013xNZ5mKB\u0019Q-a/\n\u0007\u0005ufM\u0001\u0007UCb|g\u000e\u0015:pM&dW\r\u0003\u0005\u0002\u0004\u0005-\u0006\u0019AA\u0003\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u000b\fQ#\u00193e\u0007>t7/\u001a:wCRLwN\\*uCR,8\u000fF\u0004|\u0003\u000f\fI-a3\t\r5\f\t\r1\u0001o\u0011\u0019\u0011\u0018\u0011\u0019a\u0001]\"A\u0011qWAa\u0001\u0004\tI\fC\u0004\u0002P\u0002!\t!!5\u0002+\rDWmY6G_J\u001cF/\u0019;f\u001b&\u001cX.\u0019;dQR910a5\u0002V\u0006]\u0007BB7\u0002N\u0002\u0007a\u000e\u0003\u0004s\u0003\u001b\u0004\rA\u001c\u0005\t\u0003\u0007\ti\r1\u0001\u0002\u0006!9\u00111\u001c\u0001\u0005\u0002\u0005u\u0017A\u0007<bY&$\u0017\r^3HK>\u0014XMZ3sK:\u001cWMV1mk\u0016\u001cH\u0003CA\u0003\u0003?\f\t/a9\t\r5\fI\u000e1\u0001o\u0011\u0019\u0011\u0018\u0011\u001ca\u0001]\"A\u00111AAm\u0001\u0004\t)\u0001C\u0004\u0002h\u0002!\t!!;\u00023Y\fG.\u001b3bi\u0016\u001cun\u001c:eS:\fG/Z:WC2,Xm\u001d\u000b\t\u0003W\f\t0a=\u0002vB\u0019q\"!<\n\u0007\u0005=\bCA\u0002B]fDa!\\As\u0001\u0004q\u0007B\u0002:\u0002f\u0002\u0007a\u000e\u0003\u0005\u0002\u0004\u0005\u0015\b\u0019AA\u0003\u0011\u001d\tI\u0010\u0001C\u0001\u0003w\f!\u0003\u001d:pG\u0016\u001c8oU3og&$\u0018N^5usRQ\u00111^A\u007f\u0003\u007f\u0014\tAa\u0003\t\r5\f9\u00101\u0001o\u0011\u0019\u0011\u0018q\u001fa\u0001]\"A!1AA|\u0001\u0004\u0011)!\u0001\u0005m_\u000e\fG/[8o!\r)'qA\u0005\u0004\u0005\u00131'\u0001\u0003'pG\u0006$\u0018n\u001c8\t\u0011\t5\u0011q\u001fa\u0001\u0005\u001f\t\u0001cY8oi\u0016DH/^1m\u0019\u0006LXM]:\u0011\u000b\u0019\u0013\t\"R#\n\u0005\u0011[\u0005b\u0002B\u000b\u0001\u0011\u0005!qC\u0001\u0010O\u0016$X\t_1diN\u001b\u0017NT1nKR\u0019QI!\u0007\t\r5\u0014\u0019\u00021\u0001o\u0011\u0019\u0011i\u0002\u0001C\u0001)\u00069q-\u001a;OC6,\u0007\"\u0003B\u0011\u0001E\u0005I\u0011\tB\u0012\u0003E\u0001(o\\2fgN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005KQ3!\u001eB\u0014W\t\u0011I\u0003\u0005\u0003\u0003,\tURB\u0001B\u0017\u0015\u0011\u0011yC!\r\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u001a!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t]\"Q\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class LocationProcessor
implements Processor {
    private final Logger logger;
    private SensitiveSpeciesFinder sdsFinder;
    private final SensitiveDataService sds;
    private scala.collection.immutable.Map<String, String> crsEpsgCodesMap;
    private scala.collection.immutable.Map<String, String> zoneEpsgCodesMap;
    private final String WGS84_EPSG_Code;
    private volatile byte bitmap$0;

    private SensitiveSpeciesFinder sdsFinder$lzycompute() {
        LocationProcessor locationProcessor = this;
        synchronized (locationProcessor) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sdsFinder = Config$.MODULE$.sdsFinder();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.sdsFinder;
        }
    }

    private scala.collection.immutable.Map crsEpsgCodesMap$lzycompute() {
        LocationProcessor locationProcessor = this;
        synchronized (locationProcessor) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                ObjectRef valuesMap = new ObjectRef((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                Source$.MODULE$.fromURL(this.getClass().getResource("/crsEpsgCodes.txt"), "utf-8").getLines().toList().foreach((Function1)new Serializable(this, valuesMap){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef valuesMap$1;

                    public final void apply(String line) {
                        String[] values = new StringOps(Predef$.MODULE$.augmentString(line)).split('=');
                        this.valuesMap$1.elem = ((scala.collection.immutable.Map)this.valuesMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)values[0]), (Object)values[1]));
                    }
                    {
                        this.valuesMap$1 = valuesMap$1;
                    }
                });
                this.crsEpsgCodesMap = (scala.collection.immutable.Map)valuesMap.elem;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.crsEpsgCodesMap;
        }
    }

    private scala.collection.immutable.Map zoneEpsgCodesMap$lzycompute() {
        LocationProcessor locationProcessor = this;
        synchronized (locationProcessor) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                ObjectRef valuesMap = new ObjectRef((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                Source$.MODULE$.fromURL(this.getClass().getResource("/zoneEpsgCodes.txt"), "utf-8").getLines().toList().foreach((Function1)new Serializable(this, valuesMap){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef valuesMap$2;

                    public final void apply(String line) {
                        String[] values = new StringOps(Predef$.MODULE$.augmentString(line)).split('=');
                        this.valuesMap$2.elem = ((scala.collection.immutable.Map)this.valuesMap$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)values[0]), (Object)values[1]));
                    }
                    {
                        this.valuesMap$2 = valuesMap$2;
                    }
                });
                this.zoneEpsgCodesMap = (scala.collection.immutable.Map)valuesMap.elem;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.zoneEpsgCodesMap;
        }
    }

    public Logger logger() {
        return this.logger;
    }

    public SensitiveSpeciesFinder sdsFinder() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sdsFinder$lzycompute() : this.sdsFinder;
    }

    public SensitiveDataService sds() {
        return this.sds;
    }

    public scala.collection.immutable.Map<String, String> crsEpsgCodesMap() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.crsEpsgCodesMap$lzycompute() : this.crsEpsgCodesMap;
    }

    public scala.collection.immutable.Map<String, String> zoneEpsgCodesMap() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.zoneEpsgCodesMap$lzycompute() : this.zoneEpsgCodesMap;
    }

    public String WGS84_EPSG_Code() {
        return this.WGS84_EPSG_Code;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        ArrayBuffer arrayBuffer;
        ArrayBuffer assertions = new ArrayBuffer();
        this.setProcessedCoordinates(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.processAltitudeAndDepth(guid, raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        if (processed.location().decimalLatitude() == null || processed.location().decimalLongitude() == null) {
            arrayBuffer = raw.location().footprintWKT() == null && raw.location().locality() == null && raw.location().locationID() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.LOCATION_NOT_SUPPLIED())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.LOCATION_NOT_SUPPLIED(), 1));
        } else {
            Object object;
            this.validateCoordinatesValues(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            this.checkCoordinateUncertainty(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            Option<Tuple3<Location, scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>>> point = LocationDAO$.MODULE$.getByLatLon(processed.location().decimalLatitude(), processed.location().decimalLongitude());
            if (point.isEmpty()) {
                object = BoxedUnit.UNIT;
            } else {
                Tuple3 tuple32;
                Tuple3 tuple3 = (Tuple3)point.get();
                if (tuple3 == null) throw new MatchError((Object)tuple3);
                Location location = (Location)tuple3._1();
                scala.collection.immutable.Map environmentalLayers = (scala.collection.immutable.Map)tuple3._2();
                scala.collection.immutable.Map contextualLayers = (scala.collection.immutable.Map)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)location, (Object)environmentalLayers, (Object)contextualLayers);
                Location location2 = (Location)tuple33._1();
                scala.collection.immutable.Map environmentalLayers2 = (scala.collection.immutable.Map)tuple33._2();
                scala.collection.immutable.Map contextualLayers2 = (scala.collection.immutable.Map)tuple33._3();
                processed.locationDetermined_$eq(true);
                processed.location().stateProvince_$eq(location2.stateProvince());
                processed.location().ibra_$eq(location2.ibra());
                processed.location().imcra_$eq(location2.imcra());
                processed.location().lga_$eq(location2.lga());
                processed.location().country_$eq(location2.country());
                processed.el_$eq(JavaConversions$.MODULE$.mapAsJavaMap((Map)environmentalLayers2));
                processed.cl_$eq(JavaConversions$.MODULE$.mapAsJavaMap((Map)contextualLayers2));
                processed.location().habitat_$eq((String)(StringUtils.isEmpty((String)location2.ibra()) ? (StringUtils.isEmpty((String)location2.imcra()) ? null : "Marine") : "Terrestrial"));
                this.checkForStateMismatch(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                Option<TaxonProfile> taxonProfile = TaxonProfileDAO$.MODULE$.getByGuid(processed.classification().taxonConceptID());
                if (!taxonProfile.isEmpty()) {
                    this.addConservationStatus(raw, processed, (TaxonProfile)taxonProfile.get());
                    this.checkForHabitatMismatch(raw, processed, (TaxonProfile)taxonProfile.get(), (ArrayBuffer<QualityAssertion>)assertions);
                }
                try {
                    object = this.processSensitivity(raw, processed, location2, (scala.collection.immutable.Map<String, String>)contextualLayers2);
                }
                catch (Exception exception) {
                    this.logger().error(new StringBuilder().append((Object)"Problem processing using the SDS for record ").append((Object)guid).toString(), (Throwable)exception);
                    object = BoxedUnit.UNIT;
                }
            }
            arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.LOCATION_NOT_SUPPLIED(), 1));
        }
        this.processLocations(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.validateGeoreferenceValues(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    public void processLocations(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        Option<Term> countryCodeTerm;
        Option<Term> countryTerm;
        Option<Term> stateTerm;
        ArrayBuffer arrayBuffer = raw.location().country() == null && processed.location().country() != null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_INFERRED_FROM_COORDINATES(), 0)) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_INFERRED_FROM_COORDINATES(), 1));
        ArrayBuffer arrayBuffer2 = StateProvinceCentrePoints$.MODULE$.coordinatesMatchCentre(processed.location().stateProvince(), raw.location().decimalLatitude(), raw.location().decimalLongitude()) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_STATEPROVINCE(), new StringBuilder().append((Object)"Coordinates are centre point of ").append((Object)processed.location().stateProvince()).toString())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_STATEPROVINCE(), 1));
        ArrayBuffer arrayBuffer3 = CountryCentrePoints$.MODULE$.coordinatesMatchCentre(processed.location().country(), raw.location().decimalLatitude(), raw.location().decimalLongitude()) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_COUNTRY(), new StringBuilder().append((Object)"Coordinates are centre point of ").append((Object)processed.location().country()).toString())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_COUNTRY(), 1));
        if (processed.location().stateProvince() == null && raw.location().decimalLatitude() == null && raw.location().decimalLongitude() == null && !(stateTerm = StateProvinces$.MODULE$.matchTerm(raw.location().stateProvince())).isEmpty()) {
            processed.location().stateProvince_$eq(((Term)stateTerm.get()).canonical());
            this.processSensitivity(raw, processed, processed.location(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
            processed.location().country_$eq((String)StateProvinceToCountry$.MODULE$.map().getOrElse((Object)processed.location().stateProvince(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }));
        }
        if (processed.location().country() == null && raw.location().decimalLatitude() == null && raw.location().decimalLongitude() == null && !(countryTerm = Countries$.MODULE$.matchTerm(raw.location().country())).isEmpty()) {
            processed.location().country_$eq(((Term)countryTerm.get()).canonical());
        }
        if (processed.location().country() == null && raw.location().countryCode() != null && !(countryCodeTerm = Countries$.MODULE$.matchTerm(raw.location().countryCode())).isEmpty()) {
            processed.location().country_$eq(((Term)countryCodeTerm.get()).canonical());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processAltitudeAndDepth(String guid, FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        if (raw.location().verbatimDepth() == null) {
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            Option<Tuple2<Object, MeasurementUnit>> parseDepthResult = DistanceRangeParser$.MODULE$.parse(raw.location().verbatimDepth());
            if (parseDepthResult.isDefined()) {
                Tuple2 tuple2;
                Tuple2 tuple22 = (Tuple2)parseDepthResult.get();
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                float vdepth = BoxesRunTime.unboxToFloat((Object)tuple22._1());
                MeasurementUnit sourceUnit = (MeasurementUnit)tuple22._2();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)vdepth), (Object)sourceUnit);
                float vdepth2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
                MeasurementUnit sourceUnit2 = (MeasurementUnit)tuple23._2();
                processed.location().verbatimDepth_$eq(((Object)BoxesRunTime.boxToFloat((float)vdepth2)).toString());
                ArrayBuffer arrayBuffer = vdepth2 > (float)10000 ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_OUT_OF_RANGE(), new StringBuilder().append((Object)"Depth ").append((Object)BoxesRunTime.boxToFloat((float)vdepth2)).append((Object)" is greater than 10,000 metres").toString())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_OUT_OF_RANGE(), 1));
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_NON_NUMERIC(), 1));
                MeasurementUnit measurementUnit = sourceUnit2;
                Feet$ feet$ = Feet$.MODULE$;
                boxedUnit3 = !(measurementUnit != null ? !measurementUnit.equals(feet$) : feet$ != null) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_IN_FEET(), "The supplied depth was in feet it has been converted to metres")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_IN_FEET(), 1));
            } else {
                boxedUnit3 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_NON_NUMERIC(), new StringBuilder().append((Object)"Can't parse verbatimDepth ").append((Object)raw.location().verbatimDepth()).toString()));
            }
        }
        if (raw.location().verbatimElevation() == null) {
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            Option<Tuple2<Object, MeasurementUnit>> parseElevationResult = DistanceRangeParser$.MODULE$.parse(raw.location().verbatimElevation());
            if (parseElevationResult.isDefined()) {
                Tuple2 tuple2;
                Tuple2 tuple24 = (Tuple2)parseElevationResult.get();
                if (tuple24 == null) throw new MatchError((Object)tuple24);
                float velevation = BoxesRunTime.unboxToFloat((Object)tuple24._1());
                MeasurementUnit sourceUnit = (MeasurementUnit)tuple24._2();
                Tuple2 tuple25 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)velevation), (Object)sourceUnit);
                float velevation2 = BoxesRunTime.unboxToFloat((Object)tuple25._1());
                MeasurementUnit sourceUnit3 = (MeasurementUnit)tuple25._2();
                processed.location().verbatimElevation_$eq(((Object)BoxesRunTime.boxToFloat((float)velevation2)).toString());
                ArrayBuffer arrayBuffer = velevation2 > (float)10000 || velevation2 < (float)-100 ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_OUT_OF_RANGE(), new StringBuilder().append((Object)"Elevation ").append((Object)BoxesRunTime.boxToFloat((float)velevation2)).append((Object)" is greater than 10,000 metres or less than -100 metres.").toString())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_OUT_OF_RANGE(), 1));
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_NON_NUMERIC(), 1));
                MeasurementUnit measurementUnit = sourceUnit3;
                Feet$ feet$ = Feet$.MODULE$;
                boxedUnit2 = !(measurementUnit != null ? !measurementUnit.equals(feet$) : feet$ != null) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_IN_FEET(), "The supplied altitude was in feet it has been converted to metres")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_IN_FEET(), 1));
            } else {
                boxedUnit2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_NON_NUMERIC(), new StringBuilder().append((Object)"Can't parse verbatimElevation ").append((Object)raw.location().verbatimElevation()).toString()));
            }
        }
        if (raw.location().minimumDepthInMeters() == null || raw.location().maximumDepthInMeters() == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            try {
                float min = new StringOps(Predef$.MODULE$.augmentString(raw.location().minimumDepthInMeters())).toFloat();
                float max = new StringOps(Predef$.MODULE$.augmentString(raw.location().maximumDepthInMeters())).toFloat();
                if (min > max) {
                    processed.location().minimumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    processed.location().maximumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_DEPTH_REVERSED(), new StringBuilder().append((Object)"The minimum, ").append((Object)BoxesRunTime.boxToFloat((float)min)).append((Object)", and maximum, ").append((Object)BoxesRunTime.boxToFloat((float)max)).append((Object)", depths have been transposed.").toString()));
                } else {
                    processed.location().minimumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    processed.location().maximumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_DEPTH_REVERSED(), 1));
                }
            }
            catch (Exception exception) {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        if (raw.location().minimumElevationInMeters() == null || raw.location().maximumElevationInMeters() == null) return;
        try {
            float min = new StringOps(Predef$.MODULE$.augmentString(raw.location().minimumElevationInMeters())).toFloat();
            float max = new StringOps(Predef$.MODULE$.augmentString(raw.location().maximumElevationInMeters())).toFloat();
            if (min > max) {
                processed.location().minimumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                processed.location().maximumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_ALTITUDE_REVERSED(), new StringBuilder().append((Object)"The minimum, ").append((Object)BoxesRunTime.boxToFloat((float)min)).append((Object)", and maximum, ").append((Object)BoxesRunTime.boxToFloat((float)max)).append((Object)", elevations have been transposed.").toString()));
                return;
            } else {
                processed.location().minimumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                processed.location().maximumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_ALTITUDE_REVERSED(), 1));
            }
            return;
        }
        catch (Exception exception) {
            this.logger().debug(new StringBuilder().append((Object)"Exception thrown processing elevation:").append((Object)exception.getMessage()).toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProcessedCoordinates(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (raw.location().originalDecimalLatitude() == null || raw.location().originalDecimalLongitude() == null) {
            Tuple3 tuple3;
            Tuple3 tuple32 = (Tuple3)this.processLatLong(raw.location().decimalLatitude(), raw.location().decimalLongitude(), raw.location().geodeticDatum(), raw.location().verbatimLatitude(), raw.location().verbatimLongitude(), raw.location().verbatimSRS(), raw.location().easting(), raw.location().northing(), raw.location().zone(), assertions).getOrElse((Function0)new $anonfun$2(this));
            if (tuple32 == null) throw new MatchError((Object)tuple32);
            String y = (String)tuple32._1();
            String x = (String)tuple32._2();
            String geodeticDatum = (String)tuple32._3();
            Tuple3 tuple33 = tuple3 = new Tuple3((Object)y, (Object)x, (Object)geodeticDatum);
            String y2 = (String)tuple33._1();
            String x2 = (String)tuple33._2();
            String geodeticDatum2 = (String)tuple33._3();
            processed.location().decimalLatitude_$eq(y2);
            processed.location().decimalLongitude_$eq(x2);
            processed.location().geodeticDatum_$eq(geodeticDatum2);
            return;
        } else {
            processed.location().decimalLatitude_$eq(raw.location().originalDecimalLatitude());
            processed.location().decimalLongitude_$eq(raw.location().originalDecimalLongitude());
            processed.location().verbatimLatitude_$eq(raw.location().originalVerbatimLatitude());
            processed.location().verbatimLongitude_$eq(raw.location().originalVerbatimLongitude());
            raw.location().decimalLatitude_$eq(raw.location().originalDecimalLatitude());
            raw.location().decimalLongitude_$eq(raw.location().originalDecimalLongitude());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Tuple3<String, String, String>> processLatLong(String rawLatitude, String rawLongitude, String rawGeodeticDatum, String verbatimLatitude, String verbatimLongitude, String verbatimSRS, String easting, String northing, String zone, ArrayBuffer<QualityAssertion> assertions) {
        None$ none$;
        if (rawLatitude == null || rawLongitude == null || StringHelper$.MODULE$.string2helper(rawLatitude).toFloatWithOption().isEmpty() || StringHelper$.MODULE$.string2helper(rawLongitude).toFloatWithOption().isEmpty()) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_COORDINATES_NOT_SUPPLIED()));
            if (verbatimLatitude == null || verbatimLongitude == null) {
                if (easting == null || northing == null || zone == null) {
                    none$ = None$.MODULE$;
                    return none$;
                } else {
                    String epsgCodeKey;
                    String string = epsgCodeKey = verbatimSRS == null ? new StringBuilder().append((Object)"GDA94|").append((Object)zone).toString() : new StringBuilder().append((Object)verbatimSRS.toUpperCase()).append((Object)"|").append((Object)zone).toString();
                    if (this.zoneEpsgCodesMap().contains((Object)epsgCodeKey)) {
                        String crsEpsgCode = (String)this.zoneEpsgCodesMap().apply((Object)epsgCodeKey);
                        Option<Object> eastingAsDouble = StringHelper$.MODULE$.string2helper(easting).toDoubleWithOption();
                        Option<Object> northingAsDouble = StringHelper$.MODULE$.string2helper(northing).toDoubleWithOption();
                        if (eastingAsDouble.isEmpty() || northingAsDouble.isEmpty()) {
                            none$ = None$.MODULE$;
                            return none$;
                        } else {
                            Option<Tuple2<String, String>> reprojectedCoords = this.reprojectCoordinatesToWGS84(BoxesRunTime.unboxToDouble((Object)eastingAsDouble.get()), BoxesRunTime.unboxToDouble((Object)northingAsDouble.get()), crsEpsgCode, 5);
                            if (reprojectedCoords.isEmpty()) {
                                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), "Transformation of verbatim easting and northing to WGS84 failed"));
                                none$ = None$.MODULE$;
                                return none$;
                            } else {
                                Tuple2 tuple2;
                                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), 1));
                                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_EASTING_NORTHING(), "Decimal latitude and longitude were calculated using easting, northing and zone."));
                                Tuple2 tuple22 = (Tuple2)reprojectedCoords.get();
                                if (tuple22 == null) throw new MatchError((Object)tuple22);
                                String reprojectedLatitude = (String)tuple22._1();
                                String reprojectedLongitude = (String)tuple22._2();
                                Tuple2 tuple23 = tuple2 = new Tuple2((Object)reprojectedLatitude, (Object)reprojectedLongitude);
                                String reprojectedLatitude2 = (String)tuple23._1();
                                String reprojectedLongitude2 = (String)tuple23._2();
                                none$ = new Some((Object)new Tuple3((Object)reprojectedLatitude2, (Object)reprojectedLongitude2, (Object)this.WGS84_EPSG_Code()));
                            }
                        }
                        return none$;
                    } else {
                        ArrayBuffer arrayBuffer = verbatimSRS == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), new StringBuilder().append((Object)"Unrecognized zone GDA94 / MGA zone ").append((Object)zone).toString())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), new StringBuilder().append((Object)"Unrecognized zone ").append((Object)verbatimSRS).append((Object)" / zone ").append((Object)zone).toString()));
                        none$ = None$.MODULE$;
                    }
                }
                return none$;
            } else {
                Option<Object> decimalVerbatimLat = StringHelper$.MODULE$.string2helper(verbatimLatitude).toFloatWithOption();
                Option<Object> decimalVerbatimLong = StringHelper$.MODULE$.string2helper(verbatimLongitude).toFloatWithOption();
                if (decimalVerbatimLat.isEmpty() || decimalVerbatimLong.isEmpty()) {
                    decimalVerbatimLat = VerbatimLatLongParser$.MODULE$.parse(verbatimLatitude);
                    decimalVerbatimLong = VerbatimLatLongParser$.MODULE$.parse(verbatimLongitude);
                }
                if (decimalVerbatimLat.isEmpty() || decimalVerbatimLong.isEmpty()) {
                    none$ = None$.MODULE$;
                    return none$;
                } else if (StringHelper$.MODULE$.string2helper(decimalVerbatimLat.get().toString()).isLatitude() && StringHelper$.MODULE$.string2helper(decimalVerbatimLong.get().toString()).isLongitude()) {
                    if (verbatimSRS == null) {
                        if (StringHelper$.MODULE$.string2helper(decimalVerbatimLat.get().toString()).isLatitude() && StringHelper$.MODULE$.string2helper(decimalVerbatimLong.get().toString()).isLongitude()) {
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), 1));
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM(), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS"));
                            none$ = new Some((Object)new Tuple3((Object)decimalVerbatimLat.get().toString(), (Object)decimalVerbatimLong.get().toString(), (Object)this.WGS84_EPSG_Code()));
                            return none$;
                        } else {
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), "Could not parse verbatim latitude and longitude"));
                            none$ = None$.MODULE$;
                        }
                        return none$;
                    } else {
                        Option<String> sourceEpsgCode = this.lookupEpsgCode(verbatimSRS);
                        if (sourceEpsgCode.isEmpty()) {
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), new StringBuilder().append((Object)"Unrecognized verbatimSRS ").append((Object)verbatimSRS).toString()));
                            none$ = None$.MODULE$;
                            return none$;
                        } else {
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), 1));
                            Object object = sourceEpsgCode.get();
                            String string = this.WGS84_EPSG_Code();
                            if (!(object != null ? !object.equals(string) : string != null)) {
                                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM(), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS"));
                                none$ = new Some((Object)new Tuple3((Object)decimalVerbatimLat.get().toString(), (Object)decimalVerbatimLong.get().toString(), (Object)this.WGS84_EPSG_Code()));
                                return none$;
                            } else {
                                int desiredNoDecimalPlaces = package$.MODULE$.min(this.getNumberOfDecimalPlacesInDouble(decimalVerbatimLat.get().toString()), this.getNumberOfDecimalPlacesInDouble(decimalVerbatimLong.get().toString()));
                                Option<Tuple2<String, String>> reprojectedCoords = this.reprojectCoordinatesToWGS84(BoxesRunTime.unboxToFloat((Object)decimalVerbatimLat.get()), BoxesRunTime.unboxToFloat((Object)decimalVerbatimLong.get()), (String)sourceEpsgCode.get(), desiredNoDecimalPlaces);
                                if (reprojectedCoords.isEmpty()) {
                                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), "Transformation of verbatim latiude and longitude to WGS84 failed"));
                                    none$ = None$.MODULE$;
                                    return none$;
                                } else {
                                    Tuple2 tuple2;
                                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), 1));
                                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM(), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS"));
                                    Tuple2 tuple24 = (Tuple2)reprojectedCoords.get();
                                    if (tuple24 == null) throw new MatchError((Object)tuple24);
                                    String reprojectedLatitude = (String)tuple24._1();
                                    String reprojectedLongitude = (String)tuple24._2();
                                    Tuple2 tuple25 = tuple2 = new Tuple2((Object)reprojectedLatitude, (Object)reprojectedLongitude);
                                    String reprojectedLatitude3 = (String)tuple25._1();
                                    String reprojectedLongitude3 = (String)tuple25._2();
                                    none$ = new Some((Object)new Tuple3((Object)reprojectedLatitude3, (Object)reprojectedLongitude3, (Object)this.WGS84_EPSG_Code()));
                                }
                            }
                        }
                    }
                    return none$;
                } else {
                    none$ = None$.MODULE$;
                }
            }
            return none$;
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_COORDINATES_NOT_SUPPLIED(), 1));
            if (rawGeodeticDatum == null) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.GEODETIC_DATUM_ASSUMED_WGS84(), "Geodetic datum assumed to be WGS84 (EPSG:4326)"));
                none$ = new Some((Object)new Tuple3((Object)rawLatitude, (Object)rawLongitude, (Object)this.WGS84_EPSG_Code()));
                return none$;
            } else {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.GEODETIC_DATUM_ASSUMED_WGS84(), 1));
                Option<String> sourceEpsgCode = this.lookupEpsgCode(rawGeodeticDatum);
                if (sourceEpsgCode.isEmpty()) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNIZED_GEODETIC_DATUM(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geodetic datum ", " not recognized."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rawGeodeticDatum}))));
                    none$ = new Some((Object)new Tuple3((Object)rawLatitude, (Object)rawLongitude, (Object)rawGeodeticDatum));
                    return none$;
                } else {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNIZED_GEODETIC_DATUM(), 1));
                    Object object = sourceEpsgCode.get();
                    String string = this.WGS84_EPSG_Code();
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        none$ = new Some((Object)new Tuple3((Object)rawLatitude, (Object)rawLongitude, (Object)this.WGS84_EPSG_Code()));
                        return none$;
                    } else {
                        int desiredNoDecimalPlaces = package$.MODULE$.min(this.getNumberOfDecimalPlacesInDouble(rawLatitude), this.getNumberOfDecimalPlacesInDouble(rawLongitude));
                        Option<Tuple2<String, String>> reprojectedCoords = this.reprojectCoordinatesToWGS84(new StringOps(Predef$.MODULE$.augmentString(rawLatitude)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(rawLongitude)).toDouble(), (String)sourceEpsgCode.get(), desiredNoDecimalPlaces);
                        if (reprojectedCoords.isEmpty()) {
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CONVERSION_FAILED(), "Transformation of decimal latiude and longitude to WGS84 failed"));
                            none$ = None$.MODULE$;
                            return none$;
                        } else {
                            Tuple2 tuple2;
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CONVERSION_FAILED(), 1));
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CONVERTED(), "Decimal latitude and longitude were converted to WGS84 (EPSG:4326)"));
                            Tuple2 tuple26 = (Tuple2)reprojectedCoords.get();
                            if (tuple26 == null) throw new MatchError((Object)tuple26);
                            String reprojectedLatitude = (String)tuple26._1();
                            String reprojectedLongitude = (String)tuple26._2();
                            Tuple2 tuple27 = tuple2 = new Tuple2((Object)reprojectedLatitude, (Object)reprojectedLongitude);
                            String reprojectedLatitude4 = (String)tuple27._1();
                            String reprojectedLongitude4 = (String)tuple27._2();
                            none$ = new Some((Object)new Tuple3((Object)reprojectedLatitude4, (Object)reprojectedLongitude4, (Object)this.WGS84_EPSG_Code()));
                        }
                    }
                }
            }
        }
        return none$;
    }

    public Option<Tuple2<String, String>> reprojectCoordinatesToWGS84(double coordinate1, double coordinate2, String sourceCrsEpsgCode, int decimalPlacesToRoundTo) {
        None$ none$;
        try {
            DefaultGeographicCRS wgs84CRS = DefaultGeographicCRS.WGS84;
            CoordinateReferenceSystem sourceCRS = CRS.decode((String)sourceCrsEpsgCode);
            CoordinateOperation transformOp = new DefaultCoordinateOperationFactory().createOperation(sourceCRS, (CoordinateReferenceSystem)wgs84CRS);
            GeneralDirectPosition directPosition = new GeneralDirectPosition(coordinate1, coordinate2);
            DirectPosition wgs84LatLong = transformOp.getMathTransform().transform((DirectPosition)directPosition, null);
            double longitude = wgs84LatLong.getOrdinate(0);
            double latitude = wgs84LatLong.getOrdinate(1);
            double roundedLongitude = Precision.round((double)longitude, (int)decimalPlacesToRoundTo);
            double roundedLatitude = Precision.round((double)latitude, (int)decimalPlacesToRoundTo);
            none$ = new Some((Object)new Tuple2((Object)((Object)BoxesRunTime.boxToDouble((double)roundedLatitude)).toString(), (Object)((Object)BoxesRunTime.boxToDouble((double)roundedLongitude)).toString()));
        }
        catch (Exception exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public int getNumberOfDecimalPlacesInDouble(String decimalAsString) {
        String[] tokens = new StringOps(Predef$.MODULE$.augmentString(decimalAsString)).split('.');
        return tokens.length == 2 ? tokens[1].length() : 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<String> lookupEpsgCode(String crs) {
        None$ none$;
        if (StringUtils.startsWithIgnoreCase((String)crs, (String)"EPSG:")) {
            try {
                CRS.decode((String)crs.toUpperCase());
                none$ = new Some((Object)crs.toUpperCase());
                return none$;
            }
            catch (Exception exception) {
                none$ = None$.MODULE$;
                return none$;
            }
        } else {
            if (this.crsEpsgCodesMap().contains((Object)crs.toUpperCase())) {
                none$ = new Some(this.crsEpsgCodesMap().apply((Object)crs.toUpperCase()));
                return none$;
            }
            none$ = None$.MODULE$;
            return none$;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkCoordinateUncertainty(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer;
        BoxedUnit boxedUnit;
        boolean checkedPrecision = false;
        if (raw.location().coordinateUncertaintyInMeters() != null && raw.location().coordinateUncertaintyInMeters().length() > 0) {
            Option<Tuple2<Object, MeasurementUnit>> parsedResult = DistanceRangeParser$.MODULE$.parse(raw.location().coordinateUncertaintyInMeters());
            if (parsedResult.isEmpty()) {
                String comment = new StringBuilder().append((Object)"Supplied uncertainty, ").append((Object)raw.location().coordinateUncertaintyInMeters()).append((Object)", is not a supported format").toString();
                boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_RANGE_MISMATCH(), comment));
            } else {
                ArrayBuffer arrayBuffer2;
                Tuple2 tuple2;
                Tuple2 tuple22 = (Tuple2)parsedResult.get();
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                float parsedValue = BoxesRunTime.unboxToFloat((Object)tuple22._1());
                MeasurementUnit rawUnit = (MeasurementUnit)tuple22._2();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)parsedValue), (Object)rawUnit);
                float parsedValue2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
                MeasurementUnit rawUnit2 = (MeasurementUnit)tuple23._2();
                if (parsedValue2 > 0.0f) {
                    arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_RANGE_MISMATCH(), 1));
                } else {
                    String comment = new StringBuilder().append((Object)"Supplied uncertainty, ").append((Object)raw.location().coordinateUncertaintyInMeters()).append((Object)", is not a supported format").toString();
                    arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_RANGE_MISMATCH(), comment));
                }
                processed.location().coordinateUncertaintyInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)parsedValue2)).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            Option<Object> value;
            if (raw.location().coordinatePrecision() != null && !(value = StringHelper$.MODULE$.string2helper(raw.location().coordinatePrecision()).toFloatWithOption()).isEmpty() && BoxesRunTime.unboxToFloat((Object)value.get()) > 1.0f) {
                processed.location().coordinateUncertaintyInMeters_$eq(((Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToFloat((Object)value.get())))).toString());
                String comment = new StringBuilder().append((Object)"Supplied precision, ").append((Object)raw.location().coordinatePrecision()).append((Object)", is assumed to be uncertainty in metres").toString();
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_IN_PRECISION(), comment));
                checkedPrecision = true;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (raw.location().coordinatePrecision() == null) {
            arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_COORDINATEPRECISION(), "Missing coordinatePrecision"));
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_COORDINATEPRECISION(), 1));
            if (checkedPrecision) {
                arrayBuffer = BoxedUnit.UNIT;
            } else {
                Option<Object> value = StringHelper$.MODULE$.string2helper(raw.location().coordinatePrecision()).toFloatWithOption();
                if (value.isDefined()) {
                    if (BoxesRunTime.unboxToFloat((Object)value.get()) > 0.0f && BoxesRunTime.unboxToFloat((Object)value.get()) <= 1.0f) {
                        int lonp;
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.PRECISION_RANGE_MISMATCH(), 1));
                        int pre = raw.location().coordinatePrecision().contains(".") ? raw.location().coordinatePrecision().split("\\.")[1].length() : 0;
                        String lat2 = processed.location().decimalLatitude();
                        String string = processed.location().decimalLongitude();
                        int latp = lat2.contains(".") ? lat2.split("\\.")[1].length() : 0;
                        int n = lonp = string.contains(".") ? string.split("\\.")[1].length() : 0;
                        arrayBuffer = pre == latp && pre == lonp ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_PRECISION_MISMATCH(), 1)) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_PRECISION_MISMATCH()));
                    } else {
                        arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.PRECISION_RANGE_MISMATCH(), "Coordinate precision is not between 0 and 1"));
                    }
                } else {
                    arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.PRECISION_RANGE_MISMATCH(), "Unable to parse the coordinate precision"));
                }
            }
        }
        if (processed.location().coordinateUncertaintyInMeters() == null) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_NOT_SPECIFIED(), "Uncertainty was not supplied"));
            return;
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_NOT_SPECIFIED(), 1));
        }
    }

    public void checkForHabitatMismatch(FullRecord raw, FullRecord processed, TaxonProfile taxonProfile, ArrayBuffer<QualityAssertion> assertions) {
        if (processed.location().habitat() != null) {
            if (taxonProfile.habitats() != null && !Predef$.MODULE$.refArrayOps((Object[])taxonProfile.habitats()).isEmpty()) {
                String[] habitatsForSpecies;
                String habitatsAsString = Predef$.MODULE$.refArrayOps((Object[])taxonProfile.habitats()).mkString(",");
                String habitatFromPoint = processed.location().habitat();
                Option<Object> validHabitat = HabitatMap$.MODULE$.areTermsCompatible(habitatFromPoint, habitatsForSpecies = taxonProfile.habitats());
                if (!validHabitat.isEmpty()) {
                    if (BoxesRunTime.unboxToBoolean((Object)validHabitat.get())) {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), 1));
                    } else {
                        String string = habitatsAsString;
                        String string2 = "???";
                        if (string == null ? string2 != null : !string.equals(string2)) {
                            this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] ******** Habitats incompatible for ROWKEY: ").append((Object)raw.rowKey()).append((Object)", processed:").append((Object)processed.location().habitat()).append((Object)", retrieved:").append((Object)habitatsAsString).append((Object)", http://maps.google.com/?ll=").append((Object)processed.location().decimalLatitude()).append((Object)",").append((Object)processed.location().decimalLongitude()).toString());
                            String comment = new StringBuilder().append((Object)"Recognised habitats for species: ").append((Object)habitatsAsString).append((Object)", Value determined from coordinates: ").append((Object)habitatFromPoint).toString();
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), comment));
                        }
                    }
                }
            }
        }
    }

    public void addConservationStatus(FullRecord raw, FullRecord processed, TaxonProfile taxonProfile) {
        String string = processed.location().country();
        String string2 = Config$.MODULE$.defaultCountry();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (taxonProfile.conservation() != null) {
                Option<String> country = taxonProfile.retrieveConservationStatus(processed.location().country());
                Option<String> state = taxonProfile.retrieveConservationStatus(processed.location().stateProvince());
                processed.occurrence().austConservation_$eq((String)country.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                processed.occurrence().stateConservation_$eq((String)state.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
            }
        }
    }

    public void checkForStateMismatch(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (processed.location().stateProvince() != null && raw.location().stateProvince() != null) {
            Option<Term> stateTerm = StateProvinces$.MODULE$.matchTerm(raw.location().stateProvince());
            if (stateTerm.isEmpty() || processed.location().stateProvince().equalsIgnoreCase(((Term)stateTerm.get()).canonical())) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.STATE_COORDINATE_MISMATCH(), 1));
            } else {
                this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] ").append((Object)raw.rowKey()).append((Object)", processed:").append((Object)processed.location().stateProvince()).append((Object)", raw:").append((Object)raw.location().stateProvince()).toString());
                String comment = new StringBuilder().append((Object)"Supplied: ").append((Object)((Term)stateTerm.get()).canonical()).append((Object)", calculated: ").append((Object)processed.location().stateProvince()).toString();
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.STATE_COORDINATE_MISMATCH(), comment));
            }
        }
    }

    public ArrayBuffer<QualityAssertion> validateGeoreferenceValues(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer = raw.location().geodeticDatum() == null && processed.location().geodeticDatum() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEODETICDATUM(), "Missing geodeticDatum")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEODETICDATUM(), 1));
        ArrayBuffer arrayBuffer2 = raw.location().georeferencedBy() == null && processed.location().georeferencedBy() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERNCEDBY(), "Missing georeferencedBy")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERNCEDBY(), 1));
        ArrayBuffer arrayBuffer3 = raw.location().georeferenceProtocol() == null && processed.location().georeferenceProtocol() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEPROTOCOL(), "Missing georeferenceProtocol")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEPROTOCOL(), 1));
        ArrayBuffer arrayBuffer4 = raw.location().georeferenceSources() == null && processed.location().georeferenceSources() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCESOURCES(), "Missing georeferenceSources")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCESOURCES(), 1));
        ArrayBuffer arrayBuffer5 = raw.location().georeferenceVerificationStatus() == null && processed.location().georeferenceVerificationStatus() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEVERIFICATIONSTATUS(), "Missing georeferenceVerificationStatus")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEVERIFICATIONSTATUS(), 1));
        return StringUtils.isBlank((String)raw.location().georeferencedDate()) && !raw.miscProperties().containsKey("georeferencedDate") ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCE_DATE())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCE_DATE(), 1));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object validateCoordinatesValues(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        BoxedUnit boxedUnit;
        Some some;
        Tuple2 tuple2;
        float lon2;
        float lat2;
        BoxedUnit boxedUnit2;
        block20: {
            block19: {
                ArrayBuffer arrayBuffer;
                ArrayBuffer arrayBuffer2;
                Option<Object> latWithOption = StringHelper$.MODULE$.string2helper(processed.location().decimalLatitude()).toFloatWithOption();
                Option<Object> lonWithOption = StringHelper$.MODULE$.string2helper(processed.location().decimalLongitude()).toFloatWithOption();
                if (latWithOption.isEmpty() || lonWithOption.isEmpty()) {
                    boxedUnit2 = BoxedUnit.UNIT;
                    return boxedUnit2;
                }
                lat2 = BoxesRunTime.unboxToFloat((Object)latWithOption.get());
                lon2 = BoxesRunTime.unboxToFloat((Object)lonWithOption.get());
                if (lat2 < (float)-90 || lat2 > (float)90 || lon2 < (float)-180 || lon2 > (float)180) {
                    if (lon2 >= (float)-90 && lon2 <= (float)90 && lat2 >= (float)-180 && lat2 <= (float)180) {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVERTED_COORDINATES(), new StringBuilder().append((Object)"Assume that coordinates have been inverted. Original values: ").append((Object)processed.location().decimalLatitude()).append((Object)",").append((Object)processed.location().decimalLongitude()).toString()));
                        String tmp = processed.location().decimalLatitude();
                        processed.location().decimalLatitude_$eq(processed.location().decimalLongitude());
                        processed.location().decimalLongitude_$eq(tmp);
                        arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_OUT_OF_RANGE(), 1));
                    } else {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_OUT_OF_RANGE(), new StringBuilder().append((Object)"Coordinates are out of range: ").append((Object)processed.location().decimalLatitude()).append((Object)",").append((Object)processed.location().decimalLongitude()).toString()));
                        arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVERTED_COORDINATES(), 1));
                    }
                } else {
                    arrayBuffer2 = assertions.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVERTED_COORDINATES(), 1), QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_OUT_OF_RANGE(), 1)}));
                }
                if (lat2 == 0.0f && lon2 == 0.0f) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_COORDINATES(), "Coordinates 0,0"));
                    processed.location().decimalLatitude_$eq(null);
                    processed.location().decimalLongitude_$eq(null);
                    arrayBuffer = BoxedUnit.UNIT;
                } else {
                    arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_COORDINATES(), 1));
                }
                if (raw.location().country() == null) break block19;
                String string = raw.location().country();
                String string2 = "";
                if (string != null ? !string.equals(string2) : string2 != null) break block20;
            }
            boxedUnit2 = BoxedUnit.UNIT;
            return boxedUnit2;
        }
        Option<Term> country = Countries$.MODULE$.matchTerm(raw.location().country());
        if (country.isEmpty()) {
            boxedUnit2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNKNOWN_COUNTRY_NAME(), new StringBuilder().append((Object)"Country name '").append((Object)raw.location().country()).append((Object)"' not recognised.").toString()));
            return boxedUnit2;
        }
        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNKNOWN_COUNTRY_NAME(), 1));
        Option<Tuple2<LatLng, BBox>> option = CountryCentrePoints$.MODULE$.matchName(((Term)country.get()).canonical());
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
            BoxedUnit boxedUnit3;
            BBox bbox = (BBox)tuple2._2();
            if (bbox.containsPoint(lat2, lon2)) {
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boolean hasCoordinateMismatch = true;
                if (bbox.containsPoint(lat2 * (float)-1, lon2)) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NEGATED_LATITUDE(), new StringBuilder().append((Object)"Latitude seems to be negated. Original value:").append((Object)processed.location().decimalLatitude()).toString()));
                    processed.location().decimalLatitude_$eq(((Object)BoxesRunTime.boxToFloat((float)(lat2 * (float)-1))).toString());
                    hasCoordinateMismatch = false;
                }
                if (bbox.containsPoint(lat2, lon2 * (float)-1)) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NEGATED_LONGITUDE(), new StringBuilder().append((Object)"Longitude seems to be negated. Original value: ").append((Object)processed.location().decimalLongitude()).toString()));
                    processed.location().decimalLongitude_$eq(((Object)BoxesRunTime.boxToFloat((float)(lon2 * (float)-1))).toString());
                    hasCoordinateMismatch = false;
                }
                boxedUnit3 = hasCoordinateMismatch ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_COORDINATE_MISMATCH())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_COORDINATE_MISMATCH(), 1));
            }
            boxedUnit = boxedUnit3;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boxedUnit2 = boxedUnit;
        return boxedUnit2;
    }

    public Object processSensitivity(FullRecord raw, FullRecord processed, Location location, scala.collection.immutable.Map<String, String> contextualLayers) {
        Object object;
        scala.collection.mutable.Map rawMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])raw.objectArray()).foreach((Function1)new Serializable(this, rawMap){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map rawMap$1;

            public final void apply(POSO poso) {
                scala.collection.immutable.Map<String, String> map = FullRecordMapper$.MODULE$.mapObjectToProperties(poso, Versions$.MODULE$.RAW());
                JavaConversions$.MODULE$.mutableMapAsJavaMap(this.rawMap$1).putAll(JavaConversions$.MODULE$.mapAsJavaMap(map));
            }
            {
                this.rawMap$1 = rawMap$1;
            }
        });
        Object object2 = location.stateProvince() == null ? BoxedUnit.UNIT : rawMap.put((Object)"stateProvince", (Object)location.stateProvince());
        JavaConversions$.MODULE$.asScalaBuffer(GeoLocationHelper.getGeospatialLayers()).foreach((Function1)new Serializable(this, contextualLayers, rawMap){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map contextualLayers$1;
            private final scala.collection.mutable.Map rawMap$1;

            public final Option<String> apply(String key) {
                return this.rawMap$1.put((Object)key, this.contextualLayers$1.getOrElse((Object)key, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "n/a";
                    }
                }));
            }
            {
                this.contextualLayers$1 = contextualLayers$1;
                this.rawMap$1 = rawMap$1;
            }
        });
        if (processed.event().day() != null) {
            rawMap.update((Object)"day", (Object)processed.event().day());
        }
        if (processed.event().month() != null) {
            rawMap.update((Object)"month", (Object)processed.event().month());
        }
        if (processed.event().year() != null) {
            rawMap.update((Object)"year", (Object)processed.event().year());
        }
        String exact = this.getExactSciName(raw);
        ValidationOutcome outcome = this.sds().testMapDetails(this.sdsFinder(), JavaConversions$.MODULE$.mutableMapAsJavaMap(rawMap), exact, processed.classification().taxonConceptID());
        if (outcome != null && outcome.isValid() && outcome.isSensitive()) {
            if (outcome.getResult() == null) {
                if (!outcome.isLoadable() && Config$.MODULE$.obeySDSIsLoadable()) {
                    this.logger().warn(new StringBuilder().append((Object)"SDS isLoadable status is currently not being used. Would apply to: ").append((Object)processed.uuid()).toString());
                }
            } else {
                Some some;
                Tuple3 tuple3;
                Option<Tuple3<Location, scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>>> newPoint;
                BoxedUnit boxedUnit;
                scala.collection.mutable.Map map = JavaConversions$.MODULE$.mapAsScalaMap(outcome.getResult());
                scala.collection.mutable.Map stringMap = (scala.collection.mutable.Map)map.collect((PartialFunction)new Serializable(this, processed){
                    public static final long serialVersionUID = 0L;
                    private final FullRecord processed$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<String, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            String key = (String)A1._1();
                            Object value = A1._2();
                            if (value != null) {
                                Tuple2 tuple2;
                                String string = key;
                                String string2 = "originalSensitiveValues";
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    HashMap osv = (HashMap)value;
                                    Object object2 = this.processed$1.location().coordinateUncertaintyInMeters() == null ? BoxedUnit.UNIT : osv.put("coordinateUncertaintyInMeters.p", this.processed$1.location().coordinateUncertaintyInMeters());
                                    JavaConversions$.MODULE$.asScalaBuffer(GeoLocationHelper.getGeospatialLayers()).foreach((Function1)new Serializable(this, osv){
                                        public static final long serialVersionUID = 0L;
                                        private final HashMap osv$1;

                                        public final String apply(String key) {
                                            return (String)this.osv$1.remove(key);
                                        }
                                        {
                                            this.osv$1 = osv$1;
                                        }
                                    });
                                    String newv = Json$.MODULE$.toJSON(osv);
                                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)newv);
                                } else {
                                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)value.toString());
                                }
                                object = tuple2;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<String, Object> x1) {
                        Object value;
                        Tuple2<String, Object> tuple2 = x1;
                        boolean bl = tuple2 != null && (value = tuple2._2()) != null;
                        return bl;
                    }
                    {
                        this.processed$1 = processed$1;
                    }
                }, Map$.MODULE$.canBuildFrom());
                Option uncertainty = stringMap.get((Object)"generalisationInMetres");
                if (uncertainty.isEmpty()) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (StringUtils.isNotEmpty((String)((String)uncertainty.get()).toString())) {
                        float currentUncertainty = StringUtils.isNotEmpty((String)processed.location().coordinateUncertaintyInMeters()) ? Float.parseFloat(processed.location().coordinateUncertaintyInMeters()) : 0.0f;
                        float newUncertainty = currentUncertainty + (float)Integer.parseInt(((String)uncertainty.get()).toString());
                        processed.location().coordinateUncertaintyInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)newUncertainty)).toString());
                    }
                    processed.location().decimalLatitude_$eq((String)stringMap.getOrElse((Object)"decimalLatitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }));
                    processed.location().decimalLongitude_$eq((String)stringMap.getOrElse((Object)"decimalLongitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }));
                    boxedUnit = stringMap.$minus$eq((Object)"generalisationInMetres");
                }
                processed.occurrence().informationWithheld_$eq((String)stringMap.getOrElse((Object)"informationWithheld", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
                processed.occurrence().dataGeneralizations_$eq((String)stringMap.getOrElse((Object)"dataGeneralizations", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
                stringMap.$minus$eq((Object)"informationWithheld");
                stringMap.$minus$eq((Object)"dataGeneralizations");
                raw.event().day_$eq("");
                processed.event().day_$eq("");
                processed.event().eventDate_$eq("");
                Config$.MODULE$.persistenceManager().put(raw.rowKey(), "occ", (scala.collection.immutable.Map<String, String>)stringMap.toMap(Predef$.MODULE$.conforms()));
                this.logger().debug(new StringBuilder().append((Object)"**************** Performing lookup for new point ['").append((Object)raw.rowKey()).append((Object)"',").append((Object)processed.location().decimalLongitude()).append((Object)",").append((Object)processed.location().decimalLatitude()).append((Object)"]").toString());
                Option<Tuple3<Location, scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>>> option = newPoint = LocationDAO$.MODULE$.getByLatLon(processed.location().decimalLatitude(), processed.location().decimalLongitude());
                if (option instanceof Some && (tuple3 = (Tuple3)(some = (Some)option).x()) != null) {
                    Location loc = (Location)tuple3._1();
                    processed.location().lga_$eq(loc.lga());
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    processed.location().lga_$eq(null);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                }
            }
            if (outcome.getReport().getMessages() == null) {
                object = BoxedUnit.UNIT;
            } else {
                ObjectRef infoMessage = new ObjectRef((Object)"");
                JavaConversions$.MODULE$.asScalaBuffer(outcome.getReport().getMessages()).foreach((Function1)new Serializable(this, infoMessage){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef infoMessage$1;

                    public final void apply(Message message) {
                        this.infoMessage$1.elem = new StringBuilder().append((Object)((String)this.infoMessage$1.elem)).append((Object)new StringBuilder().append((Object)message.getCategory()).append((Object)"\t").append((Object)message.getMessageText()).append((Object)"\n").toString()).toString();
                    }
                    {
                        this.infoMessage$1 = infoMessage$1;
                    }
                });
                processed.occurrence().informationWithheld_$eq((String)infoMessage.elem);
                object = BoxedUnit.UNIT;
            }
        } else {
            object = raw.occurrence().originalSensitiveValues() == null || raw.occurrence().originalSensitiveValues().isEmpty() ? BoxedUnit.UNIT : Config$.MODULE$.persistenceManager().put(raw.rowKey(), "occ", (scala.collection.immutable.Map<String, String>)raw.occurrence().originalSensitiveValues().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"originalSensitiveValues"), (Object)"")));
        }
        return object;
    }

    public String getExactSciName(FullRecord raw) {
        return raw.classification().scientificName() == null ? (raw.classification().subspecies() == null ? (raw.classification().species() == null ? (raw.classification().genus() == null ? (raw.classification().vernacularName() == null ? raw.classification().scientificName() : raw.classification().vernacularName()) : (raw.classification().specificEpithet() == null ? raw.classification().genus() : (raw.classification().infraspecificEpithet() == null ? new StringBuilder().append((Object)raw.classification().genus()).append((Object)" ").append((Object)raw.classification().specificEpithet()).toString() : new StringBuilder().append((Object)raw.classification().genus()).append((Object)" ").append((Object)raw.classification().specificEpithet()).append((Object)" ").append((Object)raw.classification().infraspecificEpithet()).toString()))) : raw.classification().species()) : raw.classification().subspecies()) : raw.classification().scientificName();
    }

    @Override
    public String getName() {
        return FullRecordMapper$.MODULE$.geospatialQa();
    }

    public LocationProcessor() {
        Processor$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"LocationProcessor");
        this.sds = new SensitiveDataService();
        this.WGS84_EPSG_Code = "EPSG:4326";
    }
}

