/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.load.MediaStore;
import au.org.ala.biocache.load.MediaStore$class;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.util.HttpUtil$;
import au.org.ala.biocache.util.Json$;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import net.minidev.json.JSONArray;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class RemoteMediaStore$
implements MediaStore {
    public static final RemoteMediaStore$ MODULE$;
    private final Logger logger;
    private final Regex imageParser;
    private final Regex soundParser;
    private final Regex videoParser;
    private final String[] imageExtension;
    private final String[] soundExtension;
    private final String[] videoExtension;
    private volatile byte bitmap$0;

    static {
        new RemoteMediaStore$();
    }

    private Regex imageParser$lzycompute() {
        RemoteMediaStore$ remoteMediaStore$ = this;
        synchronized (remoteMediaStore$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.imageParser = MediaStore$class.imageParser(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.imageParser;
        }
    }

    @Override
    public Regex imageParser() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.imageParser$lzycompute() : this.imageParser;
    }

    private Regex soundParser$lzycompute() {
        RemoteMediaStore$ remoteMediaStore$ = this;
        synchronized (remoteMediaStore$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.soundParser = MediaStore$class.soundParser(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.soundParser;
        }
    }

    @Override
    public Regex soundParser() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.soundParser$lzycompute() : this.soundParser;
    }

    private Regex videoParser$lzycompute() {
        RemoteMediaStore$ remoteMediaStore$ = this;
        synchronized (remoteMediaStore$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.videoParser = MediaStore$class.videoParser(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.videoParser;
        }
    }

    @Override
    public Regex videoParser() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.videoParser$lzycompute() : this.videoParser;
    }

    @Override
    public String[] imageExtension() {
        return this.imageExtension;
    }

    @Override
    public String[] soundExtension() {
        return this.soundExtension;
    }

    @Override
    public String[] videoExtension() {
        return this.videoExtension;
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$logger_$eq(Logger x$1) {
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$imageExtension_$eq(String[] x$1) {
        this.imageExtension = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$soundExtension_$eq(String[] x$1) {
        this.soundExtension = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$videoExtension_$eq(String[] x$1) {
        this.videoExtension = x$1;
    }

    @Override
    public boolean isValidImageURL(String url) {
        return MediaStore$class.isValidImageURL(this, url);
    }

    @Override
    public boolean isValidSoundURL(String url) {
        return MediaStore$class.isValidSoundURL(this, url);
    }

    @Override
    public boolean isValidVideoURL(String url) {
        return MediaStore$class.isValidVideoURL(this, url);
    }

    @Override
    public boolean isValidImage(String filename) {
        return MediaStore$class.isValidImage(this, filename);
    }

    @Override
    public boolean isValidSound(String filename) {
        return MediaStore$class.isValidSound(this, filename);
    }

    @Override
    public boolean isValidVideo(String filename) {
        return MediaStore$class.isValidVideo(this, filename);
    }

    @Override
    public boolean isMediaFile(File file) {
        return MediaStore$class.isMediaFile(this, file);
    }

    @Override
    public boolean endsWithOneOf(String[] acceptedExtensions, String url) {
        return MediaStore$class.endsWithOneOf(this, acceptedExtensions, url);
    }

    @Override
    public String extractFileName(String urlToMedia) {
        return MediaStore$class.extractFileName(this, urlToMedia);
    }

    @Override
    public boolean isAccessible(String urlString) {
        return MediaStore$class.isAccessible(this, urlString);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public java.util.Map<String, String> getImageFormats(String imageId) {
        void var2_2;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("thumb", new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImageThumbnail?imageId=").append((Object)imageId).toString());
        map.put("small", new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImageThumbnail?imageId=").append((Object)imageId).toString());
        map.put("large", new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImageThumbnailLarge?imageId=").append((Object)imageId).toString());
        map.put("raw", new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImage?imageId=").append((Object)imageId).toString());
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Tuple3<Object, String, String> alreadyStored(String uuid, String resourceUID, String urlToMedia) {
        Tuple3 tuple3;
        Tuple2 tuple22;
        String jsonToPost = Json$.MODULE$.toJSON((scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"filenames"), (Object)new String[]{this.constructFileID(resourceUID, uuid, urlToMedia)})}))));
        this.logger().debug(jsonToPost);
        Tuple2<Object, String> tuple2 = HttpUtil$.MODULE$.postBody(new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/ws/findImagesByOriginalFilename").toString(), "application/json", jsonToPost);
        if (tuple2 == null) throw new MatchError(tuple2);
        int code = tuple2._1$mcI$sp();
        String body = (String)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)code), (Object)body);
        int code2 = tuple23._1$mcI$sp();
        String body2 = (String)tuple23._2();
        if (code2 != 200) {
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"", (Object)"");
            return tuple3;
        }
        try {
            JsonPath jsonPath = JsonPath.compile((String)"$..imageId", (Filter[])new Filter[0]);
            JSONArray idArray = (JSONArray)jsonPath.read(body2);
            if (idArray.isEmpty()) {
                tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"", (Object)"");
                return tuple3;
            }
            if (idArray.size() == 0) {
                tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"", (Object)"");
                return tuple3;
            }
            Object imageId = idArray.get(0);
            this.logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Image ", " already stored here: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{urlToMedia}))).append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/image/proxyImage?imageId=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{imageId}))).toString());
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)this.extractFileName(urlToMedia), (Object)imageId.toString());
            return tuple3;
        }
        catch (Exception exception) {
            this.logger().debug(exception.getMessage(), (Throwable)exception);
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"", (Object)"");
        }
        return tuple3;
    }

    public String constructFileID(String resourceUID, String uuid, String urlToMedia) {
        return new StringBuilder().append((Object)resourceUID).append((Object)"||").append((Object)uuid).append((Object)"||").append((Object)this.extractFileName(urlToMedia)).toString();
    }

    @Override
    public Option<Tuple2<String, String>> save(String uuid, String resourceUID, String urlToMedia) {
        File tmpFile;
        Option<File> option;
        block11: {
            None$ none$;
            block10: {
                if (urlToMedia.startsWith(Config$.MODULE$.remoteMediaStoreUrl())) {
                    this.logger().info(new StringBuilder().append((Object)"Remote media store URL recognised: ").append((Object)urlToMedia).toString());
                    URI uri = new URI(urlToMedia);
                    List params = URLEncodedUtils.parse((URI)uri, (String)"UTF-8");
                    NameValuePair param = (NameValuePair)params.get(0);
                    String string = param.getName().toLowerCase();
                    String string2 = "imageid";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        String imageId = param.getValue();
                        URL imageMetadataUrl = new URL(new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/ws/getImageInfo?id=").append((Object)imageId).toString());
                        String response = Source$.MODULE$.fromURL(imageMetadataUrl, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
                        Map<String, Object> metadata = Json$.MODULE$.toMap(response);
                        return new Some((Object)new Tuple2((Object)metadata.getOrElse((Object)"originalFileName", (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        }).toString(), (Object)param.getValue()));
                    }
                }
                if ((option = this.downloadToTmpFile(resourceUID, uuid, urlToMedia)) instanceof Some) {
                    Some some = (Some)option;
                    tmpFile = (File)some.x();
                    Option<String> imageId = this.uploadImage(uuid, resourceUID, urlToMedia, tmpFile);
                    Object object = imageId.isDefined() ? new Some((Object)new Tuple2((Object)this.extractFileName(urlToMedia), imageId.getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }))) : None$.MODULE$;
                    none$ = object;
                    break block10;
                }
                None$ none$2 = None$.MODULE$;
                Option<File> option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block11;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
        finally {
            FileUtils.forceDelete((File)tmpFile);
        }
    }

    private Option<File> downloadToTmpFile(String resourceUID, String uuid, String urlToMedia) {
        None$ none$;
        try {
            File tmpFile = new File(new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)File.separator).append((Object)this.constructFileID(resourceUID, uuid, urlToMedia)).toString());
            URL url = new URL(urlToMedia.replaceAll(" ", "%20"));
            InputStream in = url.openStream();
            FileOutputStream out = new FileOutputStream(tmpFile);
            byte[] buffer = new byte[1024];
            int numRead = 0;
            while ((numRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, numRead);
                out.flush();
            }
            in.close();
            out.close();
            none$ = new Some((Object)tmpFile);
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Problem downloading media. URL:").append((Object)urlToMedia).toString());
            this.logger().debug(exception.getMessage(), (Throwable)exception);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<String> uploadImage(String uuid, String resourceUID, String urlToMedia, File fileToUpload) {
        block2: {
            Option option;
            block5: {
                Some some;
                block4: {
                    String responseBody;
                    StatusLine result;
                    block3: {
                        DefaultHttpClient httpClient = new DefaultHttpClient();
                        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
                        if (!fileToUpload.exists()) break block2;
                        this.logger().debug(new StringBuilder().append((Object)"File to upload: ").append((Object)fileToUpload.getAbsolutePath()).append((Object)", size:").append((Object)BoxesRunTime.boxToLong((long)fileToUpload.length())).toString());
                        FileBody fileBody = new FileBody(fileToUpload, "image/jpeg");
                        entity.addPart("image", (ContentBody)fileBody);
                        entity.addPart("metadata", (ContentBody)new StringBody(Json$.MODULE$.toJSON((scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"occurrenceId"), (Object)uuid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"dataResourceUid"), (Object)resourceUID), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"originalFileName"), (Object)this.extractFileName(urlToMedia)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"fullOriginalUrl"), (Object)urlToMedia)}))))));
                        HttpPost httpPost = new HttpPost(new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/ws/uploadImage").toString());
                        httpPost.setEntity((HttpEntity)entity);
                        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                        result = response.getStatusLine();
                        responseBody = Source$.MODULE$.fromInputStream(response.getEntity().getContent(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
                        this.logger().debug(new StringBuilder().append((Object)"Image service response code: ").append((Object)BoxesRunTime.boxToInteger((int)result.getStatusCode())).toString());
                        Map<String, Object> map = Json$.MODULE$.toMap(responseBody);
                        this.logger().debug(new StringBuilder().append((Object)"Image ID: ").append(map.getOrElse((Object)"imageId", (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        })).toString());
                        option = map.get((Object)"imageId");
                        if (!(option instanceof Some)) break block3;
                        Some some2 = (Some)option;
                        Object o = some2.x();
                        some = new Some((Object)o.toString());
                        break block4;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block5;
                    this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to persist image. Response code ", ".getStatusCode.  Image service response body: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result, responseBody})));
                    some = None$.MODULE$;
                }
                return some;
            }
            throw new MatchError((Object)option);
        }
        this.logger().error(new StringBuilder().append((Object)"File to upload does not exist or can not be read. ").append((Object)fileToUpload.getAbsolutePath()).toString());
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public java.util.Map<String, String> getSoundFormats(String mediaID) {
        void var2_2;
        HashMap<String, String> formats2 = new HashMap<String, String>();
        formats2.put("audio/mpeg", new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImage?imageId=").append((Object)mediaID).toString());
        return var2_2;
    }

    @Override
    public void convertPathsToUrls(FullRecord fullRecord, String baseUrlPath) {
        if (fullRecord.occurrence().images() != null) {
            fullRecord.occurrence().images_$eq((String[])Predef$.MODULE$.refArrayOps((Object[])fullRecord.occurrence().images()).map((Function1)new Serializable(baseUrlPath){
                public static final long serialVersionUID = 0L;
                private final String baseUrlPath$2;

                public final String apply(String x) {
                    return RemoteMediaStore$.MODULE$.convertPathToUrl(x, this.baseUrlPath$2);
                }
                {
                    this.baseUrlPath$2 = baseUrlPath$2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
    }

    @Override
    public String convertPathToUrl(String str, String baseUrlPath) {
        return new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImageThumbnail?imageId=").append((Object)str).toString();
    }

    @Override
    public String convertPathToUrl(String str) {
        return new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImageThumbnail?imageId=").append((Object)str).toString();
    }

    private RemoteMediaStore$() {
        MODULE$ = this;
        MediaStore$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"RemoteMediaStore");
    }
}

