/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.load.MediaStore;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.util.matching.Regex;

public abstract class MediaStore$class {
    public static Regex imageParser(MediaStore $this) {
        return new StringOps(Predef$.MODULE$.augmentString("^(https?://[^\\'\"<>]+?\\.(jpg|jpeg|gif|png))$")).r();
    }

    public static Regex soundParser(MediaStore $this) {
        return new StringOps(Predef$.MODULE$.augmentString("^(https?://[^\\'\"<>]+?\\.(?:wav|mp3|ogg|flac))$")).r();
    }

    public static Regex videoParser(MediaStore $this) {
        return new StringOps(Predef$.MODULE$.augmentString("^(https?://[^\\'\"<>]+?\\.(?:wmv|mp4|mpg|avi|mov))$")).r();
    }

    public static boolean isValidImageURL(MediaStore $this, String url) {
        return !$this.imageParser().unapplySeq((Object)url.trim().toLowerCase()).isEmpty();
    }

    public static boolean isValidSoundURL(MediaStore $this, String url) {
        return !$this.soundParser().unapplySeq((Object)url.trim().toLowerCase()).isEmpty();
    }

    public static boolean isValidVideoURL(MediaStore $this, String url) {
        return !$this.videoParser().unapplySeq((Object)url.trim().toLowerCase()).isEmpty();
    }

    public static boolean isValidImage(MediaStore $this, String filename) {
        return $this.endsWithOneOf($this.imageExtension(), filename) || !$this.imageParser().findAllMatchIn((CharSequence)filename).isEmpty();
    }

    public static boolean isValidSound(MediaStore $this, String filename) {
        return $this.endsWithOneOf($this.soundExtension(), filename) || !$this.soundParser().findAllMatchIn((CharSequence)filename).isEmpty();
    }

    public static boolean isValidVideo(MediaStore $this, String filename) {
        return $this.endsWithOneOf($this.videoExtension(), filename) || !$this.videoParser().findAllMatchIn((CharSequence)filename).isEmpty();
    }

    public static boolean isMediaFile(MediaStore $this, File file) {
        String name = file.getAbsolutePath();
        return $this.endsWithOneOf($this.imageExtension(), name) || $this.endsWithOneOf($this.soundExtension(), name) || $this.endsWithOneOf($this.videoExtension(), name);
    }

    public static boolean endsWithOneOf(MediaStore $this, String[] acceptedExtensions, String url) {
        return !Predef$.MODULE$.refArrayOps((Object[])acceptedExtensions).collectFirst((PartialFunction)new Serializable($this, url){
            public static final long serialVersionUID = 0L;
            private final String url$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.url$1.toLowerCase().endsWith(A1) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                boolean bl = this.url$1.toLowerCase().endsWith(string);
                return bl;
            }
            {
                this.url$1 = url$1;
            }
        }).isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String extractFileName(MediaStore $this, String urlToMedia) {
        String extension;
        String fileName;
        String string;
        block8: {
            block7: {
                if (urlToMedia.contains("fileName=")) {
                    string = urlToMedia.substring(urlToMedia.indexOf("fileName=") + "fileName=".length()).replace(" ", "_");
                    return string;
                }
                if (urlToMedia.contains("?id=") && urlToMedia.contains("imgType=")) {
                    string = urlToMedia.substring(urlToMedia.lastIndexOf("/") + 1).replace("?id=", "").replace("&imgType=", ".");
                    return string;
                }
                if (urlToMedia.lastIndexOf("/") == urlToMedia.length() - 1) {
                    return "raw";
                }
                if (!Config$.MODULE$.hashImageFileNames()) {
                    string = urlToMedia.substring(urlToMedia.lastIndexOf("/") + 1).replace(" ", "_");
                    return string;
                }
                MessageDigest md = MessageDigest.getInstance("MD5");
                fileName = urlToMedia.substring(urlToMedia.lastIndexOf("/") + 1).trim();
                extension = FilenameUtils.getExtension((String)fileName);
                if (extension == null) break block7;
                String string2 = extension;
                String string3 = "";
                if (string2 != null ? !string2.equals(string3) : string3 != null) break block8;
            }
            string = DigestUtils.md5Hex((String)fileName);
            return string;
        }
        string = new StringBuilder().append((Object)DigestUtils.md5Hex((String)fileName)).append((Object)".").append((Object)extension).toString();
        return string;
    }

    public static boolean isAccessible(MediaStore $this, String urlString) {
        boolean bl;
        if (StringUtils.isBlank((CharSequence)urlString)) {
            return false;
        }
        String urlToTest = urlString.startsWith(Config$.MODULE$.mediaFileStore()) ? new StringBuilder().append((Object)"file://").append((Object)urlString).toString() : urlString;
        InputStream in = null;
        try {
            URL url = new URL(urlToTest.replaceAll(" ", "%20"));
            in = url.openStream();
            bl = true;
        }
        catch (Exception exception) {
            $this.logger().debug(new StringBuilder().append((Object)"File with URI '").append((Object)urlString).append((Object)"' is not accessible: ").append((Object)exception.getMessage()).toString());
            bl = false;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return bl;
    }

    public static void $init$(MediaStore $this) {
        $this.au$org$ala$biocache$load$MediaStore$_setter_$logger_$eq(LoggerFactory.getLogger((String)"MediaStore"));
        $this.au$org$ala$biocache$load$MediaStore$_setter_$imageExtension_$eq((String[])((Object[])new String[]{".jpg", ".gif", ".png", ".jpeg", "imgType=jpeg"}));
        $this.au$org$ala$biocache$load$MediaStore$_setter_$soundExtension_$eq((String[])((Object[])new String[]{".wav", ".mp3", ".ogg", ".flac"}));
        $this.au$org$ala$biocache$load$MediaStore$_setter_$videoExtension_$eq((String[])((Object[])new String[]{".wmv", ".mp4", ".mpg", ".avi", ".mov"}));
    }
}

