/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.load.MediaStore;
import au.org.ala.biocache.load.MediaStore$class;
import au.org.ala.biocache.load.SameNameDifferentExtensionFilter;
import au.org.ala.biocache.load.Thumbnailer$;
import au.org.ala.biocache.model.FullRecord;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class LocalMediaStore$
implements MediaStore {
    public static final LocalMediaStore$ MODULE$;
    private final Logger logger;
    private final int limit;
    private final Map<String, String> extensionToMimeTypes;
    private final Regex imageParser;
    private final Regex soundParser;
    private final Regex videoParser;
    private final String[] imageExtension;
    private final String[] soundExtension;
    private final String[] videoExtension;
    private volatile byte bitmap$0;

    static {
        new LocalMediaStore$();
    }

    private Regex imageParser$lzycompute() {
        LocalMediaStore$ localMediaStore$ = this;
        synchronized (localMediaStore$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.imageParser = MediaStore$class.imageParser(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.imageParser;
        }
    }

    @Override
    public Regex imageParser() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.imageParser$lzycompute() : this.imageParser;
    }

    private Regex soundParser$lzycompute() {
        LocalMediaStore$ localMediaStore$ = this;
        synchronized (localMediaStore$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.soundParser = MediaStore$class.soundParser(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.soundParser;
        }
    }

    @Override
    public Regex soundParser() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.soundParser$lzycompute() : this.soundParser;
    }

    private Regex videoParser$lzycompute() {
        LocalMediaStore$ localMediaStore$ = this;
        synchronized (localMediaStore$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.videoParser = MediaStore$class.videoParser(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.videoParser;
        }
    }

    @Override
    public Regex videoParser() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.videoParser$lzycompute() : this.videoParser;
    }

    @Override
    public String[] imageExtension() {
        return this.imageExtension;
    }

    @Override
    public String[] soundExtension() {
        return this.soundExtension;
    }

    @Override
    public String[] videoExtension() {
        return this.videoExtension;
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$logger_$eq(Logger x$1) {
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$imageExtension_$eq(String[] x$1) {
        this.imageExtension = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$soundExtension_$eq(String[] x$1) {
        this.soundExtension = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$videoExtension_$eq(String[] x$1) {
        this.videoExtension = x$1;
    }

    @Override
    public boolean isValidImageURL(String url) {
        return MediaStore$class.isValidImageURL(this, url);
    }

    @Override
    public boolean isValidSoundURL(String url) {
        return MediaStore$class.isValidSoundURL(this, url);
    }

    @Override
    public boolean isValidVideoURL(String url) {
        return MediaStore$class.isValidVideoURL(this, url);
    }

    @Override
    public boolean isValidImage(String filename) {
        return MediaStore$class.isValidImage(this, filename);
    }

    @Override
    public boolean isValidSound(String filename) {
        return MediaStore$class.isValidSound(this, filename);
    }

    @Override
    public boolean isValidVideo(String filename) {
        return MediaStore$class.isValidVideo(this, filename);
    }

    @Override
    public boolean isMediaFile(File file) {
        return MediaStore$class.isMediaFile(this, file);
    }

    @Override
    public boolean endsWithOneOf(String[] acceptedExtensions, String url) {
        return MediaStore$class.endsWithOneOf(this, acceptedExtensions, url);
    }

    @Override
    public String extractFileName(String urlToMedia) {
        return MediaStore$class.extractFileName(this, urlToMedia);
    }

    @Override
    public boolean isAccessible(String urlString) {
        return MediaStore$class.isAccessible(this, urlString);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    public int limit() {
        return this.limit;
    }

    @Override
    public java.util.Map<String, String> getImageFormats(String fileName) {
        String url = this.convertPathToUrl(fileName);
        String extension = url.substring(url.lastIndexOf("."));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("thumb", url.replace(extension, new StringBuilder().append((Object)"__thumb").append((Object)extension).toString()));
        map.put("small", url.replace(extension, new StringBuilder().append((Object)"__small").append((Object)extension).toString()));
        map.put("large", url.replace(extension, new StringBuilder().append((Object)"__large").append((Object)extension).toString()));
        map.put("raw", url);
        return map;
    }

    @Override
    public void convertPathsToUrls(FullRecord fullRecord, String baseUrlPath) {
        if (fullRecord.occurrence().images() != null) {
            fullRecord.occurrence().images_$eq((String[])Predef$.MODULE$.refArrayOps((Object[])fullRecord.occurrence().images()).map((Function1)new Serializable(baseUrlPath){
                public static final long serialVersionUID = 0L;
                private final String baseUrlPath$1;

                public final String apply(String x) {
                    return LocalMediaStore$.MODULE$.convertPathToUrl(x, this.baseUrlPath$1);
                }
                {
                    this.baseUrlPath$1 = baseUrlPath$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
    }

    @Override
    public String convertPathToUrl(String str, String baseUrlPath) {
        return str.replaceAll(Config$.MODULE$.mediaFileStore(), baseUrlPath);
    }

    @Override
    public String convertPathToUrl(String str) {
        return str.replaceAll(Config$.MODULE$.mediaFileStore(), Config$.MODULE$.mediaBaseUrl());
    }

    @Override
    public Tuple3<Object, String, String> alreadyStored(String uuid, String resourceUID, String urlToMedia) {
        String path = this.createFilePath(uuid, resourceUID, urlToMedia);
        return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)new File(path).exists()), (Object)this.extractFileName(urlToMedia), (Object)path);
    }

    private String createFilePath(String uuid, String resourceUID, String urlToMedia) {
        int subdirectory = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(uuid.hashCode() % this.limit()));
        String absoluteDirectoryPath = new StringBuilder().append((Object)Config$.MODULE$.mediaFileStore()).append((Object)File.separator).append((Object)resourceUID).append((Object)File.separator).append((Object)BoxesRunTime.boxToInteger((int)subdirectory)).append((Object)File.separator).append((Object)uuid).toString();
        File directory = new File(absoluteDirectoryPath);
        if (!directory.exists()) {
            FileUtils.forceMkdir((File)directory);
        }
        return new StringBuilder().append((Object)directory.getAbsolutePath()).append((Object)File.separator).append((Object)this.extractFileName(urlToMedia)).toString();
    }

    @Override
    public Option<Tuple2<String, String>> save(String uuid, String resourceUID, String urlToMedia) {
        None$ none$;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            String fullPath = this.createFilePath(uuid, resourceUID, urlToMedia);
            File file = new File(fullPath);
            if (file.exists() && file.length() != 0L) {
                this.logger().info(new StringBuilder().append((Object)"File previously saved to: ").append((Object)fullPath).toString());
                if (this.isValidImageURL(urlToMedia)) {
                    Thumbnailer$.MODULE$.generateAllSizes(new File(fullPath), Thumbnailer$.MODULE$.generateAllSizes$default$2());
                } else {
                    this.logger().warn(new StringBuilder().append((Object)"Invalid media file. Not generating derivatives for: ").append((Object)fullPath).toString());
                }
            } else {
                URL url = new URL(urlToMedia.replaceAll(" ", "%20"));
                in = url.openStream();
                out = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                int numRead = 0;
                while ((numRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, numRead);
                    out.flush();
                }
                this.logger().info(new StringBuilder().append((Object)"File saved to: ").append((Object)fullPath).toString());
                if (this.isValidImageURL(urlToMedia)) {
                    Thumbnailer$.MODULE$.generateAllSizes(new File(fullPath), Thumbnailer$.MODULE$.generateAllSizes$default$2());
                } else {
                    this.logger().warn(new StringBuilder().append((Object)"Invalid media file. Not generating derivatives for: ").append((Object)fullPath).toString());
                }
            }
            none$ = new Some((Object)new Tuple2((Object)this.extractFileName(urlToMedia), (Object)fullPath));
        }
        catch (Exception exception) {
            this.logger().warn(new StringBuilder().append((Object)"Unable to load media ").append((Object)urlToMedia).append((Object)". ").append((Object)exception.getMessage()).toString());
            none$ = None$.MODULE$;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return none$;
    }

    public Map<String, String> extensionToMimeTypes() {
        return this.extensionToMimeTypes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public java.util.Map<String, String> getSoundFormats(String filePath) {
        boolean bl;
        block4: {
            void var2_2;
            block3: {
                Object object;
                block2: {
                    HashMap formats2 = new HashMap();
                    File file = new File(filePath);
                    bl = file.exists();
                    if (!bl) break block2;
                    String[] filenames = file.getParentFile().list(new SameNameDifferentExtensionFilter(filePath));
                    Predef$.MODULE$.refArrayOps((Object[])filenames).foreach((Function1)new Serializable(formats2, file){
                        public static final long serialVersionUID = 0L;
                        private final HashMap formats$1;
                        private final File file$1;

                        public final String apply(String f) {
                            String extension = FilenameUtils.getExtension((String)f).toLowerCase();
                            String mimeType = (String)LocalMediaStore$.MODULE$.extensionToMimeTypes().getOrElse((Object)extension, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "";
                                }
                            });
                            return this.formats$1.put(mimeType, LocalMediaStore$.MODULE$.convertPathToUrl(new StringBuilder().append((Object)this.file$1.getParent()).append((Object)File.separator).append((Object)f).toString()));
                        }
                        {
                            this.formats$1 = formats$1;
                            this.file$1 = file$1;
                        }
                    });
                    object = BoxedUnit.UNIT;
                    break block3;
                }
                if (bl) break block4;
                object = Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
            }
            return var2_2;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private LocalMediaStore$() {
        MODULE$ = this;
        MediaStore$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"LocalMediaStore");
        this.limit = 32000;
        this.extensionToMimeTypes = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"mp3"), (Object)"audio/mpeg"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ogg"), (Object)"audio/ogg")}));
    }
}

