/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.Config$;
import au.org.ala.names.model.LinnaeanRankClassification;
import java.io.FileReader;
import java.io.Reader;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HabitatLoader$ {
    public static final HabitatLoader$ MODULE$;

    static {
        new HabitatLoader$();
    }

    public void main(String[] args) {
        String[] files = Predef$.MODULE$.refArrayOps((Object[])args).size() == 0 ? (String[])((Object[])new String[]{"/data/biocache-load/species_list.txt", "/data/biocache-load/family_list.txt", "/data/biocache-load/genus_list.txt"}) : args;
        Predef$.MODULE$.refArrayOps((Object[])files).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String file) {
                HabitatLoader$.MODULE$.processFile(file);
            }
        });
    }

    public void processFile(String file) {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Loading habitats from ").append((Object)file).toString());
        CSVReader reader = new CSVReader((Reader)new FileReader(file), '\t', '\"', '~');
        String[] currentLine = reader.readNext();
        String previousScientificName = "";
        int count = 0;
        while (true) {
            if (currentLine == null) break;
            String currentScientificName = currentLine[1];
            String habitat = null;
            if (currentScientificName != null && !currentScientificName.equalsIgnoreCase(previousScientificName)) {
                LinnaeanRankClassification cl = new LinnaeanRankClassification();
                cl.setScientificName(currentScientificName);
                if (currentLine.length == 12) {
                    cl.setFamily(currentScientificName);
                    cl.setKingdom(currentLine[2]);
                    habitat = this.getValue(currentLine[4]);
                } else if (currentLine.length == 13) {
                    boolean isGenus;
                    boolean bl = isGenus = !currentScientificName.contains(" ");
                    if (isGenus) {
                        cl.setGenus(currentLine[1]);
                        if (currentLine[2].contains("unallocated")) {
                            cl.setFamily(currentLine[2]);
                        }
                    } else {
                        cl.setGenus(currentLine[2]);
                    }
                }
                String guid = Config$.MODULE$.nameIndex().searchForAcceptedLsidDefaultHandling(cl, false);
                previousScientificName = currentScientificName;
                Object object = guid == null || habitat == null ? BoxedUnit.UNIT : Config$.MODULE$.persistenceManager().put(guid, "taxon", "habitats", habitat);
                if (++count % 10000 == 0) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Loaded ").append((Object)BoxesRunTime.boxToInteger((int)count)).append((Object)" taxon >>>> ").append((Object)Predef$.MODULE$.refArrayOps((Object[])currentLine).mkString(",")).toString());
                }
            }
            currentLine = reader.readNext();
        }
    }

    public String getValue(String v) {
        String string;
        String string2;
        String string3 = string2 = v;
        Character c = BoxesRunTime.boxToCharacter((char)'M');
        if (!(string3 != null ? !string3.equals(c) : c != null)) {
            string = "Marine";
        } else {
            String string4 = string2;
            String string5 = "N";
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                string = "Non-Marine";
            } else {
                String string6 = string2;
                String string7 = "MN";
                string = !(string6 != null ? !string6.equals(string7) : string7 != null) ? "Marine and Non-marine" : null;
            }
        }
        return string;
    }

    private HabitatLoader$() {
        MODULE$ = this;
    }
}

