/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.Store$;
import au.org.ala.biocache.load.Loader;
import au.org.ala.biocache.util.HttpUtil$;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.net.HttpURLConnection;
import java.net.URL;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class BieCsvLoader$ {
    public static final BieCsvLoader$ MODULE$;
    private final String bieDrString;

    static {
        new BieCsvLoader$();
    }

    public String bieDrString() {
        return this.bieDrString;
    }

    public void main(String[] args) {
        String[] drs = args.length == 0 ? this.bieDrString().split(",") : args[0].split(",");
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Attempting to load bie resources ").append((Object)Predef$.MODULE$.refArrayOps((Object[])drs).toList()).toString());
        Loader l = new Loader();
        ArrayBuffer buf = new ArrayBuffer();
        Predef$.MODULE$.println(l.resourceList());
        List biocacheResources = (List)l.resourceList().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Map<String, String> resource) {
                return (String)resource.getOrElse((Object)"uid", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
            }
        }, List$.MODULE$.canBuildFrom());
        Set dataResources = ((TraversableOnce)Config$.MODULE$.indexDAO().getDistinctValues("*:*", "data_resource_uid", 1000).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Nothing$> apply() {
                return Nil$.MODULE$;
            }
        })).toSet();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Data Resources in index : ").append((Object)dataResources).toString());
        Predef$.MODULE$.refArrayOps((Object[])drs).foreach((Function1)new Serializable(buf, biocacheResources, dataResources){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer buf$1;
            private final List biocacheResources$1;
            private final Set dataResources$1;

            public final Object apply(String dr) {
                ArrayBuffer arrayBuffer;
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting to handle bie data resource ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dr})));
                if (this.biocacheResources$1.contains((Object)dr)) {
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Warning the collectory already contains a Record resource for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dr})));
                }
                if (this.dataResources$1.contains((Object)dr)) {
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Warning the biocache already contains a Record resource for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dr})));
                    arrayBuffer = this.buf$1.$plus$eq((Object)dr);
                } else {
                    String fileUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://www2.ala.org.au/datasets/occurrence/bie/", "/", ".csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dr, dr}));
                    HttpURLConnection connection = (HttpURLConnection)new URL(fileUrl).openConnection();
                    connection.setRequestMethod("HEAD");
                    if (connection.getResponseCode() == 200) {
                        Predef$.MODULE$.println((Object)"We have a source CSV file we can continue");
                        BieCsvLoader$.MODULE$.updateCollectoryForLoad(dr, fileUrl);
                        Store$.MODULE$.ingest((String[])((Object[])new String[]{dr}), Store$.MODULE$.ingest$default$2());
                        arrayBuffer = BoxedUnit.UNIT;
                    } else {
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There is no source file for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dr})));
                        arrayBuffer = this.buf$1.$plus$eq((Object)dr);
                    }
                }
                return arrayBuffer;
            }
            {
                this.buf$1 = buf$1;
                this.biocacheResources$1 = biocacheResources$1;
                this.dataResources$1 = dataResources$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Warning unable to load ").append((Object)buf.toList()).append((Object)" resources").toString());
        Config$.MODULE$.persistenceManager().shutdown();
        Config$.MODULE$.indexDAO().shutdown();
    }

    public boolean updateCollectoryForLoad(String resourceUid, String fileUrl) {
        boolean bl;
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            Tuple2 tuple2;
            HashMap map = new HashMap();
            Map connectParams = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"protocol"), (Object)"DwC"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"csv_text_enclosure"), (Object)"\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"termsForUniqueKey"), (Object)new String[]{"occurrenceID"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"csv_eol"), (Object)"\n"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"csv_delimiter"), (Object)","), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"csv_escape_char"), (Object)"\\"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"url"), (Object)fileUrl)}));
            Map defaultDwcValues = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"basisOfRecord"), (Object)"Image")}));
            map.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"user"), (Object)Config$.MODULE$.getProperty("registry.username")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"api_key"), (Object)Config$.MODULE$.getProperty("registry.apikey")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"resourceType"), (Object)"records"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"connectionParameters"), (Object)connectParams), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"defaultDarwinCoreValues"), (Object)defaultDwcValues)})));
            String data = mapper.writeValueAsString((Object)map);
            Predef$.MODULE$.println((Object)data);
            Tuple2<Object, String> tuple22 = HttpUtil$.MODULE$.postBody(new StringBuilder().append((Object)Config$.MODULE$.registryUrl()).append((Object)"/dataResource/").append((Object)resourceUid).toString(), "application/json", data);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            int responseCode = tuple22._1$mcI$sp();
            String respBody = (String)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)responseCode), (Object)respBody);
            int responseCode2 = tuple23._1$mcI$sp();
            String respBody2 = (String)tuple23._2();
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Data resource ").append((Object)resourceUid).append((Object)" ").append((Object)BoxesRunTime.boxToInteger((int)responseCode2)).toString());
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private BieCsvLoader$() {
        MODULE$ = this;
        this.bieDrString = "dr396,dr414,dr429,dr449,dr462,dr572,dr382,dr399,dr415,dr430,dr450,dr463,dr613,dr384,dr401,dr416,dr431,dr451,dr585,dr627,dr385,dr402,dr417,dr432,dr452,dr469,dr660,dr386,dr403,dr418,dr453,dr521,dr665,dr387,dr405,dr419,dr455,dr524,dr674,dr388,dr406,dr421,dr443,dr457,dr526,dr389,dr408,dr422,dr458,dr532,dr390,dr410,dr427,dr447,dr459,dr534,dr394,dr413,dr428,dr448,dr461,dr545,dr440";
    }
}

