/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.index;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.index.Counter;
import au.org.ala.biocache.index.IndexRunner$;
import au.org.ala.biocache.index.SolrIndexDAO;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function2;
import scala.Option;
import scala.Serializable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0001\u001b\tY\u0011J\u001c3fqJ+hN\\3s\u0015\t\u0019A!A\u0003j]\u0012,\u0007P\u0003\u0002\u0006\r\u0005A!-[8dC\u000eDWM\u0003\u0002\b\u0011\u0005\u0019\u0011\r\\1\u000b\u0005%Q\u0011aA8sO*\t1\"\u0001\u0002bk\u000e\u00011c\u0001\u0001\u000f-A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u0010/%\u0011\u0001\u0004\u0005\u0002\t%Vtg.\u00192mK\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\bdK:$(/\u00197D_VtG/\u001a:\u0011\u0005qiR\"\u0001\u0002\n\u0005y\u0011!aB\"pk:$XM\u001d\u0005\tA\u0001\u0011\t\u0011)A\u0005C\u0005AA\u000f\u001b:fC\u0012LE\r\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13EA\u0002J]RD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\tgR\f'\u000f^&fsB\u0011!&\f\b\u0003E-J!\u0001L\u0012\u0002\rA\u0013X\rZ3g\u0013\tqsF\u0001\u0004TiJLgn\u001a\u0006\u0003Y\rB\u0001\"\r\u0001\u0003\u0002\u0003\u0006I!K\u0001\u0007K:$7*Z=\t\u0011M\u0002!\u0011!Q\u0001\n%\n\u0011c]8ve\u000e,7i\u001c8g\t&\u0014\b+\u0019;i\u0011!)\u0004A!A!\u0002\u0013I\u0013!\u0005;be\u001e,GoQ8oM\u0012K'\u000fU1uQ\"Aq\u0007\u0001B\u0001B\u0003%\u0011%\u0001\u0005qC\u001e,7+\u001b>f\u0011\u0015I\u0004\u0001\"\u0001;\u0003\u0019a\u0014N\\5u}QA1\bP\u001f?\u007f\u0001\u000b%\t\u0005\u0002\u001d\u0001!)!\u0004\u000fa\u00017!)\u0001\u0005\u000fa\u0001C!)\u0001\u0006\u000fa\u0001S!)\u0011\u0007\u000fa\u0001S!)1\u0007\u000fa\u0001S!)Q\u0007\u000fa\u0001S!9q\u0007\u000fI\u0001\u0002\u0004\t\u0003b\u0002#\u0001\u0005\u0004%\t!R\u0001\u0007Y><w-\u001a:\u0016\u0003\u0019\u0003\"aR&\u000e\u0003!S!!\u0013&\u0002\u000bMdg\r\u000e6\u000b\u0003%I!\u0001\u0014%\u0003\r1{wmZ3s\u0011\u0019q\u0005\u0001)A\u0005\r\u00069An\\4hKJ\u0004\u0003\"\u0002)\u0001\t\u0003\t\u0016a\u0001:v]R\t!\u000b\u0005\u0002#'&\u0011Ak\t\u0002\u0005+:LGoB\u0004W\u0005\u0005\u0005\t\u0012A,\u0002\u0017%sG-\u001a=Sk:tWM\u001d\t\u00039a3q!\u0001\u0002\u0002\u0002#\u0005\u0011l\u0005\u0002Y5B\u0011!eW\u0005\u00039\u000e\u0012a!\u00118z%\u00164\u0007\"B\u001dY\t\u0003qF#A,\t\u000f\u0001D\u0016\u0013!C\u0001C\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\u0012A\u0019\u0016\u0003C\r\\\u0013\u0001\u001a\t\u0003K*l\u0011A\u001a\u0006\u0003O\"\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005%\u001c\u0013AC1o]>$\u0018\r^5p]&\u00111N\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class IndexRunner
implements Runnable {
    public final Counter au$org$ala$biocache$index$IndexRunner$$centralCounter;
    public final int au$org$ala$biocache$index$IndexRunner$$threadId;
    public final String au$org$ala$biocache$index$IndexRunner$$startKey;
    private final String endKey;
    private final String sourceConfDirPath;
    private final String targetConfDirPath;
    public final int au$org$ala$biocache$index$IndexRunner$$pageSize;
    private final Logger logger;

    public static int $lessinit$greater$default$7() {
        return IndexRunner$.MODULE$.$lessinit$greater$default$7();
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public void run() {
        ObjectRef csvFileWriter;
        File newIndexDir = new File(this.targetConfDirPath);
        if (newIndexDir.exists()) {
            FileUtils.deleteDirectory((File)newIndexDir);
        }
        FileUtils.forceMkdir((File)newIndexDir);
        File sourceConfDir = new File(this.sourceConfDirPath);
        FileUtils.copyDirectory((File)sourceConfDir, (File)newIndexDir);
        FileUtils.copyFileToDirectory((File)new File(new StringBuilder().append((Object)sourceConfDir.getParent()).append((Object)"/solr.xml").toString()), (File)newIndexDir.getParentFile());
        this.logger().info(new StringBuilder().append((Object)"Set SOLR Home: ").append((Object)newIndexDir.getParent()).toString());
        SolrIndexDAO indexer = new SolrIndexDAO(newIndexDir.getParent(), Config$.MODULE$.excludeSensitiveValuesFor(), Config$.MODULE$.extraMiscFields());
        indexer.solrConfigPath_$eq(new StringBuilder().append((Object)newIndexDir.getAbsolutePath()).append((Object)"/solrconfig.xml").toString());
        IntRef counter = new IntRef(0);
        long start = System.currentTimeMillis();
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        BooleanRef check = new BooleanRef(true);
        ObjectRef objectRef = Config$.MODULE$.exportIndexAsCsvPath().length() > 0 ? new ObjectRef((Object)indexer.getCsvWriter(indexer.getCsvWriter$default$1())) : (csvFileWriter = new ObjectRef(null));
        ObjectRef csvFileWriterSensitive = Config$.MODULE$.exportIndexAsCsvPath().length() > 0 ? new ObjectRef((Object)indexer.getCsvWriter(true)) : new ObjectRef(null);
        Config$.MODULE$.persistenceManager().pageOverAll("occ", (Function2<String, scala.collection.immutable.Map<String, String>, Object>)new Serializable(this, indexer, counter, startTime, finishTime, check, csvFileWriter, csvFileWriterSensitive){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexRunner $outer;
            private final SolrIndexDAO indexer$1;
            private final IntRef counter$7;
            private final LongRef startTime$6;
            private final LongRef finishTime$6;
            private final BooleanRef check$1;
            private final ObjectRef csvFileWriter$1;
            private final ObjectRef csvFileWriterSensitive$1;

            public final boolean apply(String guid, scala.collection.immutable.Map<String, String> map) {
                ++this.counter$7.elem;
                boolean commit = this.counter$7.elem % 10000 == 0;
                try {
                    if (this.check$1.elem) {
                        this.check$1.elem = false;
                        if (!guid.equals(this.$outer.au$org$ala$biocache$index$IndexRunner$$startKey)) {
                            String x$8 = guid;
                            scala.collection.immutable.Map<String, String> x$9 = map;
                            boolean x$10 = commit;
                            String x$11 = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.au$org$ala$biocache$index$IndexRunner$$threadId)).toString();
                            FileWriter x$12 = (FileWriter)this.csvFileWriter$1.elem;
                            FileWriter x$13 = (FileWriter)this.csvFileWriterSensitive$1.elem;
                            boolean x$14 = this.indexer$1.indexFromMap$default$3();
                            Option<Date> x$15 = this.indexer$1.indexFromMap$default$4();
                            Seq<String> x$16 = this.indexer$1.indexFromMap$default$6();
                            boolean x$17 = this.indexer$1.indexFromMap$default$7();
                            this.indexer$1.indexFromMap(x$8, (Map<String, String>)x$9, x$14, x$15, x$10, x$16, x$17, x$11, x$12, x$13);
                        }
                    } else {
                        String x$18 = guid;
                        scala.collection.immutable.Map<String, String> x$19 = map;
                        boolean x$20 = commit;
                        String x$21 = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.au$org$ala$biocache$index$IndexRunner$$threadId)).toString();
                        FileWriter x$22 = (FileWriter)this.csvFileWriter$1.elem;
                        FileWriter x$23 = (FileWriter)this.csvFileWriterSensitive$1.elem;
                        boolean x$24 = this.indexer$1.indexFromMap$default$3();
                        Option<Date> x$25 = this.indexer$1.indexFromMap$default$4();
                        Seq<String> x$26 = this.indexer$1.indexFromMap$default$6();
                        boolean x$27 = this.indexer$1.indexFromMap$default$7();
                        this.indexer$1.indexFromMap(x$18, (Map<String, String>)x$19, x$24, x$25, x$20, x$26, x$27, x$21, x$22, x$23);
                    }
                }
                catch (Exception exception) {
                    this.$outer.logger().error(new StringBuilder().append((Object)"Problem indexing record: ").append((Object)guid).append((Object)"").append((Object)exception.getMessage()).toString());
                }
                if (this.counter$7.elem % this.$outer.au$org$ala$biocache$index$IndexRunner$$pageSize == 0 && this.counter$7.elem > 0) {
                    this.$outer.au$org$ala$biocache$index$IndexRunner$$centralCounter.addToCounter(this.$outer.au$org$ala$biocache$index$IndexRunner$$pageSize);
                    this.finishTime$6.elem = System.currentTimeMillis();
                    this.$outer.au$org$ala$biocache$index$IndexRunner$$centralCounter.printOutStatus(this.$outer.au$org$ala$biocache$index$IndexRunner$$threadId, guid, "Indexer");
                    this.startTime$6.elem = System.currentTimeMillis();
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.indexer$1 = indexer$1;
                this.counter$7 = counter$7;
                this.startTime$6 = startTime$6;
                this.finishTime$6 = finishTime$6;
                this.check$1 = check$1;
                this.csvFileWriter$1 = csvFileWriter$1;
                this.csvFileWriterSensitive$1 = csvFileWriterSensitive$1;
            }
        }, this.au$org$ala$biocache$index$IndexRunner$$startKey, this.endKey, this.au$org$ala$biocache$index$IndexRunner$$pageSize);
        indexer.finaliseIndex(true, true);
        if ((FileWriter)csvFileWriter.elem != null) {
            ((FileWriter)csvFileWriter.elem).flush();
            ((FileWriter)csvFileWriter.elem).close();
        }
        if ((FileWriter)csvFileWriterSensitive.elem != null) {
            ((FileWriter)csvFileWriterSensitive.elem).flush();
            ((FileWriter)csvFileWriterSensitive.elem).close();
        }
        finishTime.elem = System.currentTimeMillis();
        this.logger().info(new StringBuilder().append((Object)"Total indexing time for this thread ").append((Object)BoxesRunTime.boxToFloat((float)((float)(finishTime.elem - start) / 60000.0f))).append((Object)" minutes.").toString());
    }

    public IndexRunner(Counter centralCounter, int threadId, String startKey, String endKey, String sourceConfDirPath, String targetConfDirPath, int pageSize) {
        this.au$org$ala$biocache$index$IndexRunner$$centralCounter = centralCounter;
        this.au$org$ala$biocache$index$IndexRunner$$threadId = threadId;
        this.au$org$ala$biocache$index$IndexRunner$$startKey = startKey;
        this.endKey = endKey;
        this.sourceConfDirPath = sourceConfDirPath;
        this.targetConfDirPath = targetConfDirPath;
        this.au$org$ala$biocache$index$IndexRunner$$pageSize = pageSize;
        this.logger = LoggerFactory.getLogger((String)"IndexRunner");
    }
}

