/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache;

import au.org.ala.biocache.dao.DeletedRecordDAO;
import au.org.ala.biocache.dao.DeletedRecordDAOImpl;
import au.org.ala.biocache.dao.DuplicateDAO;
import au.org.ala.biocache.dao.DuplicateDAOImpl;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.dao.OccurrenceDAOImpl;
import au.org.ala.biocache.dao.OutlierStatsDAO;
import au.org.ala.biocache.dao.OutlierStatsDAOImpl;
import au.org.ala.biocache.dao.QidDAO;
import au.org.ala.biocache.dao.QidDAOImpl;
import au.org.ala.biocache.dao.ValidationRuleDAO;
import au.org.ala.biocache.dao.ValidationRuleDAOImpl;
import au.org.ala.biocache.index.IndexDAO;
import au.org.ala.biocache.index.SolrIndexDAO;
import au.org.ala.biocache.persistence.CassandraPersistenceManager;
import au.org.ala.biocache.persistence.MockPersistenceManager;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.persistence.PostgresPersistenceManager;
import au.org.ala.names.search.ALANameSearcher;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001u2A!\u0001\u0002\u0005\u0017\ta1i\u001c8gS\u001elu\u000eZ;mK*\u00111\u0001B\u0001\tE&|7-Y2iK*\u0011QAB\u0001\u0004C2\f'BA\u0004\t\u0003\ry'o\u001a\u0006\u0002\u0013\u0005\u0011\u0011-^\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e)5\taB\u0003\u0002\u0010!\u00051\u0011N\u001c6fGRT!!\u0005\n\u0002\r\u001d|wn\u001a7f\u0015\u0005\u0019\u0012aA2p[&\u0011QC\u0004\u0002\u000f\u0003\n\u001cHO]1di6{G-\u001e7f\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t!\u0001C\u0004\u001d\u0001\t\u0007I\u0011C\u000f\u0002\r1|wmZ3s+\u0005q\u0002CA\u0010$\u001b\u0005\u0001#BA\u0011#\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00059\u0011B\u0001\u0013!\u0005\u0019aunZ4fe\"1a\u0005\u0001Q\u0001\ny\tq\u0001\\8hO\u0016\u0014\b\u0005C\u0004)\u0001\t\u0007I\u0011A\u0015\u0002\u0015A\u0014x\u000e]3si&,7/F\u0001+!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0003vi&d'\"A\u0018\u0002\t)\fg/Y\u0005\u0003c1\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019\u0019\u0004\u0001)A\u0005U\u0005Y\u0001O]8qKJ$\u0018.Z:!\u0011\u0015)\u0004\u0001\"\u00117\u0003%\u0019wN\u001c4jOV\u0014X\rF\u00018!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0011)f.\u001b;")
public class ConfigModule
extends AbstractModule {
    private final Logger logger = LoggerFactory.getLogger((String)"ConfigModule");
    private final Properties properties;

    public Logger logger() {
        return this.logger;
    }

    public Properties properties() {
        return this.properties;
    }

    public void configure() {
        block7: {
            block5: {
                String string;
                block6: {
                    block4: {
                        Names.bindProperties((Binder)this.binder(), (Properties)this.properties());
                        this.bind(OccurrenceDAO.class).to(OccurrenceDAOImpl.class).in(Scopes.SINGLETON);
                        this.bind(OutlierStatsDAO.class).to(OutlierStatsDAOImpl.class).in(Scopes.SINGLETON);
                        this.logger().debug("Initialising SOLR");
                        this.bind(IndexDAO.class).to(SolrIndexDAO.class).in(Scopes.SINGLETON);
                        this.bind(DeletedRecordDAO.class).to(DeletedRecordDAOImpl.class).in(Scopes.SINGLETON);
                        this.bind(DuplicateDAO.class).to(DuplicateDAOImpl.class).in(Scopes.SINGLETON);
                        this.bind(ValidationRuleDAO.class).to(ValidationRuleDAOImpl.class).in(Scopes.SINGLETON);
                        this.bind(QidDAO.class).to(QidDAOImpl.class).in(Scopes.SINGLETON);
                        this.logger().debug("Initialising name matching indexes");
                        try {
                            String nameIndexLocation = this.properties().getProperty("name.index.dir");
                            this.logger().debug(new StringBuilder().append((Object)"Loading name index from ").append((Object)nameIndexLocation).toString());
                            ALANameSearcher nameIndex = new ALANameSearcher(nameIndexLocation);
                            this.bind(ALANameSearcher.class).toInstance((Object)nameIndex);
                        }
                        catch (Exception exception) {
                            this.logger().warn(new StringBuilder().append((Object)"Lucene indexes are not currently available. Please check 'name.index.dir' property in config. Message: ").append((Object)exception.getMessage()).toString());
                        }
                        this.logger().debug("Initialising persistence manager");
                        String string2 = string = this.properties().getProperty("db");
                        if ("mock" != null ? !"mock".equals(string2) : string2 != null) break block4;
                        this.bind(PersistenceManager.class).to(MockPersistenceManager.class).in(Scopes.SINGLETON);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block5;
                    }
                    String string3 = string;
                    if ("postgres" != null ? !"postgres".equals(string3) : string3 != null) break block6;
                    this.bind(PersistenceManager.class).to(PostgresPersistenceManager.class).in(Scopes.SINGLETON);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                String string4 = string;
                if ("cassandra" != null ? !"cassandra".equals(string4) : string4 != null) break block7;
                this.bind(PersistenceManager.class).to(CassandraPersistenceManager.class).in(Scopes.SINGLETON);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            this.logger().debug("Configure complete");
            return;
        }
        throw new RuntimeException("Persistence manager typ unrecognised. Please check your external config file. ");
    }

    /*
     * WARNING - void declaration
     */
    public ConfigModule() {
        void var1_1;
        InputStream stream;
        Properties properties = new Properties();
        String filename = System.getProperty("biocache.config", "/data/biocache/config/biocache-config.properties");
        this.logger().info(new StringBuilder().append((Object)"Using config file: ").append((Object)filename).toString());
        File file = new File(filename);
        InputStream inputStream = stream = file.exists() ? new FileInputStream(file) : ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        if (stream == null) {
            throw new RuntimeException("Configuration file not found. Please add to classpath or /data/biocache/config/biocache-test-config.properties");
        }
        this.logger().debug(new StringBuilder().append((Object)"Loading configuration from ").append((Object)filename).toString());
        properties.load(stream);
        this.properties = var1_1;
    }
}

