/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.ConfigModule;
import au.org.ala.biocache.dao.DeletedRecordDAO;
import au.org.ala.biocache.dao.DuplicateDAO;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.dao.OutlierStatsDAO;
import au.org.ala.biocache.dao.ValidationRuleDAO;
import au.org.ala.biocache.index.IndexDAO;
import au.org.ala.biocache.load.LocalMediaStore$;
import au.org.ala.biocache.load.MediaStore;
import au.org.ala.biocache.load.RemoteMediaStore$;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.util.LayersStore;
import au.org.ala.names.search.ALANameSearcher;
import au.org.ala.sds.SensitiveSpeciesFinder;
import au.org.ala.sds.SensitiveSpeciesFinderFactory;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;

public final class Config$ {
    public static final Config$ MODULE$;
    private final Logger logger;
    private final ConfigModule au$org$ala$biocache$Config$$configModule;
    private Injector inj;
    private final PersistenceManager persistenceManager;
    private final OccurrenceDAO occurrenceDAO;
    private final OutlierStatsDAO outlierStatsDAO;
    private final DeletedRecordDAO deletedRecordDAO;
    private final DuplicateDAO duplicateDAO;
    private final ValidationRuleDAO validationRuleDAO;
    private final IndexDAO indexDAO;
    private final MediaStore mediaStore;
    private final String remoteMediaStoreUrl;
    private final ALANameSearcher nameIndex;
    private SensitiveSpeciesFinder sdsFinder;
    private final boolean allowLayerLookup;
    private final boolean hashImageFileNames;
    private final int solrUpdateThreads;
    private final String volunteerHubUid;
    private final String collectoryApiKey;
    private final String loadFileStore;
    private final String vocabDirectory;
    private final String deletedFileStore;
    private final String mediaFileStore;
    private final String mediaBaseUrl;
    private final String excludeSensitiveValuesFor;
    private final String allowCollectoryUpdates;
    private final String extraMiscFields;
    private final String technicalContact;
    private final boolean obeySDSIsLoadable;
    private final List<String> blacklistedMediaUrls;
    private final String speciesSubgroupsUrl;
    private final String listToolUrl;
    private final String volunteerUrl;
    private final String tmpWorkDir;
    private final String registryUrl;
    private String flickrUsersUrl;
    private String reindexUrl;
    private String reindexData;
    private String reindexViewDataResourceUrl;
    private String layersServiceUrl;
    private String layersServiceSampling;
    private String biocacheServiceUrl;
    private final String stateProvinceLayerID;
    private final String terrestrialBioRegionsLayerID;
    private final String marineBioRegionsLayerID;
    private final String countriesLayerID;
    private final String localGovLayerID;
    private final String defaultCountry;
    private final Properties versionProperties;
    private final List<String> additionalFieldsToIndex;
    private final String exportIndexAsCsvPath;
    private final String exportIndexAsCsvPathSensitive;
    private volatile byte bitmap$0;

    static {
        new Config$();
    }

    private SensitiveSpeciesFinder sdsFinder$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String sdsUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("sds.url", "http://sds.ala.org.au/sensitive-species-data.xml");
                this.sdsFinder = SensitiveSpeciesFinderFactory.getSensitiveSpeciesFinder((String)sdsUrl, (ALANameSearcher)this.nameIndex());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.sdsFinder;
        }
    }

    private String flickrUsersUrl$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.flickrUsersUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("flickr.users.url", "http://auth.ala.org.au/userdetails/external/flickr");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.flickrUsersUrl;
        }
    }

    private String reindexUrl$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.reindexUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("reindex.url");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.reindexUrl;
        }
    }

    private String reindexData$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.reindexData = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("reindex.data");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.reindexData;
        }
    }

    private String reindexViewDataResourceUrl$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.reindexViewDataResourceUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("reindex.data.resource.url");
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.reindexViewDataResourceUrl;
        }
    }

    private String layersServiceUrl$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.layersServiceUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layers.service.url");
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            return this.layersServiceUrl;
        }
    }

    private String layersServiceSampling$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.layersServiceSampling = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layers.service.sampling", "true");
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
            return this.layersServiceSampling;
        }
    }

    private String biocacheServiceUrl$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                this.biocacheServiceUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("webservices.root", "http://biocache.ala.org.au/ws");
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
            }
            return this.biocacheServiceUrl;
        }
    }

    public Logger logger() {
        return this.logger;
    }

    public ConfigModule au$org$ala$biocache$Config$$configModule() {
        return this.au$org$ala$biocache$Config$$configModule;
    }

    public Injector inj() {
        return this.inj;
    }

    public void inj_$eq(Injector x$1) {
        this.inj = x$1;
    }

    public Object getInstance(Class<?> classs) {
        return this.inj().getInstance(classs);
    }

    public PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    public OccurrenceDAO occurrenceDAO() {
        return this.occurrenceDAO;
    }

    public OutlierStatsDAO outlierStatsDAO() {
        return this.outlierStatsDAO;
    }

    public DeletedRecordDAO deletedRecordDAO() {
        return this.deletedRecordDAO;
    }

    public DuplicateDAO duplicateDAO() {
        return this.duplicateDAO;
    }

    public ValidationRuleDAO validationRuleDAO() {
        return this.validationRuleDAO;
    }

    public IndexDAO indexDAO() {
        return this.indexDAO;
    }

    public MediaStore mediaStore() {
        return this.mediaStore;
    }

    public String remoteMediaStoreUrl() {
        return this.remoteMediaStoreUrl;
    }

    public ALANameSearcher nameIndex() {
        return this.nameIndex;
    }

    public SensitiveSpeciesFinder sdsFinder() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sdsFinder$lzycompute() : this.sdsFinder;
    }

    public boolean allowLayerLookup() {
        return this.allowLayerLookup;
    }

    public boolean hashImageFileNames() {
        return this.hashImageFileNames;
    }

    public int solrUpdateThreads() {
        return this.solrUpdateThreads;
    }

    public String volunteerHubUid() {
        return this.volunteerHubUid;
    }

    public String collectoryApiKey() {
        return this.collectoryApiKey;
    }

    public String loadFileStore() {
        return this.loadFileStore;
    }

    public String vocabDirectory() {
        return this.vocabDirectory;
    }

    public String deletedFileStore() {
        return this.deletedFileStore;
    }

    public String mediaFileStore() {
        return this.mediaFileStore;
    }

    public String mediaBaseUrl() {
        return this.mediaBaseUrl;
    }

    public String excludeSensitiveValuesFor() {
        return this.excludeSensitiveValuesFor;
    }

    public String allowCollectoryUpdates() {
        return this.allowCollectoryUpdates;
    }

    public String extraMiscFields() {
        return this.extraMiscFields;
    }

    public String technicalContact() {
        return this.technicalContact;
    }

    public boolean obeySDSIsLoadable() {
        return this.obeySDSIsLoadable;
    }

    public String[] fieldsToSample() {
        String[] stringArray;
        block8: {
            String[] fields;
            ArrayList<Object> arrayList;
            String defaultFields;
            String str;
            block7: {
                block6: {
                    str = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("sample.fields");
                    defaultFields = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("default.sample.fields", "");
                    if (str == null) break block6;
                    String string = str.trim();
                    String string2 = "";
                    if (string != null ? !string.equals(string2) : string2 != null) break block7;
                }
                try {
                    arrayList = new LayersStore(this.layersServiceUrl()).getFieldIds();
                }
                catch (Exception exception) {
                    arrayList = new ArrayList();
                }
            }
            String string = str;
            String string3 = "none";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
            } else {
                String[] fields2 = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])str.split(",")).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x) {
                        return x.trim();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class));
                this.logger().info(new StringBuilder().append((Object)"Fields to sample: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])fields2).mkString(",")).toString());
                stringArray = fields2;
            }
            break block8;
            ArrayList<Object> dbfields = arrayList;
            String[] stringArray2 = fields = dbfields.size() > 0 ? (String[])Array$.MODULE$.ofDim(dbfields.size(), ClassTag$.MODULE$.apply(String.class)) : (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])defaultFields.split(",")).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x) {
                    return x.trim();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class));
            if (!dbfields.isEmpty()) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), dbfields.size()).foreach$mVc$sp((Function1)new Serializable(dbfields, fields){
                    public static final long serialVersionUID = 0L;
                    private final ArrayList dbfields$1;
                    private final String[] fields$1;

                    public final void apply(int a) {
                        this.apply$mcVI$sp(a);
                    }

                    public void apply$mcVI$sp(int a) {
                        this.fields$1[a] = (String)this.dbfields$1.get(a);
                    }
                    {
                        this.dbfields$1 = dbfields$1;
                        this.fields$1 = fields$1;
                    }
                });
            }
            this.logger().info(new StringBuilder().append((Object)"Fields to sample: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])fields).mkString(",")).toString());
            stringArray = fields;
        }
        return stringArray;
    }

    public List<String> blacklistedMediaUrls() {
        return this.blacklistedMediaUrls;
    }

    public String speciesSubgroupsUrl() {
        return this.speciesSubgroupsUrl;
    }

    public String listToolUrl() {
        return this.listToolUrl;
    }

    public String volunteerUrl() {
        return this.volunteerUrl;
    }

    public String tmpWorkDir() {
        return this.tmpWorkDir;
    }

    public String registryUrl() {
        return this.registryUrl;
    }

    public String flickrUsersUrl() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.flickrUsersUrl$lzycompute() : this.flickrUsersUrl;
    }

    public String reindexUrl() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.reindexUrl$lzycompute() : this.reindexUrl;
    }

    public String reindexData() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.reindexData$lzycompute() : this.reindexData;
    }

    public String reindexViewDataResourceUrl() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.reindexViewDataResourceUrl$lzycompute() : this.reindexViewDataResourceUrl;
    }

    public String layersServiceUrl() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.layersServiceUrl$lzycompute() : this.layersServiceUrl;
    }

    public String layersServiceSampling() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.layersServiceSampling$lzycompute() : this.layersServiceSampling;
    }

    public String biocacheServiceUrl() {
        return (byte)(this.bitmap$0 & 0x80) == 0 ? this.biocacheServiceUrl$lzycompute() : this.biocacheServiceUrl;
    }

    public String getProperty(String prop) {
        return this.au$org$ala$biocache$Config$$configModule().properties().getProperty(prop);
    }

    public String getProperty(String prop, String string) {
        return this.au$org$ala$biocache$Config$$configModule().properties().getProperty(prop, string);
    }

    public void outputConfig() {
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(this.au$org$ala$biocache$Config$$configModule().properties().stringPropertyNames().toArray()).sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object x$2, Object x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2.toString())).$less((Object)x$3.toString());
            }
        })).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object name) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)name.toString()).append((Object)" = ").append((Object)Config$.MODULE$.au$org$ala$biocache$Config$$configModule().properties().getProperty(name.toString(), "NOT DEFINED")).toString());
            }
        });
    }

    public String stateProvinceLayerID() {
        return this.stateProvinceLayerID;
    }

    public String terrestrialBioRegionsLayerID() {
        return this.terrestrialBioRegionsLayerID;
    }

    public String marineBioRegionsLayerID() {
        return this.marineBioRegionsLayerID;
    }

    public String countriesLayerID() {
        return this.countriesLayerID;
    }

    public String localGovLayerID() {
        return this.localGovLayerID;
    }

    public String defaultCountry() {
        return this.defaultCountry;
    }

    public Properties versionProperties() {
        return this.versionProperties;
    }

    public List<String> additionalFieldsToIndex() {
        return this.additionalFieldsToIndex;
    }

    public String exportIndexAsCsvPath() {
        return this.exportIndexAsCsvPath;
    }

    public String exportIndexAsCsvPathSensitive() {
        return this.exportIndexAsCsvPathSensitive;
    }

    private final void liftedTree1$1(Properties properties$1, Enumeration resources$1) {
        try {
            URL url = (URL)resources$1.nextElement();
            Manifest manifest = new Manifest(url.openStream());
            Object title = manifest.getMainAttributes().get(new Attributes.Name("Implementation-Title"));
            if ("Biocache".equals(title)) {
                Attributes entries = manifest.getMainAttributes();
                JavaConversions$.MODULE$.asScalaSet(entries.entrySet()).foreach((Function1)new Serializable(properties$1){
                    public static final long serialVersionUID = 0L;
                    private final Properties properties$1;

                    public final Object apply(Map.Entry<Object, Object> entry) {
                        return this.properties$1.put(entry.getKey().toString(), entry.getValue().toString());
                    }
                    {
                        this.properties$1 = properties$1;
                    }
                });
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Config$() {
        List list;
        MediaStore mediaStore;
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"Config");
        this.au$org$ala$biocache$Config$$configModule = new ConfigModule();
        this.inj = Guice.createInjector((Module[])new Module[]{this.au$org$ala$biocache$Config$$configModule()});
        this.persistenceManager = (PersistenceManager)this.getInstance(PersistenceManager.class);
        this.occurrenceDAO = (OccurrenceDAO)this.getInstance(OccurrenceDAO.class);
        this.outlierStatsDAO = (OutlierStatsDAO)this.getInstance(OutlierStatsDAO.class);
        this.deletedRecordDAO = (DeletedRecordDAO)this.getInstance(DeletedRecordDAO.class);
        this.duplicateDAO = (DuplicateDAO)this.getInstance(DuplicateDAO.class);
        this.validationRuleDAO = (ValidationRuleDAO)this.getInstance(ValidationRuleDAO.class);
        this.indexDAO = (IndexDAO)this.getInstance(IndexDAO.class);
        String str = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("media.store.local", "true");
        if (new StringOps(Predef$.MODULE$.augmentString(str)).toBoolean()) {
            this.logger().debug("Using local media store");
            mediaStore = LocalMediaStore$.MODULE$;
        } else {
            this.logger().debug("Using remote media store");
            mediaStore = RemoteMediaStore$.MODULE$;
        }
        this.mediaStore = mediaStore;
        this.remoteMediaStoreUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("media.store.url", "http://10.1.1.2/images");
        this.nameIndex = (ALANameSearcher)this.getInstance(ALANameSearcher.class);
        String str2 = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("allow.layer.lookup");
        this.allowLayerLookup = str2 == null ? false : new StringOps(Predef$.MODULE$.augmentString(str2)).toBoolean();
        this.hashImageFileNames = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("hash.image.filenames", "false"))).toBoolean();
        this.solrUpdateThreads = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.update.threads", "4"))).toInt();
        this.volunteerHubUid = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("volunteer.hub.uid", "");
        this.collectoryApiKey = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("registry.api.key", "xxxxxxxxxxxxxxxxx");
        this.loadFileStore = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("load.dir", "/data/biocache-load/");
        this.vocabDirectory = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("vocab.dir", "/data/biocache/vocab/");
        this.deletedFileStore = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("deleted.file.store", "/data/biocache-delete/");
        this.mediaFileStore = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("media.dir", "/data/biocache-media/");
        this.mediaBaseUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("media.url", "http://biocache.ala.org.au/biocache-media");
        this.excludeSensitiveValuesFor = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("exclude.sensitive.values", "");
        this.allowCollectoryUpdates = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("allow.registry.updates", "false");
        this.extraMiscFields = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("extra.misc.fields", "");
        this.technicalContact = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("technical.contact", "support@ala.org.au");
        this.obeySDSIsLoadable = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("obey.sds.is.loadable", "true"))).toBoolean();
        String blacklistMediaUrlsFile = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("blacklist.media.file", "/data/biocache/config/blacklistMediaUrls.txt");
        if (new File(blacklistMediaUrlsFile).exists()) {
            this.logger().info(new StringBuilder().append((Object)"Using the set of blacklisted media URLs defined in: ").append((Object)blacklistMediaUrlsFile).toString());
            list = Source$.MODULE$.fromFile(new File(blacklistMediaUrlsFile), Codec$.MODULE$.fallbackSystemCodec()).getLines().map((Function1)new anonfun.3()).toList();
        } else {
            this.logger().info("Using the default set of blacklisted media URLs");
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://www.inaturalist.org/photos/", "http://www.flickr.com/photos/", "http://www.facebook.com/photo.php", "https://picasaweb.google.com"}));
        }
        this.blacklistedMediaUrls = list;
        this.speciesSubgroupsUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("species.subgroups.url", "http://bie.ala.org.au/subgroups.json");
        this.listToolUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("list.tool.url", "http://lists.ala.org.au/ws");
        this.volunteerUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("volunteer.url", "http://volunteer.ala.org.au");
        this.tmpWorkDir = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("tmp.work.dir", "/tmp");
        this.registryUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("registry.url", "http://collections.ala.org.au/ws");
        this.stateProvinceLayerID = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layer.state.province", "cl927");
        this.terrestrialBioRegionsLayerID = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layer.bio.regions.terrestrial", "cl1048");
        this.marineBioRegionsLayerID = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layer.bio.regions.marine", "cl21");
        this.countriesLayerID = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layer.countries", "cl932");
        this.localGovLayerID = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layer.localgov", "cl959");
        this.defaultCountry = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("default.country", "Australia");
        Properties properties = new Properties();
        Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            this.liftedTree1$1(properties, resources);
        }
        this.versionProperties = properties;
        List list2 = Predef$.MODULE$.refArrayOps((Object[])this.au$org$ala$biocache$Config$$configModule().properties().getProperty("additional.fields.to.index", "").split(",")).toList();
        if (list2.length() == 1 && ((String)list2.apply(0)).length() == 0) {
            list2 = Nil$.MODULE$;
        }
        this.additionalFieldsToIndex = list2;
        this.exportIndexAsCsvPath = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("export.index.as.csv.path", "");
        this.exportIndexAsCsvPathSensitive = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("export.index.as.csv.path.sensitive", "");
    }
}

