/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.vocab;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.model.Classification;
import au.org.ala.biocache.util.ReflectBean$;
import au.org.ala.biocache.vocab.SpeciesGroup;
import au.org.ala.biocache.vocab.SpeciesGroups$;
import au.org.ala.names.model.NameSearchResult;
import au.org.ala.names.model.RankType;
import au.org.ala.names.search.HomonymException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.parsing.json.JSON$;

public final class SpeciesGroups$ {
    public static final SpeciesGroups$ MODULE$;
    private final Logger logger;
    private final List<SpeciesGroup> groups;
    private final List<SpeciesGroup> subgroups;

    static {
        new SpeciesGroups$();
    }

    public Logger logger() {
        return this.logger;
    }

    public List<SpeciesGroup> groups() {
        return this.groups;
    }

    public void main(String[] args) {
        Predef$.MODULE$.println(this.subgroups());
        Predef$.MODULE$.println(this.groups());
        Predef$.MODULE$.println(this.getSpeciesGroups("362235", "362236"));
        Predef$.MODULE$.println(this.getSpeciesSubGroups("362235", "362236"));
        Predef$.MODULE$.println(this.getSpeciesGroups("32353", "32354"));
        Predef$.MODULE$.println(this.getSpeciesSubGroups("32353", "32354"));
    }

    public List<SpeciesGroup> subgroups() {
        return this.subgroups;
    }

    public SpeciesGroup createSpeciesGroup(String title, String rank, String[] values, String[] excludedValues, String parent) {
        Tuple3[] lftRgts = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])values).map((Function1)new Serializable(rank){
            public static final long serialVersionUID = 0L;
            private final String rank$1;

            public final Tuple3<Object, Object, Object> apply(String v) {
                Tuple3 tuple3;
                NameSearchResult snr;
                NameSearchResult nameSearchResult;
                try {
                    nameSearchResult = Config$.MODULE$.nameIndex().searchForRecord(v, RankType.getForName((String)this.rank$1));
                }
                catch (Exception exception) {
                    nameSearchResult = null;
                }
                catch (HomonymException homonymException) {
                    nameSearchResult = snr = (NameSearchResult)JavaConversions$.MODULE$.asScalaBuffer(homonymException.getResults()).apply(0);
                }
                if (snr == null) {
                    SpeciesGroups$.MODULE$.logger().debug(new StringBuilder().append((Object)v).append((Object)" has no name ").toString());
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                } else {
                    if (snr.isSynonym()) {
                        snr = Config$.MODULE$.nameIndex().searchForRecordByLsid(snr.getAcceptedLsid());
                    }
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(snr.getLeft())), (Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(snr.getRight())), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
                return tuple3;
            }
            {
                this.rank$1 = rank$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        Tuple3[] lftRgtExcluded = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])excludedValues).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(String v) {
                Tuple3 tuple3;
                NameSearchResult snr = Config$.MODULE$.nameIndex().searchForRecord(v, null);
                if (snr == null) {
                    SpeciesGroups$.MODULE$.logger().debug(new StringBuilder().append((Object)v).append((Object)" has no name").toString());
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                } else {
                    if (snr.isSynonym()) {
                        snr = Config$.MODULE$.nameIndex().searchForRecordByLsid(snr.getAcceptedLsid());
                    }
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(snr.getLeft())), (Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(snr.getRight())), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                }
                return tuple3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        return new SpeciesGroup(title, rank, values, excludedValues, (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])lftRgtExcluded).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])lftRgts), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class))), parent);
    }

    public java.util.List<String> getStringList() {
        return JavaConversions$.MODULE$.seqAsJavaList((Seq)((List)this.groups().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(SpeciesGroup g) {
                return g.name();
            }
        }, List$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Deprecated
    public Option<List<String>> getSpeciesGroups(Classification cl) {
        List matchedGroups = (List)this.groups().collect((PartialFunction)new Serializable(cl){
            public static final long serialVersionUID = 0L;
            private final Classification cl$1;

            public final <A1 extends SpeciesGroup, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                Object object = A12 != null && Predef$.MODULE$.refArrayOps((Object[])(A1 = A12).values()).contains((Object)StringUtils.capitalize((String)StringUtils.lowerCase((String)((String)ReflectBean$.MODULE$.beanHelper(this.cl$1).getter(A1.rank()))))) ? A1.name() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SpeciesGroup x1) {
                SpeciesGroup speciesGroup;
                SpeciesGroup speciesGroup2 = x1;
                boolean bl = speciesGroup2 != null && Predef$.MODULE$.refArrayOps((Object[])(speciesGroup = speciesGroup2).values()).contains((Object)StringUtils.capitalize((String)StringUtils.lowerCase((String)((String)ReflectBean$.MODULE$.beanHelper(this.cl$1).getter(speciesGroup.rank())))));
                return bl;
            }
            {
                this.cl$1 = cl$1;
            }
        }, List$.MODULE$.canBuildFrom());
        return new Some((Object)matchedGroups);
    }

    public Option<List<String>> getSpeciesGroups(String lft, String rgt) {
        return this.getGenericGroups(lft, rgt, this.groups());
    }

    public Option<List<String>> getSpeciesSubGroups(String lft, String rgt) {
        return this.getGenericGroups(lft, rgt, this.subgroups());
    }

    public Option<List<String>> getGenericGroups(String lft, String rgt, List<SpeciesGroup> groupingList) {
        None$ none$;
        try {
            int ilft = Integer.parseInt(lft);
            List matchedGroups = (List)groupingList.collect((PartialFunction)new Serializable(ilft){
                public static final long serialVersionUID = 0L;
                private final int ilft$1;

                public final <A1 extends SpeciesGroup, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1;
                    A1 A12 = x2;
                    Object object = A12 != null && (A1 = A12).isPartOfGroup(this.ilft$1) ? A1.name() : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SpeciesGroup x2) {
                    SpeciesGroup speciesGroup;
                    SpeciesGroup speciesGroup2 = x2;
                    boolean bl = speciesGroup2 != null && (speciesGroup = speciesGroup2).isPartOfGroup(this.ilft$1);
                    return bl;
                }
                {
                    this.ilft$1 = ilft$1;
                }
            }, List$.MODULE$.canBuildFrom());
            none$ = new Some((Object)matchedGroups);
        }
        catch (Exception exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private SpeciesGroups$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"SpeciesGroups");
        SpeciesGroup[] speciesGroupArray = new SpeciesGroup[22];
        speciesGroupArray[0] = this.createSpeciesGroup("Animals", "kingdom", (String[])((Object[])new String[]{"Animalia"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), null);
        speciesGroupArray[1] = this.createSpeciesGroup("Mammals", "classs", (String[])((Object[])new String[]{"Mammalia"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Animals");
        speciesGroupArray[2] = this.createSpeciesGroup("Birds", "classs", (String[])((Object[])new String[]{"Aves"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Animals");
        speciesGroupArray[3] = this.createSpeciesGroup("Reptiles", "classs", (String[])((Object[])new String[]{"Reptilia"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Animals");
        speciesGroupArray[4] = this.createSpeciesGroup("Amphibians", "classs", (String[])((Object[])new String[]{"Amphibia"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Animals");
        speciesGroupArray[5] = this.createSpeciesGroup("Fish", "classs", (String[])((Object[])new String[]{"Agnatha", "Chondrichthyes", "Osteichthyes", "Actinopterygii", "Sarcopterygii"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Animals");
        speciesGroupArray[6] = this.createSpeciesGroup("Molluscs", "phylum", (String[])((Object[])new String[]{"Mollusca"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Animals");
        speciesGroupArray[7] = this.createSpeciesGroup("Arthropods", "phylum", (String[])((Object[])new String[]{"Arthropoda"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Animals");
        speciesGroupArray[8] = this.createSpeciesGroup("Crustaceans", "classs", (String[])((Object[])new String[]{"Branchiopoda", "Remipedia", "Maxillopoda", "Ostracoda", "Malacostraca"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Arthropods");
        speciesGroupArray[9] = this.createSpeciesGroup("Insects", "classs", (String[])((Object[])new String[]{"Insecta"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Arthropods");
        speciesGroupArray[10] = this.createSpeciesGroup("Plants", "kingdom", (String[])((Object[])new String[]{"Plantae"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), null);
        speciesGroupArray[11] = this.createSpeciesGroup("Bryophytes", "phylum", (String[])((Object[])new String[]{"Bryophyta", "Marchantiophyta", "Anthocerotophyta"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Plants");
        speciesGroupArray[12] = this.createSpeciesGroup("Gymnosperms", "subclass", (String[])((Object[])new String[]{"Pinidae", "Cycadidae"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Plants");
        speciesGroupArray[13] = this.createSpeciesGroup("FernsAndAllies", "subclass", (String[])((Object[])new String[]{"Equisetidae", "Lycopodiidae", "Marattiidae", "Ophioglossidae", "Polypodiidae", "Psilotidae"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Plants");
        speciesGroupArray[14] = this.createSpeciesGroup("Angiosperms", "subclass", (String[])((Object[])new String[]{"Magnoliidae"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Plants");
        speciesGroupArray[15] = this.createSpeciesGroup("Monocots", "superorder", (String[])((Object[])new String[]{"Lilianae"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), "Angiosperms");
        speciesGroupArray[16] = this.createSpeciesGroup("Dicots", "subclass", (String[])((Object[])new String[]{"Magnoliidae"}), (String[])((Object[])new String[]{"Lilianae"}), "Angiosperms");
        speciesGroupArray[17] = this.createSpeciesGroup("Fungi", "kingdom", (String[])((Object[])new String[]{"Fungi"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), null);
        speciesGroupArray[18] = this.createSpeciesGroup("Chromista", "kingdom", (String[])((Object[])new String[]{"Chromista"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), null);
        speciesGroupArray[19] = this.createSpeciesGroup("Protozoa", "kingdom", (String[])((Object[])new String[]{"Protozoa"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), null);
        speciesGroupArray[20] = this.createSpeciesGroup("Bacteria", "kingdom", (String[])((Object[])new String[]{"Bacteria"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), null);
        speciesGroupArray[21] = this.createSpeciesGroup("Algae", "phylum", (String[])((Object[])new String[]{"Bacillariophyta", "Chlorophyta", "Cyanidiophyta", "Prasinophyta", "Rhodophyta", "Cryptophyta", "Ochrophyta", "Sagenista", "Cercozoa", "Euglenozoa", "Cyanobacteria"}), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), null);
        this.groups = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])speciesGroupArray));
        String json = Source$.MODULE$.fromURL("https://ala-bie.googlecode.com/svn/trunk/bie-profile/src/main/resources/subgroups.json", Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
        List list = (List)JSON$.MODULE$.parseFull(json).get();
        ArrayBuffer subGroupBuffer = new ArrayBuffer();
        list.foreach((Function1)new anonfun.3(subGroupBuffer));
        this.subgroups = subGroupBuffer.toList();
    }
}

