/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.vocab;

import au.org.ala.biocache.vocab.BBox;
import au.org.ala.biocache.vocab.CentrePoints;
import au.org.ala.biocache.vocab.LatLng;
import au.org.ala.biocache.vocab.Term;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichFloat$;
import scala.runtime.RichInt$;

public abstract class CentrePoints$class {
    public static Option matchName(CentrePoints $this, String str) {
        return $this.map().get((Object)str.toLowerCase());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean coordinatesMatchCentre(CentrePoints $this, String state, String decimalLatitude, String decimalLongitude) {
        Tuple2 tuple22;
        Option<Term> matchedState = $this.vocab().matchTerm(state);
        if (matchedState.isEmpty()) return false;
        if (decimalLatitude == null) return false;
        if (decimalLongitude == null) {
            return false;
        }
        Option latlngBBox = $this.map().get((Object)((Term)matchedState.get()).canonical().toLowerCase());
        if (latlngBBox.isEmpty()) {
            return false;
        }
        Tuple2 tuple2 = (Tuple2)latlngBBox.get();
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        LatLng latlng = (LatLng)tuple2._1();
        BBox bbox = (BBox)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)latlng, (Object)bbox);
        LatLng latlng2 = (LatLng)tuple23._1();
        BBox bbox2 = (BBox)tuple23._2();
        try {
            float latitude = new StringOps(Predef$.MODULE$.augmentString(decimalLatitude)).toFloat();
            float longitude = new StringOps(Predef$.MODULE$.augmentString(decimalLongitude)).toFloat();
            int latDecPlaces = $this.noOfDecimalPlace(latitude);
            int longDecPlaces = $this.noOfDecimalPlace(longitude);
            float approximatedLat = $this.round(latlng2.latitude(), latDecPlaces);
            float approximatedLong = $this.round(latlng2.longitude(), longDecPlaces);
            if (approximatedLat != latitude) return false;
            if (approximatedLong != longitude) return false;
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static Tuple2 getHemispheresForPoint(CentrePoints $this, double lat2, double lng) {
        return new Tuple2.mcCC.sp(lat2 >= 0.0 ? $this.north() : $this.south(), lng >= 0.0 ? $this.east() : $this.west());
    }

    public static Option getHemispheres(CentrePoints $this, String region) {
        None$ none$;
        Some some;
        Tuple2 tuple2;
        Option<Term> matchedRegion = $this.vocab().matchTerm(region);
        Option option = $this.map().get((Object)((Term)matchedRegion.get()).canonical().toLowerCase());
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
            BBox bbox = (BBox)tuple2._2();
            none$ = new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{bbox.north() >= 0.0f ? $this.north() : $this.south(), bbox.south() > 0.0f ? $this.north() : $this.south(), bbox.east() >= 0.0f ? $this.east() : $this.west(), bbox.west() > 0.0f ? $this.east() : $this.west()})));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static float round(CentrePoints $this, float number, int decimalPlaces) {
        float f;
        if (decimalPlaces > 0) {
            IntRef x = new IntRef(1);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), decimalPlaces).foreach$mVc$sp((Function1)new Serializable($this, x){
                public static final long serialVersionUID = 0L;
                private final IntRef x$2;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.x$2.elem *= 10;
                }
                {
                    this.x$2 = x$2;
                }
            });
            f = (float)((int)(number * (float)x.elem)) / (float)x.elem;
        } else {
            f = RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper(number));
        }
        return f;
    }

    public static int noOfDecimalPlace(CentrePoints $this, float number) {
        String numberString = ((Object)BoxesRunTime.boxToFloat((float)number)).toString();
        int decimalPointLoc = numberString.indexOf(".");
        return decimalPointLoc < 0 ? 0 : numberString.substring(decimalPointLoc + 1).length();
    }

    public static Map loadFromFile(CentrePoints $this, String filePath) {
        return ((TraversableOnce)Source$.MODULE$.fromURL($this.getClass().getResource(filePath), "utf-8").getLines().toList().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Tuple2<LatLng, BBox>> apply(String row) {
                String[] values = row.split("\t");
                String name = ((String)Predef$.MODULE$.refArrayOps((Object[])values).head()).toLowerCase();
                float[] coordinates = (float[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])values).tail()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final float apply(String x) {
                        return new StringOps(Predef$.MODULE$.augmentString(x)).toFloat();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)name), (Object)new Tuple2((Object)new LatLng(coordinates[0], coordinates[1]), (Object)new BBox(coordinates[2], coordinates[3], coordinates[4], coordinates[5])));
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public static void $init$(CentrePoints $this) {
        $this.au$org$ala$biocache$vocab$CentrePoints$_setter_$north_$eq('N');
        $this.au$org$ala$biocache$vocab$CentrePoints$_setter_$south_$eq('S');
        $this.au$org$ala$biocache$vocab$CentrePoints$_setter_$east_$eq('E');
        $this.au$org$ala$biocache$vocab$CentrePoints$_setter_$west_$eq('W');
    }
}

