/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.parser.DateParser$;
import au.org.ala.biocache.parser.EventDate;
import au.org.ala.biocache.util.StringHelper$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001b\ta1\u000b\u001e:j]\u001eDU\r\u001c9fe*\u00111\u0001B\u0001\u0005kRLGN\u0003\u0002\u0006\r\u0005A!-[8dC\u000eDWM\u0003\u0002\b\u0011\u0005\u0019\u0011\r\\1\u000b\u0005%Q\u0011aA8sO*\t1\"\u0001\u0002bk\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\"AQ\u0003\u0001B\u0001B\u0003%a#A\u0002tiJ\u0004\"a\u0006\u000e\u000f\u0005=A\u0012BA\r\u0011\u0003\u0019\u0001&/\u001a3fM&\u00111\u0004\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e\u0001\u0002\"\u0002\u0010\u0001\t\u0003y\u0012A\u0002\u001fj]&$h\b\u0006\u0002!EA\u0011\u0011\u0005A\u0007\u0002\u0005!)Q#\ba\u0001-!9A\u0005\u0001b\u0001\n\u0003)\u0013a\u00023fG&l\u0017\r\\\u000b\u0002MA\u0011qeK\u0007\u0002Q)\u0011\u0011FK\u0001\t[\u0006$8\r[5oO*\u00111\u0001E\u0005\u0003Y!\u0012QAU3hKbDaA\f\u0001!\u0002\u00131\u0013\u0001\u00033fG&l\u0017\r\u001c\u0011\t\u000bA\u0002A\u0011A\u0019\u0002\u0011\u0019L\u0007pV5ei\"$\"A\u0006\u001a\t\u000bMz\u0003\u0019\u0001\u001b\u0002\u000b]LG\r\u001e5\u0011\u0005=)\u0014B\u0001\u001c\u0011\u0005\rIe\u000e\u001e\u0005\u0006q\u0001!\t!O\u0001\u0006SNLe\u000e^\u000b\u0002uA\u0011qbO\u0005\u0003yA\u0011qAQ8pY\u0016\fg\u000eC\u0003?\u0001\u0011\u0005\u0011(A\u0004jg\u001acw.\u0019;\t\u000b\u0001\u0003A\u0011A\u001d\u0002\u001f%\u001cH)Z2j[\u0006dg*^7cKJDQA\u0011\u0001\u0005\u0002e\na![:ECR,\u0007\"\u0002#\u0001\t\u0003I\u0014AC5t\u0019\u0006$\u0018\u000e^;eK\")a\t\u0001C\u0001s\u0005Y\u0011n\u001d'p]\u001eLG/\u001e3f\u0011\u0015A\u0005\u0001\"\u0001J\u0003I!x\u000eR8vE2,w+\u001b;i\u001fB$\u0018n\u001c8\u0016\u0003)\u00032aD&N\u0013\ta\u0005C\u0001\u0004PaRLwN\u001c\t\u0003\u001f9K!a\u0014\t\u0003\r\u0011{WO\u00197f\u0011\u0015\t\u0006\u0001\"\u0001S\u0003E!xN\u00127pCR<\u0016\u000e\u001e5PaRLwN\\\u000b\u0002'B\u0019qb\u0013+\u0011\u0005=)\u0016B\u0001,\u0011\u0005\u00151En\\1u\u000f\u0015A&\u0001#\u0001Z\u00031\u0019FO]5oO\"+G\u000e]3s!\t\t#LB\u0003\u0002\u0005!\u00051l\u0005\u0002[\u001d!)aD\u0017C\u0001;R\t\u0011\fC\u0003`5\u0012\r\u0001-A\u0007tiJLgn\u001a\u001aiK2\u0004XM\u001d\u000b\u0003A\u0005DQ!\u00060A\u0002Y\u0001")
public class StringHelper {
    private final String str;
    private final Regex decimal;

    public static StringHelper string2helper(String string) {
        return StringHelper$.MODULE$.string2helper(string);
    }

    public Regex decimal() {
        return this.decimal;
    }

    public String fixWidth(int width) {
        return this.str.length() > width ? this.str.substring(0, width) : (this.str.length() < width ? new StringBuilder().append((Object)this.str).append((Object)((TraversableOnce)List$.MODULE$.fill(width - this.str.length(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return " ";
            }
        })).mkString()).toString() : this.str);
    }

    public boolean isInt() {
        boolean bl;
        try {
            new StringOps(Predef$.MODULE$.augmentString(this.str)).toInt();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean isFloat() {
        boolean bl;
        try {
            new StringOps(Predef$.MODULE$.augmentString(this.str)).toFloat();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean isDecimalNumber() {
        return !this.decimal().findFirstMatchIn((CharSequence)this.str).isEmpty();
    }

    public boolean isDate() {
        Option<EventDate> option = DateParser$.MODULE$.parseDate(this.str, DateParser$.MODULE$.parseDate$default$2(), DateParser$.MODULE$.parseDate$default$3());
        boolean bl = !option.isEmpty() && DateParser$.MODULE$.isValid((EventDate)option.get());
        return bl;
    }

    public boolean isLatitude() {
        boolean bl;
        try {
            float latitude = new StringOps(Predef$.MODULE$.augmentString(this.str)).toFloat();
            bl = (double)latitude <= 90.0 && (double)latitude >= -90.0;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean isLongitude() {
        boolean bl;
        try {
            float longitude = new StringOps(Predef$.MODULE$.augmentString(this.str)).toFloat();
            bl = (double)longitude <= 180.0 && (double)longitude >= -180.0;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public Option<Object> toDoubleWithOption() {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(this.str)).toDouble()));
        }
        catch (Exception exception) {
            some = None$.MODULE$;
        }
        return some;
    }

    public Option<Object> toFloatWithOption() {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(this.str)).toFloat()));
        }
        catch (Exception exception) {
            some = None$.MODULE$;
        }
        return some;
    }

    public StringHelper(String str) {
        this.str = str;
        this.decimal = new StringOps(Predef$.MODULE$.augmentString("[0-9]{1,}\\.[0-9]{1,}")).r();
    }
}

