/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.Config$;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Processed$;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.Version;
import au.org.ala.biocache.model.Versions$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processors$;
import au.org.ala.biocache.tool.RecordProcessor$;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.StringConsumer;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0001\u0003\u00015\u0011qBU3d_J$\u0007K]8dKN\u001cxN\u001d\u0006\u0003\u0007\u0011\tA\u0001^8pY*\u0011QAB\u0001\tE&|7-Y2iK*\u0011q\u0001C\u0001\u0004C2\f'BA\u0005\u000b\u0003\ry'o\u001a\u0006\u0002\u0017\u0005\u0011\u0011-^\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAqA\u0007\u0001C\u0002\u0013\u00051$\u0001\u0004m_\u001e<WM]\u000b\u00029A\u0011Q$I\u0007\u0002=)\u0011q\u0004I\u0001\u0006g24GG\u001b\u0006\u0002\u0013%\u0011!E\b\u0002\u0007\u0019><w-\u001a:\t\r\u0011\u0002\u0001\u0015!\u0003\u001d\u0003\u001dawnZ4fe\u0002BqA\n\u0001C\u0002\u0013\u0005q%A\u0006qe>\u001cWm]:US6,W#\u0001\u0015\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013\u0001\u00027b]\u001eT\u0011!L\u0001\u0005U\u00064\u0018-\u0003\u00020U\t11\u000b\u001e:j]\u001eDa!\r\u0001!\u0002\u0013A\u0013\u0001\u00049s_\u000e,7o\u001d+j[\u0016\u0004\u0003bB\u001a\u0001\u0005\u0004%\t\u0001N\u0001\u000bIV\u0004H.[2bi\u0016\u001cX#A\u001b\u0011\u0007YZ\u0004&D\u00018\u0015\tA\u0014(A\u0005j[6,H/\u00192mK*\u0011!\bE\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001f8\u0005\u0011a\u0015n\u001d;\t\ry\u0002\u0001\u0015!\u00036\u0003-!W\u000f\u001d7jG\u0006$Xm\u001d\u0011\t\u000b\u0001\u0003A\u0011A!\u0002\u001dA\u0014xnY3tgJ+7m\u001c:egR\u0011!)\u0012\t\u0003\u001f\rK!\u0001\u0012\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006\r~\u0002\raR\u0001\be><8*Z=t!\rA\u0005K\u0015\b\u0003\u0013:s!AS'\u000e\u0003-S!\u0001\u0014\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA(\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001P)\u000b\u0005=\u0003\u0002CA*W\u001d\tyA+\u0003\u0002V!\u00051\u0001K]3eK\u001aL!aL,\u000b\u0005U\u0003\u0002\"B-\u0001\t\u0003Q\u0016!\u00043po:dw.\u00193NK\u0012L\u0017\r\u0006\u0002C7\")A\f\u0017a\u0001;\u0006\u0019!/Y<\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001$\u0011!B7pI\u0016d\u0017B\u00012`\u0005)1U\u000f\u001c7SK\u000e|'\u000f\u001a\u0005\u0006I\u0002!\t!Z\u0001\u0015aJ|7-Z:t\r&dWm\u00144S_^\\U-_:\u0015\u0005\t3\u0007\"B4d\u0001\u0004\u0011\u0016\u0001\u00034jY\u0016t\u0015-\\3\t\u000b%\u0004A\u0011\u00016\u0002'A\u0014xnY3tg\u001aKG.\u001a+ie\u0016\fG-\u001a3\u0015\u0007\t[7\u000fC\u0003mQ\u0002\u0007Q.\u0001\u0003gS2,\u0007C\u00018r\u001b\u0005y'B\u00019-\u0003\tIw.\u0003\u0002s_\n!a)\u001b7f\u0011\u0015!\b\u000e1\u0001v\u0003\u001d!\bN]3bIN\u0004\"a\u0004<\n\u0005]\u0004\"aA%oi\")\u0011\u0010\u0001C\u0001u\u0006Q\u0001O]8dKN\u001c\u0018\t\u001c7\u0016\u0003\tCQ\u0001 \u0001\u0005\u0002u\fQ\u0002\u001d:pG\u0016\u001c8OU3d_J$Gc\u0001\"\u007f\u007f\")Al\u001fa\u0001;\"1\u0011\u0011A>A\u0002u\u000b\u0001cY;se\u0016tG\u000f\u0015:pG\u0016\u001c8/\u001a3\t\rq\u0004A\u0011AA\u0003)\u0011\t9!a\b\u0011\r=\tI!XA\u0007\u0013\r\tY\u0001\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\rM\u000byAUA\n\u0013\r\t\tb\u0016\u0002\u0004\u001b\u0006\u0004\b#B\b\u0002\u0016\u0005e\u0011bAA\f!\t)\u0011I\u001d:bsB\u0019a,a\u0007\n\u0007\u0005uqL\u0001\tRk\u0006d\u0017\u000e^=BgN,'\u000f^5p]\"1A,a\u0001A\u0002uCq!a\t\u0001\t\u0003\t)#\u0001\fqe>\u001cWm]:SK\u000e|'\u000fZ!oIV\u0003H-\u0019;f)\r\u0011\u0015q\u0005\u0005\u00079\u0006\u0005\u0002\u0019A/\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.\u0005\u0019\u0012\r\u001a3SK\u000e|'\u000fZ!oIB\u0013xnY3tgR)!+a\f\u00024!9\u0011\u0011GA\u0015\u0001\u0004\u0011\u0016a\u00043bi\u0006\u0014Vm]8ve\u000e,W+\u001b3\t\u0011\u0005U\u0012\u0011\u0006a\u0001\u0003o\t!\u0002\u001d:pa\u0016\u0014H/[3t!\u0015\u0019\u0016q\u0002*S\u0011\u001d\tY\u0004\u0001C\u0001\u0003{\t\u0011\"\u00193e%\u0016\u001cwN\u001d3\u0015\u000bI\u000by$!\u0011\t\u000f\u0005E\u0012\u0011\ba\u0001%\"A\u0011QGA\u001d\u0001\u0004\t9\u0004")
public class RecordProcessor {
    private final Logger logger = LoggerFactory.getLogger(RecordProcessor.class);
    private final String processTime = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final List<String> duplicates = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"D", "D1", "D2"}));

    public Logger logger() {
        return this.logger;
    }

    public String processTime() {
        return this.processTime;
    }

    public List<String> duplicates() {
        return this.duplicates;
    }

    public void processRecords(List<String> rowKeys) {
        this.logger().debug(new StringBuilder().append((Object)"Starting to process all the records in the list: ").append(rowKeys).toString());
        IntRef counter = new IntRef(0);
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        rowKeys.foreach((Function1)new Serializable(this, counter, startTime, finishTime){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordProcessor $outer;
            private final IntRef counter$1;
            private final LongRef startTime$1;
            private final LongRef finishTime$1;

            public final void apply(String rowKey) {
                Option<FullRecord[]> rawProcessed = Config$.MODULE$.occurrenceDAO().getRawProcessedByRowKey(rowKey);
                if (!rawProcessed.isEmpty()) {
                    FullRecord[] rp = (FullRecord[])rawProcessed.get();
                    this.$outer.processRecord(rp[0], rp[1]);
                    if (this.counter$1.elem % 100 == 0) {
                        this.finishTime$1.elem = System.currentTimeMillis();
                        this.$outer.logger().debug(new StringBuilder().append(this.counter$1.elem).append((Object)" >> Last key : ").append((Object)rp[0].uuid()).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(100.0f / ((float)(this.finishTime$1.elem - this.startTime$1.elem) / 1000.0f)))).toString());
                        this.startTime$1.elem = System.currentTimeMillis();
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.counter$1 = counter$1;
                this.startTime$1 = startTime$1;
                this.finishTime$1 = finishTime$1;
            }
        });
    }

    public void downloadMedia(FullRecord raw) {
        Config$.MODULE$.occurrenceDAO().downloadMedia(raw);
    }

    public void processFileOfRowKeys(String fileName) {
        this.logger().info(new StringBuilder().append((Object)"Starting processing from file......").append((Object)fileName).toString());
        int counter = 0;
        long startTime = System.currentTimeMillis();
        long finishTime = System.currentTimeMillis();
        CSVReader csvReader = new CSVReader((Reader)new FileReader(fileName));
        String[] current = csvReader.readNext();
        while (true) {
            if (current == null) break;
            ++counter;
            Option<FullRecord[]> rawProcessed = Config$.MODULE$.occurrenceDAO().getRawProcessedByRowKey(current[0]);
            if (!rawProcessed.isEmpty()) {
                FullRecord[] rp = (FullRecord[])rawProcessed.get();
                this.processRecord(rp[0], rp[1]);
                if (counter % 1000 == 0) {
                    finishTime = System.currentTimeMillis();
                    Predef$.MODULE$.println((Object)new StringBuilder().append(counter).append((Object)" >> Last key : ").append((Object)rp[0].uuid()).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(finishTime - startTime) / 1000.0f)))).toString());
                    startTime = System.currentTimeMillis();
                }
            }
            current = csvReader.readNext();
        }
        this.logger().info("Finished processing from file.");
    }

    public void processFileThreaded(File file, int threads) {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(100);
        IntRef ids = new IntRef(0);
        StringConsumer[] pool = (StringConsumer[])Array$.MODULE$.fill(threads, (Function0)new Serializable(this, queue, ids){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordProcessor $outer;
            private final ArrayBlockingQueue queue$1;
            private final IntRef ids$1;

            public final StringConsumer apply() {
                IntRef counter = new IntRef(0);
                LongRef startTime = new LongRef(System.currentTimeMillis());
                LongRef finishTime = new LongRef(System.currentTimeMillis());
                StringConsumer p = new StringConsumer(this.queue$1, this.ids$1.elem, (Function1<String, BoxedUnit>)new Serializable(this, counter, startTime, finishTime){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final IntRef counter$2;
                    private final LongRef startTime$2;
                    private final LongRef finishTime$2;

                    public final void apply(String guid) {
                        ++this.counter$2.elem;
                        Option<FullRecord[]> rawProcessed = Config$.MODULE$.occurrenceDAO().getRawProcessedByRowKey(guid);
                        if (!rawProcessed.isEmpty()) {
                            FullRecord[] rp = (FullRecord[])rawProcessed.get();
                            this.$outer.au$org$ala$biocache$tool$RecordProcessor$$anonfun$$$outer().processRecord(rp[0], rp[1]);
                            if (this.counter$2.elem % 1000 == 0) {
                                this.finishTime$2.elem = System.currentTimeMillis();
                                this.$outer.au$org$ala$biocache$tool$RecordProcessor$$anonfun$$$outer().logger().info(new StringBuilder().append(this.counter$2.elem).append((Object)" >> Last key : ").append((Object)rp[0].uuid()).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$2.elem - this.startTime$2.elem) / 1000.0f)))).toString());
                                this.startTime$2.elem = System.currentTimeMillis();
                            }
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.counter$2 = counter$2;
                        this.startTime$2 = startTime$2;
                        this.finishTime$2 = finishTime$2;
                    }
                });
                ++this.ids$1.elem;
                p.start();
                return p;
            }

            public /* synthetic */ RecordProcessor au$org$ala$biocache$tool$RecordProcessor$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.queue$1 = queue$1;
                this.ids$1 = ids$1;
            }
        }, ClassTag$.MODULE$.apply(StringConsumer.class));
        FileHelper$.MODULE$.file2helper(file).foreachLine((Function1<String, BoxedUnit>)new Serializable(this, queue){
            public static final long serialVersionUID = 0L;
            private final ArrayBlockingQueue queue$1;

            public final void apply(String line) {
                this.queue$1.put(line.trim());
            }
            {
                this.queue$1 = queue$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(StringConsumer t) {
                t.shouldStop_$eq(true);
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(StringConsumer x$1) {
                x$1.join();
            }
        });
    }

    public void processAll() {
        IntRef counter = new IntRef(0);
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        OccurrenceDAO qual$1 = Config$.MODULE$.occurrenceDAO();
        Serializable x$4 = new Serializable(this, counter, startTime, finishTime){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordProcessor $outer;
            private final IntRef counter$3;
            private final LongRef startTime$3;
            private final LongRef finishTime$3;

            public final boolean apply(Option<Tuple2<FullRecord, FullRecord>> record) {
                Tuple2 tuple2;
                block5: {
                    block4: {
                        Tuple2 tuple22;
                        ++this.counter$3.elem;
                        if (record.isEmpty()) break block4;
                        tuple2 = (Tuple2)record.get();
                        if (tuple2 == null) break block5;
                        FullRecord raw = (FullRecord)tuple2._1();
                        FullRecord processed = (FullRecord)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)raw, (Object)processed);
                        FullRecord raw2 = (FullRecord)tuple23._1();
                        FullRecord processed2 = (FullRecord)tuple23._2();
                        this.$outer.processRecord(raw2, processed2);
                        if (this.counter$3.elem % 1000 == 0) {
                            this.finishTime$3.elem = System.currentTimeMillis();
                            this.$outer.logger().info(new StringBuilder().append(this.counter$3.elem).append((Object)" >> Last key : ").append((Object)raw2.uuid()).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$3.elem - this.startTime$3.elem) / 1000.0f)))).toString());
                            this.startTime$3.elem = System.currentTimeMillis();
                        }
                    }
                    return true;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.counter$3 = counter$3;
                this.startTime$3 = startTime$3;
                this.finishTime$3 = finishTime$3;
            }
        };
        String x$5 = qual$1.pageOverRawProcessed$default$2();
        String x$6 = qual$1.pageOverRawProcessed$default$3();
        int x$7 = qual$1.pageOverRawProcessed$default$4();
        qual$1.pageOverRawProcessed((Function1<Option<Tuple2<FullRecord, FullRecord>>, Object>)x$4, x$5, x$6, x$7);
    }

    public void processRecord(FullRecord raw, FullRecord currentProcessed) {
        String guid = raw.rowKey();
        OccurrenceDAO occurrenceDAO = (OccurrenceDAO)Config$.MODULE$.getInstance(OccurrenceDAO.class);
        ObjectRef processed = new ObjectRef((Object)raw.createNewProcessedRecord());
        ObjectRef assertions = new ObjectRef((Object)new HashMap());
        Processors$.MODULE$.foreach((Function1<Processor, BoxedUnit>)new Serializable(this, raw, currentProcessed, guid, processed, assertions){
            public static final long serialVersionUID = 0L;
            private final FullRecord raw$2;
            private final FullRecord currentProcessed$1;
            private final String guid$1;
            private final ObjectRef processed$1;
            private final ObjectRef assertions$1;

            public final void apply(Processor processor) {
                ((HashMap)this.assertions$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)processor.process(this.guid$1, this.raw$2, (FullRecord)this.processed$1.elem, (Option<FullRecord>)new Some((Object)this.currentProcessed$1))));
            }
            {
                this.raw$2 = raw$2;
                this.currentProcessed$1 = currentProcessed$1;
                this.guid$1 = guid$1;
                this.processed$1 = processed$1;
                this.assertions$1 = assertions$1;
            }
        });
        ((FullRecord)processed.elem).lastModifiedTime_$eq(this.processTime());
        Some systemAssertions = new Some((Object)((HashMap)assertions.elem).toMap(Predef$.MODULE$.conforms()));
        occurrenceDAO.updateOccurrence(guid, currentProcessed, (FullRecord)processed.elem, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)systemAssertions, Processed$.MODULE$);
    }

    public Tuple2<FullRecord, scala.collection.immutable.Map<String, QualityAssertion[]>> processRecord(FullRecord raw) {
        ObjectRef processed = new ObjectRef((Object)raw.createNewProcessedRecord());
        ObjectRef assertions = new ObjectRef((Object)new HashMap());
        Processors$.MODULE$.foreach((Function1<Processor, BoxedUnit>)new Serializable(this, raw, processed, assertions){
            public static final long serialVersionUID = 0L;
            private final FullRecord raw$1;
            private final ObjectRef processed$2;
            private final ObjectRef assertions$2;

            public final void apply(Processor processor) {
                ((HashMap)this.assertions$2.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)processor.process(this.raw$1.rowKey(), this.raw$1, (FullRecord)this.processed$2.elem, processor.process$default$4())));
            }
            {
                this.raw$1 = raw$1;
                this.processed$2 = processed$2;
                this.assertions$2 = assertions$2;
            }
        });
        return new Tuple2((Object)((FullRecord)processed.elem), (Object)((HashMap)assertions.elem).toMap(Predef$.MODULE$.conforms()));
    }

    public void processRecordAndUpdate(FullRecord raw) {
        Tuple2<FullRecord, scala.collection.immutable.Map<String, QualityAssertion[]>> tuple2 = this.processRecord(raw);
        if (tuple2 != null) {
            Tuple2 tuple22;
            FullRecord processed = (FullRecord)tuple2._1();
            scala.collection.immutable.Map assertions = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)processed, (Object)assertions);
            FullRecord processed2 = (FullRecord)tuple23._1();
            scala.collection.immutable.Map assertions2 = (scala.collection.immutable.Map)tuple23._2();
            Some systemAssertions = new Some((Object)assertions2);
            processed2.lastModifiedTime_$eq(this.processTime());
            Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), processed2, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)systemAssertions, Processed$.MODULE$);
            return;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public String addRecordAndProcess(String dataResourceUid, scala.collection.immutable.Map<String, String> properties) {
        void var3_3;
        String uuid = (String)properties.getOrElse((Object)"uuid", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return UUID.randomUUID().toString();
            }
        });
        String rowKey = new StringBuilder().append((Object)dataResourceUid).append((Object)"|").append((Object)uuid).toString();
        FullRecord raw = FullRecordMapper$.MODULE$.createFullRecord(rowKey, (Map<String, String>)properties, (Version)Versions$.MODULE$.RAW());
        raw.uuid_$eq(uuid);
        raw.attribution().dataResourceUid_$eq(dataResourceUid);
        Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), raw, (Version)Versions$.MODULE$.RAW());
        RecordProcessor processor = new RecordProcessor();
        processor.processRecordAndUpdate(raw);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public String addRecord(String dataResourceUid, scala.collection.immutable.Map<String, String> properties) {
        void var3_3;
        String uuid = (String)properties.getOrElse((Object)"uuid", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return UUID.randomUUID().toString();
            }
        });
        String rowKey = new StringBuilder().append((Object)dataResourceUid).append((Object)"|").append((Object)uuid).toString();
        FullRecord raw = FullRecordMapper$.MODULE$.createFullRecord(rowKey, (Map<String, String>)properties, (Version)Versions$.MODULE$.RAW());
        raw.uuid_$eq(uuid);
        raw.attribution().dataResourceUid_$eq(dataResourceUid);
        Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), raw, (Version)Versions$.MODULE$.RAW());
        boolean downloaded = Config$.MODULE$.occurrenceDAO().downloadMedia(raw);
        if (downloaded) {
            Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), raw, (Version)Versions$.MODULE$.RAW());
        }
        return var3_3;
    }
}

