/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.qa.QaPasser;
import au.org.ala.biocache.qa.QaPasser$;
import au.org.ala.biocache.tool.ExpertDistributionOutlierTool;
import au.org.ala.biocache.util.OptionParser;
import au.org.ala.biocache.vocab.AssertionCodes$;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class ExpertDistributionOutlierTool$ {
    public static final ExpertDistributionOutlierTool$ MODULE$;
    private final String DISTRIBUTIONS_URL;
    private final String DISTRIBUTION_DETAILS_URL_TEMPLATE;
    private final String DISTANCE_URL_TEMPLATE;
    private final String RECORDS_QUERY_TEMPLATE;
    private final String RECORDS_FILTER_QUERY_TEMPLATE;
    private final String DATE_RANGE_FILTER;
    private final String DISTRIBUTION_OUTLIERS_COLUMN_FAMILY_KEY;
    private final int OUTLIER_THRESHOLD;
    private final int RECORDS_PAGE_SIZE;

    static {
        new ExpertDistributionOutlierTool$();
    }

    public String DISTRIBUTIONS_URL() {
        return this.DISTRIBUTIONS_URL;
    }

    public String DISTRIBUTION_DETAILS_URL_TEMPLATE() {
        return this.DISTRIBUTION_DETAILS_URL_TEMPLATE;
    }

    public String DISTANCE_URL_TEMPLATE() {
        return this.DISTANCE_URL_TEMPLATE;
    }

    public String RECORDS_QUERY_TEMPLATE() {
        return this.RECORDS_QUERY_TEMPLATE;
    }

    public String RECORDS_FILTER_QUERY_TEMPLATE() {
        return this.RECORDS_FILTER_QUERY_TEMPLATE;
    }

    public String DATE_RANGE_FILTER() {
        return this.DATE_RANGE_FILTER;
    }

    public String DISTRIBUTION_OUTLIERS_COLUMN_FAMILY_KEY() {
        return this.DISTRIBUTION_OUTLIERS_COLUMN_FAMILY_KEY;
    }

    public int OUTLIER_THRESHOLD() {
        return this.OUTLIER_THRESHOLD;
    }

    public int RECORDS_PAGE_SIZE() {
        return this.RECORDS_PAGE_SIZE;
    }

    public void main(String[] args) {
        ExpertDistributionOutlierTool tool = new ExpertDistributionOutlierTool();
        ObjectRef speciesLsid = new ObjectRef(null);
        IntRef numThreads = new IntRef(1);
        IntRef passThreads = new IntRef(16);
        BooleanRef test = new BooleanRef(false);
        ObjectRef dir = new ObjectRef((Object)None$.MODULE$);
        ObjectRef lastModifiedDate = new ObjectRef((Object)None$.MODULE$);
        OptionParser parser = new OptionParser(speciesLsid, numThreads, passThreads, test, dir, lastModifiedDate){
            {
                this.opt("l", "specieslsid", "Species LSID. If supplied, outlier detection is only performed for occurrences of the species with the supplied taxon concept LSID ", (Function1<String, BoxedUnit>)new Serializable(this, speciesLsid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef speciesLsid$1;

                    public final void apply(String v) {
                        this.speciesLsid$1.elem = v;
                    }
                    {
                        this.speciesLsid$1 = speciesLsid$1;
                    }
                });
                this.intOpt("t", "numThreads", "Number of threads to use when detecting outliers", (Function1<Object, BoxedUnit>)new Serializable(this, numThreads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef numThreads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.numThreads$1.elem = v;
                    }
                    {
                        this.numThreads$1 = numThreads$1;
                    }
                });
                this.intOpt("pt", "passThreads", "Number of threads to write the passed records on.", (Function1<Object, BoxedUnit>)new Serializable(this, passThreads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef passThreads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.passThreads$1.elem = v;
                    }
                    {
                        this.passThreads$1 = passThreads$1;
                    }
                });
                this.opt("test", "Test the outliers but don't write to Cassandra", (Function0<BoxedUnit>)new Serializable(this, test$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef test$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.test$1.elem = true;
                    }
                    {
                        this.test$1 = test$1;
                    }
                });
                this.opt("d", "dir", "The directory in which the offline dumps are located", (Function1<String, BoxedUnit>)new Serializable(this, dir$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dir$1;

                    public final void apply(String v) {
                        this.dir$1.elem = new Some((Object)v);
                    }
                    {
                        this.dir$1 = dir$1;
                    }
                });
                this.intOpt("day", "numDaysMod", "Number of days since the last modified.  This will limit the records that are marked as passed.", (Function1<Object, BoxedUnit>)new Serializable(this, lastModifiedDate$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef lastModifiedDate$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        SimpleDateFormat sfd = new SimpleDateFormat("yyyy-MM-dd");
                        int days = 0 - v;
                        this.lastModifiedDate$1.elem = new Some((Object)new StringBuilder().append((Object)sfd.format(DateUtils.addDays((Date)new Date(), (int)days))).append((Object)"T00:00:00Z").toString());
                    }
                    {
                        this.lastModifiedDate$1 = lastModifiedDate$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            QaPasser qaPasser = new QaPasser(QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.SPECIES_OUTSIDE_EXPERT_RANGE(), 1), passThreads.elem, QaPasser$.MODULE$.$lessinit$greater$default$3(), QaPasser$.MODULE$.$lessinit$greater$default$4());
            Config$.MODULE$.indexDAO().init();
            tool.findOutliers((String)speciesLsid.elem, numThreads.elem, test.elem, qaPasser, (Option<String>)((Option)dir.elem), (Option<String>)((Option)lastModifiedDate.elem));
        }
    }

    private ExpertDistributionOutlierTool$() {
        MODULE$ = this;
        this.DISTRIBUTIONS_URL = new StringBuilder().append((Object)Config$.MODULE$.layersServiceUrl()).append((Object)"/distributions").toString();
        this.DISTRIBUTION_DETAILS_URL_TEMPLATE = new StringBuilder().append((Object)Config$.MODULE$.layersServiceUrl()).append((Object)"/distribution/lsid/{0}").toString();
        this.DISTANCE_URL_TEMPLATE = new StringBuilder().append((Object)Config$.MODULE$.layersServiceUrl()).append((Object)"/distribution/outliers/{0}").toString();
        this.RECORDS_QUERY_TEMPLATE = "species_guid:{0} OR subspecies_guid:{0}";
        this.RECORDS_FILTER_QUERY_TEMPLATE = "geospatial_kosher:true";
        this.DATE_RANGE_FILTER = "last_load_date:[{0} TO *]";
        this.DISTRIBUTION_OUTLIERS_COLUMN_FAMILY_KEY = "rowkeys";
        this.OUTLIER_THRESHOLD = 50000;
        this.RECORDS_PAGE_SIZE = 5000;
    }
}

