/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.index.IndexRecords$;
import au.org.ala.biocache.tool.DuplicationDetection;
import au.org.ala.biocache.tool.DuplicationDetection$;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.OptionParser;
import au.org.ala.biocache.util.StringConsumer;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class DuplicationDetection$ {
    public static final DuplicationDetection$ MODULE$;
    private final Logger logger;
    private String rootDir;

    static {
        new DuplicationDetection$();
    }

    public Logger logger() {
        return this.logger;
    }

    public String rootDir() {
        return this.rootDir;
    }

    public void rootDir_$eq(String x$1) {
        this.rootDir = x$1;
    }

    public void main(String[] args) {
        BooleanRef all = new BooleanRef(false);
        BooleanRef exist = new BooleanRef(false);
        ObjectRef guid = new ObjectRef((Object)None$.MODULE$);
        ObjectRef speciesFile = new ObjectRef((Object)None$.MODULE$);
        IntRef threads = new IntRef(4);
        BooleanRef cleanup = new BooleanRef(false);
        BooleanRef load2 = new BooleanRef(false);
        BooleanRef incremental = new BooleanRef(false);
        BooleanRef removeObsoleteData = new BooleanRef(false);
        ObjectRef offlineDir = new ObjectRef((Object)"/data/offline/exports");
        OptionParser parser = new OptionParser(all, exist, guid, speciesFile, threads, cleanup, load2, incremental, removeObsoleteData, offlineDir){
            {
                this.opt("all", "detect duplicates for all species", (Function0<BoxedUnit>)new Serializable(this, all$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef all$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.all$1.elem = true;
                    }
                    {
                        this.all$1 = all$1;
                    }
                });
                this.opt("g", "guid", "A single guid to test for duplications", (Function1<String, BoxedUnit>)new Serializable(this, guid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef guid$1;

                    public final void apply(String v) {
                        this.guid$1.elem = new Some((Object)v);
                    }
                    {
                        this.guid$1 = guid$1;
                    }
                });
                this.opt("exist", "use existing occurrence dumps", (Function0<BoxedUnit>)new Serializable(this, exist$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef exist$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.exist$1.elem = true;
                    }
                    {
                        this.exist$1 = exist$1;
                    }
                });
                this.opt("inc", "perform an incremental duplication detection based on the last time it was run", (Function0<BoxedUnit>)new Serializable(this, incremental$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef incremental$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.incremental$1.elem = true;
                    }
                    {
                        this.incremental$1 = incremental$1;
                    }
                });
                this.opt("cleanup", "cleanup the temporary files that get created", (Function0<BoxedUnit>)new Serializable(this, cleanup$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef cleanup$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.cleanup$1.elem = true;
                    }
                    {
                        this.cleanup$1 = cleanup$1;
                    }
                });
                this.opt("load", "load to duplicates into the database", (Function0<BoxedUnit>)new Serializable(this, load$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef load$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.load$1.elem = true;
                    }
                    {
                        this.load$1 = load$1;
                    }
                });
                this.opt("f", "file", "A file that contains a list of species guids to detect duplication for", (Function1<String, BoxedUnit>)new Serializable(this, speciesFile$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef speciesFile$1;

                    public final void apply(String v) {
                        this.speciesFile$1.elem = new Some((Object)v);
                    }
                    {
                        this.speciesFile$1 = speciesFile$1;
                    }
                });
                this.opt("removeold", "Removes the duplicate information for records that are no longer duplicates", (Function0<BoxedUnit>)new Serializable(this, removeObsoleteData$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef removeObsoleteData$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.removeObsoleteData$1.elem = true;
                    }
                    {
                        this.removeObsoleteData$1 = removeObsoleteData$1;
                    }
                });
                this.opt("od", "offlinedir", "The offline directory that contains the export files.", (Function1<String, BoxedUnit>)new Serializable(this, offlineDir$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef offlineDir$1;

                    public final void apply(String v) {
                        this.offlineDir$1.elem = v;
                    }
                    {
                        this.offlineDir$1 = offlineDir$1;
                    }
                });
                this.intOpt("t", "threads", " The number of concurrent species duplications to perform.", (Function1<Object, BoxedUnit>)new Serializable(this, threads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threads$1.elem = v;
                    }
                    {
                        this.threads$1 = threads$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            Option<String> lastRunDate;
            Option<String> option = lastRunDate = incremental.elem ? Config$.MODULE$.duplicateDAO().getLastDuplicationRun() : None$.MODULE$;
            if (removeObsoleteData.elem) {
                this.removeObsoleteDuplicates((Option<String>)((Option)speciesFile.elem));
            } else if (all.elem) {
                String filename = new StringBuilder().append((Object)this.rootDir()).append((Object)"dd_all_species_guids").toString();
                this.detectDuplicates(new File(filename), threads.elem, exist.elem, cleanup.elem, load2.elem, (String)offlineDir.elem);
            } else if (((Option)guid.elem).isDefined()) {
                DuplicationDetection dd = new DuplicationDetection();
                String datafilename = new StringBuilder().append((Object)this.rootDir()).append((Object)"dd_data_").append((Object)((String)((Option)guid.elem).get()).replaceAll("[\\.:]", "_")).append((Object)".txt").toString();
                String passedfilename = new StringBuilder().append((Object)this.rootDir()).append((Object)"passed").append((Object)((String)((Option)guid.elem).get()).replaceAll("[\\.:]", "_")).append((Object)".txt").toString();
                String dupfilename = new StringBuilder().append((Object)this.rootDir()).append((Object)"duplicates_").append((Object)((String)((Option)guid.elem).get()).replaceAll("[\\.:]", "_")).append((Object)".txt").toString();
                String indexfilename = new StringBuilder().append((Object)this.rootDir()).append((Object)"reindex_").append((Object)((String)((Option)guid.elem).get()).replaceAll("[\\.:]", "_")).append((Object)".txt").toString();
                String olddup = new StringBuilder().append((Object)this.rootDir()).append((Object)"olddup_").append((Object)((String)((Option)guid.elem).get()).replaceAll("[\\.:]", "_")).append((Object)".txt").toString();
                if (load2.elem) {
                    dd.loadDuplicates((String)((Option)guid.elem).get(), threads.elem, dupfilename, new FileWriter(indexfilename), new FileWriter(olddup));
                    IndexRecords$.MODULE$.indexList(new File(indexfilename), false);
                    this.updateLastDuplicateTime();
                } else {
                    String x$13 = datafilename;
                    FileWriter x$14 = new FileWriter(dupfilename);
                    FileWriter x$15 = new FileWriter(passedfilename);
                    String x$16 = (String)((Option)guid.elem).get();
                    boolean x$17 = !exist.elem;
                    boolean x$18 = cleanup.elem;
                    String x$19 = dd.detect$default$6();
                    dd.detect(x$13, x$14, x$15, x$16, x$17, x$19, x$18);
                }
                Config$.MODULE$.persistenceManager().shutdown();
                Config$.MODULE$.indexDAO().shutdown();
            } else if (((Option)speciesFile.elem).isDefined()) {
                this.detectDuplicates(new File((String)((Option)speciesFile.elem).get()), threads.elem, exist.elem, cleanup.elem, load2.elem, this.detectDuplicates$default$6());
            } else {
                parser.showUsage();
            }
        }
    }

    public void removeObsoleteDuplicates(Option<String> filename) {
        String olddupfilename = (String)filename.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)DuplicationDetection$.MODULE$.rootDir()).append((Object)"olddups.txt").toString();
            }
        });
        File file = new File(olddupfilename);
        FileHelper$.MODULE$.file2helper(file).foreachLine((Function1<String, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String line) {
                String[] parts = line.split("\t");
                String uuid = parts[1];
                Config$.MODULE$.duplicateDAO().deleteObsoleteDuplicate(uuid);
            }
        });
    }

    public void detectDuplicates(File file, int threads, boolean exist, boolean cleanup, boolean load2, String offlineDir) {
        IntRef ids = new IntRef(0);
        Thread[] pool = (Thread[])Array$.MODULE$.fill(threads, (Function0)new Serializable(threads, load2, offlineDir, ids){
            public static final long serialVersionUID = 0L;
            public final int threads$2;
            private final boolean load$2;
            private final String offlineDir$2;
            private final IntRef ids$1;

            public final Thread apply() {
                Thread thread;
                String dir = new StringBuilder().append((Object)DuplicationDetection$.MODULE$.rootDir()).append((Object)BoxesRunTime.boxToInteger((int)this.ids$1.elem)).append((Object)File.separator).toString();
                FileUtils.forceMkdir((File)new File(dir));
                String sourceFile = new StringBuilder().append((Object)dir).append((Object)"dd_data.txt").toString();
                String dupfilename = new StringBuilder().append((Object)dir).append((Object)"duplicates.txt").toString();
                String passedfilename = new StringBuilder().append((Object)dir).append((Object)"passed.txt").toString();
                String indexfilename = new StringBuilder().append((Object)dir).append((Object)"reindex.txt").toString();
                String olddupfilename = new StringBuilder().append((Object)dir).append((Object)"olddups.txt").toString();
                if (this.load$2) {
                    thread = new Thread(this, dupfilename, passedfilename, indexfilename, olddupfilename){
                        private final /* synthetic */ anonfun.12 $outer;
                        private final String dupfilename$1;
                        private final String passedfilename$1;
                        private final String indexfilename$1;
                        private final String olddupfilename$1;

                        public void run() {
                            new DuplicationDetection().loadMultipleDuplicatesFromFile(this.dupfilename$1, this.passedfilename$1, this.$outer.threads$2, new FileWriter(new File(this.indexfilename$1)), new FileWriter(new File(this.olddupfilename$1)));
                            IndexRecords$.MODULE$.indexList(new File(this.indexfilename$1), false);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.dupfilename$1 = dupfilename$1;
                            this.passedfilename$1 = passedfilename$1;
                            this.indexfilename$1 = indexfilename$1;
                            this.olddupfilename$1 = olddupfilename$1;
                        }
                    };
                } else {
                    String sourceFileName = new StringBuilder().append((Object)this.offlineDir$2).append((Object)File.separator).append((Object)BoxesRunTime.boxToInteger((int)this.ids$1.elem)).append((Object)File.separator).append((Object)"species.out").toString();
                    thread = new Thread(this, dupfilename, passedfilename, sourceFileName){
                        private final /* synthetic */ anonfun.12 $outer;
                        private final String dupfilename$1;
                        private final String passedfilename$1;
                        private final String sourceFileName$1;

                        public void run() {
                            new DuplicationDetection().detectMultipleDuplicatesFromFile(this.sourceFileName$1, new FileWriter(this.dupfilename$1), new FileWriter(this.passedfilename$1), this.$outer.threads$2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.dupfilename$1 = dupfilename$1;
                            this.passedfilename$1 = passedfilename$1;
                            this.sourceFileName$1 = sourceFileName$1;
                        }
                    };
                }
                Thread p = thread;
                ++this.ids$1.elem;
                p.start();
                return p;
            }
            {
                this.threads$2 = threads$2;
                this.load$2 = load$2;
                this.offlineDir$2 = offlineDir$2;
                this.ids$1 = ids$1;
            }
        }, ClassTag$.MODULE$.apply(Thread.class));
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Thread t) {
                if (t instanceof StringConsumer) {
                    ((StringConsumer)t).shouldStop_$eq(true);
                }
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Thread x$1) {
                x$1.join();
            }
        });
        if (load2) {
            this.updateLastDuplicateTime();
            File baseFile = new File(new StringBuilder().append((Object)this.rootDir()).append((Object)"olddups.txt").toString());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), threads - 1).foreach$mVc$sp((Function1)new Serializable(baseFile){
                public static final long serialVersionUID = 0L;
                private final File baseFile$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    File ifile = new File(new StringBuilder().append((Object)DuplicationDetection$.MODULE$.rootDir()).append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)File.separator).append((Object)"olddups.txt").toString());
                    FileHelper$.MODULE$.file2helper(this.baseFile$1).append(FileHelper$.MODULE$.file2helper(ifile));
                }
                {
                    this.baseFile$1 = baseFile$1;
                }
            });
        }
        Config$.MODULE$.persistenceManager().shutdown();
        Config$.MODULE$.indexDAO().shutdown();
    }

    public String detectDuplicates$default$6() {
        return "";
    }

    public void updateLastDuplicateTime() {
        Date date = DateUtils.truncate((Date)new Date(), (int)5);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.add(10, -24);
        Config$.MODULE$.duplicateDAO().setLastDuplicationRun(cal.getTime());
    }

    private DuplicationDetection$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"DuplicateDetection");
        this.rootDir = "/data/tool/";
    }
}

