/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.tool.CalculatedLayerHelper;
import au.org.ala.biocache.util.OptionParser;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class CalculatedLayerHelper$ {
    public static final CalculatedLayerHelper$ MODULE$;
    private final String SPECIES_GUID_QUERY;
    private final String SPECIFIC_SPECIES_GUID_QUERY_TEMPLATE;
    private final String ALL_SPECIES_FILTER_QUERY;
    private final String NON_MARINE_SPECIES_FILTER_QUERY;
    private final String SPECIES_FACET;
    private final String POINT_001_FACET;

    static {
        new CalculatedLayerHelper$();
    }

    public String SPECIES_GUID_QUERY() {
        return this.SPECIES_GUID_QUERY;
    }

    public String SPECIFIC_SPECIES_GUID_QUERY_TEMPLATE() {
        return this.SPECIFIC_SPECIES_GUID_QUERY_TEMPLATE;
    }

    public String ALL_SPECIES_FILTER_QUERY() {
        return this.ALL_SPECIES_FILTER_QUERY;
    }

    public String NON_MARINE_SPECIES_FILTER_QUERY() {
        return this.NON_MARINE_SPECIES_FILTER_QUERY;
    }

    public String SPECIES_FACET() {
        return this.SPECIES_FACET;
    }

    public String POINT_001_FACET() {
        return this.POINT_001_FACET;
    }

    public void main(String[] args) {
        CalculatedLayerHelper helper = new CalculatedLayerHelper();
        ObjectRef outputFileDirectory = new ObjectRef(null);
        ObjectRef speciesCellCountsFilePrefix = new ObjectRef(null);
        ObjectRef cellSpeciesFilePrefix = new ObjectRef(null);
        ObjectRef cellOccurrenceCountsFilePrefix = new ObjectRef(null);
        IntRef numThreads = new IntRef(1);
        OptionParser parser = new OptionParser(outputFileDirectory, speciesCellCountsFilePrefix, cellSpeciesFilePrefix, cellOccurrenceCountsFilePrefix, numThreads){
            {
                this.arg("outputFileDirectory", "Directory in which to write the output files", (Function1<String, BoxedUnit>)new Serializable(this, outputFileDirectory$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef outputFileDirectory$1;

                    public final void apply(String v) {
                        this.outputFileDirectory$1.elem = v;
                    }
                    {
                        this.outputFileDirectory$1 = outputFileDirectory$1;
                    }
                });
                this.arg("speciesCellCountsFilePrefix", "Prefix for files containing species cell counts (without .txt extension)", (Function1<String, BoxedUnit>)new Serializable(this, speciesCellCountsFilePrefix$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef speciesCellCountsFilePrefix$1;

                    public final void apply(String v) {
                        this.speciesCellCountsFilePrefix$1.elem = v;
                    }
                    {
                        this.speciesCellCountsFilePrefix$1 = speciesCellCountsFilePrefix$1;
                    }
                });
                this.arg("cellSpeciesFilePrefix", "Prefix for files containing cell species lists (without .txt extension)", (Function1<String, BoxedUnit>)new Serializable(this, cellSpeciesFilePrefix$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef cellSpeciesFilePrefix$1;

                    public final void apply(String v) {
                        this.cellSpeciesFilePrefix$1.elem = v;
                    }
                    {
                        this.cellSpeciesFilePrefix$1 = cellSpeciesFilePrefix$1;
                    }
                });
                this.arg("cellOccurrenceCountsFilePrefix", "Prefix for files containing cell occurrence counts (without .txt extension)", (Function1<String, BoxedUnit>)new Serializable(this, cellOccurrenceCountsFilePrefix$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef cellOccurrenceCountsFilePrefix$1;

                    public final void apply(String v) {
                        this.cellOccurrenceCountsFilePrefix$1.elem = v;
                    }
                    {
                        this.cellOccurrenceCountsFilePrefix$1 = cellOccurrenceCountsFilePrefix$1;
                    }
                });
                this.intOpt("t", "numThreads", "Number of threads to use", (Function1<Object, BoxedUnit>)new Serializable(this, numThreads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef numThreads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.numThreads$1.elem = v;
                    }
                    {
                        this.numThreads$1 = numThreads$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Output file directory: ").append((Object)((String)outputFileDirectory.elem)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Species cell counts file prefix: ").append((Object)((String)speciesCellCountsFilePrefix.elem)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Cell species file prefix: ").append((Object)((String)cellSpeciesFilePrefix.elem)).toString());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Cell occurrence counts file prefix: ").append((Object)((String)cellOccurrenceCountsFilePrefix.elem)).toString());
            helper.execute(numThreads.elem, (String)outputFileDirectory.elem, (String)speciesCellCountsFilePrefix.elem, (String)cellSpeciesFilePrefix.elem, (String)cellOccurrenceCountsFilePrefix.elem);
        }
    }

    public Tuple2<ListBuffer<String>, Map<String, Object>> doFacetQuery(String query, String filterQuery, String facet) {
        ObjectRef valuesList = new ObjectRef((Object)new ListBuffer());
        Map valuesCountMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Config$.MODULE$.indexDAO().pageOverFacet((Function2<String, Object, Object>)new Serializable(valuesList, valuesCountMap){
            public static final long serialVersionUID = 0L;
            private final ObjectRef valuesList$1;
            private final Map valuesCountMap$1;

            public final boolean apply(String name, int count) {
                return CalculatedLayerHelper$.MODULE$.au$org$ala$biocache$tool$CalculatedLayerHelper$$addToList$1(name, count, this.valuesList$1, this.valuesCountMap$1);
            }
            {
                this.valuesList$1 = valuesList$1;
                this.valuesCountMap$1 = valuesCountMap$1;
            }
        }, facet, query, (String[])((Object[])new String[]{filterQuery}));
        return new Tuple2((Object)((ListBuffer)valuesList.elem), (Object)valuesCountMap);
    }

    public final boolean au$org$ala$biocache$tool$CalculatedLayerHelper$$addToList$1(String name, int count, ObjectRef valuesList$1, Map valuesCountMap$1) {
        ((ListBuffer)valuesList$1.elem).$plus$eq((Object)name);
        valuesCountMap$1.put((Object)name, (Object)BoxesRunTime.boxToInteger((int)count));
        return true;
    }

    private CalculatedLayerHelper$() {
        MODULE$ = this;
        this.SPECIES_GUID_QUERY = "species_guid:*";
        this.SPECIFIC_SPECIES_GUID_QUERY_TEMPLATE = "species_guid:{0}";
        this.ALL_SPECIES_FILTER_QUERY = "geospatial_kosher:true";
        this.NON_MARINE_SPECIES_FILTER_QUERY = "!species_habitats:Marine AND geospatial_kosher:true AND (state:* OR country:Australia)";
        this.SPECIES_FACET = "species_guid";
        this.POINT_001_FACET = "point-0.001";
    }
}

