/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.load.MediaStore$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.parser.CollectorNameParser$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.EstablishmentMeans$;
import au.org.ala.biocache.vocab.Interactions$;
import au.org.ala.biocache.vocab.Term;
import org.apache.commons.lang.StringUtils;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u00015\u0011a#T5tG\u0016dG.\u00198f_V\u001c\bK]8dKN\u001cxN\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\u000b\u0005\u00151\u0011\u0001\u00032j_\u000e\f7\r[3\u000b\u0005\u001dA\u0011aA1mC*\u0011\u0011BC\u0001\u0004_J<'\"A\u0006\u0002\u0005\u0005,8\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\tI\u0001K]8dKN\u001cxN\u001d\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"!\u0006\u0001\t\u000fu\u0001!\u0019!C\u0001=\u0005QA*S*U?\u0012+E*S'\u0016\u0003}\u0001\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u00115\fGo\u00195j]\u001eT!\u0001\n\t\u0002\tU$\u0018\u000e\\\u0005\u0003M\u0005\u0012QAU3hKbDa\u0001\u000b\u0001!\u0002\u0013y\u0012a\u0003'J'R{F)\u0012'J\u001b\u0002BqA\u000b\u0001C\u0002\u0013\u0005a$\u0001\nj]R,'/Y2uS>t\u0007+\u0019;uKJt\u0007B\u0002\u0017\u0001A\u0003%q$A\nj]R,'/Y2uS>t\u0007+\u0019;uKJt\u0007\u0005C\u0003/\u0001\u0011\u0005q&A\u0004qe>\u001cWm]:\u0015\u000bAJ$iR%\u0011\u0007=\t4'\u0003\u00023!\t)\u0011I\u001d:bsB\u0011AgN\u0007\u0002k)\u0011a\u0007B\u0001\u0006[>$W\r\\\u0005\u0003qU\u0012\u0001#U;bY&$\u00180Q:tKJ$\u0018n\u001c8\t\u000bij\u0003\u0019A\u001e\u0002\t\u001d,\u0018\u000e\u001a\t\u0003y}r!aD\u001f\n\u0005y\u0002\u0012A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!A\u0010\t\t\u000b\rk\u0003\u0019\u0001#\u0002\u0007I\fw\u000f\u0005\u00025\u000b&\u0011a)\u000e\u0002\u000b\rVdGNU3d_J$\u0007\"\u0002%.\u0001\u0004!\u0015!\u00039s_\u000e,7o]3e\u0011\u001dQU\u0006%AA\u0002-\u000bQ\u0002\\1tiB\u0013xnY3tg\u0016$\u0007cA\bM\t&\u0011Q\n\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b=\u0003A\u0011\u0001)\u0002+A\u0014xnY3tg6K7oY(dGV\u0014(/\u001a8dKR!\u0011\u000bV+W!\ty!+\u0003\u0002T!\t!QK\\5u\u0011\u0015\u0019e\n1\u0001E\u0011\u0015Ae\n1\u0001E\u0011\u00159f\n1\u0001Y\u0003)\t7o]3si&|gn\u001d\t\u00043z\u001bT\"\u0001.\u000b\u0005mc\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003;B\t!bY8mY\u0016\u001cG/[8o\u0013\ty&LA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\b\"B1\u0001\t\u0003\u0011\u0017!\u00059s_\u000e,7o]\"pY2,7\r^8sgR!1MZ4i!\tyA-\u0003\u0002f!\t\u0019\u0011I\\=\t\u000b\r\u0003\u0007\u0019\u0001#\t\u000b!\u0003\u0007\u0019\u0001#\t\u000b]\u0003\u0007\u0019\u0001-\t\u000b)\u0004A\u0011A6\u00023A\u0014xnY3tg\u0016\u001bH/\u00192mSNDW.\u001a8u\u001b\u0016\fgn\u001d\u000b\u0005#2lg\u000eC\u0003DS\u0002\u0007A\tC\u0003IS\u0002\u0007A\tC\u0003XS\u0002\u0007\u0001\fC\u0003q\u0001\u0011\u0005\u0011/A\u000bqe>\u001cWm]:JI\u0016tG/\u001b4jG\u0006$\u0018n\u001c8\u0015\ta\u00138\u000f\u001e\u0005\u0006\u0007>\u0004\r\u0001\u0012\u0005\u0006\u0011>\u0004\r\u0001\u0012\u0005\u0006/>\u0004\r\u0001\u0017\u0005\u0006m\u0002!\ta^\u0001\u0014aJ|7-Z:t\u0013:$XM]1di&|gn\u001d\u000b\u0005#bL(\u0010C\u0003;k\u0002\u00071\bC\u0003Dk\u0002\u0007A\tC\u0003Ik\u0002\u0007A\tC\u0003}\u0001\u0011\u0005Q0\u0001\tqCJ\u001cX-\u00138uKJ\f7\r^5p]R\u0011ap \t\u0004\u001f1[\u0004\"B\"|\u0001\u0004Y\u0004bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u000eaJ|7-Z:t\u00136\fw-Z:\u0015\u0013\r\f9!!\u0003\u0002\f\u00055\u0001B\u0002\u001e\u0002\u0002\u0001\u00071\b\u0003\u0004D\u0003\u0003\u0001\r\u0001\u0012\u0005\u0007\u0011\u0006\u0005\u0001\u0019\u0001#\t\r]\u000b\t\u00011\u0001Y\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\tqaZ3u\u001d\u0006lW-\u0006\u0002\u0002\u0016A!\u0011qCA\u0011\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011\u0001\u00027b]\u001eT!!a\b\u0002\t)\fg/Y\u0005\u0004\u0001\u0006e\u0001\"CA\u0013\u0001E\u0005I\u0011IA\u0014\u0003E\u0001(o\\2fgN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003SQ3aSA\u0016W\t\ti\u0003\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001c!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0012\u0011\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class MiscellaneousProcessor
implements Processor {
    private final Regex LIST_DELIM;
    private final Regex interactionPattern;

    public Regex LIST_DELIM() {
        return this.LIST_DELIM;
    }

    public Regex interactionPattern() {
        return this.interactionPattern;
    }

    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        ArrayBuffer assertions = new ArrayBuffer();
        this.processImages(guid, raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.processInteractions(guid, raw, processed);
        this.processEstablishmentMeans(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.processIdentification(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.processCollectors(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.processMiscOccurrence(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    public void processMiscOccurrence(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer = StringUtils.isBlank((String)raw.occurrence().catalogNumber()) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_CATALOGUENUMBER(), "No catalogue number provided")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_CATALOGUENUMBER(), 1));
        if (StringUtils.isNotBlank((String)raw.occurrence().dataGeneralizations())) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DATA_ARE_GENERALISED()));
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DATA_ARE_GENERALISED(), 1));
        }
    }

    public Object processCollectors(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        BoxedUnit boxedUnit;
        if (StringUtils.isNotBlank((String)raw.occurrence().recordedBy())) {
            Option<List<String>> parsedCollectors = CollectorNameParser$.MODULE$.parseForList(raw.occurrence().recordedBy());
            if (parsedCollectors.isDefined()) {
                processed.occurrence().recordedBy_$eq(((TraversableOnce)parsedCollectors.get()).mkString("|"));
                boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.RECORDED_BY_UNPARSABLE(), 1));
            } else {
                boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.RECORDED_BY_UNPARSABLE(), "Can not parse recordedBy"));
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public void processEstablishmentMeans(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (StringUtils.isNotBlank((String)raw.occurrence().establishmentMeans())) {
            Option cultEscaped;
            String[] ameans = this.LIST_DELIM().split((CharSequence)raw.occurrence().establishmentMeans());
            String[] newmeans = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])ameans).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String means) {
                    Option<Term> term = EstablishmentMeans$.MODULE$.matchTerm(means);
                    return term.isDefined() ? ((Term)term.get()).getCanonical() : "";
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$1) {
                    return x$1.length() > 0;
                }
            });
            if (!Predef$.MODULE$.refArrayOps((Object[])newmeans).isEmpty()) {
                processed.occurrence().establishmentMeans_$eq(Predef$.MODULE$.refArrayOps((Object[])newmeans).mkString("; "));
            }
            if ((cultEscaped = Predef$.MODULE$.refArrayOps((Object[])newmeans).find((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(String em) {
                    String string = em;
                    String string2 = "cultivated";
                    if (string == null) {
                        if (string2 == null) return true;
                    } else if (string.equals(string2)) return true;
                    String string3 = em;
                    String string4 = "assumed to be cultivated";
                    if (string3 == null) {
                        if (string4 == null) return true;
                    } else if (string3.equals(string4)) return true;
                    String string5 = em;
                    String string6 = "formerly cultivated (extinct)";
                    if (string5 == null) {
                        if (string6 == null) return true;
                    } else if (string5.equals(string6)) return true;
                    String string7 = em;
                    String string8 = "possibly cultivated";
                    if (string7 == null) {
                        if (string8 == null) return true;
                    } else if (string7.equals(string8)) return true;
                    String string9 = em;
                    String string10 = "presumably cultivated";
                    if (string9 != null) {
                        if (!string9.equals(string10)) return false;
                        return true;
                    }
                    if (string10 == null) return true;
                    return false;
                }
            })).isDefined()) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.OCCURRENCE_IS_CULTIVATED_OR_ESCAPEE()));
            } else {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.OCCURRENCE_IS_CULTIVATED_OR_ESCAPEE(), 1));
            }
        }
    }

    public ArrayBuffer<QualityAssertion> processIdentification(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer = raw.identification().identificationQualifier() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_IDENTIFICATIONQUALIFIER(), "Missing identificationQualifier")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_IDENTIFICATIONQUALIFIER(), 1));
        ArrayBuffer arrayBuffer2 = raw.identification().identifiedBy() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_IDENTIFIEDBY(), "Missing identifiedBy")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_IDENTIFIEDBY(), 1));
        ArrayBuffer arrayBuffer3 = raw.identification().identificationReferences() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_IDENTIFICATIONREFERENCES(), "Missing identificationReferences")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_IDENTIFICATIONREFERENCES(), 1));
        return raw.identification().dateIdentified() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_DATEIDENTIFIED(), "Missing dateIdentified")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_DATEIDENTIFIED(), 1));
    }

    public void processInteractions(String guid, FullRecord raw, FullRecord processed) {
        Option<Term> term;
        Option<String> interaction;
        if (!(raw.occurrence().associatedTaxa() == null || raw.occurrence().associatedTaxa().isEmpty() || (interaction = this.parseInteraction(raw.occurrence().associatedTaxa())).isEmpty() || (term = Interactions$.MODULE$.matchTerm((String)interaction.get())).isEmpty())) {
            processed.occurrence().interactions_$eq((String[])((Object[])new String[]{((Term)term.get()).getCanonical()}));
        }
    }

    public Option<String> parseInteraction(String raw) {
        None$ none$;
        String string = raw;
        Option option = this.interactionPattern().unapplySeq((Object)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String interaction = (String)((LinearSeqOptimized)option.get()).apply(0);
            none$ = new Some((Object)interaction);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Object processImages(String guid, FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        BoxedUnit boxedUnit;
        String urls = raw.occurrence().associatedMedia();
        if (urls == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            String[] aurls = (String[])Predef$.MODULE$.refArrayOps((Object[])urls.split(";")).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String url) {
                    return url.trim();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            processed.occurrence().images_$eq((String[])Predef$.MODULE$.refArrayOps((Object[])aurls).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String url) {
                    return MediaStore$.MODULE$.isValidImageURL(url) && MediaStore$.MODULE$.doesFileExist(url);
                }
            }));
            processed.occurrence().sounds_$eq((String[])Predef$.MODULE$.refArrayOps((Object[])aurls).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String url) {
                    return MediaStore$.MODULE$.isValidSoundURL(url) && MediaStore$.MODULE$.doesFileExist(url);
                }
            }));
            processed.occurrence().videos_$eq((String[])Predef$.MODULE$.refArrayOps((Object[])aurls).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String url) {
                    return MediaStore$.MODULE$.isValidVideoURL(url) && MediaStore$.MODULE$.doesFileExist(url);
                }
            }));
            boxedUnit = aurls.length != processed.occurrence().images().length + processed.occurrence().sounds().length + processed.occurrence().videos().length ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_IMAGE_URL(), "URL refers to an invalid file.")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_IMAGE_URL(), 1));
        }
        return boxedUnit;
    }

    @Override
    public String getName() {
        return "image";
    }

    public MiscellaneousProcessor() {
        Processor$class.$init$(this);
        this.LIST_DELIM = new StringOps(Predef$.MODULE$.augmentString(";")).r();
        this.interactionPattern = new StringOps(Predef$.MODULE$.augmentString("([A-Za-z]*):([\\x00-\\x7F\\s]*)")).r();
    }
}

