/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.persistence;

import au.org.ala.biocache.persistence.CassandraPersistenceManager$;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.persistence.PersistenceManager$class;
import au.org.ala.biocache.util.Json$;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.SlicePredicate;
import org.scale7.cassandra.pelops.Bytes;
import org.scale7.cassandra.pelops.Cluster;
import org.scale7.cassandra.pelops.Mutator;
import org.scale7.cassandra.pelops.OperandPolicy;
import org.scale7.cassandra.pelops.Pelops;
import org.scale7.cassandra.pelops.RowDeletor;
import org.scale7.cassandra.pelops.Selector;
import org.scale7.cassandra.pelops.exceptions.NotFoundException;
import org.scale7.cassandra.pelops.pool.CommonsBackedPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0011Ua\u0001B\u0001\u0003\u00015\u00111dQ1tg\u0006tGM]1QKJ\u001c\u0018n\u001d;f]\u000e,W*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003-\u0001XM]:jgR,gnY3\u000b\u0005\u00151\u0011\u0001\u00032j_\u000e\f7\r[3\u000b\u0005\u001dA\u0011aA1mC*\u0011\u0011BC\u0001\u0004_J<'\"A\u0006\u0002\u0005\u0005,8\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\t\u0011\u0002+\u001a:tSN$XM\\2f\u001b\u0006t\u0017mZ3s\u0011!I\u0002A!b\u0001\n\u0003Q\u0012\u0001\u00025pgR,\u0012a\u0007\t\u00039}q!aD\u000f\n\u0005y\u0001\u0012A\u0002)sK\u0012,g-\u0003\u0002!C\t11\u000b\u001e:j]\u001eT!A\b\t\t\u0011\r\u0002!\u0011!Q\u0001\nm\tQ\u0001[8ti\u0002B\u0001\"\n\u0001\u0003\u0006\u0004%\tAJ\u0001\u0005a>\u0014H/F\u0001(!\ty\u0001&\u0003\u0002*!\t\u0019\u0011J\u001c;\t\u0011-\u0002!\u0011!Q\u0001\n\u001d\nQ\u0001]8si\u0002B\u0001\"\f\u0001\u0003\u0006\u0004%\tAG\u0001\ta>|GNT1nK\"Aq\u0006\u0001B\u0001B\u0003%1$A\u0005q_>dg*Y7fA!A\u0011\u0007\u0001BC\u0002\u0013\u0005!$\u0001\u0005lKf\u001c\b/Y2f\u0011!\u0019\u0004A!A!\u0002\u0013Y\u0012!C6fsN\u0004\u0018mY3!\u0011!)\u0004A!b\u0001\n\u00031\u0013AD7bq\u000e{gN\\3di&|gn\u001d\u0005\to\u0001\u0011\t\u0011)A\u0005O\u0005yQ.\u0019=D_:tWm\u0019;j_:\u001c\b\u0005\u0003\u0005:\u0001\t\u0015\r\u0011\"\u0001'\u0003)i\u0017\r\u001f*fiJLWm\u001d\u0005\tw\u0001\u0011\t\u0011)A\u0005O\u0005YQ.\u0019=SKR\u0014\u0018.Z:!\u0011!i\u0004A!b\u0001\n\u00031\u0013\u0001E8qKJ\fG/[8o)&lWm\\;u\u0011!y\u0004A!A!\u0002\u00139\u0013!E8qKJ\fG/[8o)&lWm\\;uA!)\u0011\t\u0001C\u0001\u0005\u00061A(\u001b8jiz\"\u0002b\u0011#V3v\u000bW-\u001b\t\u0003+\u0001Aq!\u0007!\u0011\u0002\u0003\u00071\u0004\u000b\u0003E\rJ\u001b\u0006CA$Q\u001b\u0005A%BA%K\u0003\u0011q\u0017-\\3\u000b\u0005-c\u0015AB5oU\u0016\u001cGO\u0003\u0002N\u001d\u00061qm\\8hY\u0016T\u0011aT\u0001\u0004G>l\u0017BA)I\u0005\u0015q\u0015-\\3e\u0003\u00151\u0018\r\\;fC\u0005!\u0016aD2bgN\fg\u000e\u001a:b]!|7\u000f^:\t\u000f\u0015\u0002\u0005\u0013!a\u0001O!\"QK\u0012*XC\u0005A\u0016AD2bgN\fg\u000e\u001a:b]A|'\u000f\u001e\u0005\b[\u0001\u0003\n\u00111\u0001\u001cQ\u0011IfIU.\"\u0003q\u000babY1tg\u0006tGM]1/a>|G\u000eC\u00042\u0001B\u0005\t\u0019A\u000e)\tu3%kX\u0011\u0002A\u0006\u00112-Y:tC:$'/\u0019\u0018lKf\u001c\b/Y2f\u0011\u001d)\u0004\t%AA\u0002\u001dBC!\u0019$SG\u0006\nA-A\rdCN\u001c\u0018M\u001c3sC:j\u0017\r\u001f\u0018d_:tWm\u0019;j_:\u001c\bbB\u001dA!\u0003\u0005\ra\n\u0015\u0005K\u001a\u0013v-I\u0001i\u0003U\u0019\u0017m]:b]\u0012\u0014\u0018ML7bq:\u0012X\r\u001e:jKNDq!\u0010!\u0011\u0002\u0003\u0007q\u0005\u000b\u0003j\rJ[\u0017%\u00017\u00021QD'/\u001b4u]=\u0004XM]1uS>tg\u0006^5nK>,H\u000f\u000b\u0002A]B\u0011q\u000e]\u0007\u0002\u0015&\u0011\u0011O\u0013\u0002\u0007\u0013:TWm\u0019;\t\u000fM\u0004!\u0019!C\u0001i\u00061An\\4hKJ,\u0012!\u001e\t\u0003mjl\u0011a\u001e\u0006\u0003qf\fQa\u001d7gi)T\u0011!C\u0005\u0003w^\u0014a\u0001T8hO\u0016\u0014\bBB?\u0001A\u0003%Q/A\u0004m_\u001e<WM\u001d\u0011\t\u000f}\u0004!\u0019!C\u0001M\u0005qQ.\u0019=D_2,XN\u001c'j[&$\bbBA\u0002\u0001\u0001\u0006IaJ\u0001\u0010[\u0006D8i\u001c7v[:d\u0015.\\5uA!I\u0011q\u0001\u0001C\u0002\u0013\u0005\u0011\u0011B\u0001\bG2,8\u000f^3s+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005mQBAA\b\u0015\u0011\t\t\"a\u0005\u0002\rA,Gn\u001c9t\u0015\u0011\t)\"a\u0006\u0002\u0013\r\f7o]1oIJ\f'bAA\rs\u000611oY1mK^JA!!\b\u0002\u0010\t91\t\\;ti\u0016\u0014\b\u0002CA\u0011\u0001\u0001\u0006I!a\u0003\u0002\u0011\rdWo\u001d;fe\u0002B\u0011\"!\n\u0001\u0005\u0004%\t!a\n\u0002\rA|G.[2z+\t\tI\u0003\u0005\u0003\u0002,\u0005]b\u0002BA\u0017\u0003gi!!a\f\u000b\t\u0005E\u0012qB\u0001\u0005a>|G.\u0003\u0003\u00026\u0005=\u0012!E\"p[6|gn\u001d\"bG.,G\rU8pY&!\u0011\u0011HA\u001e\u0005\u0019\u0001v\u000e\\5ds*!\u0011QGA\u0018\u0011!\ty\u0004\u0001Q\u0001\n\u0005%\u0012a\u00029pY&\u001c\u0017\u0010\t\u0005\n\u0003\u0007\u0002!\u0019!C\u0001\u0003\u000b\nQb\u001c9fe\u0006tG\rU8mS\u000eLXCAA$!\u0011\ti!!\u0013\n\t\u0005-\u0013q\u0002\u0002\u000e\u001fB,'/\u00198e!>d\u0017nY=\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u000f\nab\u001c9fe\u0006tG\rU8mS\u000eL\b\u0005C\u0004\u0002T\u0001!\t!!\u0016\u0002\u0015%t\u0017\u000e^5bY&\u001cX-\u0006\u0002\u0002XA\u0019q\"!\u0017\n\u0007\u0005m\u0003C\u0001\u0003V]&$\bbBA0\u0001\u0011\u0005\u0011\u0011M\u0001\u0004O\u0016$HCBA2\u0003_\n\u0019\bE\u0003\u0010\u0003K\nI'C\u0002\u0002hA\u0011aa\u00149uS>t\u0007#\u0002\u000f\u0002lmY\u0012bAA7C\t\u0019Q*\u00199\t\u000f\u0005E\u0014Q\fa\u00017\u0005!Q/^5e\u0011\u001d\t)(!\u0018A\u0002m\t!\"\u001a8uSRLh*Y7f\u0011\u001d\ty\u0006\u0001C\u0001\u0003s\"\"\"a\u001f\u0002 \u0006\u0005\u00161UAT!\u0015y\u0011QMA?!\u0019\ty(!#\u0002\u000e6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))\u0001\u0003vi&d'BAAD\u0003\u0011Q\u0017M^1\n\t\u0005-\u0015\u0011\u0011\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0010\u0006mUBAAI\u0015\u0011\t\u0019*!&\u0002\rQD'/\u001b4u\u0015\u0011\t)\"a&\u000b\u0007\u0005e\u00150\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003;\u000b\tJ\u0001\u0004D_2,XN\u001c\u0005\b\u0003c\n9\b1\u0001\u001c\u0011\u001d\t)(a\u001eA\u0002mAq!!*\u0002x\u0001\u00071$A\u0007ti\u0006\u0014H\u000f\u0015:pa\u0016\u0014H/\u001f\u0005\b\u0003S\u000b9\b1\u0001\u001c\u0003-)g\u000e\u001a)s_B,'\u000f^=\t\u000f\u00055\u0006\u0001\"\u0001\u00020\u0006Ar-\u001a;D_2,XN\\:XSRDG+[7fgR\fW\u000e]:\u0015\r\u0005E\u00161XA_!\u0015y\u0011QMAZ!\u0019a\u00121N\u000e\u00026B\u0019q\"a.\n\u0007\u0005e\u0006C\u0001\u0003M_:<\u0007bBA9\u0003W\u0003\ra\u0007\u0005\b\u0003k\nY\u000b1\u0001\u001c\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007\f!bZ3u\u0005fLe\u000eZ3y)!\t\u0019'!2\u0002H\u0006%\u0007bBA9\u0003\u007f\u0003\ra\u0007\u0005\b\u0003k\ny\f1\u0001\u001c\u0011\u001d\tY-a0A\u0002m\t\u0011\"\u001b3y\u0007>dW/\u001c8\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002PRQ\u0011\u0011[Aj\u0003+\f9.!7\u0011\t=\t)g\u0007\u0005\b\u0003c\ni\r1\u0001\u001c\u0011\u001d\t)(!4A\u0002mAq!a3\u0002N\u0002\u00071\u0004C\u0004\u0002\\\u00065\u0007\u0019A\u000e\u0002\u0019A\u0014x\u000e]3sift\u0015-\\3\t\u000f\u0005}\u0007\u0001\"\u0001\u0002b\u00069r-\u001a;GSJ\u001cHOV1mk\u0016\u001chI]8n\u0013:$W\r\u001f\u000b\u000b\u0003G\n\u0019/!:\u0002h\u0006%\bbBA;\u0003;\u0004\ra\u0007\u0005\b\u0003\u0017\fi\u000e1\u0001\u001c\u0011\u0019\u0011\u0016Q\u001ca\u00017!A\u00111^Ao\u0001\u0004\ti/\u0001\btY&\u001cW\r\u0015:fI&\u001c\u0017\r^3\u0011\t\u0005=\u0015q^\u0005\u0005\u0003c\f\tJ\u0001\bTY&\u001cW\r\u0015:fI&\u001c\u0017\r^3\t\u000f\u0005}\u0003\u0001\"\u0001\u0002vRA\u0011\u0011[A|\u0003s\fY\u0010C\u0004\u0002r\u0005M\b\u0019A\u000e\t\u000f\u0005U\u00141\u001fa\u00017!9\u00111\\Az\u0001\u0004Y\u0002bBA\u0000\u0001\u0011\u0005!\u0011A\u0001\fO\u0016$8+\u001a7fGR,G\r\u0006\u0005\u0002d\t\r!Q\u0001B\u0004\u0011\u001d\t\t(!@A\u0002mAq!!\u001e\u0002~\u0002\u00071\u0004\u0003\u0005\u0003\n\u0005u\b\u0019\u0001B\u0006\u00035\u0001(o\u001c9feRLh*Y7fgB)!Q\u0002B\u000f79!!q\u0002B\r\u001d\u0011\u0011\tBa\u0006\u000e\u0005\tM!b\u0001B\u000b\u0019\u00051AH]8pizJ\u0011!E\u0005\u0004\u00057\u0001\u0012a\u00029bG.\fw-Z\u0005\u0005\u0005?\u0011\tCA\u0002TKFT1Aa\u0007\u0011\u0011\u001d\u0011)\u0003\u0001C\u0001\u0005O\t\u0001\u0002];u\u0005\u0006$8\r\u001b\u000b\u0007\u0003/\u0012ICa\u000b\t\u000f\u0005U$1\u0005a\u00017!A!Q\u0006B\u0012\u0001\u0004\u0011y#A\u0003cCR\u001c\u0007\u000e\u0005\u0004\u001d\u0003WZ\u0012\u0011\u000e\u0005\b\u0005g\u0001A\u0011\u0001B\u001b\u0003\r\u0001X\u000f\u001e\u000b\b7\t]\"\u0011\bB\u001e\u0011\u001d\t\tH!\rA\u0002mAq!!\u001e\u00032\u0001\u00071\u0004\u0003\u0005\u0003>\tE\u0002\u0019AA5\u00035YW-\u001f,bYV,\u0007+Y5sg\"9!1\u0007\u0001\u0005\u0002\t\u0005C#C\u000e\u0003D\t\u0015#q\tB%\u0011\u001d\t\tHa\u0010A\u0002mAq!!\u001e\u0003@\u0001\u00071\u0004C\u0004\u0002\\\n}\u0002\u0019A\u000e\t\u000f\t-#q\ba\u00017\u0005i\u0001O]8qKJ$\u0018PV1mk\u0016DqAa\u0014\u0001\t\u0003\u0011\t&A\u0004hKRd\u0015n\u001d;\u0016\t\tM#Q\f\u000b\u000b\u0005+\u0012yG!\u001d\u0003t\tU\u0004C\u0002B\u0007\u0005/\u0012I&\u0003\u0003\u0002\f\n\u0005\u0002\u0003\u0002B.\u0005;b\u0001\u0001\u0002\u0005\u0003`\t5#\u0019\u0001B1\u0005\u0005\t\u0015\u0003\u0002B2\u0005S\u00022a\u0004B3\u0013\r\u00119\u0007\u0005\u0002\b\u001d>$\b.\u001b8h!\ry!1N\u0005\u0004\u0005[\u0002\"aA!os\"9\u0011\u0011\u000fB'\u0001\u0004Y\u0002bBA;\u0005\u001b\u0002\ra\u0007\u0005\b\u00037\u0014i\u00051\u0001\u001c\u0011!\u00119H!\u0014A\u0002\te\u0014\u0001\u0003;iK\u000ec\u0017m]:1\t\tm$\u0011\u0012\t\u0007\u0005{\u0012\u0019Ia\"\u000e\u0005\t}$\u0002\u0002BA\u0003\u000b\u000bA\u0001\\1oO&!!Q\u0011B@\u0005\u0015\u0019E.Y:t!\u0011\u0011YF!#\u0005\u0019\t-%QOA\u0001\u0002\u0003\u0015\tA!\u0019\u0003\u0007}#\u0013\u0007C\u0004\u0003\u0010\u0002!\tA!%\u0002\u000fA,H\u000fT5tiV!!1\u0013BR)5Y\"Q\u0013BL\u00053\u0013YJ!*\u00032\"9\u0011\u0011\u000fBG\u0001\u0004Y\u0002bBA;\u0005\u001b\u0003\ra\u0007\u0005\b\u00037\u0014i\t1\u0001\u001c\u0011!\u0011iJ!$A\u0002\t}\u0015a\u00028fo2K7\u000f\u001e\t\u0007\u0005\u001b\u0011iB!)\u0011\t\tm#1\u0015\u0003\t\u0005?\u0012iI1\u0001\u0003b!A!q\u000fBG\u0001\u0004\u00119\u000b\r\u0003\u0003*\n5\u0006C\u0002B?\u0005\u0007\u0013Y\u000b\u0005\u0003\u0003\\\t5F\u0001\u0004BX\u0005K\u000b\t\u0011!A\u0003\u0002\t\u0005$aA0%e!A!1\u0017BG\u0001\u0004\u0011),A\u0005pm\u0016\u0014xO]5uKB\u0019qBa.\n\u0007\te\u0006CA\u0004C_>dW-\u00198\t\u000f\tu\u0006\u0001\"\u0001\u0003@\u0006A\u0001/Y4f\u001fZ,'\u000f\u0006\t\u0002X\t\u0005'1\u0019Bg\u0005#\u0014\u0019Na6\u0003\\\"9\u0011Q\u000fB^\u0001\u0004Y\u0002\u0002\u0003Bc\u0005w\u0003\rAa2\u0002\tA\u0014xn\u0019\t\t\u001f\t%7$!\u001b\u00036&\u0019!1\u001a\t\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004b\u0002Bh\u0005w\u0003\raJ\u0001\ta\u0006<WmU5{K\"A\u00111\u001eB^\u0001\u0004\ti\u000f\u0003\u0006\u0003V\nm\u0006\u0013!a\u0001\u0005k\u000b!b\u00195fG.,U\u000e\u001d;z\u0011%\u0011INa/\u0011\u0002\u0003\u00071$A\u0005ti\u0006\u0014H/V;jI\"I!Q\u001cB^!\u0003\u0005\raG\u0001\bK:$W+^5e\u0011\u001d\u0011\t\u000f\u0001C\u0005\u0005G\fQdZ3u\u0007>dW/\u001c8t\rJ|WNU8xg^KG\u000f\u001b*fiJLWm\u001d\u000b\r\u0005K\u0014yO!=\u0003|\nu8q\u0001\t\t\u0003\u007f\u00129O!;\u0002~%!\u0011QNAA!\u0011\tiAa;\n\t\t5\u0018q\u0002\u0002\u0006\u0005f$Xm\u001d\u0005\b\u0003k\u0012y\u000e1\u0001\u001c\u0011!\u0011\u0019Pa8A\u0002\tU\u0018\u0001C6fsJ\u000bgnZ3\u0011\t\u0005=%q_\u0005\u0005\u0005s\f\tJ\u0001\u0005LKf\u0014\u0016M\\4f\u0011!\tYOa8A\u0002\u00055\b\u0002\u0003B\u0000\u0005?\u0004\ra!\u0001\u0002\u0005\rd\u0007\u0003BAH\u0007\u0007IAa!\u0002\u0002\u0012\n\u00012i\u001c8tSN$XM\\2z\u0019\u00164X\r\u001c\u0005\b\u0007\u0013\u0011y\u000e1\u0001(\u0003A\u0001XM]7jiR,GMU3ue&,7\u000fC\u0004\u0004\u000e\u0001!\taa\u0004\u0002\u001dA\fw-Z(wKJ\u001cV\r\\3diRq\u0011qKB\t\u0007'\u0019)ba\u0006\u0004\u001a\rm\u0001bBA;\u0007\u0017\u0001\ra\u0007\u0005\t\u0005\u000b\u001cY\u00011\u0001\u0003H\"9!\u0011\\B\u0006\u0001\u0004Y\u0002b\u0002Bo\u0007\u0017\u0001\ra\u0007\u0005\b\u0005\u001f\u001cY\u00011\u0001(\u0011!\u0019iba\u0003A\u0002\r}\u0011AC2pYVlgNT1nKB!qb!\t\u001c\u0013\r\u0019\u0019\u0003\u0005\u0002\u000byI,\u0007/Z1uK\u0012t\u0004bBB\u0014\u0001\u0011\u00051\u0011F\u0001\u0014a\u0006<Wm\u0014<fe\u000e{G.^7o%\u0006tw-\u001a\u000b\u0011\u0003/\u001aYc!\f\u00040\rE21GB\u001b\u0007sAq!!\u001e\u0004&\u0001\u00071\u0004\u0003\u0005\u0003F\u000e\u0015\u0002\u0019\u0001Bd\u0011%\u0011In!\n\u0011\u0002\u0003\u00071\u0004C\u0005\u0003^\u000e\u0015\u0002\u0013!a\u00017!I!qZB\u0013!\u0003\u0005\ra\n\u0005\n\u0007o\u0019)\u0003%AA\u0002m\t1b\u001d;beR\u001cu\u000e\\;n]\"I11HB\u0013!\u0003\u0005\raG\u0001\nK:$7i\u001c7v[:Dqaa\u0010\u0001\t\u0003\u0019\t%A\u0006qC\u001e,wJ^3s\u00032dG\u0003DA,\u0007\u0007\u001a)ea\u0012\u0004J\r-\u0003bBA;\u0007{\u0001\ra\u0007\u0005\t\u0005\u000b\u001ci\u00041\u0001\u0003H\"I!\u0011\\B\u001f!\u0003\u0005\ra\u0007\u0005\n\u0005;\u001ci\u0004%AA\u0002mA\u0011Ba4\u0004>A\u0005\t\u0019A\u0014\t\u000f\r=\u0003\u0001\"\u0001\u0004R\u0005Q1/\u001a7fGR\u0014vn^:\u0015\u0015\u0005]31KB,\u00073\u001ai\u0006\u0003\u0005\u0004V\r5\u0003\u0019\u0001B\u0006\u0003\u001d\u0011xn^6fsNDq!!\u001e\u0004N\u0001\u00071\u0004\u0003\u0005\u0004\\\r5\u0003\u0019\u0001B\u0006\u0003\u00191\u0017.\u001a7eg\"A!QYB'\u0001\u0004\u0019y\u0006E\u0004\u0010\u0007C\nI'a\u0016\n\u0007\r\r\u0004CA\u0005Gk:\u001cG/[8oc!91q\r\u0001\u0005\u0012\r%\u0014AD2pYVlg\u000eT5tiJj\u0015\r\u001d\u000b\u0005\u0003S\u001aY\u0007\u0003\u0005\u0004n\r\u0015\u0004\u0019AA?\u0003)\u0019w\u000e\\;n]2K7\u000f\u001e\u0005\b\u0007c\u0002A\u0011CB:\u0003I\u0019w\u000e\\;n]2K7\u000f\u001e\u001aUS6,W*\u00199\u0015\t\u0005M6Q\u000f\u0005\t\u0007[\u001ay\u00071\u0001\u0002~!91\u0011\u0010\u0001\u0005\u0012\rm\u0014!C4fi\u000e{G.^7o)!\u0019iha \u0004\u0002\u000e\u0015\u0005#B\b\u0002f\u00055\u0005bBA9\u0007o\u0002\ra\u0007\u0005\b\u0007\u0007\u001b9\b1\u0001\u001c\u00031\u0019w\u000e\\;n]\u001a\u000bW.\u001b7z\u0011\u001d\u0019iba\u001eA\u0002mAqa!#\u0001\t\u0003\t)&\u0001\u0005tQV$Hm\\<o\u0011\u001d\u0019i\t\u0001C\u0001\u0007\u001f\u000bQ\u0002Z3mKR,7i\u001c7v[:\u001cH\u0003CA,\u0007#\u001b\u0019j!&\t\u000f\u0005E41\u0012a\u00017!9\u0011QOBF\u0001\u0004Y\u0002\u0002CB\u000f\u0007\u0017\u0003\raa\b\t\u000f\re\u0005\u0001\"\u0001\u0004\u001c\u00061A-\u001a7fi\u0016$b!a\u0016\u0004\u001e\u000e}\u0005bBA9\u0007/\u0003\ra\u0007\u0005\b\u0003k\u001a9\n1\u0001\u001c\u0011%\u0019\u0019\u000bAI\u0001\n\u0003\u0019)+\u0001\nqC\u001e,wJ^3sI\u0011,g-Y;mi\u0012*TCABTU\u0011\u0011)l!+,\u0005\r-\u0006\u0003BBW\u0007ok!aa,\u000b\t\rE61W\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!.\u0011\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007s\u001byKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011b!0\u0001#\u0003%\taa0\u0002%A\fw-Z(wKJ$C-\u001a4bk2$HEN\u000b\u0003\u0007\u0003T3aGBU\u0011%\u0019)\rAI\u0001\n\u0003\u0019y,\u0001\nqC\u001e,wJ^3sI\u0011,g-Y;mi\u0012:\u0004\"CBe\u0001E\u0005I\u0011IB`\u0003u\u0001\u0018mZ3Pm\u0016\u00148i\u001c7v[:\u0014\u0016M\\4fI\u0011,g-Y;mi\u0012\u001a\u0004\"CBg\u0001E\u0005I\u0011IB`\u0003u\u0001\u0018mZ3Pm\u0016\u00148i\u001c7v[:\u0014\u0016M\\4fI\u0011,g-Y;mi\u0012\"\u0004\"CBi\u0001E\u0005I\u0011IBj\u0003u\u0001\u0018mZ3Pm\u0016\u00148i\u001c7v[:\u0014\u0016M\\4fI\u0011,g-Y;mi\u0012*TCABkU\r93\u0011\u0016\u0005\n\u00073\u0004\u0011\u0013!C!\u0007\u007f\u000bQ\u0004]1hK>3XM]\"pYVlgNU1oO\u0016$C-\u001a4bk2$HE\u000e\u0005\n\u0007;\u0004\u0011\u0013!C!\u0007\u007f\u000bQ\u0004]1hK>3XM]\"pYVlgNU1oO\u0016$C-\u001a4bk2$He\u000e\u0005\n\u0007C\u0004\u0011\u0013!C!\u0007\u007f\u000bQ\u0003]1hK>3XM]!mY\u0012\"WMZ1vYR$3\u0007C\u0005\u0004f\u0002\t\n\u0011\"\u0011\u0004@\u0006)\u0002/Y4f\u001fZ,'/\u00117mI\u0011,g-Y;mi\u0012\"\u0004\"CBu\u0001E\u0005I\u0011IBj\u0003U\u0001\u0018mZ3Pm\u0016\u0014\u0018\t\u001c7%I\u00164\u0017-\u001e7uIU:\u0011b!<\u0003\u0003\u0003E\taa<\u00027\r\u000b7o]1oIJ\f\u0007+\u001a:tSN$XM\\2f\u001b\u0006t\u0017mZ3s!\r)2\u0011\u001f\u0004\t\u0003\t\t\t\u0011#\u0001\u0004tN\u00191\u0011\u001f\b\t\u000f\u0005\u001b\t\u0010\"\u0001\u0004xR\u00111q\u001e\u0005\u000b\u0007w\u001c\t0%A\u0005\u0002\r}\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\u0007\u0003\u0006\u0004\u0000\u000eE\u0018\u0013!C\u0001\u0007'\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0004B\u0003C\u0002\u0007c\f\n\u0011\"\u0001\u0004@\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIMB!\u0002b\u0002\u0004rF\u0005I\u0011AB`\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i!QA1BBy#\u0003%\taa5\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0011)!ya!=\u0012\u0002\u0013\u000511[\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\t\u0015\u0011M1\u0011_I\u0001\n\u0003\u0019\u0019.A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\u000e")
public class CassandraPersistenceManager
implements PersistenceManager {
    private final String host;
    private final int port;
    private final String poolName;
    private final String keyspace;
    private final int maxConnections;
    private final int maxRetries;
    private final int operationTimeout;
    private final Logger logger;
    private final int maxColumnLimit;
    private final Cluster cluster;
    private final CommonsBackedPool.Policy policy;
    private final OperandPolicy operandPolicy;

    public static int $lessinit$greater$default$7() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$7();
    }

    public static int $lessinit$greater$default$6() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$5() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$1() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public char fieldDelimiter() {
        return PersistenceManager$class.fieldDelimiter(this);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String poolName() {
        return this.poolName;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public int maxConnections() {
        return this.maxConnections;
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public int operationTimeout() {
        return this.operationTimeout;
    }

    public Logger logger() {
        return this.logger;
    }

    public int maxColumnLimit() {
        return this.maxColumnLimit;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public CommonsBackedPool.Policy policy() {
        return this.policy;
    }

    public OperandPolicy operandPolicy() {
        return this.operandPolicy;
    }

    public void initialise() {
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with pool name: ").append((Object)this.poolName()).toString());
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with hosts: ").append((Object)this.host()).toString());
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with port: ").append((Object)BoxesRunTime.boxToInteger((int)this.port())).toString());
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with max connections: ").append((Object)BoxesRunTime.boxToInteger((int)this.maxConnections())).toString());
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with max retries: ").append((Object)BoxesRunTime.boxToInteger((int)this.maxRetries())).toString());
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with operation timeout: ").append((Object)BoxesRunTime.boxToInteger((int)this.operationTimeout())).toString());
        Pelops.addPool((String)this.poolName(), (Cluster)this.cluster(), (String)this.keyspace(), (CommonsBackedPool.Policy)this.policy(), (OperandPolicy)this.operandPolicy());
    }

    @Override
    public Option<scala.collection.immutable.Map<String, String>> get(String uuid, String entityName) {
        Object object;
        Selector selector = Pelops.createSelector((String)this.poolName());
        SlicePredicate slicePredicate = Selector.newColumnsPredicateAll((boolean)true, (int)this.maxColumnLimit());
        try {
            java.util.List columnList = selector.getColumnsFromRow(entityName, uuid, slicePredicate, ConsistencyLevel.ONE);
            object = columnList.isEmpty() ? None$.MODULE$ : new Some(this.columnList2Map(columnList));
        }
        catch (Exception exception) {
            this.logger().trace(exception.getMessage(), (Throwable)exception);
            object = None$.MODULE$;
        }
        return object;
    }

    public Option<java.util.List<Column>> get(String uuid, String entityName, String startProperty, String endProperty) {
        Some some;
        Selector selector = Pelops.createSelector((String)this.poolName());
        SlicePredicate slicePredicate = Selector.newColumnsPredicate((String)startProperty, (String)endProperty, (boolean)false, (int)this.maxColumnLimit());
        try {
            some = new Some((Object)selector.getColumnsFromRow(entityName, uuid, slicePredicate, ConsistencyLevel.ONE));
        }
        catch (Exception exception) {
            some = None$.MODULE$;
        }
        return some;
    }

    @Override
    public Option<scala.collection.immutable.Map<String, Object>> getColumnsWithTimestamps(String uuid, String entityName) {
        Object object;
        Selector selector = Pelops.createSelector((String)this.poolName());
        SlicePredicate slicePredicate = Selector.newColumnsPredicateAll((boolean)true, (int)this.maxColumnLimit());
        try {
            java.util.List columnList = selector.getColumnsFromRow(entityName, uuid, slicePredicate, ConsistencyLevel.ONE);
            object = columnList.isEmpty() ? None$.MODULE$ : new Some(this.columnList2TimeMap(columnList));
        }
        catch (Exception exception) {
            this.logger().debug(exception.getMessage(), (Throwable)exception);
            object = None$.MODULE$;
        }
        return object;
    }

    @Override
    public Option<scala.collection.immutable.Map<String, String>> getByIndex(String uuid, String entityName, String idxColumn) {
        return this.getFirstValuesFromIndex(entityName, idxColumn, uuid, Selector.newColumnsPredicateAll((boolean)true, (int)this.maxColumnLimit()));
    }

    @Override
    public Option<String> getByIndex(String uuid, String entityName, String idxColumn, String propertyName) {
        Option<scala.collection.immutable.Map<String, String>> map = this.getFirstValuesFromIndex(entityName, idxColumn, uuid, Selector.newColumnsPredicate((String[])new String[]{propertyName}));
        return map.isEmpty() ? None$.MODULE$ : new Some(((MapLike)map.get()).getOrElse((Object)propertyName, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }));
    }

    public Option<scala.collection.immutable.Map<String, String>> getFirstValuesFromIndex(String entityName, String idxColumn, String value, SlicePredicate slicePredicate) {
        None$ none$;
        Selector selector = Pelops.createSelector((String)this.poolName());
        IndexClause indexClause = Selector.newIndexClause((String)value, (int)1, (IndexExpression[])new IndexExpression[]{Selector.newIndexExpression((String)idxColumn, (IndexOperator)IndexOperator.EQ, (Bytes)Bytes.fromUTF8((String)value))});
        try {
            LinkedHashMap columnMap = selector.getIndexedColumns(entityName, indexClause, slicePredicate, ConsistencyLevel.ONE);
            if (columnMap == null || columnMap.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                java.util.List columnList = (java.util.List)columnMap.entrySet().iterator().next().getValue();
                scala.collection.immutable.Map<String, String> map = this.columnList2Map(columnList);
                none$ = new Some(map);
            }
        }
        catch (Exception exception) {
            this.logger().warn(exception.getMessage(), (Throwable)exception);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Option<String> get(String uuid, String entityName, String propertyName) {
        None$ none$;
        try {
            Selector selector = Pelops.createSelector((String)this.poolName());
            Column column = selector.getColumnFromRow(entityName, uuid, propertyName, ConsistencyLevel.ONE);
            none$ = new Some((Object)new String(column.getValue(), "UTF-8"));
        }
        catch (Exception exception) {
            this.logger().error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        catch (NotFoundException notFoundException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Option<scala.collection.immutable.Map<String, String>> getSelected(String uuid, String entityName, Seq<String> propertyNames) {
        Object object;
        Selector selector = Pelops.createSelector((String)this.poolName());
        SlicePredicate slicePredicate = Selector.newColumnsPredicate((String[])((String[])propertyNames.toArray(ClassTag$.MODULE$.apply(String.class))));
        try {
            java.util.List columnList = selector.getColumnsFromRow(entityName, uuid, slicePredicate, ConsistencyLevel.ONE);
            object = columnList.isEmpty() ? None$.MODULE$ : new Some(this.columnList2Map(columnList));
        }
        catch (Exception exception) {
            this.logger().trace(exception.getMessage(), (Throwable)exception);
            object = None$.MODULE$;
        }
        return object;
    }

    @Override
    public void putBatch(String entityName, scala.collection.immutable.Map<String, scala.collection.immutable.Map<String, String>> batch) {
        Mutator mutator = Pelops.createMutator((String)this.poolName());
        batch.foreach((Function1)new Serializable(this, entityName, mutator){
            public static final long serialVersionUID = 0L;
            public final String entityName$1;
            public final Mutator mutator$1;

            public final void apply(Tuple2<String, scala.collection.immutable.Map<String, String>> uuidMap) {
                String uuid = (String)uuidMap._1();
                scala.collection.immutable.Map keyValuePairs = (scala.collection.immutable.Map)uuidMap._2();
                keyValuePairs.foreach((Function1)new Serializable(this, uuid){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$putBatch$1 $outer;
                    private final String uuid$1;

                    public final Mutator apply(Tuple2<String, String> keyValue) {
                        return this.$outer.mutator$1.writeColumn(this.$outer.entityName$1, this.uuid$1, this.$outer.mutator$1.newColumn((String)keyValue._1(), (String)keyValue._2()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.uuid$1 = uuid$1;
                    }
                });
            }
            {
                this.entityName$1 = entityName$1;
                this.mutator$1 = mutator$1;
            }
        });
        mutator.execute(ConsistencyLevel.ONE);
    }

    @Override
    public String put(String uuid, String entityName, scala.collection.immutable.Map<String, String> keyValuePairs) {
        String recordId = uuid == null ? UUID.randomUUID().toString() : uuid;
        Mutator mutator = Pelops.createMutator((String)this.poolName());
        keyValuePairs.foreach((Function1)new Serializable(this, entityName, recordId, mutator){
            public static final long serialVersionUID = 0L;
            private final String entityName$2;
            private final String recordId$1;
            private final Mutator mutator$2;

            public final Object apply(Tuple2<String, String> keyValue) {
                return keyValue._2() == null ? BoxedUnit.UNIT : this.mutator$2.writeColumn(this.entityName$2, this.recordId$1, this.mutator$2.newColumn((String)keyValue._1(), (String)keyValue._2()));
            }
            {
                this.entityName$2 = entityName$2;
                this.recordId$1 = recordId$1;
                this.mutator$2 = mutator$2;
            }
        });
        Object object = uuid == null ? mutator.writeColumn(entityName, recordId, mutator.newColumn("uuid", recordId)) : BoxedUnit.UNIT;
        mutator.execute(ConsistencyLevel.ONE);
        return recordId;
    }

    @Override
    public String put(String uuid, String entityName, String propertyName, String propertyValue) {
        String recordId = uuid == null ? UUID.randomUUID().toString() : uuid;
        Mutator mutator = Pelops.createMutator((String)this.poolName());
        mutator.writeColumn(entityName, recordId, mutator.newColumn(propertyName, propertyValue));
        Object object = uuid == null ? mutator.writeColumn(entityName, recordId, mutator.newColumn("uuid", recordId)) : BoxedUnit.UNIT;
        mutator.execute(ConsistencyLevel.ONE);
        return recordId;
    }

    @Override
    public <A> List<A> getList(String uuid, String entityName, String propertyName, Class<?> theClass) {
        List list;
        Option<Column> column = this.getColumn(uuid, entityName, propertyName);
        if (column.isEmpty()) {
            list = Nil$.MODULE$;
        } else {
            String json = new String(((Column)column.get()).getValue());
            list = Json$.MODULE$.toListWithGeneric(json, theClass);
        }
        return list;
    }

    @Override
    public <A> String putList(String uuid, String entityName, String propertyName, Seq<A> newList, Class<?> theClass, boolean overwrite) {
        Mutator mutator;
        String recordId = uuid == null ? UUID.randomUUID().toString() : uuid;
        Mutator mutator2 = Pelops.createMutator((String)this.poolName());
        if (overwrite) {
            String json = Json$.MODULE$.toJSONWithGeneric(newList);
            mutator = mutator2.writeColumn(entityName, recordId, mutator2.newColumn(propertyName, json));
        } else {
            Option<Column> column = this.getColumn(uuid, entityName, propertyName);
            if (column.isEmpty()) {
                String json = Json$.MODULE$.toJSONWithGeneric(newList);
                mutator = mutator2.writeColumn(entityName, recordId, mutator2.newColumn(propertyName, json));
            } else {
                String currentJson = new String(((Column)column.get()).getValue());
                List currentList = Json$.MODULE$.toListWithGeneric(currentJson, theClass);
                ObjectRef buffer = new ObjectRef((Object)new ListBuffer());
                currentList.foreach((Function1)new Serializable(this, newList, buffer){
                    public static final long serialVersionUID = 0L;
                    private final Seq newList$1;
                    private final ObjectRef buffer$1;

                    public final Object apply(Nothing$ theObject) {
                        Seq seq = this.newList$1;
                        throw theObject;
                    }
                    {
                        this.newList$1 = newList$1;
                        this.buffer$1 = buffer$1;
                    }
                });
                ((ListBuffer)buffer.elem).$plus$plus$eq(newList);
                String newJson = Json$.MODULE$.toJSONWithGeneric(((ListBuffer)buffer.elem).toList());
                mutator = mutator2.writeColumn(entityName, recordId, mutator2.newColumn(propertyName, newJson));
            }
        }
        mutator2.execute(ConsistencyLevel.ONE);
        return recordId;
    }

    public void pageOver(String entityName, Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, int pageSize, SlicePredicate slicePredicate, boolean checkEmpty, String startUuid, String endUuid) {
        Bytes startKey = new Bytes(startUuid.getBytes());
        Bytes endKey = new Bytes(endUuid.getBytes());
        KeyRange keyRange = Selector.newKeyRange((Bytes)startKey, (Bytes)endKey, (int)(pageSize + 1));
        boolean hasMore = true;
        int counter = 0;
        BooleanRef booleanRef = new BooleanRef(true);
        ObjectRef columnMap = new ObjectRef(this.getColumnsFromRowsWithRetries(entityName, keyRange, slicePredicate, ConsistencyLevel.ONE, 10));
        while (!((Map)columnMap.elem).isEmpty() && booleanRef.elem) {
            List columnsObj;
            List keys = columnsObj = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(((Map)columnMap.elem).keySet().toArray()));
            startKey = (Bytes)keys.last();
            keys.foreach((Function1)new Serializable(this, proc, checkEmpty, booleanRef, columnMap){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraPersistenceManager $outer;
                private final Function2 proc$1;
                private final boolean checkEmpty$1;
                private final BooleanRef continue$1;
                private final ObjectRef columnMap$1;

                public final void apply(Bytes buuid) {
                    java.util.List columnList = (java.util.List)((Map)this.columnMap$1.elem).get(buuid);
                    if (!this.checkEmpty$1 || !columnList.isEmpty()) {
                        scala.collection.immutable.Map<String, String> map = this.$outer.columnList2Map(columnList);
                        String uuid = (String)map.getOrElse((Object)"rowKey", (Function0)new Serializable(this, buuid){
                            public static final long serialVersionUID = 0L;
                            private final Bytes buuid$1;

                            public final String apply() {
                                return this.buuid$1.toUTF8();
                            }
                            {
                                this.buuid$1 = buuid$1;
                            }
                        });
                        this.continue$1.elem = BoxesRunTime.unboxToBoolean((Object)this.proc$1.apply((Object)uuid, map));
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.proc$1 = proc$1;
                    this.checkEmpty$1 = checkEmpty$1;
                    this.continue$1 = continue$1;
                    this.columnMap$1 = columnMap$1;
                }
            });
            counter += keys.size();
            keyRange = Selector.newKeyRange((Bytes)startKey, (Bytes)endKey, (int)(pageSize + 1));
            columnMap.elem = this.getColumnsFromRowsWithRetries(entityName, keyRange, slicePredicate, ConsistencyLevel.ONE, 10);
            ((Map)columnMap.elem).remove(startKey);
        }
        if (counter > 0) {
            this.logger().debug(new StringBuilder().append((Object)"Finished paging. Records paged over : ").append((Object)BoxesRunTime.boxToInteger((int)counter)).toString());
        }
    }

    public boolean pageOver$default$5() {
        return false;
    }

    public String pageOver$default$6() {
        return "";
    }

    public String pageOver$default$7() {
        return "";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Bytes, java.util.List<Column>> getColumnsFromRowsWithRetries(String entityName, KeyRange keyRange, SlicePredicate slicePredicate, ConsistencyLevel cl, int permittedRetries) {
        boolean success = false;
        boolean noOfRetries = false;
        HashMap columnMap = null;
        while (!success) {
            try {
                Selector selector = Pelops.createSelector((String)this.poolName());
                LinkedHashMap linkedHashMap = selector.getColumnsFromRows(entityName, keyRange, slicePredicate, cl);
                boolean bl = true;
                continue;
            }
            catch (Exception exception) {
                void var7_7;
                this.logger().debug(new StringBuilder().append((Object)"Problem retrieving data. Number of retries left:").append((Object)BoxesRunTime.boxToInteger((int)(permittedRetries - var7_7))).append((Object)", Error: ").append((Object)exception.getMessage()).toString());
                Thread.sleep(20000L);
                this.initialise();
                if (var7_7 == permittedRetries) {
                    this.logger().error(new StringBuilder().append((Object)"Problem retrieving data. Number of DB connection retries exceeded. Error: ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
                    throw new RuntimeException(exception);
                }
                ++var7_7;
                continue;
            }
            break;
        }
        return columnMap;
    }

    @Override
    public void pageOverSelect(String entityName, Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, String startUuid, String endUuid, int pageSize, Seq<String> columnName) {
        SlicePredicate slicePredicate = Selector.newColumnsPredicate((String[])((String[])columnName.toArray(ClassTag$.MODULE$.apply(String.class))));
        String x$1 = entityName;
        Function2<String, scala.collection.immutable.Map<String, String>, Object> x$2 = proc;
        int x$3 = pageSize;
        SlicePredicate x$4 = slicePredicate;
        String x$5 = startUuid;
        String x$6 = endUuid;
        boolean x$7 = this.pageOver$default$5();
        this.pageOver(x$1, x$2, x$3, x$4, x$7, x$5, x$6);
    }

    @Override
    public void pageOverColumnRange(String entityName, Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, String startUuid, String endUuid, int pageSize, String startColumn, String endColumn) {
        SlicePredicate slicePredicate = Selector.newColumnsPredicate((String)startColumn, (String)endColumn, (boolean)false, (int)this.maxColumnLimit());
        Bytes startKey = new Bytes(startUuid.getBytes());
        Bytes endKey = new Bytes(endUuid.getBytes());
        KeyRange keyRange = Selector.newKeyRange((Bytes)startKey, (Bytes)endKey, (int)(pageSize + 1));
        boolean hasMore = true;
        int counter = 0;
        BooleanRef booleanRef = new BooleanRef(true);
        ObjectRef columnMap = new ObjectRef(this.getColumnsFromRowsWithRetries(entityName, keyRange, slicePredicate, ConsistencyLevel.ONE, 10));
        while (!((Map)columnMap.elem).isEmpty() && booleanRef.elem) {
            List columnsObj;
            List keys = columnsObj = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(((Map)columnMap.elem).keySet().toArray()));
            startKey = (Bytes)keys.last();
            keys.foreach((Function1)new Serializable(this, entityName, proc, endColumn, booleanRef, columnMap){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraPersistenceManager $outer;
                private final String entityName$3;
                private final Function2 proc$2;
                private final String endColumn$1;
                private final BooleanRef continue$2;
                private final ObjectRef columnMap$2;

                public final void apply(Bytes buuid) {
                    java.util.List columnList = (java.util.List)((Map)this.columnMap$2.elem).get(buuid);
                    boolean moreCols = true;
                    String uuid = buuid.toUTF8();
                    String startCol = new String(((Column)columnList.get(columnList.size() - 1)).getName(), "UTF-8");
                    while (moreCols) {
                        Option<java.util.List<Column>> nextCols = this.$outer.get(uuid, this.entityName$3, startCol, this.endColumn$1);
                        if (!nextCols.isDefined()) continue;
                        ((java.util.List)nextCols.get()).remove(0);
                        if (((java.util.List)nextCols.get()).isEmpty()) {
                            moreCols = false;
                            continue;
                        }
                        columnList.addAll((Collection)nextCols.get());
                        startCol = new String(((Column)columnList.get(columnList.size() - 1)).getName(), "UTF-8");
                    }
                    if (!columnList.isEmpty()) {
                        scala.collection.immutable.Map<String, String> map = this.$outer.columnList2Map(columnList);
                        this.continue$2.elem = BoxesRunTime.unboxToBoolean((Object)this.proc$2.apply((Object)uuid, map));
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.entityName$3 = entityName$3;
                    this.proc$2 = proc$2;
                    this.endColumn$1 = endColumn$1;
                    this.continue$2 = continue$2;
                    this.columnMap$2 = columnMap$2;
                }
            });
            counter += keys.size();
            keyRange = Selector.newKeyRange((Bytes)startKey, (Bytes)endKey, (int)(pageSize + 1));
            columnMap.elem = this.getColumnsFromRowsWithRetries(entityName, keyRange, slicePredicate, ConsistencyLevel.ONE, 10);
            ((Map)columnMap.elem).remove(startKey);
        }
        if (counter > 0) {
            this.logger().debug(new StringBuilder().append((Object)"Finished paging. Records paged over : ").append((Object)BoxesRunTime.boxToInteger((int)counter)).toString());
        }
    }

    @Override
    public String pageOverColumnRange$default$3() {
        return "";
    }

    @Override
    public String pageOverColumnRange$default$4() {
        return "";
    }

    @Override
    public int pageOverColumnRange$default$5() {
        return 1000;
    }

    @Override
    public String pageOverColumnRange$default$6() {
        return "";
    }

    @Override
    public String pageOverColumnRange$default$7() {
        return "";
    }

    @Override
    public void pageOverAll(String entityName, Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, String startUuid, String endUuid, int pageSize) {
        SlicePredicate slicePredicate = Selector.newColumnsPredicateAll((boolean)true, (int)this.maxColumnLimit());
        this.pageOver(entityName, proc, pageSize, slicePredicate, true, startUuid, endUuid);
    }

    @Override
    public String pageOverAll$default$3() {
        return "";
    }

    @Override
    public String pageOverAll$default$4() {
        return "";
    }

    @Override
    public int pageOverAll$default$5() {
        return 1000;
    }

    @Override
    public void selectRows(Seq<String> rowkeys, String entityName, Seq<String> fields, Function1<scala.collection.immutable.Map<String, String>, BoxedUnit> proc) {
        Selector selector = Pelops.createSelector((String)this.poolName());
        SlicePredicate slicePredicate = Selector.newColumnsPredicate((String[])((String[])fields.toArray(ClassTag$.MODULE$.apply(String.class))));
        LinkedHashMap columnMap = selector.getColumnsFromRowsUtf8Keys(entityName, JavaConversions$.MODULE$.seqAsJavaList((Seq)rowkeys.toList()), slicePredicate, ConsistencyLevel.ONE);
        List keys = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(columnMap.keySet().toArray()));
        keys.foreach((Function1)new Serializable(this, proc, columnMap){
            public static final long serialVersionUID = 0L;
            private final Function1 proc$3;
            private final LinkedHashMap columnMap$3;

            public final void apply(Object key) {
                java.util.List columnsList = (java.util.List)this.columnMap$3.get(key);
                Tuple2[] fieldValues = (Tuple2[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(columnsList).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(Column column) {
                        return new Tuple2((Object)new String(column.getName(), "UTF-8"), (Object)new String(column.getValue(), "UTF-8"));
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                scala.collection.mutable.Map map = Map$.MODULE$.empty();
                Predef$.MODULE$.refArrayOps((Object[])fieldValues).foreach((Function1)new Serializable(this, map){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.mutable.Map map$1;

                    public final void apply(Tuple2<String, String> fieldValue) {
                        this.map$1.update(fieldValue._1(), fieldValue._2());
                    }
                    {
                        this.map$1 = map$1;
                    }
                });
                this.proc$3.apply((Object)map.toMap(Predef$.MODULE$.conforms()));
            }
            {
                this.proc$3 = proc$3;
                this.columnMap$3 = columnMap$3;
            }
        });
    }

    public scala.collection.immutable.Map<String, String> columnList2Map(java.util.List<Column> columnList) {
        scala.collection.mutable.HashMap map = new scala.collection.mutable.HashMap();
        for (Column c : columnList) {
            map.put((Object)new String(c.getName(), "UTF-8"), (Object)new String(c.getValue(), "UTF-8"));
        }
        return map.toMap(Predef$.MODULE$.conforms());
    }

    public scala.collection.immutable.Map<String, Object> columnList2TimeMap(java.util.List<Column> columnList) {
        scala.collection.mutable.HashMap map = new scala.collection.mutable.HashMap();
        for (Column c : columnList) {
            map.put((Object)new String(c.getName(), "UTF-8"), (Object)BoxesRunTime.boxToLong((long)(c.getTimestamp() / 1000L)));
        }
        return map.toMap(Predef$.MODULE$.conforms());
    }

    public Option<Column> getColumn(String uuid, String columnFamily, String columnName) {
        Some some;
        try {
            Selector selector = Pelops.createSelector((String)this.poolName());
            some = new Some((Object)selector.getColumnFromRow(columnFamily, uuid, columnName, ConsistencyLevel.ONE));
        }
        catch (Exception exception) {
            this.logger().debug(new StringBuilder().append((Object)exception.getMessage()).append((Object)" for ").append((Object)uuid).append((Object)" - ").append((Object)columnFamily).append((Object)" - ").append((Object)columnName).toString());
            some = None$.MODULE$;
        }
        return some;
    }

    @Override
    public void shutdown() {
        try {
            Pelops.shutdown();
        }
        catch (Exception exception) {
            this.logger().warn(exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public void deleteColumns(String uuid, String entityName, Seq<String> columnName) {
        if (uuid != null && entityName != null && columnName != null) {
            Mutator mutator = Pelops.createMutator((String)this.poolName());
            mutator.deleteColumns(entityName, uuid, (String[])columnName.toArray(ClassTag$.MODULE$.apply(String.class)));
            mutator.execute(ConsistencyLevel.ONE);
        }
    }

    @Override
    public void delete(String uuid, String entityName) {
        if (uuid != null && entityName != null) {
            RowDeletor deletor = Pelops.createRowDeletor((String)this.poolName());
            deletor.deleteRow(entityName, uuid, ConsistencyLevel.ONE);
        }
    }

    @Inject
    public CassandraPersistenceManager(@Named(value="cassandra.hosts") String host, @Named(value="cassandra.port") int port, @Named(value="cassandra.pool") String poolName, @Named(value="cassandra.keyspace") String keyspace, @Named(value="cassandra.max.connections") int maxConnections, @Named(value="cassandra.max.retries") int maxRetries, @Named(value="thrift.operation.timeout") int operationTimeout) {
        this.host = host;
        this.port = port;
        this.poolName = poolName;
        this.keyspace = keyspace;
        this.maxConnections = maxConnections;
        this.maxRetries = maxRetries;
        this.operationTimeout = operationTimeout;
        PersistenceManager$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"CassandraPersistenceManager");
        this.maxColumnLimit = 10000;
        this.cluster = new Cluster(host, port, operationTimeout, false);
        this.policy = new CommonsBackedPool.Policy();
        this.policy().setMaxTotal(maxConnections);
        this.policy().setMaxWaitForConnection(3 * operationTimeout);
        this.operandPolicy = new OperandPolicy(maxRetries, false);
        this.initialise();
    }
}

