/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.load.ImageSize;
import au.org.ala.biocache.load.LARGE$;
import au.org.ala.biocache.load.MediaStore$;
import au.org.ala.biocache.load.SMALL$;
import au.org.ala.biocache.load.THUMB$;
import au.org.ala.biocache.load.ThumbnailableImage;
import au.org.ala.biocache.util.OptionParser;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class Thumbnailer$ {
    public static final Thumbnailer$ MODULE$;
    private final Logger logger;

    static {
        new Thumbnailer$();
    }

    public final Logger logger() {
        return this.logger;
    }

    public void main(String[] args) {
        ObjectRef directoryPath = new ObjectRef((Object)"");
        ObjectRef filePath = new ObjectRef((Object)"");
        OptionParser parser = new OptionParser(directoryPath, filePath){
            {
                this.opt("f", "absolute-file-path", "File path to image to generate thumbnails for", (Function1<String, BoxedUnit>)new Serializable(this, filePath$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef filePath$1;

                    public final void apply(String v) {
                        this.filePath$1.elem = v;
                    }
                    {
                        this.filePath$1 = filePath$1;
                    }
                });
                this.opt("d", "absolute-directory-path", "Directory path to recursively", (Function1<String, BoxedUnit>)new Serializable(this, directoryPath$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef directoryPath$1;

                    public final void apply(String v) {
                        this.directoryPath$1.elem = v;
                    }
                    {
                        this.directoryPath$1 = directoryPath$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            String string = (String)filePath.elem;
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.generateAllSizes(new File((String)filePath.elem));
            }
            String string3 = (String)directoryPath.elem;
            String string4 = "";
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                this.recursivelyGenerateThumbnails(new File((String)directoryPath.elem));
            }
        }
    }

    public void recursivelyGenerateThumbnails(File directory) {
        this.logger().info(new StringBuilder().append((Object)"Starting with directory: ").append((Object)directory.getAbsolutePath()).toString());
        if (directory.isDirectory()) {
            ObjectRef children = new ObjectRef((Object)directory.list());
            if ((String[])children.elem == null) {
                children.elem = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
            }
            this.logger().info(new StringBuilder().append((Object)"Recursive Dir: ").append((Object)directory.getName()).append((Object)", size of subDirs: ").append((Object)BoxesRunTime.boxToInteger((int)((String[])children.elem).length)).toString());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ((String[])children.elem).length).foreach$mVc$sp((Function1)new Serializable(directory, children){
                public static final long serialVersionUID = 0L;
                private final File directory$1;
                private final ObjectRef children$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    Thumbnailer$.MODULE$.recursivelyGenerateThumbnails(new File(this.directory$1, ((String[])this.children$1.elem)[i]));
                }
                {
                    this.directory$1 = directory$1;
                    this.children$1 = children$1;
                }
            });
        } else if (MediaStore$.MODULE$.isValidImageURL(directory.getAbsolutePath())) {
            this.generateAllSizes(directory);
        }
    }

    public void generateAllSizes(File source) {
        String fileName = source.getName();
        if (!(fileName.contains(THUMB$.MODULE$.suffix()) || fileName.contains(SMALL$.MODULE$.suffix()) || fileName.contains(LARGE$.MODULE$.suffix()))) {
            this.generateThumbnail(source, THUMB$.MODULE$);
            this.generateThumbnail(source, SMALL$.MODULE$);
            this.generateThumbnail(source, LARGE$.MODULE$);
        }
    }

    public void generateThumbnail(File source, ImageSize imageSize) {
        String extension = FilenameUtils.getExtension((String)source.getAbsolutePath());
        String targetFilePath = source.getAbsolutePath().replace(new StringBuilder().append((Object)".").append((Object)extension).toString(), new StringBuilder().append((Object)imageSize.suffix()).append((Object)".").append((Object)extension).toString());
        File target = new File(targetFilePath);
        this.generateThumbnail(source, target, imageSize.size());
    }

    public void generateThumbnail(File source, File target, float thumbnailSize) {
        ThumbnailableImage t = new ThumbnailableImage(source);
        t.writeThumbnailToFile(target, thumbnailSize);
    }

    private Thumbnailer$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"Thumbnailer");
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
    }
}

