/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.load.SameNameDifferentExtensionFilter;
import au.org.ala.biocache.load.Thumbnailer$;
import au.org.ala.biocache.model.FullRecord;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class MediaStore$ {
    public static final MediaStore$ MODULE$;
    private final Logger logger;
    private Regex imageParser;
    private Regex soundParser;
    private Regex videoParser;
    private final String[] imageExtension;
    private final String[] soundExtension;
    private final String[] videoExtension;
    private final int limit;
    private volatile byte bitmap$0;

    static {
        new MediaStore$();
    }

    private Regex imageParser$lzycompute() {
        MediaStore$ mediaStore$ = this;
        synchronized (mediaStore$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.imageParser = new StringOps(Predef$.MODULE$.augmentString("^(https?://[^\\'\"<>]+?\\.(jpg|jpeg|gif|png))$")).r();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.imageParser;
        }
    }

    private Regex soundParser$lzycompute() {
        MediaStore$ mediaStore$ = this;
        synchronized (mediaStore$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.soundParser = new StringOps(Predef$.MODULE$.augmentString("^(https?://[^\\'\"<>]+?\\.(?:wav|mp3|ogg|flac))$")).r();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.soundParser;
        }
    }

    private Regex videoParser$lzycompute() {
        MediaStore$ mediaStore$ = this;
        synchronized (mediaStore$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.videoParser = new StringOps(Predef$.MODULE$.augmentString("^(https?://[^\\'\"<>]+?\\.(?:wmv|mp4|mpg|avi|mov))$")).r();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.videoParser;
        }
    }

    public Logger logger() {
        return this.logger;
    }

    public Regex imageParser() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.imageParser$lzycompute() : this.imageParser;
    }

    public Regex soundParser() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.soundParser$lzycompute() : this.soundParser;
    }

    public Regex videoParser() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.videoParser$lzycompute() : this.videoParser;
    }

    public String[] imageExtension() {
        return this.imageExtension;
    }

    public String[] soundExtension() {
        return this.soundExtension;
    }

    public String[] videoExtension() {
        return this.videoExtension;
    }

    public int limit() {
        return this.limit;
    }

    public boolean doesFileExist(String urlString) {
        boolean bl;
        String urlToTest = urlString.startsWith(Config$.MODULE$.mediaFileStore()) ? new StringBuilder().append((Object)"file://").append((Object)urlString).toString() : urlString;
        InputStream in = null;
        try {
            URL url = new URL(urlToTest.replaceAll(" ", "%20"));
            in = url.openStream();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return bl;
    }

    public boolean isValidImageURL(String url) {
        return !this.imageParser().unapplySeq((Object)url.trim().toLowerCase()).isEmpty() || this.isStoredMedia(this.imageExtension(), url);
    }

    public boolean isValidSoundURL(String url) {
        return !this.soundParser().unapplySeq((Object)url.trim().toLowerCase()).isEmpty() || this.isStoredMedia(this.soundExtension(), url);
    }

    public boolean isValidVideoURL(String url) {
        return !this.videoParser().unapplySeq((Object)url.trim().toLowerCase()).isEmpty() || this.isStoredMedia(this.videoExtension(), url);
    }

    public boolean isMediaFile(File file) {
        String name = file.getAbsolutePath();
        return this.endsWithOneOf(this.imageExtension(), name) || this.endsWithOneOf(this.soundExtension(), name) || this.endsWithOneOf(this.videoExtension(), name);
    }

    public boolean isStoredMedia(String[] acceptedExtensions, String url) {
        return url.startsWith(Config$.MODULE$.mediaFileStore()) && this.endsWithOneOf(acceptedExtensions, url.toLowerCase());
    }

    public boolean endsWithOneOf(String[] acceptedExtensions, String url) {
        return !Predef$.MODULE$.refArrayOps((Object[])acceptedExtensions).collectFirst((PartialFunction)new Serializable(url){
            public static final long serialVersionUID = 0L;
            private final String url$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.url$1.endsWith(A1) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                boolean bl = this.url$1.endsWith(string);
                return bl;
            }
            {
                this.url$1 = url$1;
            }
        }).isEmpty();
    }

    public void convertPathsToUrls(FullRecord fullRecord, String baseUrlPath) {
        if (fullRecord.occurrence().images() != null) {
            fullRecord.occurrence().images_$eq((String[])Predef$.MODULE$.refArrayOps((Object[])fullRecord.occurrence().images()).map((Function1)new Serializable(baseUrlPath){
                public static final long serialVersionUID = 0L;
                private final String baseUrlPath$1;

                public final String apply(String x) {
                    return MediaStore$.MODULE$.convertPathToUrl(x, this.baseUrlPath$1);
                }
                {
                    this.baseUrlPath$1 = baseUrlPath$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
    }

    public String convertPathToUrl(String str, String baseUrlPath) {
        return str.replaceAll(Config$.MODULE$.mediaFileStore(), baseUrlPath);
    }

    public Tuple2<String, Object> exists(String uuid, String resourceUID, String urlToMedia) {
        String path = this.createFilePath(uuid, resourceUID, urlToMedia);
        return new Tuple2((Object)path, (Object)BoxesRunTime.boxToBoolean((boolean)new File(path).exists()));
    }

    public String createFilePath(String uuid, String resourceUID, String urlToMedia) {
        int subdirectory = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(uuid.hashCode() % this.limit()));
        String absoluteDirectoryPath = new StringBuilder().append((Object)Config$.MODULE$.mediaFileStore()).append((Object)File.separator).append((Object)resourceUID).append((Object)File.separator).append((Object)BoxesRunTime.boxToInteger((int)subdirectory)).append((Object)File.separator).append((Object)uuid).toString();
        File directory = new File(absoluteDirectoryPath);
        if (!directory.exists()) {
            FileUtils.forceMkdir((File)directory);
        }
        String fileName = urlToMedia.contains("fileName=") ? urlToMedia.substring(urlToMedia.indexOf("fileName=") + "fileName=".length()).replace(" ", "_") : (urlToMedia.contains("?id=") && urlToMedia.contains("imgType=") ? urlToMedia.substring(urlToMedia.lastIndexOf("/") + 1).replace("?id=", "").replace("&imgType=", ".") : (urlToMedia.lastIndexOf("/") == urlToMedia.length() - 1 ? "raw" : urlToMedia.substring(urlToMedia.lastIndexOf("/") + 1).replace(" ", "_")));
        return new StringBuilder().append((Object)directory.getAbsolutePath()).append((Object)File.separator).append((Object)fileName).toString();
    }

    public Option<String> save(String uuid, String resourceUID, String urlToMedia) {
        None$ none$;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            String fullPath = this.createFilePath(uuid, resourceUID, urlToMedia);
            File file = new File(fullPath);
            if (file.exists() && file.length() != 0L) {
                this.logger().info(new StringBuilder().append((Object)"File previously saved to: ").append((Object)fullPath).toString());
            } else {
                URL url = new URL(urlToMedia.replaceAll(" ", "%20"));
                in = url.openStream();
                out = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                int numRead = 0;
                while ((numRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, numRead);
                    out.flush();
                }
                this.logger().info(new StringBuilder().append((Object)"File saved to: ").append((Object)fullPath).toString());
                if (this.isValidImageURL(urlToMedia)) {
                    Thumbnailer$.MODULE$.generateAllSizes(new File(fullPath));
                }
            }
            none$ = new Some((Object)fullPath);
        }
        catch (Exception exception) {
            this.logger().warn(new StringBuilder().append((Object)"Unable to load media ").append((Object)urlToMedia).append((Object)". ").append((Object)exception.getMessage()).toString());
            none$ = None$.MODULE$;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return none$;
    }

    public String[] alternativeFormats(String filePath) {
        boolean bl;
        block4: {
            String[] stringArray;
            block3: {
                block2: {
                    File file = new File(filePath);
                    bl = file.exists();
                    if (!bl) break block2;
                    String[] filenames = file.getParentFile().list(new SameNameDifferentExtensionFilter(filePath));
                    stringArray = (String[])Predef$.MODULE$.refArrayOps((Object[])filenames).map((Function1)new Serializable(file){
                        public static final long serialVersionUID = 0L;
                        private final File file$1;

                        public final String apply(String f) {
                            return new StringBuilder().append((Object)this.file$1.getParent()).append((Object)File.separator).append((Object)f).toString();
                        }
                        {
                            this.file$1 = file$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                    break block3;
                }
                if (bl) break block4;
                stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
            }
            return stringArray;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private MediaStore$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"MediaStore");
        this.imageExtension = (String[])((Object[])new String[]{".jpg", ".gif", ".png", ".jpeg", "imgType=jpeg"});
        this.soundExtension = (String[])((Object[])new String[]{".wav", ".mp3", ".ogg", ".flac"});
        this.videoExtension = (String[])((Object[])new String[]{".wmv", ".mp4", ".mpg", ".avi", ".mov"});
        this.limit = 32000;
    }
}

