/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.index;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.ObserverCallback;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.index.IndexDAO;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.parser.DateParser$;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.OptionParser;
import au.org.ala.biocache.util.StringConsumer;
import java.io.File;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

public final class IndexRecords$ {
    public static final IndexRecords$ MODULE$;
    private final Logger logger;
    private final IndexDAO indexer;
    private final OccurrenceDAO occurrenceDAO;
    private final PersistenceManager persistenceManager;

    static {
        new IndexRecords$();
    }

    public Logger logger() {
        return this.logger;
    }

    public IndexDAO indexer() {
        return this.indexer;
    }

    public OccurrenceDAO occurrenceDAO() {
        return this.occurrenceDAO;
    }

    public PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    public void main(String[] args) {
        ObjectRef startUuid = new ObjectRef((Object)None$.MODULE$);
        ObjectRef endUuid = new ObjectRef((Object)None$.MODULE$);
        ObjectRef dataResource = new ObjectRef((Object)None$.MODULE$);
        BooleanRef empty = new BooleanRef(false);
        BooleanRef check = new BooleanRef(false);
        ObjectRef startDate = new ObjectRef((Object)None$.MODULE$);
        IntRef pageSize = new IntRef(1000);
        ObjectRef uuidFile = new ObjectRef((Object)"");
        ObjectRef rowKeyFile = new ObjectRef((Object)"");
        IntRef threads = new IntRef(1);
        BooleanRef test = new BooleanRef(false);
        OptionParser parser = new OptionParser(startUuid, endUuid, dataResource, empty, check, startDate, pageSize, uuidFile, rowKeyFile, threads, test){
            {
                this.opt("empty", "empty the index first", (Function0<BoxedUnit>)new Serializable(this, empty$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef empty$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.empty$1.elem = true;
                    }
                    {
                        this.empty$1 = empty$1;
                    }
                });
                this.opt("check", "check to see if the record is deleted before indexing", (Function0<BoxedUnit>)new Serializable(this, check$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef check$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.check$1.elem = true;
                    }
                    {
                        this.check$1 = check$1;
                    }
                });
                this.opt("s", "start", "The record to start with", (Function1<String, BoxedUnit>)new Serializable(this, startUuid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef startUuid$1;

                    public final void apply(String v) {
                        this.startUuid$1.elem = new Some((Object)v);
                    }
                    {
                        this.startUuid$1 = startUuid$1;
                    }
                });
                this.opt("e", "end", "The record to end with", (Function1<String, BoxedUnit>)new Serializable(this, endUuid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef endUuid$1;

                    public final void apply(String v) {
                        this.endUuid$1.elem = new Some((Object)v);
                    }
                    {
                        this.endUuid$1 = endUuid$1;
                    }
                });
                this.opt("dr", "resource", "The data resource to process", (Function1<String, BoxedUnit>)new Serializable(this, dataResource$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dataResource$1;

                    public final void apply(String v) {
                        this.dataResource$1.elem = new Some((Object)v);
                    }
                    {
                        this.dataResource$1 = dataResource$1;
                    }
                });
                this.opt("date", "date", "The earliest modification date for records to be indexed. Date in the form yyyy-mm-dd", (Function1<String, BoxedUnit>)new Serializable(this, startDate$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef startDate$1;

                    public final void apply(String v) {
                        this.startDate$1.elem = new Some((Object)v);
                    }
                    {
                        this.startDate$1 = startDate$1;
                    }
                });
                this.intOpt("ps", "pageSize", "The page size for indexing", (Function1<Object, BoxedUnit>)new Serializable(this, pageSize$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef pageSize$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.pageSize$1.elem = v;
                    }
                    {
                        this.pageSize$1 = pageSize$1;
                    }
                });
                this.opt("if", "file-uuids-to-index", "Absolute file path to fle containing UUIDs to index", (Function1<String, BoxedUnit>)new Serializable(this, uuidFile$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef uuidFile$1;

                    public final void apply(String v) {
                        this.uuidFile$1.elem = v;
                    }
                    {
                        this.uuidFile$1 = uuidFile$1;
                    }
                });
                this.opt("rf", "file-rowkeys-to-index", "Absolute file path to fle containing rowkeys to index", (Function1<String, BoxedUnit>)new Serializable(this, rowKeyFile$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef rowKeyFile$1;

                    public final void apply(String v) {
                        this.rowKeyFile$1.elem = v;
                    }
                    {
                        this.rowKeyFile$1 = rowKeyFile$1;
                    }
                });
                this.intOpt("t", "threads", "Number of threads to index from", (Function1<Object, BoxedUnit>)new Serializable(this, threads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threads$1.elem = v;
                    }
                    {
                        this.threads$1 = threads$1;
                    }
                });
                this.opt("test", "test the speed of creating the index the minus the actual SOLR indexing costs", (Function0<BoxedUnit>)new Serializable(this, test$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef test$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.test$1.elem = true;
                    }
                    {
                        this.test$1 = test$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            if (empty.elem) {
                this.logger().info("Emptying index");
                this.indexer().emptyIndex();
            }
            String string = (String)uuidFile.elem;
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = (String)rowKeyFile.elem;
                String string4 = "";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    Option x$2 = (Option)startUuid.elem;
                    Option x$3 = (Option)endUuid.elem;
                    Option x$4 = (Option)dataResource.elem;
                    boolean x$5 = false;
                    boolean x$6 = false;
                    Option x$7 = (Option)startDate.elem;
                    boolean x$8 = check.elem;
                    int x$9 = pageSize.elem;
                    boolean x$10 = test.elem;
                    Seq<String> x$11 = this.index$default$9();
                    ObserverCallback x$12 = this.index$default$10();
                    this.index((Option<String>)x$2, (Option<String>)x$3, (Option<String>)x$4, x$5, x$6, (Option<String>)x$7, x$8, x$9, x$11, x$12, x$10);
                } else if (threads.elem == 1) {
                    this.indexList(new File((String)rowKeyFile.elem), this.indexList$default$2());
                } else {
                    this.indexListThreaded(new File((String)rowKeyFile.elem), threads.elem);
                }
            } else {
                this.indexListOfUUIDs(new File((String)uuidFile.elem));
            }
            this.indexer().shutdown();
            this.persistenceManager().shutdown();
        }
    }

    public void index(Option<String> startUuid, Option<String> endUuid, Option<String> dataResource, boolean optimise, boolean shutdown, Option<String> startDate, boolean checkDeleted, int pageSize, Seq<String> miscIndexProperties, ObserverCallback callback, boolean test) {
        String startKey = startUuid.isEmpty() && !dataResource.isEmpty() ? new StringBuilder().append((Object)((String)dataResource.get())).append((Object)"|").toString() : (String)startUuid.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        Option<Date> date = None$.MODULE$;
        if (!startDate.isEmpty()) {
            date = DateParser$.MODULE$.parseStringToDate(new StringBuilder().append((Object)((String)startDate.get())).append((Object)" 00:00:00").toString());
            if (date.isEmpty()) {
                throw new Exception("Date is in incorrect format. Try yyyy-mm-dd");
            }
            this.logger().info(new StringBuilder().append((Object)"Indexing will be restricted to records changed after ").append(date.get()).toString());
        }
        String endKey = dataResource.isEmpty() || endUuid.isDefined() ? (String)endUuid.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }) : new StringBuilder().append((Object)((String)dataResource.get())).append((Object)"|~").toString();
        String string = startKey;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.logger().info("Starting full index");
        } else {
            this.logger().info(new StringBuilder().append((Object)"Starting to index ").append((Object)startKey).append((Object)" until ").append((Object)endKey).toString());
        }
        String x$13 = startKey;
        String x$14 = endKey;
        Option<Date> x$15 = date;
        boolean x$16 = checkDeleted;
        Seq<String> x$17 = miscIndexProperties;
        ObserverCallback x$18 = callback;
        boolean x$19 = test;
        int x$20 = this.indexRange$default$5();
        this.indexRange(x$13, x$14, x$15, x$16, x$20, x$17, x$18, x$19);
        this.indexer().finaliseIndex(optimise, shutdown);
    }

    public boolean index$default$4() {
        return false;
    }

    public boolean index$default$5() {
        return false;
    }

    public Option<String> index$default$6() {
        return None$.MODULE$;
    }

    public boolean index$default$7() {
        return false;
    }

    public int index$default$8() {
        return 1000;
    }

    public Seq<String> index$default$9() {
        return Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
    }

    public ObserverCallback index$default$10() {
        return null;
    }

    public boolean index$default$11() {
        return false;
    }

    public void indexRange(String startUuid, String endUuid, Option<Date> startDate, boolean checkDeleted, int pageSize, Seq<String> miscIndexProperties, ObserverCallback callback, boolean test) {
        IntRef counter = new IntRef(0);
        long start = System.currentTimeMillis();
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        Serializable x$28 = new Serializable(startDate, pageSize, miscIndexProperties, callback, test, counter, startTime, finishTime){
            public static final long serialVersionUID = 0L;
            private final Option startDate$2;
            private final int pageSize$2;
            private final Seq miscIndexProperties$1;
            private final ObserverCallback callback$1;
            private final boolean test$2;
            private final IntRef counter$1;
            private final LongRef startTime$1;
            private final LongRef finishTime$1;

            public final boolean apply(String guid, scala.collection.immutable.Map<String, String> map) {
                ++this.counter$1.elem;
                boolean shouldcommit = this.counter$1.elem % 10000 == 0;
                String x$21 = guid;
                scala.collection.immutable.Map<String, String> x$22 = map;
                Option x$23 = this.startDate$2;
                boolean x$24 = shouldcommit;
                Seq x$25 = this.miscIndexProperties$1;
                boolean x$26 = this.test$2;
                boolean x$27 = IndexRecords$.MODULE$.indexer().indexFromMap$default$3();
                IndexRecords$.MODULE$.indexer().indexFromMap(x$21, (Map<String, String>)x$22, x$27, (Option<Date>)x$23, x$24, (Seq<String>)x$25, x$26);
                if (this.counter$1.elem % this.pageSize$2 == 0) {
                    if (this.callback$1 != null) {
                        this.callback$1.progressMessage(this.counter$1.elem);
                    }
                    this.finishTime$1.elem = System.currentTimeMillis();
                    IndexRecords$.MODULE$.logger().info(new StringBuilder().append(this.counter$1.elem).append((Object)" >> Last key : ").append((Object)guid).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)((float)this.pageSize$2 / ((float)(this.finishTime$1.elem - this.startTime$1.elem) / 1000.0f)))).toString());
                    this.startTime$1.elem = System.currentTimeMillis();
                }
                return true;
            }
            {
                this.startDate$2 = startDate$2;
                this.pageSize$2 = pageSize$2;
                this.miscIndexProperties$1 = miscIndexProperties$1;
                this.callback$1 = callback$1;
                this.test$2 = test$2;
                this.counter$1 = counter$1;
                this.startTime$1 = startTime$1;
                this.finishTime$1 = finishTime$1;
            }
        };
        String x$29 = startUuid;
        String x$30 = endUuid;
        boolean x$31 = checkDeleted;
        int x$32 = pageSize;
        this.performPaging((Function2<String, scala.collection.immutable.Map<String, String>, Object>)x$28, x$29, x$30, x$32, x$31);
        finishTime.elem = System.currentTimeMillis();
        this.logger().info(new StringBuilder().append((Object)"Total indexing time ").append((Object)BoxesRunTime.boxToFloat((float)((float)(finishTime.elem - start) / 1000.0f))).append((Object)" seconds").toString());
    }

    public Option<Date> indexRange$default$3() {
        return None$.MODULE$;
    }

    public boolean indexRange$default$4() {
        return false;
    }

    public int indexRange$default$5() {
        return 1000;
    }

    public Seq<String> indexRange$default$6() {
        return Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
    }

    public ObserverCallback indexRange$default$7() {
        return null;
    }

    public boolean indexRange$default$8() {
        return false;
    }

    public void performPaging(Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, String startKey, String endKey, int pageSize, boolean checkDeleted) {
        if (checkDeleted) {
            this.persistenceManager().pageOverSelect("occ", (Function2<String, scala.collection.immutable.Map<String, String>, Object>)new Serializable(proc){
                public static final long serialVersionUID = 0L;
                private final Function2 proc$1;

                public final boolean apply(String guid, scala.collection.immutable.Map<String, String> map) {
                    Option<scala.collection.immutable.Map<String, String>> map2;
                    Object object = ((String)map.getOrElse((Object)FullRecordMapper$.MODULE$.deletedColumn(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "false";
                        }
                    })).equals("false") ? ((map2 = IndexRecords$.MODULE$.persistenceManager().get(guid, "occ")).isEmpty() ? BoxedUnit.UNIT : this.proc$1.apply((Object)guid, map2.get())) : BoxedUnit.UNIT;
                    return true;
                }
                {
                    this.proc$1 = proc$1;
                }
            }, startKey, endKey, pageSize, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuid", "rowKey", FullRecordMapper$.MODULE$.deletedColumn()}));
        } else {
            this.persistenceManager().pageOverAll("occ", (Function2<String, scala.collection.immutable.Map<String, String>, Object>)new Serializable(proc){
                public static final long serialVersionUID = 0L;
                private final Function2 proc$1;

                public final boolean apply(String guid, scala.collection.immutable.Map<String, String> map) {
                    return BoxesRunTime.unboxToBoolean((Object)this.proc$1.apply((Object)guid, map));
                }
                {
                    this.proc$1 = proc$1;
                }
            }, startKey, endKey, pageSize);
        }
    }

    public String performPaging$default$2() {
        return "";
    }

    public String performPaging$default$3() {
        return "";
    }

    public int performPaging$default$4() {
        return 1000;
    }

    public boolean performPaging$default$5() {
        return false;
    }

    public void indexList(List<String> rowKeys) {
        IntRef counter = new IntRef(0);
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        rowKeys.foreach((Function1)new Serializable(counter, startTime, finishTime){
            public static final long serialVersionUID = 0L;
            private final IntRef counter$2;
            private final LongRef startTime$2;
            private final LongRef finishTime$2;

            public final void apply(String rowKey) {
                boolean shouldcommit;
                ++this.counter$2.elem;
                Option<scala.collection.immutable.Map<String, String>> map = IndexRecords$.MODULE$.persistenceManager().get(rowKey, "occ");
                boolean bl = shouldcommit = this.counter$2.elem % 10000 == 0;
                if (!map.isEmpty()) {
                    String x$33 = rowKey;
                    scala.collection.immutable.Map x$34 = (scala.collection.immutable.Map)map.get();
                    boolean x$35 = shouldcommit;
                    boolean x$36 = IndexRecords$.MODULE$.indexer().indexFromMap$default$3();
                    Option<Date> x$37 = IndexRecords$.MODULE$.indexer().indexFromMap$default$4();
                    Seq<String> x$38 = IndexRecords$.MODULE$.indexer().indexFromMap$default$6();
                    boolean x$39 = IndexRecords$.MODULE$.indexer().indexFromMap$default$7();
                    IndexRecords$.MODULE$.indexer().indexFromMap(x$33, (Map<String, String>)x$34, x$36, x$37, x$35, x$38, x$39);
                }
                if (this.counter$2.elem % 100 == 0) {
                    this.finishTime$2.elem = System.currentTimeMillis();
                    IndexRecords$.MODULE$.logger().debug(new StringBuilder().append(this.counter$2.elem).append((Object)" >> Last key : ").append((Object)rowKey).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(100.0f / ((float)(this.finishTime$2.elem - this.startTime$2.elem) / 1000.0f)))).toString());
                    this.startTime$2.elem = System.currentTimeMillis();
                }
            }
            {
                this.counter$2 = counter$2;
                this.startTime$2 = startTime$2;
                this.finishTime$2 = finishTime$2;
            }
        });
        this.indexer().finaliseIndex(false, false);
    }

    public void indexListThreaded(File rowKeys, int threads) {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(100);
        IntRef ids = new IntRef(0);
        StringConsumer[] pool = (StringConsumer[])Array$.MODULE$.fill(threads, (Function0)new Serializable(queue, ids){
            public static final long serialVersionUID = 0L;
            private final ArrayBlockingQueue queue$1;
            private final IntRef ids$1;

            public final StringConsumer apply() {
                IntRef counter = new IntRef(0);
                LongRef startTime = new LongRef(System.currentTimeMillis());
                LongRef finishTime = new LongRef(System.currentTimeMillis());
                IndexRecords$.MODULE$.indexer().init();
                StringConsumer p = new StringConsumer(this.queue$1, this.ids$1.elem, (Function1<String, BoxedUnit>)new Serializable(this, counter, startTime, finishTime){
                    public static final long serialVersionUID = 0L;
                    private final IntRef counter$3;
                    private final LongRef startTime$3;
                    private final LongRef finishTime$3;

                    public final void apply(String rowKey) {
                        boolean shouldcommit;
                        ++this.counter$3.elem;
                        Option<scala.collection.immutable.Map<String, String>> map = IndexRecords$.MODULE$.persistenceManager().get(rowKey, "occ");
                        boolean bl = shouldcommit = this.counter$3.elem % 1000 == 0;
                        if (!map.isEmpty()) {
                            String x$40 = rowKey;
                            scala.collection.immutable.Map x$41 = (scala.collection.immutable.Map)map.get();
                            boolean x$42 = shouldcommit;
                            boolean x$43 = IndexRecords$.MODULE$.indexer().indexFromMap$default$3();
                            Option<Date> x$44 = IndexRecords$.MODULE$.indexer().indexFromMap$default$4();
                            Seq<String> x$45 = IndexRecords$.MODULE$.indexer().indexFromMap$default$6();
                            boolean x$46 = IndexRecords$.MODULE$.indexer().indexFromMap$default$7();
                            IndexRecords$.MODULE$.indexer().indexFromMap(x$40, (Map<String, String>)x$41, x$43, x$44, x$42, x$45, x$46);
                        }
                        if (this.counter$3.elem % 1000 == 0) {
                            this.finishTime$3.elem = System.currentTimeMillis();
                            Predef$.MODULE$.println((Object)new StringBuilder().append(this.counter$3.elem).append((Object)" >> Last key : ").append((Object)rowKey).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$3.elem - this.startTime$3.elem) / 1000.0f)))).toString());
                            this.startTime$3.elem = System.currentTimeMillis();
                        }
                    }
                    {
                        this.counter$3 = counter$3;
                        this.startTime$3 = startTime$3;
                        this.finishTime$3 = finishTime$3;
                    }
                });
                ++this.ids$1.elem;
                p.start();
                return p;
            }
            {
                this.queue$1 = queue$1;
                this.ids$1 = ids$1;
            }
        }, ClassTag$.MODULE$.apply(StringConsumer.class));
        FileHelper$.MODULE$.file2helper(rowKeys).foreachLine((Function1<String, BoxedUnit>)new Serializable(queue){
            public static final long serialVersionUID = 0L;
            private final ArrayBlockingQueue queue$1;

            public final void apply(String line) {
                this.queue$1.put(line.trim());
            }
            {
                this.queue$1 = queue$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(StringConsumer t) {
                t.shouldStop_$eq(true);
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(StringConsumer x$1) {
                x$1.join();
            }
        });
        this.indexer().finaliseIndex(false, false);
    }

    public void indexList(File file, boolean shutdown) {
        Predef$.MODULE$.println((Object)"Starting the reindex by row key....");
        IntRef counter = new IntRef(0);
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        FileHelper$.MODULE$.file2helper(file).foreachLine((Function1<String, BoxedUnit>)new Serializable(counter, startTime, finishTime){
            public static final long serialVersionUID = 0L;
            private final IntRef counter$4;
            private final LongRef startTime$4;
            private final LongRef finishTime$4;

            public final void apply(String line) {
                boolean shouldcommit;
                ++this.counter$4.elem;
                String rowKey = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(line)).head()) == '\"' && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(line)).last()) == '\"' ? line.substring(1, line.length() - 1) : line;
                Option<scala.collection.immutable.Map<String, String>> map = IndexRecords$.MODULE$.persistenceManager().get(rowKey, "occ");
                boolean bl = shouldcommit = this.counter$4.elem % 10000 == 0;
                if (!map.isEmpty()) {
                    String x$47 = rowKey;
                    scala.collection.immutable.Map x$48 = (scala.collection.immutable.Map)map.get();
                    boolean x$49 = shouldcommit;
                    boolean x$50 = IndexRecords$.MODULE$.indexer().indexFromMap$default$3();
                    Option<Date> x$51 = IndexRecords$.MODULE$.indexer().indexFromMap$default$4();
                    Seq<String> x$52 = IndexRecords$.MODULE$.indexer().indexFromMap$default$6();
                    boolean x$53 = IndexRecords$.MODULE$.indexer().indexFromMap$default$7();
                    IndexRecords$.MODULE$.indexer().indexFromMap(x$47, (Map<String, String>)x$48, x$50, x$51, x$49, x$52, x$53);
                }
                if (this.counter$4.elem % 1000 == 0) {
                    this.finishTime$4.elem = System.currentTimeMillis();
                    IndexRecords$.MODULE$.logger().info(new StringBuilder().append(this.counter$4.elem).append((Object)" >> Last key : ").append((Object)line).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$4.elem - this.startTime$4.elem) / 1000.0f)))).toString());
                    this.startTime$4.elem = System.currentTimeMillis();
                }
            }
            {
                this.counter$4 = counter$4;
                this.startTime$4 = startTime$4;
                this.finishTime$4 = finishTime$4;
            }
        });
        this.indexer().finaliseIndex(false, shutdown);
    }

    public boolean indexList$default$2() {
        return true;
    }

    public void indexListOfUUIDs(File file) {
        Predef$.MODULE$.println((Object)"Starting the reindex by UUIDs....");
        IntRef counter = new IntRef(0);
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        FileHelper$.MODULE$.file2helper(file).foreachLine((Function1<String, BoxedUnit>)new Serializable(counter, startTime, finishTime){
            public static final long serialVersionUID = 0L;
            private final IntRef counter$5;
            private final LongRef startTime$5;
            private final LongRef finishTime$5;

            public final void apply(String line) {
                boolean shouldcommit;
                String uuid = line.replaceAll("\"", "");
                ++this.counter$5.elem;
                Option<scala.collection.immutable.Map<String, String>> map = IndexRecords$.MODULE$.persistenceManager().getByIndex(uuid, "occ", "uuid");
                boolean bl = shouldcommit = this.counter$5.elem % 10000 == 0;
                if (!map.isEmpty()) {
                    String x$54 = uuid;
                    scala.collection.immutable.Map x$55 = (scala.collection.immutable.Map)map.get();
                    boolean x$56 = shouldcommit;
                    boolean x$57 = IndexRecords$.MODULE$.indexer().indexFromMap$default$3();
                    Option<Date> x$58 = IndexRecords$.MODULE$.indexer().indexFromMap$default$4();
                    Seq<String> x$59 = IndexRecords$.MODULE$.indexer().indexFromMap$default$6();
                    boolean x$60 = IndexRecords$.MODULE$.indexer().indexFromMap$default$7();
                    IndexRecords$.MODULE$.indexer().indexFromMap(x$54, (Map<String, String>)x$55, x$57, x$58, x$56, x$59, x$60);
                }
                if (this.counter$5.elem % 1000 == 0) {
                    this.finishTime$5.elem = System.currentTimeMillis();
                    IndexRecords$.MODULE$.logger().info(new StringBuilder().append(this.counter$5.elem).append((Object)" >> Last key : ").append((Object)line).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$5.elem - this.startTime$5.elem) / 1000.0f)))).toString());
                    this.startTime$5.elem = System.currentTimeMillis();
                }
            }
            {
                this.counter$5 = counter$5;
                this.startTime$5 = startTime$5;
                this.finishTime$5 = finishTime$5;
            }
        });
        Predef$.MODULE$.println((Object)"Finalising index.....");
        this.indexer().finaliseIndex(false, true);
        Predef$.MODULE$.println((Object)"Finalised index.");
    }

    private IndexRecords$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"IndexRecords");
        this.indexer = (IndexDAO)Config$.MODULE$.getInstance(IndexDAO.class);
        this.occurrenceDAO = (OccurrenceDAO)Config$.MODULE$.getInstance(OccurrenceDAO.class);
        this.persistenceManager = (PersistenceManager)Config$.MODULE$.getInstance(PersistenceManager.class);
    }
}

