/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.export;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.export.ExportFacet$;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.OptionParser;
import java.io.File;
import java.io.FileWriter;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class ExportAllSpatialSpecies$ {
    public static final ExportAllSpatialSpecies$ MODULE$;

    static {
        new ExportAllSpatialSpecies$();
    }

    public void main(String[] args) {
        IntRef threads = new IntRef(4);
        String[] fieldsToExport = (String[])((Object[])new String[]{"row_key", "id", "species_guid", "subspecies_guid", "year", "month", "occurrence_date", "point-1", "point-0.1", "point-0.01", "point-0.001", "point-0.0001", "lat_long", "raw_taxon_name", "collectors", "duplicate_status", "duplicate_record", "latitude", "longitude", "el882", "el889", "el887", "el865", "el894", "coordinate_uncertainty"});
        String query = "lat_long:* AND species_guid:*";
        String[] filterQueries = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        String[] sortFields = (String[])((Object[])new String[]{"species_guid", "subspecies_guid", "row_key"});
        Some multivaluedFields = new Some((Object)new String[]{"duplicate_record"});
        ObjectRef exportDirectory = new ObjectRef((Object)"/data/offline/exports");
        BooleanRef lastWeek = new BooleanRef(false);
        ObjectRef validGuids = new ObjectRef((Object)None$.MODULE$);
        OptionParser parser = new OptionParser(threads, exportDirectory, lastWeek){
            {
                this.arg("<output directory>", "the output directory for the exports", (Function1<String, BoxedUnit>)new Serializable(this, exportDirectory$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef exportDirectory$1;

                    public final void apply(String v) {
                        this.exportDirectory$1.elem = v;
                    }
                    {
                        this.exportDirectory$1 = exportDirectory$1;
                    }
                });
                this.intOpt("t", "threads", "the number of threads/files to have for the exports", (Function1<Object, BoxedUnit>)new Serializable(this, threads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threads$1.elem = v;
                    }
                    {
                        this.threads$1 = threads$1;
                    }
                });
                this.opt("lastWeek", "species that have changed in the last week", (Function0<BoxedUnit>)new Serializable(this, lastWeek$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef lastWeek$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.lastWeek$1.elem = true;
                    }
                    {
                        this.lastWeek$1 = lastWeek$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            if (lastWeek.elem) {
                String[] args2 = (String[])((Object[])new String[]{"species_guid", this.filename$1(exportDirectory), "--lastWeek", "true", "--open"});
                ExportFacet$.MODULE$.main(args2);
                ArrayBuffer buf = new ArrayBuffer();
                FileHelper$.MODULE$.file2helper(new File(this.filename$1(exportDirectory))).foreachLine((Function1<String, BoxedUnit>)new Serializable(buf){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer buf$1;

                    public final void apply(String line) {
                        this.buf$1.$plus$eq((Object)line);
                    }
                    {
                        this.buf$1 = buf$1;
                    }
                });
                validGuids.elem = new Some((Object)buf.toList());
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"There are ").append((Object)BoxesRunTime.boxToInteger((int)buf.size())).append((Object)" valid guids to download").toString());
            }
            IntRef ids = new IntRef(0);
            Tuple2[] files = (Tuple2[])Array$.MODULE$.fill(threads.elem, (Function0)new Serializable(exportDirectory, ids){
                public static final long serialVersionUID = 0L;
                private final ObjectRef exportDirectory$1;
                private final IntRef ids$1;

                public final Tuple2<FileWriter, FileWriter> apply() {
                    File file = new File(new StringBuilder().append((Object)((String)this.exportDirectory$1.elem)).append((Object)File.separator).append((Object)BoxesRunTime.boxToInteger((int)this.ids$1.elem)).toString());
                    FileUtils.forceMkdir((File)file);
                    ++this.ids$1.elem;
                    return new Tuple2((Object)new FileWriter(new File(new StringBuilder().append((Object)file.getAbsolutePath()).append((Object)File.separator).append((Object)"species.out").toString())), (Object)new FileWriter(new File(new StringBuilder().append((Object)file.getAbsolutePath()).append((Object)File.separator).append((Object)"subspecies.out").toString())));
                }
                {
                    this.exportDirectory$1 = exportDirectory$1;
                    this.ids$1 = ids$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            IntRef counter = new IntRef(0);
            ObjectRef currentLsid = new ObjectRef((Object)"");
            IntRef lsidCount = new IntRef(0);
            ObjectRef fileWriter = new ObjectRef(null);
            ObjectRef subspeciesWriter = new ObjectRef(null);
            BooleanRef loadCurrent = new BooleanRef(true);
            Config$.MODULE$.indexDAO().streamIndex((Function1<Map<String, Object>, Object>)new Serializable(threads, fieldsToExport, validGuids, files, counter, currentLsid, lsidCount, fileWriter, subspeciesWriter, loadCurrent){
                public static final long serialVersionUID = 0L;
                private final IntRef threads$1;
                private final String[] fieldsToExport$1;
                private final ObjectRef validGuids$1;
                private final Tuple2[] files$1;
                private final IntRef counter$1;
                private final ObjectRef currentLsid$1;
                private final IntRef lsidCount$1;
                private final ObjectRef fileWriter$1;
                private final ObjectRef subspeciesWriter$1;
                private final BooleanRef loadCurrent$1;

                public final boolean apply(Map<String, Object> map) {
                    String outputLine = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.fieldsToExport$1).map((Function1)new Serializable(this, map){
                        public static final long serialVersionUID = 0L;
                        private final Map map$1;

                        public final String apply(String f) {
                            return ExportAllSpatialSpecies$.MODULE$.getFromMap(this.map$1, f);
                        }
                        {
                            this.map$1 = map$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\t");
                    ++this.counter$1.elem;
                    Object thisLsid = map.get("species_guid");
                    if (thisLsid != null) {
                        Object object = thisLsid;
                        String string = (String)this.currentLsid$1.elem;
                        if (object == null ? string != null : !object.equals(string)) {
                            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Starting to handle ").append(thisLsid).append((Object)" ").append((Object)BoxesRunTime.boxToInteger((int)this.counter$1.elem)).append((Object)" ").append((Object)BoxesRunTime.boxToInteger((int)this.lsidCount$1.elem)).toString());
                            this.currentLsid$1.elem = thisLsid.toString();
                            boolean bl = this.loadCurrent$1.elem = ((Option)this.validGuids$1.elem).isEmpty() || ((LinearSeqOptimized)((Option)this.validGuids$1.elem).get()).contains((Object)((String)this.currentLsid$1.elem));
                            if (this.loadCurrent$1.elem) {
                                ++this.lsidCount$1.elem;
                            }
                            if ((FileWriter)this.fileWriter$1.elem != null) {
                                ((FileWriter)this.fileWriter$1.elem).flush();
                                ((FileWriter)this.subspeciesWriter$1.elem).flush();
                            }
                            this.fileWriter$1.elem = (FileWriter)this.files$1[this.lsidCount$1.elem % this.threads$1.elem]._1();
                            this.subspeciesWriter$1.elem = (FileWriter)this.files$1[this.lsidCount$1.elem % this.threads$1.elem]._2();
                        }
                    }
                    if (this.loadCurrent$1.elem) {
                        ((FileWriter)this.fileWriter$1.elem).write(outputLine);
                        ((FileWriter)this.fileWriter$1.elem).write("\n");
                        Object subspecies = map.get("subspecies_guid");
                        if (subspecies != null) {
                            ((FileWriter)this.subspeciesWriter$1.elem).write(outputLine);
                            ((FileWriter)this.subspeciesWriter$1.elem).write("\n");
                        }
                    }
                    if (this.counter$1.elem % 10000 == 0) {
                        ((FileWriter)this.fileWriter$1.elem).flush();
                        ((FileWriter)this.subspeciesWriter$1.elem).flush();
                    }
                    return true;
                }
                {
                    this.threads$1 = threads$1;
                    this.fieldsToExport$1 = fieldsToExport$1;
                    this.validGuids$1 = validGuids$1;
                    this.files$1 = files$1;
                    this.counter$1 = counter$1;
                    this.currentLsid$1 = currentLsid$1;
                    this.lsidCount$1 = lsidCount$1;
                    this.fileWriter$1 = fileWriter$1;
                    this.subspeciesWriter$1 = subspeciesWriter$1;
                    this.loadCurrent$1 = loadCurrent$1;
                }
            }, fieldsToExport, query, filterQueries, sortFields, (Option<String[]>)multivaluedFields);
            Predef$.MODULE$.refArrayOps((Object[])files).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<FileWriter, FileWriter> x0$1) {
                    Tuple2<FileWriter, FileWriter> tuple2 = x0$1;
                    if (tuple2 != null) {
                        FileWriter fw1 = (FileWriter)tuple2._1();
                        FileWriter fw2 = (FileWriter)tuple2._2();
                        fw1.flush();
                        fw1.close();
                        fw2.flush();
                        fw2.close();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
        }
    }

    public String getFromMap(Map<String, Object> map, String key) {
        Object value = map.get(key);
        return value == null ? "" : value.toString().replaceAll("(\r\n|\n)", " ");
    }

    private final String filename$1(ObjectRef exportDirectory$1) {
        return new StringBuilder().append((Object)((String)exportDirectory$1.elem)).append((Object)File.separator).append((Object)"delta-species-guids.txt").toString();
    }

    private ExportAllSpatialSpecies$() {
        MODULE$ = this;
    }
}

