/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.export;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.Config$;
import au.org.ala.biocache.export.DwCACreator$;
import au.org.ala.biocache.export.ExportUtil$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u0005ur!B\u0001\u0003\u0011\u0003i\u0011a\u0003#x\u0007\u0006\u001b%/Z1u_JT!a\u0001\u0003\u0002\r\u0015D\bo\u001c:u\u0015\t)a!\u0001\u0005cS>\u001c\u0017m\u00195f\u0015\t9\u0001\"A\u0002bY\u0006T!!\u0003\u0006\u0002\u0007=\u0014xMC\u0001\f\u0003\t\tWo\u0001\u0001\u0011\u00059yQ\"\u0001\u0002\u0007\u000bA\u0011\u0001\u0012A\t\u0003\u0017\u0011;8)Q\"sK\u0006$xN]\n\u0003\u001fI\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007\"B\r\u0010\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u000e\u0011\u001darB1A\u0005\u0002u\ta\u0001\\8hO\u0016\u0014X#\u0001\u0010\u0011\u0005}\u0019S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013!B:mMRR'\"A\u0005\n\u0005\u0011\u0002#A\u0002'pO\u001e,'\u000f\u0003\u0004'\u001f\u0001\u0006IAH\u0001\bY><w-\u001a:!\u0011\u0015As\u0002\"\u0001*\u0003\u0011i\u0017-\u001b8\u0015\u0005)j\u0003CA\n,\u0013\taCC\u0001\u0003V]&$\b\"\u0002\u0018(\u0001\u0004y\u0013\u0001B1sON\u00042a\u0005\u00193\u0013\t\tDCA\u0003BeJ\f\u0017\u0010\u0005\u00024m9\u00111\u0003N\u0005\u0003kQ\ta\u0001\u0015:fI\u00164\u0017BA\u001c9\u0005\u0019\u0019FO]5oO*\u0011Q\u0007\u0006\u0005\bu=\u0011\r\u0011\"\u0001<\u0003M!\u0017\r^1SKN|WO]2f!\u0006$H/\u001a:o+\u0005a\u0004CA\u001fC\u001b\u0005q$BA A\u0003!i\u0017\r^2iS:<'BA!\u0015\u0003\u0011)H/\u001b7\n\u0005\rs$!\u0002*fO\u0016D\bBB#\u0010A\u0003%A(\u0001\u000beCR\f'+Z:pkJ\u001cW\rU1ui\u0016\u0014h\u000e\t\u0005\u0006\u000f>!\t\u0001S\u0001\u0014O\u0016$H)\u0019;b%\u0016\u001cx.\u001e:dKVKGm]\u000b\u0002\u0013B\u0019!J\u0015\u001a\u000f\u0005-\u0003fB\u0001'P\u001b\u0005i%B\u0001(\r\u0003\u0019a$o\\8u}%\tQ#\u0003\u0002R)\u00059\u0001/Y2lC\u001e,\u0017BA*U\u0005\r\u0019V-\u001d\u0006\u0003#RAQAV\b\u0005\u0002]\u000bq\u0001]1sg\u00164\u0015\u000f\u0006\u000231\")\u0011,\u0016a\u0001e\u0005\u0011a-\u001d\u0004\u0005!\t\u00011l\u0005\u0002[%!)\u0011D\u0017C\u0001;R\ta\f\u0005\u0002\u000f5\"9AD\u0017b\u0001\n\u0003i\u0002B\u0002\u0014[A\u0003%a\u0004C\u0004c5\n\u0007I\u0011A2\u0002\u001b\u0011,g-Y;mi\u001aKW\r\u001c3t+\u0005!\u0007cA3kY6\taM\u0003\u0002hQ\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003SR\t!bY8mY\u0016\u001cG/[8o\u0013\tYgM\u0001\u0003MSN$\bCA7s\u001b\u0005q'BA8q\u0003\u0011a\u0017M\\4\u000b\u0003E\fAA[1wC&\u0011qG\u001c\u0005\u0007ij\u0003\u000b\u0011\u00023\u0002\u001d\u0011,g-Y;mi\u001aKW\r\u001c3tA!9aO\u0017b\u0001\n\u00039\u0018\u0001E2p[B,Hn]8ss\u001aKW\r\u001c3t+\u0005A\b\u0003B3zY2L!A\u001f4\u0003\u00075\u000b\u0007\u000f\u0003\u0004}5\u0002\u0006I\u0001_\u0001\u0012G>l\u0007/\u001e7t_JLh)[3mIN\u0004\u0003\"\u0002@[\t\u0003y\u0018AB2sK\u0006$X\rF\u0003+\u0003\u0003\t)\u0001\u0003\u0004\u0002\u0004u\u0004\rAM\u0001\nI&\u0014Xm\u0019;pefDa!a\u0002~\u0001\u0004\u0011\u0014\u0001\u00043bi\u0006\u0014Vm]8ve\u000e,\u0007bBA\u00065\u0012\u0005\u0011QB\u0001\u0007C\u0012$W)\u0014'\u0015\r\u0005=\u0011QCA\u0014!\r\u0019\u0012\u0011C\u0005\u0004\u0003'!\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003/\tI\u00011\u0001\u0002\u001a\u0005\u0019!p\u001c9\u0011\t\u0005m\u00111E\u0007\u0003\u0003;QA!a\b\u0002\"\u0005\u0019!0\u001b9\u000b\u0005\u0005\u0003\u0018\u0002BA\u0013\u0003;\u0011qBW5q\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003S\tI\u00011\u00013\u0003\t!'\u000fC\u0004\u0002.i#\t!a\f\u0002\u000f\u0005$G-T3uCR\u0019!&!\r\t\u0011\u0005]\u00111\u0006a\u0001\u00033Aq!!\u000e[\t\u0003\t9$\u0001\u0004bI\u0012\u001c5K\u0016\u000b\u0006U\u0005e\u00121\b\u0005\t\u0003/\t\u0019\u00041\u0001\u0002\u001a!9\u0011\u0011FA\u001a\u0001\u0004\u0011\u0004")
public class DwCACreator {
    private final Logger logger = LoggerFactory.getLogger((String)"DwCACreator");
    private final List<String> defaultFields = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuid", "catalogNumber", "collectionCode", "institutionCode", "scientificName", "recordedBy", "taxonRank", "kingdom", "phylum", "class", "order", "family", "genus", "specificEpithet", "infraspecificEpithet", "decimalLatitude", "decimalLongitude", "coordinatePrecision", "coordinateUncertaintyInMeters", "maximumElevationInMeters", "minimumElevationInMeters", "minimumDepthInMeters", "maximumDepthInMeters", "continent", "country", "stateProvince", "county", "locality", "year", "month", "day", "basisOfRecord", "identifiedBy", "dateIdentified", "occurrenceRemarks", "locationRemarks", "recordNumber", "vernacularName", "identificationQualifier", "individualCount", "eventID", "geodeticDatum", "eventTime", "associatedSequences", "eventDate"}));
    private final Map<String, String> compulsoryFields = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"catalogNumber"), (Object)"uuid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"collectionCode"), (Object)"dataResourceName.p"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"institutionCode"), (Object)"dataResourceName.p")}));

    public static String parseFq(String string) {
        return DwCACreator$.MODULE$.parseFq(string);
    }

    public static Seq<String> getDataResourceUids() {
        return DwCACreator$.MODULE$.getDataResourceUids();
    }

    public static Regex dataResourcePattern() {
        return DwCACreator$.MODULE$.dataResourcePattern();
    }

    public static void main(String[] stringArray) {
        DwCACreator$.MODULE$.main(stringArray);
    }

    public Logger logger() {
        return this.logger;
    }

    public List<String> defaultFields() {
        return this.defaultFields;
    }

    public Map<String, String> compulsoryFields() {
        return this.compulsoryFields;
    }

    public void create(String directory, String dataResource) {
        this.logger().info(new StringBuilder().append((Object)"Creating archive for ").append((Object)dataResource).toString());
        File zipFile = new File(new StringBuilder().append((Object)directory).append((Object)System.getProperty("file.separator")).append((Object)dataResource).append((Object)System.getProperty("file.separator")).append((Object)dataResource).append((Object)"_ror_dwca.zip").toString());
        FileUtils.forceMkdir((File)zipFile.getParentFile());
        ZipOutputStream zop = new ZipOutputStream(new FileOutputStream(zipFile));
        if (this.addEML(zop, dataResource)) {
            this.addMeta(zop);
            this.addCSV(zop, dataResource);
            zop.close();
        } else {
            zop.close();
            FileUtils.deleteQuietly((File)zipFile);
        }
    }

    public boolean addEML(ZipOutputStream zop, String dr) {
        boolean bl;
        try {
            zop.putNextEntry(new ZipEntry("eml.xml"));
            String content = Source$.MODULE$.fromURL(new StringBuilder().append((Object)Config$.MODULE$.registryUrl()).append((Object)"/eml/").append((Object)dr).toString(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
            zop.write(content.getBytes());
            zop.flush();
            zop.closeEntry();
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public void addMeta(ZipOutputStream zop) {
        zop.putNextEntry(new ZipEntry("meta.xml"));
        TopScope$ $tmpscope = Predef$.MODULE$.$scope();
        TopScope$ $scope = $tmpscope = new NamespaceBinding(null, "http://rs.tdwg.org/dwc/text/", (NamespaceBinding)$tmpscope);
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("metadata", (Seq)new Text("eml.xml"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("rowType", (Seq)new Text("http://rs.tdwg.org/dwc/terms/Occurrence"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("ignoreHeaderLines", (Seq)new Text("0"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("fieldsEnclosedBy", (Seq)new Text("\""), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("fieldsTerminatedBy", (Seq)new Text(","), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("linesTerminatedBy", (Seq)new Text("\\r\\n"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("encoding", (Seq)new Text("UTF-8"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("raw_occurrence_record.csv"));
        $buf3.$amp$plus((Object)new Elem(null, "location", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "files", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n            "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("index", (Seq)new Text("0"), (MetaData)$md3);
        $buf2.$amp$plus((Object)new Elem(null, "id", (MetaData)$md3, (NamespaceBinding)$scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n            "));
        $buf2.$amp$plus(((TraversableLike)this.defaultFields().tail()).map((Function1)new Serializable(this, (NamespaceBinding)$scope){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DwCACreator $outer;
            private final NamespaceBinding $scope$1;

            public final Elem apply(String f) {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("term", new StringBuilder().append((Object)"http://rs.tdwg.org/dwc/terms/").append((Object)f).toString(), (MetaData)$md);
                $md = new UnprefixedAttribute("index", ((Object)BoxesRunTime.boxToInteger((int)this.$outer.defaultFields().indexOf((Object)f))).toString(), (MetaData)$md);
                return new Elem(null, "field", (MetaData)$md, this.$scope$1, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.$scope$1 = $scope$1;
            }
        }, List$.MODULE$.canBuildFrom()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "core", (MetaData)$md2, (NamespaceBinding)$scope, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        Elem metaXml = new Elem(null, "archive", (MetaData)$md, (NamespaceBinding)$scope, false, (Seq)$buf);
        zop.write("<?xml version=\"1.0\"?>".getBytes());
        zop.write("\n".getBytes());
        zop.write(metaXml.mkString("\n").getBytes());
        zop.flush();
        zop.closeEntry();
    }

    public void addCSV(ZipOutputStream zop, String dr) {
        zop.putNextEntry(new ZipEntry("raw_occurrence_record.csv"));
        String startUuid = new StringBuilder().append((Object)dr).append((Object)"|").toString();
        String endUuid = new StringBuilder().append((Object)startUuid).append((Object)"~").toString();
        ExportUtil$.MODULE$.export(new CSVWriter((Writer)new OutputStreamWriter(zop)), "occ", this.defaultFields(), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuid"})), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuid"})), (Option<Map<String, String>>)new Some(this.compulsoryFields()), startUuid, endUuid, Integer.MAX_VALUE, ExportUtil$.MODULE$.export$default$10());
        zop.flush();
        zop.closeEntry();
    }
}

