/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.caches;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.caches.TaxonSpeciesListDAO$;
import au.org.ala.biocache.caches.WebServiceLoader$;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.util.Json$;
import au.org.ala.biocache.vocab.SpeciesListAcronyms$;
import au.org.ala.biocache.vocab.Term;
import java.text.MessageFormat;
import org.apache.commons.collections.map.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.util.parsing.json.JSON$;

public final class TaxonSpeciesListDAO$ {
    public static final TaxonSpeciesListDAO$ MODULE$;
    private final Logger logger;
    private final String guidUrl;
    private final LRUMap lru;
    private final Object lock;
    private final String[] au$org$ala$biocache$caches$TaxonSpeciesListDAO$$validLists;
    private final Set<String> au$org$ala$biocache$caches$TaxonSpeciesListDAO$$prefixFields;
    private final Set<String> au$org$ala$biocache$caches$TaxonSpeciesListDAO$$indexValues;
    private final boolean loadSpeciesLists;
    private final String columnFamily;
    private final PersistenceManager persistenceManager;
    private final String LIST;
    private final String LIST_PROPERTIES;
    private Map<String, Tuple2<List<String>, Map<String, String>>> speciesListMap;

    static {
        new TaxonSpeciesListDAO$();
    }

    public Logger logger() {
        return this.logger;
    }

    public String listToolUrl() {
        return "http://lists.ala.org.au/ws/species/";
    }

    public String guidUrl() {
        return this.guidUrl;
    }

    private LRUMap lru() {
        return this.lru;
    }

    private Object lock() {
        return this.lock;
    }

    public String[] au$org$ala$biocache$caches$TaxonSpeciesListDAO$$validLists() {
        return this.au$org$ala$biocache$caches$TaxonSpeciesListDAO$$validLists;
    }

    public Set<String> au$org$ala$biocache$caches$TaxonSpeciesListDAO$$prefixFields() {
        return this.au$org$ala$biocache$caches$TaxonSpeciesListDAO$$prefixFields;
    }

    public Set<String> au$org$ala$biocache$caches$TaxonSpeciesListDAO$$indexValues() {
        return this.au$org$ala$biocache$caches$TaxonSpeciesListDAO$$indexValues;
    }

    private boolean loadSpeciesLists() {
        return this.loadSpeciesLists;
    }

    private String columnFamily() {
        return this.columnFamily;
    }

    private PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    private String LIST() {
        return this.LIST;
    }

    private String LIST_PROPERTIES() {
        return this.LIST_PROPERTIES;
    }

    private Map<String, Tuple2<List<String>, Map<String, String>>> speciesListMap() {
        return this.speciesListMap;
    }

    private void speciesListMap_$eq(Map<String, Tuple2<List<String>, Map<String, String>>> x$1) {
        this.speciesListMap = x$1;
    }

    public Tuple2<List<String>, Map<String, String>> getListsFromPM(String guid) {
        Option<Map<String, String>> map = this.persistenceManager().getSelected(guid, this.columnFamily(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.LIST(), this.LIST_PROPERTIES()}));
        Object object = map.isDefined() ? new Tuple2(Json$.MODULE$.toListWithGeneric((String)((MapLike)map.get()).getOrElse((Object)this.LIST(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "[]";
            }
        }), String.class), Json$.MODULE$.toStringMap((String)((MapLike)map.get()).getOrElse((Object)this.LIST_PROPERTIES(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "{}";
            }
        }))) : BoxedUnit.UNIT;
        return new Tuple2((Object)Nil$.MODULE$, (Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
    }

    public void addToPM(String guid, List<String> lists, Map<String, String> listProperties) {
        this.persistenceManager().put(guid, this.columnFamily(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.LIST()), (Object)Json$.MODULE$.toJSON(lists)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.LIST_PROPERTIES()), (Object)Json$.MODULE$.toJSON(listProperties))}))));
    }

    public Map<String, Tuple2<List<String>, Map<String, String>>> updateLists() {
        this.logger().info("Updating the lists");
        HashMap newMap = new HashMap();
        ArrayBuffer guidsArray = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])this.au$org$ala$biocache$caches$TaxonSpeciesListDAO$$validLists()).foreach((Function1)new Serializable(guidsArray){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer guidsArray$1;

            public final Object apply(String v) {
                BoxedUnit boxedUnit;
                String response;
                String url = MessageFormat.format(TaxonSpeciesListDAO$.MODULE$.guidUrl(), v);
                String string = response = WebServiceLoader$.MODULE$.getWSStringContent(url);
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    List list = (List)JSON$.MODULE$.parseFull(response).get();
                    boxedUnit = this.guidsArray$1.$plus$plus$eq((TraversableOnce)list.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$1) {
                            return x$1 != null;
                        }
                    }));
                }
                return boxedUnit;
            }
            {
                this.guidsArray$1 = guidsArray$1;
            }
        });
        Set guids = guidsArray.toSet();
        this.logger().info(new StringBuilder().append((Object)"The number of distinct species ").append((Object)BoxesRunTime.boxToInteger((int)guids.size())).toString());
        guids.foreach((Function1)new Serializable(newMap){
            public static final long serialVersionUID = 0L;
            private final HashMap newMap$1;

            public final void apply(String g) {
                this.newMap$1.update((Object)g, TaxonSpeciesListDAO$.MODULE$.getListsForTaxon(g, true));
            }
            {
                this.newMap$1 = newMap$1;
            }
        });
        this.logger().info("Finished creating the map");
        return newMap.toMap(Predef$.MODULE$.conforms());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tuple2<List<String>, Map<String, String>> getCachedListsForTaxon(String conceptLsid) {
        BoxedUnit boxedUnit;
        if (this.speciesListMap() != null) {
            boxedUnit = BoxedUnit.UNIT;
            return (Tuple2)this.speciesListMap().getOrElse((Object)conceptLsid, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<List<Nothing$>, Map<String, Nothing$>> apply() {
                    return new Tuple2((Object)Nil$.MODULE$, (Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                }
            });
        }
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit2;
            if (this.speciesListMap() == null) {
                this.speciesListMap_$eq(this.updateLists());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit2;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : object
            boxedUnit = boxedUnit3;
            return (Tuple2)this.speciesListMap().getOrElse((Object)conceptLsid, (Function0)new /* invalid duplicate definition of identical inner class */);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tuple2<List<String>, Map<String, String>> getListsForTaxon(String conceptLsid, boolean forceLoad) {
        Tuple2 tuple2;
        String response;
        String string = response = WebServiceLoader$.MODULE$.getWSStringContent(new StringBuilder().append((Object)this.listToolUrl()).append((Object)conceptLsid).toString());
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            tuple2 = new Tuple2((Object)Nil$.MODULE$, (Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            return tuple2;
        }
        List list = (List)JSON$.MODULE$.parseFull(response).get();
        List newObject = ((TraversableOnce)((TraversableLike)list.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Map<String, Object> x$2) {
                return x$2.getOrElse((Object)"dataResourceUid", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }).toString();
            }
        }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String v) {
                return Predef$.MODULE$.refArrayOps((Object[])TaxonSpeciesListDAO$.MODULE$.au$org$ala$biocache$caches$TaxonSpeciesListDAO$$validLists()).contains((Object)v);
            }
        })).toSet().toList();
        scala.collection.mutable.Map newMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        list.foreach((Function1)new Serializable(newMap){
            public static final long serialVersionUID = 0L;
            public final scala.collection.mutable.Map newMap$2;

            public final void apply(Map<String, Object> map) {
                Option kvparrayopt;
                String dr = map.getOrElse((Object)"dataResourceUid", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }).toString();
                if (Predef$.MODULE$.refArrayOps((Object[])TaxonSpeciesListDAO$.MODULE$.au$org$ala$biocache$caches$TaxonSpeciesListDAO$$validLists()).contains((Object)dr) && (kvparrayopt = map.get((Object)"kvpValues")).isDefined()) {
                    String value;
                    Option<Term> matchedPrefix;
                    List kvparray = (List)kvparrayopt.get();
                    Option prefix = kvparray.find((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Map<String, String> map) {
                            return TaxonSpeciesListDAO$.MODULE$.au$org$ala$biocache$caches$TaxonSpeciesListDAO$$prefixFields().contains(map.getOrElse((Object)"key", (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "";
                                }
                            }));
                        }
                    });
                    String stringPrefix = prefix.isDefined() ? ((matchedPrefix = SpeciesListAcronyms$.MODULE$.matchTerm(value = TaxonSpeciesListDAO$.MODULE$.getValueBasedOnKVP((Map<String, String>)((Map)prefix.get())))).isDefined() ? ((Term)matchedPrefix.get()).canonical().toLowerCase() : value.replaceAll(" ", "_").toLowerCase()) : "";
                    List filteredList = (List)kvparray.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Map<String, String> x$3) {
                            return ((TraversableOnce)x$3.values().toSet().intersect(TaxonSpeciesListDAO$.MODULE$.au$org$ala$biocache$caches$TaxonSpeciesListDAO$$indexValues())).size() > 0;
                        }
                    });
                    filteredList.foreach((Function1)new Serializable(this, dr, stringPrefix){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getListsForTaxon.1 $outer;
                        private final String dr$1;
                        private final String stringPrefix$1;

                        public final void apply(Map<String, String> item) {
                            if (TaxonSpeciesListDAO$.MODULE$.au$org$ala$biocache$caches$TaxonSpeciesListDAO$$indexValues().contains(item.getOrElse((Object)"key", (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "";
                                }
                            }))) {
                                String value = TaxonSpeciesListDAO$.MODULE$.getValueBasedOnKVP(item);
                                this.$outer.newMap$2.update((Object)new StringBuilder().append((Object)this.dr$1).append((Object)TaxonSpeciesListDAO$.MODULE$.getEscapedValue(this.stringPrefix$1)).append((Object)TaxonSpeciesListDAO$.MODULE$.getEscapedValue((String)item.getOrElse((Object)"key", (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }))).toString(), (Object)value);
                            }
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.dr$1 = dr$1;
                            this.stringPrefix$1 = stringPrefix$1;
                        }
                    });
                }
            }
            {
                this.newMap$2 = newMap$2;
            }
        });
        Object object = this.lock();
        synchronized (object) {
            this.lru().put((Object)conceptLsid, (Object)new Tuple2((Object)newObject, (Object)newMap.toMap(Predef$.MODULE$.conforms())));
        }
        tuple2 = new Tuple2((Object)newObject, (Object)newMap.toMap(Predef$.MODULE$.conforms()));
        return tuple2;
    }

    public String getEscapedValue(String value) {
        return new StringOps(Predef$.MODULE$.augmentString(value.trim())).size() > 0 ? new StringBuilder().append((Object)"_").append((Object)value).toString() : value.trim();
    }

    public String getValueBasedOnKVP(Map<String, String> item) {
        return item.getOrElse((Object)"vocabValue", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }) == null ? (String)item.getOrElse((Object)"value", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }) : (String)item.getOrElse((Object)"vocabValue", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
    }

    public void refreshCache() {
        Object object = this.lock();
        synchronized (object) {
            Map<String, Tuple2<List<String>, Map<String, String>>> tmpMap = this.updateLists();
            this.speciesListMap_$eq(tmpMap);
            return;
        }
    }

    private TaxonSpeciesListDAO$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"TaxonSpeciesListDAO");
        this.guidUrl = "http://lists.ala.org.au/ws/speciesList/{0}/taxa";
        this.lru = new LRUMap(100000);
        this.lock = new Object();
        this.au$org$ala$biocache$caches$TaxonSpeciesListDAO$$validLists = Config$.MODULE$.getProperty("specieslists", "").split(",");
        this.au$org$ala$biocache$caches$TaxonSpeciesListDAO$$prefixFields = Predef$.MODULE$.refArrayOps((Object[])Config$.MODULE$.getProperty("slPrefix", "stateProvince").split(",")).toSet();
        this.au$org$ala$biocache$caches$TaxonSpeciesListDAO$$indexValues = Predef$.MODULE$.refArrayOps((Object[])Config$.MODULE$.getProperty("slIndexKeys", "category").split(",")).toSet();
        this.loadSpeciesLists = Config$.MODULE$.getProperty("includeSpeciesLists", "false").equals("true");
        this.columnFamily = "taxon";
        this.persistenceManager = (PersistenceManager)Config$.MODULE$.getInstance(PersistenceManager.class);
        this.LIST = "lists";
        this.LIST_PROPERTIES = "listProperties";
    }
}

