/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.caches;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.model.Location;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.vocab.StateProvinces$;
import au.org.ala.biocache.vocab.Term;
import java.util.ArrayList;
import org.ala.layers.client.Client;
import org.ala.layers.dao.LayerIntersectDAO;
import org.apache.commons.collections.map.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

public final class LocationDAO$ {
    public static final LocationDAO$ MODULE$;
    private final Logger logger;
    private final String columnFamily;
    private final Object lock;
    private final LRUMap lru;
    private final PersistenceManager persistenceManager;
    private final String latitudeCol;
    private final String longitudeCol;

    static {
        new LocationDAO$();
    }

    public Logger logger() {
        return this.logger;
    }

    private String columnFamily() {
        return this.columnFamily;
    }

    private Object lock() {
        return this.lock;
    }

    private LRUMap lru() {
        return this.lru;
    }

    private PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    private final String latitudeCol() {
        return "lat";
    }

    private final String longitudeCol() {
        return "lon";
    }

    public void addTagToLocation(float latitude, float longitude, String tagName, String tagValue) {
        String guid = this.getLatLongKey(latitude, longitude);
        this.persistenceManager().put(guid, this.columnFamily(), "lat", ((Object)BoxesRunTime.boxToFloat((float)latitude)).toString());
        this.persistenceManager().put(guid, this.columnFamily(), "lon", ((Object)BoxesRunTime.boxToFloat((float)longitude)).toString());
        this.persistenceManager().put(guid, this.columnFamily(), tagName, tagValue);
    }

    public void addRegionToPoint(double latitude, double longitude, Map<String, String> mapping) {
        String guid = this.getLatLongKey(latitude, longitude);
        scala.collection.mutable.Map properties = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        properties.$plus$plus$eq(mapping);
        properties.put((Object)"lat", (Object)((Object)BoxesRunTime.boxToDouble((double)latitude)).toString());
        properties.put((Object)"lon", (Object)((Object)BoxesRunTime.boxToDouble((double)longitude)).toString());
        this.persistenceManager().put(guid, this.columnFamily(), (Map<String, String>)properties.toMap(Predef$.MODULE$.conforms()));
    }

    public void addRegionToPoint(String latitude, String longitude, Map<String, String> mapping) {
        if (latitude != null && latitude.trim().length() > 0 && longitude != null && longitude.trim().length() > 0) {
            String guid = this.getLatLongKey(latitude, longitude);
            this.persistenceManager().put(guid, this.columnFamily(), (Map<String, String>)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lat"), (Object)latitude), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lon"), (Object)longitude)}))).$plus$plus(mapping));
        }
    }

    public void addLayerIntersects(String latitude, String longitude, Map<String, String> contextual, Map<String, Object> environmental) {
        if (latitude != null && latitude.trim().length() > 0 && longitude != null && longitude.trim().length() > 0) {
            String guid = this.getLatLongKey(latitude, longitude);
            HashMap mapBuffer = new HashMap();
            mapBuffer.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lat"), (Object)latitude));
            mapBuffer.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lon"), (Object)longitude));
            mapBuffer.$plus$plus$eq(contextual);
            mapBuffer.$plus$plus$eq((TraversableOnce)environmental.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(Tuple2<String, Object> x) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(x._1()), (Object)x._2().toString());
                }
            }, Map$.MODULE$.canBuildFrom()));
            this.persistenceManager().put(guid, this.columnFamily(), (Map<String, String>)mapBuffer.toMap(Predef$.MODULE$.conforms()));
        }
    }

    private String getLatLongKey(String latitude, String longitude) {
        return new StringBuilder().append((Object)((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(latitude)).toFloat())).toString().trim()).append((Object)"|").append((Object)((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(longitude)).toFloat())).toString()).toString();
    }

    private String getLatLongKey(float latitude, float longitude) {
        return new StringBuilder().append((Object)((Object)BoxesRunTime.boxToFloat((float)latitude)).toString().trim()).append((Object)"|").append((Object)((Object)BoxesRunTime.boxToFloat((float)longitude)).toString()).toString();
    }

    private String getLatLongKey(double latitude, double longitude) {
        return new StringBuilder().append((Object)((Object)BoxesRunTime.boxToDouble((double)latitude)).toString().trim()).append((Object)"|").append((Object)((Object)BoxesRunTime.boxToDouble((double)longitude)).toString()).toString();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Tuple3<Location, Map<String, String>, Map<String, String>>> getByLatLon(String latitude, String longitude) {
        Option option;
        Object cachedObject;
        block17: {
            Some some;
            Some some2;
            if (latitude == null || longitude == null || latitude.trim().length() == 0 || longitude.trim().length() == 0) {
                return None$.MODULE$;
            }
            String uuid = this.getLatLongKey(latitude, longitude);
            Object object = this.lock();
            synchronized (object) {
                Object object2 = this.lru().get((Object)uuid);
                // MONITOREXIT @DISABLED, blocks:[0, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var5_4
                cachedObject = object2;
                if (cachedObject != null) break block17;
            }
            Option<Map<String, String>> map = this.persistenceManager().get(uuid, this.columnFamily());
            Option<Map<String, String>> option2 = map;
            if (option2 instanceof Some) {
                Some some3 = (Some)option2;
                Map map2 = (Map)some3.x();
                Location location = new Location();
                location.decimalLatitude_$eq(latitude);
                location.decimalLongitude_$eq(longitude);
                String stateProvinceValue = (String)map2.getOrElse((Object)"cl927", (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                });
                String string = stateProvinceValue;
                String string2 = "";
                if (stateProvinceValue != null & (string != null ? !string.equals(string2) : string2 != null)) {
                    Option<Term> option3 = StateProvinces$.MODULE$.matchTerm(stateProvinceValue);
                    if (option3 instanceof Some) {
                        Some some4 = (Some)option3;
                        Term term = (Term)some4.x();
                        location.stateProvince_$eq(term.canonical());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option<Term> option4 = option3;
                        if (none$ != null ? !none$.equals(option4) : option4 != null) throw new MatchError(option3);
                        this.logger().warn(new StringBuilder().append((Object)"Unrecognised state province value retrieved from layer cl927: ").append((Object)stateProvinceValue).toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                location.ibra_$eq((String)map2.getOrElse((Object)"cl20", (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                location.imcra_$eq((String)map2.getOrElse((Object)"cl21", (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                location.country_$eq((String)map2.getOrElse((Object)"cl932", (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                location.lga_$eq((String)map2.getOrElse((Object)"cl23", (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                if (location.country() == null && location.stateProvince() != null) {
                    location.country_$eq("Australia");
                }
                Map el = (Map)map2.filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, String> x) {
                        return ((String)x._1()).startsWith("el");
                    }
                });
                Map cl = (Map)map2.filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, String> x) {
                        return ((String)x._1()).startsWith("cl");
                    }
                });
                Some returnValue = new Some((Object)new Tuple3((Object)location, (Object)el, (Object)cl));
                Object object3 = this.lock();
                synchronized (object3) {
                    this.lru().put((Object)uuid, (Object)returnValue);
                    // MONITOREXIT @DISABLED, blocks:[1, 5, 15] lbl49 : MonitorExitStatement: MONITOREXIT : var23_23
                    some2 = returnValue;
                }
            }
            None$ none$ = None$.MODULE$;
            Option<Map<String, String>> option5 = option2;
            if (none$ != null ? !none$.equals(option5) : option5 != null) throw new MatchError(option2);
            this.logger().debug(new StringBuilder().append((Object)"Performing a layer lookup for [").append((Object)latitude).append((Object)",").append((Object)longitude).append((Object)"]").toString());
            if (Config$.MODULE$.allowLayerLookup()) {
                Some intersection = this.doLayerIntersectForPoint(latitude, longitude);
                Object object4 = this.lock();
                synchronized (object4) {
                    this.lru().put((Object)uuid, intersection);
                    // MONITOREXIT @DISABLED, blocks:[2, 4, 10] lbl63 : MonitorExitStatement: MONITOREXIT : var26_27
                    some = intersection;
                }
            } else {
                some = None$.MODULE$;
            }
            some2 = some;
            option = some2;
            return option;
        }
        option = (Option)cachedObject;
        return option;
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public Option<Tuple3<Location, Map<String, String>, Map<String, String>>> doLayerIntersectForPoint(String latitude, String longitude) {
        None$ none$;
        LayerIntersectDAO layerIntersectDAO = Client.getLayerIntersectDao();
        double[][] points = (double[][])((Object[])new double[][]{(double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{new StringOps(Predef$.MODULE$.augmentString(longitude)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(latitude)).toDouble()}), ClassTag$.MODULE$.Double())});
        ArrayList samples = layerIntersectDAO.sampling(Config$.MODULE$.fieldsToSample(), points);
        if (samples.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String[] values = (String[])samples.toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
            HashMap mapBuffer = new HashMap();
            mapBuffer.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lat"), (Object)latitude));
            mapBuffer.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)longitude), (Object)longitude));
            mapBuffer.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Config$.MODULE$.fieldsToSample()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])values), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(Tuple2<String, String> x) {
                    if (((String)x._2()).trim().length() == 0) return false;
                    Object object = x._2();
                    String string = "n/a";
                    if (object == null) {
                        if (string == null) return false;
                        return true;
                    } else if (object.equals(string)) return false;
                    return true;
                }
            })));
            Map propertyMap = mapBuffer.toMap(Predef$.MODULE$.conforms());
            String guid = this.getLatLongKey(latitude, longitude);
            this.persistenceManager().put(guid, this.columnFamily(), (Map<String, String>)propertyMap);
            Location location = new Location();
            location.decimalLatitude_$eq(latitude);
            location.decimalLongitude_$eq(longitude);
            String stateProvinceValue = (String)propertyMap.getOrElse((Object)"cl927", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            });
            String string = stateProvinceValue;
            String string2 = "";
            if (stateProvinceValue != null & (string != null ? !string.equals(string2) : string2 != null)) {
                Option<Term> option = StateProvinces$.MODULE$.matchTerm(stateProvinceValue);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Term term = (Term)some.x();
                    location.stateProvince_$eq(term.canonical());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    None$ none$2 = None$.MODULE$;
                    Option<Term> option2 = option;
                    if (!(none$2 != null ? !none$2.equals(option2) : option2 != null)) {
                        this.logger().warn(new StringBuilder().append((Object)"Unrecognised stateprovince value retrieved from layer cl927: ").append((Object)stateProvinceValue).toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(option);
                    }
                }
            }
            location.ibra_$eq((String)propertyMap.getOrElse((Object)"cl20", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            }));
            location.imcra_$eq((String)propertyMap.getOrElse((Object)"cl21", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            }));
            location.country_$eq((String)propertyMap.getOrElse((Object)"cl922", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            }));
            Map el = (Map)propertyMap.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, String> x) {
                    return ((String)x._1()).startsWith("el");
                }
            });
            Map cl = (Map)propertyMap.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, String> x) {
                    return ((String)x._1()).startsWith("cl");
                }
            });
            none$ = new Some((Object)new Tuple3((Object)location, (Object)el, (Object)cl));
        }
        return none$;
    }

    private LocationDAO$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"LocationDAO");
        this.columnFamily = "loc";
        this.lock = new Object();
        this.lru = new LRUMap(10000);
        this.persistenceManager = Config$.MODULE$.persistenceManager();
    }
}

