/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.caches;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.caches.WebServiceLoader$;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.Attribution;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.util.Json$;
import au.org.ala.biocache.vocab.DwC$;
import au.org.ala.biocache.vocab.Term;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.commons.collections.map.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.parsing.json.JSON$;

public final class AttributionDAO$ {
    public static final AttributionDAO$ MODULE$;
    private final String columnFamily;
    private final LRUMap lru;
    private final PersistenceManager persistenceManager;
    private final scala.collection.immutable.Map<String, String> wsPropertyMap;
    private final Object lock;
    private final Logger logger;

    static {
        new AttributionDAO$();
    }

    private String columnFamily() {
        return this.columnFamily;
    }

    private LRUMap lru() {
        return this.lru;
    }

    private PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    private scala.collection.immutable.Map<String, String> wsPropertyMap() {
        return this.wsPropertyMap;
    }

    private Object lock() {
        return this.lock;
    }

    public Logger logger() {
        return this.logger;
    }

    public void add(String institutionCode, String collectionCode, Attribution attribution) {
        String guid = new StringBuilder().append((Object)institutionCode.toUpperCase()).append((Object)"|").append((Object)collectionCode.toUpperCase()).toString();
        scala.collection.immutable.Map<String, String> map = FullRecordMapper$.MODULE$.mapObjectToProperties(attribution, FullRecordMapper$.MODULE$.mapObjectToProperties$default$2());
        this.persistenceManager().put(guid, this.columnFamily(), map);
    }

    /*
     * WARNING - void declaration
     */
    public Option<Attribution> getDataResourceByUid(String uid) {
        Option option;
        Object cachedObject = this.lru().get((Object)uid);
        if (cachedObject == null) {
            void var3_3;
            Option<Attribution> att = this.getDataResourceFromWS(uid);
            this.lru().put((Object)uid, att);
            option = var3_3;
        } else {
            option = (Option)cachedObject;
        }
        return option;
    }

    public scala.collection.immutable.Map<String, String> getDataProviderAsMap(String value) {
        String json = Source$.MODULE$.fromURL(new StringBuilder().append((Object)Config$.MODULE$.registryUrl()).append((Object)"/dataProvider/").append((Object)value).append((Object)".json").toString(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
        return (scala.collection.immutable.Map)JSON$.MODULE$.parseFull(json).get();
    }

    public scala.collection.immutable.Map<String, String> getDataResourceAsMap(String value) {
        String json = Source$.MODULE$.fromURL(new StringBuilder().append((Object)Config$.MODULE$.registryUrl()).append((Object)"/dataResource/").append((Object)value).append((Object)".json").toString(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
        return (scala.collection.immutable.Map)JSON$.MODULE$.parseFull(json).get();
    }

    public Option<Attribution> getDataResourceFromWS(String value) {
        None$ none$;
        try {
            String dpname;
            if (value == null) {
                return None$.MODULE$;
            }
            Attribution attribution = new Attribution();
            this.logger().info(new StringBuilder().append((Object)"Calling web service for ").append((Object)value).toString());
            String wscontent = WebServiceLoader$.MODULE$.getWSStringContent(new StringBuilder().append((Object)Config$.MODULE$.registryUrl()).append((Object)"/dataResource/").append((Object)value).append((Object)".json").toString());
            Map<String, Object> wsmap = Json$.MODULE$.toMap(wscontent);
            String name = (String)wsmap.getOrElse((Object)"name", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            String provenance = (String)wsmap.getOrElse((Object)"provenance", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            Object hints = wsmap.getOrElse((Object)"taxonomyCoverageHints", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            });
            String[] ahints = hints == null ? null : (String[])Predef$.MODULE$.refArrayOps(((ArrayList)hints).toArray()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Object o) {
                    return o.toString().replace("=", ":").replace("{", "").replace("}", "");
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            Object hub = wsmap.getOrElse((Object)"hubMembership", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            });
            String[] ahub = hub == null ? null : (String[])Predef$.MODULE$.refArrayOps(((ArrayList)hub).toArray()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Object o) {
                    return ((LinkedHashMap)o).get("uid").toString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            java.util.Map dp = (java.util.Map)wsmap.getOrElse((Object)"provider", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            });
            String string = dp == null ? null : (dpname = (String)dp.get("name"));
            String dpuid = dp == null ? null : (String)dp.get("uid");
            boolean hasColl = BoxesRunTime.unboxToBoolean((Object)wsmap.getOrElse((Object)"hasMappedCollections", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
            Object defaultDwc = wsmap.getOrElse((Object)"defaultDarwinCoreValues", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            });
            attribution.dataResourceName_$eq(name);
            attribution.dataProviderUid_$eq(dpuid);
            attribution.dataProviderName_$eq(dpname);
            attribution.dataHubUid_$eq(ahub);
            attribution.taxonomicHints_$eq(ahints);
            attribution.hasMappedCollections_$eq(hasColl);
            attribution.provenance_$eq(provenance);
            if (defaultDwc != null) {
                LinkedHashMap map = (LinkedHashMap)defaultDwc;
                LinkedHashMap newMap = new LinkedHashMap();
                JavaConversions$.MODULE$.mapAsScalaMap((java.util.Map)map).keys().foreach((Function1)new Serializable(attribution, map, newMap){
                    public static final long serialVersionUID = 0L;
                    private final Attribution attribution$1;
                    private final LinkedHashMap map$1;
                    private final LinkedHashMap newMap$1;

                    public final void apply(String key) {
                        String value = (String)this.map$1.get(key);
                        Option<Term> v = DwC$.MODULE$.matchTerm(key);
                        String string = v.isDefined() && !((Term)v.get()).canonical().equals(key) ? this.newMap$1.put(((Term)v.get()).canonical(), value) : this.newMap$1.put(key, value);
                        this.attribution$1.defaultDwcValues_$eq((scala.collection.immutable.Map<String, String>)JavaConversions$.MODULE$.mapAsScalaMap((java.util.Map)this.newMap$1).toMap(Predef$.MODULE$.conforms()));
                    }
                    {
                        this.attribution$1 = attribution$1;
                        this.map$1 = map$1;
                        this.newMap$1 = newMap$1;
                    }
                });
            }
            none$ = new Some((Object)attribution);
        }
        catch (Exception exception) {
            this.logger().error(exception.getMessage(), (Throwable)exception);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<Attribution> getByCodes(String institutionCode, String collectionCode) {
        None$ none$;
        if (institutionCode == null || collectionCode == null) {
            none$ = None$.MODULE$;
            return none$;
        }
        String uuid = new StringBuilder().append((Object)institutionCode.toUpperCase()).append((Object)"|").append((Object)collectionCode.toUpperCase()).toString();
        Object cachedObject = this.lru().get((Object)uuid);
        if (cachedObject != null) {
            none$ = (Option)cachedObject;
            return none$;
        }
        this.logger().info(new StringBuilder().append((Object)"Looking up collectory web service for ").append((Object)uuid).toString());
        String wscontent = WebServiceLoader$.MODULE$.getWSStringContent(new StringBuilder().append((Object)Config$.MODULE$.registryUrl()).append((Object)"/lookup/inst/").append((Object)URLEncoder.encode(institutionCode)).append((Object)"/coll/").append((Object)URLEncoder.encode(collectionCode)).append((Object)".json").toString());
        Map<String, Object> wsmap = Json$.MODULE$.toMap(wscontent);
        if (wsmap.isEmpty() || wsmap.contains((Object)"error")) {
            None$ none$2;
            Option<scala.collection.immutable.Map<String, String>> map = this.persistenceManager().get(uuid, "attr");
            if (map.isEmpty()) {
                none$2 = None$.MODULE$;
            } else {
                Attribution attribution = new Attribution();
                FullRecordMapper$.MODULE$.mapPropertiesToObject(attribution, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)map.get()));
                none$2 = new Some((Object)attribution);
            }
            None$ result = none$2;
            Object object = this.lock();
            synchronized (object) {
                this.lru().put((Object)uuid, (Object)result);
                // MONITOREXIT @DISABLED, blocks:[0, 2, 9] lbl26 : MonitorExitStatement: MONITOREXIT : var15_10
                none$ = result;
                return none$;
            }
        }
        Attribution attribution = new Attribution();
        Object hints = wsmap.getOrElse((Object)"taxonomyCoverageHints", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
        if (hints != null) {
            String[] ahint = (String[])Predef$.MODULE$.refArrayOps(((ArrayList)hints).toArray()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Object o) {
                    return o.toString().replace("=", ":").replace("{", "").replace("}", "");
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            attribution.taxonomicHints_$eq(ahint);
        }
        FullRecordMapper$.MODULE$.mapmapPropertiesToObject(attribution, (Map<String, Object>)wsmap.$minus((Object)"taxonomyCoverageHints"), (Map<String, String>)this.wsPropertyMap());
        Some result = new Some((Object)attribution);
        Object object = this.lock();
        synchronized (object) {
            this.lru().put((Object)uuid, (Object)result);
            // MONITOREXIT @DISABLED, blocks:[1, 3] lbl44 : MonitorExitStatement: MONITOREXIT : var11_15
            this.add(institutionCode, collectionCode, attribution);
            none$ = result;
            return none$;
        }
    }

    private AttributionDAO$() {
        MODULE$ = this;
        this.columnFamily = "attr";
        this.lru = new LRUMap(10000);
        this.persistenceManager = (PersistenceManager)Config$.MODULE$.getInstance(PersistenceManager.class);
        this.wsPropertyMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"collectionName"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"uid"), (Object)"collectionUid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"taxonomyCoverageHints"), (Object)"taxonomicHints"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"institutionUid"), (Object)"institutionUid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"institution"), (Object)"institutionName")}));
        this.lock = new Object();
        this.logger = LoggerFactory.getLogger((String)"AttributionDAO");
    }
}

